/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.netbeans.modules.projects.ProjectDataLoader;
import org.netbeans.modules.projects.ProjectDataObject;
import org.openide.TopManager;
import org.openide.cookies.ProjectCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;

public class ProjectsModule
extends ModuleInstall {
    public static final String PROJECT_LAST_NAME = "project";
    public static final String PROJECT_LAST_EXT = "last";
    static final long serialVersionUID = -8515854707471314270L;

    public void restored() {
        this.checkProjectsConsistency();
        try {
            if (!this.lastExists()) {
                ProjectDataObject projectDataObject = ProjectDataObject.createDefaultProject();
                this.saveLast(projectDataObject.support);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify((Throwable)exception);
        }
    }

    public void installed() {
    }

    public void uninstalled() {
        this.removeLast();
        try {
            TopManager.getDefault().openProject(null);
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
    }

    private boolean lastExists() {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot();
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
        return fileObject2 != null;
    }

    /*
     * Loose catch block
     */
    private void saveLast(ProjectCookie projectCookie) {
        block18: {
            ObjectOutputStream objectOutputStream;
            FileLock fileLock;
            block17: {
                fileLock = null;
                objectOutputStream = null;
                FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
                FileObject fileObject = fileSystem.getRoot();
                FileObject fileObject2 = fileObject.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createData(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                }
                fileLock = fileObject2.lock();
                objectOutputStream = new ObjectOutputStream(fileObject2.getOutputStream(fileLock));
                objectOutputStream.writeObject(projectCookie);
                Object var8_8 = null;
                if (fileLock == null) break block17;
                fileLock.releaseLock();
            }
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block18;
            }
            catch (IOException iOException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    iOException.printStackTrace();
                }
                break block18;
            }
            {
                catch (IOException iOException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        iOException.printStackTrace();
                    }
                    Object var8_9 = null;
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException2) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            iOException2.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var8_10 = null;
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block19;
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeLast() {
        FileLock fileLock = null;
        try {
            block5: {
                try {
                    FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
                    FileObject fileObject = fileSystem.getRoot();
                    FileObject fileObject2 = fileObject.getFileObject(PROJECT_LAST_NAME, PROJECT_LAST_EXT);
                    if (fileObject2 == null) break block5;
                    fileLock = fileObject2.lock();
                    fileObject2.delete(fileLock);
                }
                catch (IOException iOException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        iOException.printStackTrace();
                    }
                    Object var6_7 = null;
                    if (fileLock == null) return;
                    fileLock.releaseLock();
                    return;
                }
            }
            Object var6_6 = null;
            if (fileLock == null) return;
            fileLock.releaseLock();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
    }

    private void checkProjectsConsistency() {
        DataObject[] dataObjectArray = TopManager.getDefault().getPlaces().folders().projects().getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n].getPrimaryFile().isFolder() && !(dataObjectArray[n] instanceof ProjectDataObject)) {
                try {
                    ProjectDataLoader.INSTANCE.markFile(dataObjectArray[n].getPrimaryFile());
                    dataObjectArray[n].setValid(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }
}

