/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.awt.Dialog;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.modules.projects.content.ProjectErrorsPanel;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class ProjectErrorManager {
    public static final int TYPE_FILE = 1;
    public static final int TYPE_SCO = 2;
    public static final int TYPE_ITEM = 3;
    public static final int TYPE_WM = 5;
    static final String PROP_ERROR_DETAILS = "details";
    private static String[] missingPackages = null;
    private List exceptions = new ArrayList();
    private AllErrorsNode errorsRootNode;
    private ProjectErrorsPanel panel;
    static /* synthetic */ Class class$org$netbeans$modules$projects$content$ProjectErrorManager;

    public void annotate(int n, String string, Throwable throwable) {
        this.annotate(n, string, throwable, true);
    }

    public void annotate(int n, String string, Throwable throwable, boolean bl) {
        if (throwable instanceof StreamCorruptedException) {
            TopManager.getDefault().getErrorManager().notify(1, throwable);
        } else if (!this.isExpectedException(throwable)) {
            ListEntry listEntry = new ListEntry(n, string, throwable);
            this.exceptions.add(listEntry);
            this.getErrorsRootNode().getChildren().add(new Node[]{new ErrorNode(listEntry)});
            if (bl) {
                TopManager.getDefault().getErrorManager().annotate(throwable, listEntry.toString());
                TopManager.getDefault().getErrorManager().notify(1, throwable);
            }
        }
    }

    public void clear() {
        this.exceptions.clear();
        this.errorsRootNode = null;
    }

    public void show() {
        if (!this.isEmpty()) {
            ProjectErrorsPanel projectErrorsPanel = this.getPanel();
            projectErrorsPanel.getExplorerManager().setRootContext((Node)this.getErrorsRootNode());
            projectErrorsPanel.updateDescription();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)projectErrorsPanel, ProjectErrorManager.getString("CTL_ErrorsDialogTitle"));
            dialogDescriptor.setModal(false);
            Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
            dialog.show();
        }
    }

    public boolean isEmpty() {
        return this.exceptions.isEmpty();
    }

    private ProjectErrorsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new ProjectErrorsPanel();
        }
        return this.panel;
    }

    private AllErrorsNode getErrorsRootNode() {
        if (this.errorsRootNode == null) {
            this.errorsRootNode = new AllErrorsNode();
        }
        return this.errorsRootNode;
    }

    private static String getString(String string) {
        try {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$projects$content$ProjectErrorManager == null ? (class$org$netbeans$modules$projects$content$ProjectErrorManager = ProjectErrorManager.class$("org.netbeans.modules.projects.content.ProjectErrorManager")) : class$org$netbeans$modules$projects$content$ProjectErrorManager)).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return "Missing resource";
        }
    }

    private boolean isExpectedException(Throwable throwable) {
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        ErrorManager.Annotation[] annotationArray = TopManager.getDefault().getErrorManager().findAnnotations(throwable);
        linkedList.add(throwable);
        if (annotationArray != null) {
            int n = 0;
            while (n < annotationArray.length) {
                linkedList.add(annotationArray[n].getStackTrace());
                ++n;
            }
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Throwable throwable2 = (Throwable)iterator.next();
            if (!(throwable2 instanceof ClassNotFoundException)) continue;
            String[] stringArray = this.getMissingPackages();
            int n = 0;
            while (n < stringArray.length) {
                if (-1 != throwable2.getMessage().indexOf(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private synchronized String[] getMissingPackages() {
        if (null == missingPackages) {
            try {
                ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.projects.content.IgnoredPackages");
                Enumeration<String> enumeration = resourceBundle.getKeys();
                LinkedList<String> linkedList = new LinkedList<String>();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    linkedList.add(resourceBundle.getString(string));
                }
                missingPackages = linkedList.toArray(new String[linkedList.size()]);
            }
            catch (MissingResourceException missingResourceException) {
                missingPackages = new String[0];
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)missingResourceException);
            }
        }
        return missingPackages;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ErrorNode
    extends AbstractNode {
        private ListEntry entry;

        public ErrorNode(ListEntry listEntry) {
            super(Children.LEAF);
            this.entry = listEntry;
            ((FeatureDescriptor)((Object)this)).setValue(ProjectErrorManager.PROP_ERROR_DETAILS, listEntry);
            this.setIconBase("/org/netbeans/modules/projects/resources/ErrorNodeIcon");
            this.setName(ProjectErrorManager.getString("LBL_ErrorNode"));
            this.setDisplayName(listEntry.name);
            String string = ProjectErrorManager.getString("HINT_ErrorNode");
            switch (listEntry.type) {
                case 1: {
                    string = ProjectErrorManager.getString("MSG_ErrorTypeFile");
                    break;
                }
                case 2: {
                    string = ProjectErrorManager.getString("MSG_ErrorTypeSCO");
                    break;
                }
                case 3: {
                    string = ProjectErrorManager.getString("MSG_ErrorTypeItem");
                    break;
                }
                case 5: {
                    string = ProjectErrorManager.getString("MSG_ErrorTypeWindowManager");
                }
            }
            this.setShortDescription(string);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Node cloneNode() {
            return new ErrorNode(this.entry);
        }

        public boolean canCopy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public Transferable clipboardCopy() {
            try {
                ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
                exTransferable.put(new ExTransferable.Single(this, DataFlavor.stringFlavor){
                    private final /* synthetic */ ErrorNode this$0;
                    {
                        this.this$0 = errorNode;
                    }

                    protected Object getData() {
                        return ((FeatureDescriptor)((Object)this.this$0)).getDisplayName();
                    }
                });
                return exTransferable;
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                return ExTransferable.EMPTY;
            }
        }
    }

    private class AllErrorsNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$netbeans$modules$projects$content$ProjectErrorManager;

        public AllErrorsNode() {
            super((Children)new Children.Array());
            this.setIconBase("/org/netbeans/modules/projects/resources/AllErrorsNodeIcon");
            Node node = TopManager.getDefault().getPlaces().nodes().projectDesktop();
            String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$projects$content$ProjectErrorManager == null ? (class$org$netbeans$modules$projects$content$ProjectErrorManager = AllErrorsNode.class$("org.netbeans.modules.projects.content.ProjectErrorManager")) : class$org$netbeans$modules$projects$content$ProjectErrorManager), (String)"LBL_AllErrorsNode", (Object)node.getName());
            this.setName(string);
            this.setDisplayName(string);
            this.setShortDescription(ProjectErrorManager.getString("HINT_AllErrorsNode"));
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Node cloneNode() {
            return new AllErrorsNode();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static class ListEntry {
        int type;
        String name;
        Throwable t;

        public ListEntry(int n, String string, Throwable throwable) {
            this.type = n;
            this.name = string;
            this.t = throwable;
        }

        public String toString() {
            return MessageFormat.format(ProjectErrorManager.getString("FMT_ErrorText"), new Integer(this.type), this.name, this.t);
        }
    }
}

