/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.netbeans.modules.projects.content.ProjectErrorManager;
import org.openide.TopManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Node;

public class ProjectErrorsPanel
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private JLabel detailsLabel;
    private JButton detailsButton;
    private ListView errorList;
    private JScrollPane detailsScrollPane;
    private JTextPane detailsTextPane;
    private JPanel detailsPanel;
    private JPanel mainPanel;
    private JLabel errorListTitle;

    public ProjectErrorsPanel() {
        this.initComponents();
        this.initAccessibility();
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectErrorsPanel.this.updateDescription();
            }
        });
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("ACS_ProjectErrorsPanel"));
        this.errorListTitle.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("LBL_AllErrorsNode_Mnem").charAt(0));
        this.detailsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("LBL_Details_Mnem").charAt(0));
        this.errorList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("ACS_ErrorList"));
        this.detailsButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("ACS_CTL_ShowDetails"));
        this.detailsTextPane.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("ACS_DetailsTextPane"));
    }

    private void initComponents() {
        this.detailsButton = new JButton();
        this.detailsPanel = new JPanel();
        this.detailsScrollPane = new JScrollPane();
        this.detailsTextPane = new JTextPane();
        this.detailsLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.errorListTitle = new JLabel();
        this.errorList = new ListView();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(400, 300));
        this.detailsButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("CTL_ShowDetails_Mnem").charAt(0));
        this.detailsButton.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("CTL_ShowDetails"));
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectErrorsPanel.this.detailsButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(17, 12, 11, 0);
        this.add((Component)this.detailsButton, gridBagConstraints);
        this.detailsPanel.setLayout(new GridBagLayout());
        this.detailsScrollPane.setAlignmentY(1.0f);
        this.detailsTextPane.setEditable(false);
        this.detailsTextPane.setBackground(new Color(204, 204, 204));
        this.detailsTextPane.setAlignmentY(1.0f);
        this.detailsScrollPane.setViewportView(this.detailsTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.detailsPanel.add((Component)this.detailsScrollPane, gridBagConstraints);
        this.detailsLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/projects/content/Bundle").getString("LBL_Details"));
        this.detailsLabel.setForeground(Color.black);
        this.detailsLabel.setLabelFor(this.detailsTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.detailsPanel.add((Component)this.detailsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(17, 12, 0, 11);
        this.add((Component)this.detailsPanel, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        this.errorListTitle.setText(this.getExplorerManager().getRootContext().getDisplayName());
        this.errorListTitle.setForeground(Color.black);
        this.errorListTitle.setLabelFor((Component)this.errorList);
        this.errorList.setPreferredSize(new Dimension(10, 10));
        this.errorList.setMinimumSize(new Dimension(10, 10));
        this.errorList.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.mainPanel.add((Component)this.errorListTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.errorList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.mainPanel, gridBagConstraints);
    }

    private void detailsButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1) {
            this.showDetails(nodeArray[0].getValue("details"));
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ProjectErrorsPanel projectErrorsPanel = this;
            synchronized (projectErrorsPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    void updateDescription() {
        boolean bl = false;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1) {
            this.detailsTextPane.setText(nodeArray[0].getShortDescription());
            bl = true;
        }
        this.detailsButton.setEnabled(bl);
        this.errorListTitle.setText(this.getExplorerManager().getRootContext().getDisplayName());
    }

    private void showDetails(Object object) {
        if (object instanceof ProjectErrorManager.ListEntry) {
            ProjectErrorManager.ListEntry listEntry = (ProjectErrorManager.ListEntry)object;
            TopManager.getDefault().getErrorManager().notify(4096, listEntry.t);
        } else {
            TopManager.getDefault().getErrorManager().log(4096, "Internal problem in ProjectErrorManager.showDetails: " + object.getClass());
        }
    }
}

