/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class IdxPropertyPattern
extends PropertyPattern {
    protected MethodElement indexedGetterMethod = null;
    protected MethodElement indexedSetterMethod = null;
    protected Type indexedType;

    public IdxPropertyPattern(PatternAnalyser patternAnalyser, MethodElement methodElement, MethodElement methodElement2, MethodElement methodElement3, MethodElement methodElement4) throws IntrospectionException {
        super(patternAnalyser, methodElement, methodElement2);
        this.indexedGetterMethod = methodElement3;
        this.indexedSetterMethod = methodElement4;
        this.findIndexedPropertyType();
        this.name = this.findIndexedPropertyName();
    }

    private IdxPropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2, String string3) throws SourceException {
        IdxPropertyPattern idxPropertyPattern = new IdxPropertyPattern(patternAnalyser);
        idxPropertyPattern.name = string;
        idxPropertyPattern.type = Type.parse((String)string2);
        idxPropertyPattern.indexedType = Type.parse((String)string3);
        idxPropertyPattern.generateGetterMethod();
        idxPropertyPattern.generateSetterMethod();
        idxPropertyPattern.generateIndexedGetterMethod();
        idxPropertyPattern.generateIndexedSetterMethod();
        return idxPropertyPattern;
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) throws SourceException {
        return IdxPropertyPattern.create(patternAnalyser, string, string2, n, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, false, false);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12) throws SourceException {
        IdxPropertyPattern idxPropertyPattern = new IdxPropertyPattern(patternAnalyser);
        idxPropertyPattern.name = string;
        idxPropertyPattern.type = null;
        idxPropertyPattern.indexedType = Type.parse((String)string2);
        if (bl3 || bl6 || bl7 || bl9) {
            idxPropertyPattern.type = Type.createArray((Type)idxPropertyPattern.indexedType);
        }
        if ((bl3 || bl6) && !bl12 && idxPropertyPattern.type != null) {
            try {
                idxPropertyPattern.generateField(true);
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String string3 = null;
        String string4 = null;
        if (bl6) {
            boolean bl13 = bl;
            boolean bl14 = bl2;
            if (!bl11) {
                if (bl13 && (string3 = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(idxPropertyPattern.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    bl13 = false;
                }
                if (bl14 && (string4 = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(idxPropertyPattern.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    bl14 = false;
                }
            } else {
                if (bl13 && (string3 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(idxPropertyPattern.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    bl13 = false;
                }
                if (bl14 && (string4 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(idxPropertyPattern.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    bl14 = false;
                }
            }
            if (bl13) {
                string3 = BeanPatternGenerator.supportField(idxPropertyPattern.getDeclaringClass());
            }
            if (bl14) {
                string4 = BeanPatternGenerator.vetoSupportField(idxPropertyPattern.getDeclaringClass());
            }
            if (bl13) {
                BeanPatternGenerator.supportListenerMethods(idxPropertyPattern.getDeclaringClass(), string3);
            }
            if (bl14) {
                BeanPatternGenerator.vetoSupportListenerMethods(idxPropertyPattern.getDeclaringClass(), string4);
            }
        }
        if (n == 1 || n == 2) {
            if (bl12 && bl4 || !bl12) {
                idxPropertyPattern.generateIndexedGetterMethod(BeanPatternGenerator.idxPropertyGetterBody(string, bl4), true);
            }
            if (idxPropertyPattern.type != null && bl7) {
                idxPropertyPattern.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(string, bl8), true);
            }
        }
        if (n == 1 || n == 4) {
            if (bl12 && bl5 || !bl12) {
                idxPropertyPattern.generateIndexedSetterMethod(BeanPatternGenerator.idxPropertySetterBody(string, idxPropertyPattern.getIndexedType(), bl, bl2, bl5, bl6, string3, string4), bl2, true);
            }
            if (idxPropertyPattern.type != null && bl9) {
                idxPropertyPattern.generateSetterMethod(BeanPatternGenerator.propertySetterBody(string, idxPropertyPattern.getType(), bl, bl2, bl10, bl6, string3, string4), bl2, true);
            }
        }
        return idxPropertyPattern;
    }

    public Type getIndexedType() {
        return this.indexedType;
    }

    public void setName(String string) throws SourceException {
        Identifier identifier;
        super.setName(string);
        string = Pattern.capitalizeFirstLetter(string);
        if (this.indexedGetterMethod != null) {
            identifier = Identifier.create((String)((this.indexedGetterMethod.getName().getName().startsWith("get") ? "get" : "is") + string));
            this.indexedGetterMethod.setName(identifier);
        }
        if (this.indexedSetterMethod != null) {
            identifier = Identifier.create((String)("set" + string));
            this.indexedSetterMethod.setName(identifier);
        }
    }

    public MethodElement getIndexedGetterMethod() {
        return this.indexedGetterMethod;
    }

    public MethodElement getIndexedSetterMethod() {
        return this.indexedSetterMethod;
    }

    public void setType(Type type) throws SourceException {
        if (this.type != null && this.type.compareTo(type, true)) {
            return;
        }
        Type type2 = this.indexedType;
        Type type3 = this.type;
        if (type3 == null) {
            this.type = type;
            type3 = type;
            int n = this.getMode();
            if (n == 1 || n == 2) {
                this.generateGetterMethod();
            }
            if (n == 1 || n == 4) {
                this.generateSetterMethod();
            }
        } else {
            super.setType(type);
        }
        if (type.isArray() && type3.isArray() && type3.getElementType().compareTo(type2, false)) {
            MethodParameter[] methodParameterArray;
            Type type4 = type.getElementType();
            if (this.indexedGetterMethod != null) {
                this.indexedGetterMethod.setReturn(type4);
            }
            if (this.indexedSetterMethod != null && (methodParameterArray = this.indexedSetterMethod.getParameters()).length > 1) {
                methodParameterArray[1].setType(type4);
                this.indexedSetterMethod.setParameters(methodParameterArray);
            }
            this.setIndexedType(type4);
        }
    }

    public void setIndexedType(Type type) throws SourceException {
        Type type2;
        if (this.indexedType.compareTo(type, true)) {
            return;
        }
        Type type3 = this.indexedType;
        Type type4 = this.type;
        if (this.indexedGetterMethod != null) {
            this.indexedGetterMethod.setReturn(type);
        }
        if (this.indexedSetterMethod != null && ((MethodParameter[])(type2 = this.indexedSetterMethod.getParameters())).length > 1) {
            type2[1].setType(type);
            this.indexedSetterMethod.setParameters((MethodParameter[])type2);
            String string = this.indexedSetterMethod.getBody();
            if (string != null && (string.indexOf("firePropertyChange") != -1 || string.indexOf("fireVetoableChange") != -1)) {
                String string2;
                String string3 = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName().getName());
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string3, 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION) && (string2 = this.regeneratePropertySupport(this.indexedSetterMethod.getBody(), null, type2[1].getName(), type, type4)) != null) {
                    this.indexedSetterMethod.setBody(string2);
                }
            }
        }
        if (type4 != null && type4.isArray() && type4.getElementType().compareTo(type3, false)) {
            type2 = Type.createArray((Type)type);
            super.setType(type2);
        }
        this.indexedType = type;
    }

    private String regenerateIdxPropertySupport(String string, String string2, Type type, Type type2) {
        if (string == null) {
            return null;
        }
        int n = -1;
        String string3 = PropertyActionSettings.getDefault().getPropStyle();
        String string4 = type2.toString() + " old" + Pattern.capitalizeFirstLetter(string2) + " = " + string3 + string2;
        n = string.indexOf(string4);
        if (n == -1) {
            return null;
        }
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(59, n);
        if (n >= n2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(type.toString());
        stringBuffer.append(" old").append(Pattern.capitalizeFirstLetter(string2));
        stringBuffer.append(" = ").append(string3).append(string2);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.delete(n, n2);
        stringBuffer2.insert(n, (Object)stringBuffer);
        return stringBuffer2.toString();
    }

    public int getMode() {
        if (this.indexedSetterMethod != null && this.indexedGetterMethod != null) {
            return 1;
        }
        if (this.indexedGetterMethod != null && this.indexedSetterMethod == null) {
            return 2;
        }
        if (this.indexedSetterMethod != null && this.indexedGetterMethod == null) {
            return 4;
        }
        return super.getMode();
    }

    public void setMode(int n) throws SourceException {
        if (this.getMode() == n) {
            return;
        }
        switch (n) {
            case 1: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod();
                }
                if (this.setterMethod == null) {
                    this.generateSetterMethod();
                }
                if (this.indexedGetterMethod == null) {
                    this.generateIndexedGetterMethod();
                }
                if (this.indexedSetterMethod != null) break;
                this.generateIndexedSetterMethod();
                break;
            }
            case 2: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod();
                }
                if (this.indexedGetterMethod == null) {
                    this.generateIndexedGetterMethod();
                }
                if (this.setterMethod == null && this.indexedSetterMethod == null) break;
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                if (this.setterMethod != null) {
                    this.deleteSetterMethod();
                }
                if (this.indexedSetterMethod == null) break;
                this.deleteIndexedSetterMethod();
                break;
            }
            case 4: {
                if (this.setterMethod == null) {
                    this.generateSetterMethod();
                }
                if (this.indexedSetterMethod == null) {
                    this.generateIndexedSetterMethod();
                }
                if (this.getterMethod == null && this.indexedGetterMethod == null) break;
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                if (this.getterMethod != null) {
                    this.deleteGetterMethod();
                }
                if (this.indexedGetterMethod == null) break;
                this.deleteIndexedGetterMethod();
            }
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (this.indexedGetterMethod != null) {
            return this.indexedGetterMethod.getCookie(clazz);
        }
        if (this.indexedSetterMethod != null) {
            return this.indexedSetterMethod.getCookie(clazz);
        }
        return super.getCookie(clazz);
    }

    public void destroy() throws SourceException {
        this.deleteIndexedSetterMethod();
        this.deleteIndexedGetterMethod();
        super.destroy();
    }

    IdxPropertyPattern(PropertyPattern propertyPattern, PropertyPattern propertyPattern2) {
        super(propertyPattern, propertyPattern2);
        IdxPropertyPattern idxPropertyPattern;
        if (propertyPattern instanceof IdxPropertyPattern) {
            idxPropertyPattern = (IdxPropertyPattern)propertyPattern;
            this.indexedGetterMethod = idxPropertyPattern.indexedGetterMethod;
            this.indexedSetterMethod = idxPropertyPattern.indexedSetterMethod;
            this.indexedType = idxPropertyPattern.indexedType;
        }
        if (propertyPattern2 instanceof IdxPropertyPattern) {
            idxPropertyPattern = (IdxPropertyPattern)propertyPattern2;
            if (idxPropertyPattern.indexedGetterMethod != null) {
                this.indexedGetterMethod = idxPropertyPattern.indexedGetterMethod;
            }
            if (idxPropertyPattern.indexedSetterMethod != null) {
                this.indexedSetterMethod = idxPropertyPattern.indexedSetterMethod;
            }
            this.indexedType = idxPropertyPattern.indexedType;
        }
        this.name = this.findIndexedPropertyName();
    }

    private void findIndexedPropertyType() throws IntrospectionException {
        MethodParameter[] methodParameterArray;
        this.indexedType = null;
        if (this.indexedGetterMethod != null) {
            methodParameterArray = this.indexedGetterMethod.getParameters();
            if (methodParameterArray.length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (!methodParameterArray[0].getType().compareTo(Type.INT, false)) {
                throw new IntrospectionException("not int index to indexed read method");
            }
            this.indexedType = this.indexedGetterMethod.getReturn();
            if (this.indexedType.compareTo(Type.VOID, false)) {
                throw new IntrospectionException("indexed read method return void");
            }
        }
        if (this.indexedSetterMethod != null) {
            methodParameterArray = this.indexedSetterMethod.getParameters();
            if (methodParameterArray.length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (!methodParameterArray[0].getType().compareTo(Type.INT, false)) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (this.indexedType != null && !this.indexedType.compareTo(methodParameterArray[1].getType(), false)) {
                throw new IntrospectionException("type mismatch between indexed read and write methods");
            }
            this.indexedType = methodParameterArray[1].getType();
        }
        if (!((methodParameterArray = this.getType()) == null || methodParameterArray.isArray() && methodParameterArray.getElementType().compareTo(this.indexedType, false))) {
            throw new IntrospectionException("type mismatch between property type and indexed type");
        }
    }

    String findIndexedPropertyName() {
        String string = this.findPropertyName();
        if (string == null) {
            String string2 = null;
            if (this.indexedGetterMethod != null) {
                string2 = this.indexedGetterMethod.getName().getName();
            } else if (this.indexedSetterMethod != null) {
                string2 = this.indexedSetterMethod.getName().getName();
            } else {
                throw new InternalError("Indexed property with all methods == null");
            }
            return string2.startsWith("is") ? Introspector.decapitalize(string2.substring(2)) : Introspector.decapitalize(string2.substring(3));
        }
        return string;
    }

    void generateGetterMethod() throws SourceException {
        if (this.type != null) {
            super.generateGetterMethod();
        }
    }

    void generateSetterMethod() throws SourceException {
        if (this.type != null) {
            super.generateSetterMethod();
        }
    }

    void generateIndexedGetterMethod() throws SourceException {
        this.generateIndexedGetterMethod(null, false);
    }

    void generateIndexedGetterMethod(String string, boolean bl) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("index", Type.INT, false)};
        methodElement.setName(Identifier.create((String)("get" + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(this.indexedType);
        methodElement.setModifiers(1);
        methodElement.setParameters(methodParameterArray);
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (bl) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), this.getName());
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.indexedGetterMethod = classElement.getMethod(methodElement.getName(), PropertyPattern.getParameterTypes(methodElement));
    }

    void generateIndexedSetterMethod() throws SourceException {
        this.generateIndexedSetterMethod(null, false, false);
    }

    void generateIndexedSetterMethod(String string, boolean bl, boolean bl2) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        MethodParameter[] methodParameterArray = new MethodParameter[]{new MethodParameter("index", Type.INT, false), new MethodParameter(this.name, this.indexedType, false)};
        methodElement.setName(Identifier.create((String)("set" + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(Type.VOID);
        methodElement.setModifiers(1);
        methodElement.setParameters(methodParameterArray);
        if (bl) {
            methodElement.setExceptions(new Identifier[]{Identifier.create((String)"java.beans.PropertyVetoException")});
        }
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (bl2) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), this.getName(), this.name);
            if (bl) {
                string2 = string2 + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.indexedSetterMethod = classElement.getMethod(methodElement.getName(), PropertyPattern.getParameterTypes(methodElement));
    }

    void deleteIndexedGetterMethod() throws SourceException {
        if (this.indexedGetterMethod == null) {
            return;
        }
        ClassElement classElement = this.getDeclaringClass();
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.removeMethod(this.indexedGetterMethod);
        this.indexedGetterMethod = null;
    }

    void deleteIndexedSetterMethod() throws SourceException {
        if (this.indexedSetterMethod == null) {
            return;
        }
        ClassElement classElement = this.getDeclaringClass();
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.removeMethod(this.indexedSetterMethod);
        this.indexedSetterMethod = null;
    }

    void copyProperties(IdxPropertyPattern idxPropertyPattern) {
        boolean bl;
        boolean bl2 = !idxPropertyPattern.getIndexedType().equals((Object)this.getIndexedType()) || !(idxPropertyPattern.getType() == null ? this.getType() == null : idxPropertyPattern.getType().equals((Object)this.getType())) || !idxPropertyPattern.getName().equals(this.getName()) || idxPropertyPattern.getMode() != this.getMode() || !(idxPropertyPattern.getEstimatedField() != null ? idxPropertyPattern.getEstimatedField().equals(this.estimatedField) : this.estimatedField == null) ? true : (bl = false);
        if (idxPropertyPattern.getIndexedGetterMethod() != this.indexedGetterMethod) {
            this.indexedGetterMethod = idxPropertyPattern.getIndexedGetterMethod();
        }
        if (idxPropertyPattern.getIndexedSetterMethod() != this.indexedSetterMethod) {
            this.indexedSetterMethod = idxPropertyPattern.getIndexedSetterMethod();
        }
        if (idxPropertyPattern.getGetterMethod() != this.getterMethod) {
            bl = true;
            this.getterMethod = idxPropertyPattern.getGetterMethod();
        }
        if (idxPropertyPattern.getSetterMethod() != this.setterMethod) {
            bl = true;
            this.setterMethod = idxPropertyPattern.getSetterMethod();
        }
        if (idxPropertyPattern.getEstimatedField() != this.estimatedField) {
            this.estimatedField = idxPropertyPattern.getEstimatedField();
        }
        if (bl) {
            try {
                this.type = this.findPropertyType();
                this.findIndexedPropertyType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.name = this.findIndexedPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

