/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class PatternAnalyser
implements Node.Cookie {
    private static final int PROPERTIES_RESERVE = 11;
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private ArrayList currentPropertyPatterns = new ArrayList();
    private ArrayList currentIdxPropertyPatterns = new ArrayList();
    private ArrayList currentEventSetPatterns = new ArrayList();
    private HashMap propertyPatterns;
    private HashMap idxPropertyPatterns;
    private HashMap eventSetPatterns;
    private ClassElement classElement;
    private boolean analyzed = false;
    private boolean ignore;

    public PatternAnalyser(ClassElement classElement) {
        this.classElement = classElement;
    }

    public void analyzeAll() {
        if (this.ignore) {
            return;
        }
        this.analyzed = true;
        int n = this.classElement.getMethods().length;
        this.propertyPatterns = new HashMap(n / 2 + 11);
        this.idxPropertyPatterns = new HashMap();
        this.eventSetPatterns = new HashMap();
        this.resolveMethods();
        this.resolveFields();
        this.resolveChangesOfProperties();
        this.resolveChangesOfIdxProperties();
        this.resolveChangesOfEventSets();
    }

    boolean isAnalyzed() {
        return this.analyzed;
    }

    void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public Collection getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public Collection getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public Collection getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public ClassElement getClassElement() {
        return this.classElement;
    }

    public void resolveMethods() {
        PropertyPattern propertyPattern;
        String string;
        MethodElement methodElement;
        MethodElement[] methodElementArray = this.classElement.getMethods();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n = 0;
        while (n < methodElementArray.length) {
            methodElement = methodElementArray[n];
            string = methodElement.getName().getName();
            if ((string.startsWith(GET_PREFIX) || string.startsWith(SET_PREFIX) || string.startsWith(IS_PREFIX)) && (propertyPattern = this.analyseMethodForProperties(methodElement)) != null) {
                this.addProperty(propertyPattern);
            }
            if (string.startsWith(ADD_PREFIX) || string.startsWith(REMOVE_PREFIX)) {
                this.analyseMethodForEventSets(methodElement, hashtable, hashtable2);
            }
            ++n;
        }
        methodElement = hashtable.keys();
        while (methodElement.hasMoreElements()) {
            EventSetPattern eventSetPattern;
            string = (String)methodElement.nextElement();
            if (hashtable2.get(string) == null || string.indexOf("Listener:") <= 0) continue;
            propertyPattern = (MethodElement)hashtable.get(string);
            MethodElement methodElement2 = (MethodElement)hashtable2.get(string);
            Type type = propertyPattern.getParameters()[0].getType();
            if (!PatternAnalyser.isSubclass(ClassElement.forName((String)type.getClassName().getFullName()), ClassElement.forName((String)"java.util.EventListener"))) continue;
            try {
                eventSetPattern = new EventSetPattern(this, (MethodElement)propertyPattern, methodElement2);
            }
            catch (IntrospectionException introspectionException) {
                eventSetPattern = null;
            }
            if (eventSetPattern == null) continue;
            this.addEventSet(eventSetPattern);
        }
    }

    void resolveFields() {
        FieldElement[] fieldElementArray = this.classElement.getFields();
        String string = PropertyActionSettings.getDefault().getPropStyle();
        int n = 0;
        while (n < fieldElementArray.length) {
            FieldElement fieldElement = fieldElementArray[n];
            if ((fieldElement.getModifiers() & 8) == 0) {
                Type type;
                PropertyPattern propertyPattern;
                String string2 = fieldElement.getName().getName();
                if (string2.startsWith(string)) {
                    string2 = string2.substring(1);
                }
                if ((propertyPattern = (PropertyPattern)this.propertyPatterns.get(string2)) == null) {
                    propertyPattern = (PropertyPattern)this.idxPropertyPatterns.get(string2);
                }
                if (propertyPattern != null && (type = propertyPattern.getType()) != null && propertyPattern.getType().compareTo(fieldElement.getType(), false)) {
                    propertyPattern.setEstimatedField(fieldElement);
                }
            }
            ++n;
        }
    }

    private void resolveChangesOfProperties() {
        this.currentPropertyPatterns = PatternAnalyser.resolveChanges(this.currentPropertyPatterns, this.propertyPatterns, LevelComparator.PROPERTY);
    }

    private void resolveChangesOfIdxProperties() {
        this.currentIdxPropertyPatterns = PatternAnalyser.resolveChanges(this.currentIdxPropertyPatterns, this.idxPropertyPatterns, LevelComparator.IDX_PROPERTY);
    }

    private void resolveChangesOfEventSets() {
        this.currentEventSetPatterns = PatternAnalyser.resolveChanges(this.currentEventSetPatterns, this.eventSetPatterns, LevelComparator.EVENT_SET);
    }

    static ArrayList resolveChanges(Collection collection, Map map, LevelComparator levelComparator) {
        ArrayList arrayList = new ArrayList(collection);
        ArrayList arrayList2 = new ArrayList(map.size());
        arrayList2.addAll(map.values());
        ArrayList<Pattern> arrayList3 = new ArrayList<Pattern>(map.size() + 5);
        int n = 0;
        while (n <= levelComparator.getLevels()) {
            Iterator iterator = arrayList2.iterator();
            block1: while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    Pattern pattern2 = (Pattern)iterator2.next();
                    if (!levelComparator.compare(n, pattern2, pattern)) continue;
                    iterator2.remove();
                    iterator.remove();
                    levelComparator.copyProperties(pattern2, pattern);
                    arrayList3.add(pattern2);
                    continue block1;
                }
            }
            ++n;
        }
        arrayList3.addAll(arrayList2);
        return arrayList3;
    }

    PropertyPattern analyseMethodForProperties(MethodElement methodElement) {
        int n = methodElement.getModifiers();
        if (Modifier.isStatic(n)) {
            return null;
        }
        String string = methodElement.getName().getName();
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        int n2 = methodParameterArray == null ? 0 : methodParameterArray.length;
        Type type = methodElement.getReturn();
        PropertyPattern propertyPattern = null;
        try {
            if (n2 == 0) {
                if (string.startsWith(GET_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, methodElement, null);
                } else if (type.compareTo(Type.BOOLEAN, false) && string.startsWith(IS_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, methodElement, null);
                }
            } else if (n2 == 1) {
                if (methodParameterArray[0].getType().compareTo(Type.INT, false) && string.startsWith(GET_PREFIX)) {
                    propertyPattern = new IdxPropertyPattern(this, null, null, methodElement, null);
                } else if (type.compareTo(Type.VOID, false) && string.startsWith(SET_PREFIX)) {
                    propertyPattern = new PropertyPattern(this, null, methodElement);
                }
            } else if (n2 == 2 && methodParameterArray[0].getType().compareTo(Type.INT, false) && string.startsWith(SET_PREFIX)) {
                propertyPattern = new IdxPropertyPattern(this, null, null, null, methodElement);
            }
        }
        catch (IntrospectionException introspectionException) {
            propertyPattern = null;
        }
        return propertyPattern;
    }

    void analyseMethodForEventSets(MethodElement methodElement, Map map, Map map2) {
        int n = methodElement.getModifiers();
        if (Modifier.isStatic(n)) {
            return;
        }
        String string = methodElement.getName().getName();
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        Type type = methodElement.getReturn();
        if (string.startsWith(ADD_PREFIX) && methodParameterArray.length == 1 && type == Type.VOID) {
            String string2 = string.substring(3) + ":" + methodParameterArray[0].getType();
            map.put(string2, methodElement);
        } else if (string.startsWith(REMOVE_PREFIX) && methodParameterArray.length == 1 && type == Type.VOID) {
            String string3 = string.substring(6) + ":" + methodParameterArray[0].getType();
            map2.put(string3, methodElement);
        }
    }

    private void addProperty(PropertyPattern propertyPattern) {
        boolean bl = propertyPattern instanceof IdxPropertyPattern;
        HashMap hashMap = bl ? this.idxPropertyPatterns : this.propertyPatterns;
        String string = propertyPattern.getName();
        PropertyPattern propertyPattern2 = (PropertyPattern)this.propertyPatterns.get(string);
        if (propertyPattern2 == null) {
            propertyPattern2 = (PropertyPattern)this.idxPropertyPatterns.get(string);
        }
        if (propertyPattern2 == null) {
            hashMap.put(string, propertyPattern);
            return;
        }
        Type type = propertyPattern2.getType();
        Type type2 = propertyPattern.getType();
        if (type != null && type2 != null && !type.compareTo(type2, false)) {
            hashMap.put(string, propertyPattern);
            return;
        }
        boolean bl2 = propertyPattern2 instanceof IdxPropertyPattern;
        if (bl || bl2) {
            if (bl && !bl2) {
                this.propertyPatterns.remove(propertyPattern2.getName());
            } else if (!bl && bl2) {
                this.idxPropertyPatterns.remove(propertyPattern2.getName());
            }
            IdxPropertyPattern idxPropertyPattern = new IdxPropertyPattern(propertyPattern2, propertyPattern);
            this.idxPropertyPatterns.put(string, idxPropertyPattern);
        } else {
            PropertyPattern propertyPattern3 = new PropertyPattern(propertyPattern2, propertyPattern);
            this.propertyPatterns.put(string, propertyPattern3);
        }
    }

    void addEventSet(EventSetPattern eventSetPattern) {
        String string = eventSetPattern.getName() + eventSetPattern.getType();
        EventSetPattern eventSetPattern2 = (EventSetPattern)this.eventSetPatterns.get(string);
        if (eventSetPattern2 == null) {
            this.eventSetPatterns.put(string, eventSetPattern);
            return;
        }
        EventSetPattern eventSetPattern3 = new EventSetPattern(eventSetPattern2, eventSetPattern);
        this.eventSetPatterns.put(string, eventSetPattern3);
    }

    static boolean isSubclass(ClassElement classElement, ClassElement classElement2) {
        if (classElement == null || classElement2 == null) {
            return false;
        }
        if (classElement.getName().compareTo(classElement2.getName(), false)) {
            return true;
        }
        ClassElement classElement3 = classElement;
        while (classElement3 != null) {
            if (classElement3.getName().compareTo(classElement2.getName(), false)) {
                return true;
            }
            if (classElement2.isInterface()) {
                Identifier[] identifierArray = classElement3.getInterfaces();
                int n = 0;
                while (n < identifierArray.length) {
                    ClassElement classElement4 = ClassElement.forName((String)identifierArray[n].getFullName());
                    if (PatternAnalyser.isSubclass(classElement4, classElement2)) {
                        return true;
                    }
                    ++n;
                }
            }
            ClassElement classElement5 = classElement3 = classElement3.getSuperclass() == null ? null : ClassElement.forName((String)classElement3.getSuperclass().getFullName());
        }
        return false;
    }

    static abstract class LevelComparator {
        static LevelComparator PROPERTY = new Property();
        static LevelComparator IDX_PROPERTY = new IdxProperty();
        static LevelComparator EVENT_SET = new EventSet();

        LevelComparator() {
        }

        abstract boolean compare(int var1, Pattern var2, Pattern var3);

        abstract int getLevels();

        abstract void copyProperties(Pattern var1, Pattern var2);

        static class EventSet
        extends LevelComparator {
            EventSet() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((EventSetPattern)pattern).getAddListenerMethod() == ((EventSetPattern)pattern2).getAddListenerMethod() || ((EventSetPattern)pattern).getRemoveListenerMethod() == ((EventSetPattern)pattern2).getRemoveListenerMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 0;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((EventSetPattern)pattern).copyProperties((EventSetPattern)pattern2);
            }
        }

        static class IdxProperty
        extends LevelComparator {
            IdxProperty() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((IdxPropertyPattern)pattern).getIndexedGetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedGetterMethod() && ((IdxPropertyPattern)pattern).getIndexedSetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedSetterMethod();
                    }
                    case 1: {
                        return ((IdxPropertyPattern)pattern).getIndexedGetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedGetterMethod();
                    }
                    case 2: {
                        return ((IdxPropertyPattern)pattern).getIndexedSetterMethod() == ((IdxPropertyPattern)pattern2).getIndexedSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((IdxPropertyPattern)pattern).copyProperties((IdxPropertyPattern)pattern2);
            }
        }

        static class Property
        extends LevelComparator {
            Property() {
            }

            boolean compare(int n, Pattern pattern, Pattern pattern2) {
                switch (n) {
                    case 0: {
                        return ((PropertyPattern)pattern).getGetterMethod() == ((PropertyPattern)pattern2).getGetterMethod() && ((PropertyPattern)pattern).getSetterMethod() == ((PropertyPattern)pattern2).getSetterMethod();
                    }
                    case 1: {
                        return ((PropertyPattern)pattern).getGetterMethod() == ((PropertyPattern)pattern2).getGetterMethod();
                    }
                    case 2: {
                        return ((PropertyPattern)pattern).getSetterMethod() == ((PropertyPattern)pattern2).getSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern pattern, Pattern pattern2) {
                ((PropertyPattern)pattern).copyProperties((PropertyPattern)pattern2);
            }
        }
    }
}

