/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.Utilities;

public class PropertyPattern
extends Pattern {
    public static final int READ_WRITE = 1;
    public static final int READ_ONLY = 2;
    public static final int WRITE_ONLY = 4;
    static final String PROPERTY_CHANGE = "firePropertyChange";
    static final String VETOABLE_CHANGE = "fireVetoableChange";
    protected MethodElement getterMethod = null;
    protected MethodElement setterMethod = null;
    protected FieldElement estimatedField = null;
    protected Type type;
    protected String name;

    public PropertyPattern(PatternAnalyser patternAnalyser, MethodElement methodElement, MethodElement methodElement2) throws IntrospectionException {
        super(patternAnalyser);
        this.getterMethod = methodElement;
        this.setterMethod = methodElement2;
        this.type = this.findPropertyType();
        this.name = this.findPropertyName();
    }

    PropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2) throws SourceException {
        PropertyPattern propertyPattern = new PropertyPattern(patternAnalyser);
        propertyPattern.name = string;
        propertyPattern.type = Type.parse((String)string2);
        propertyPattern.generateGetterMethod();
        propertyPattern.generateSetterMethod();
        return propertyPattern;
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws SourceException {
        return PropertyPattern.create(patternAnalyser, string, string2, n, bl, bl2, bl3, bl4, bl5, bl6, false, false);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws SourceException {
        PropertyPattern propertyPattern = new PropertyPattern(patternAnalyser);
        propertyPattern.name = string;
        propertyPattern.type = Type.parse((String)string2);
        if ((bl3 || bl6) && !bl8) {
            try {
                propertyPattern.generateField(true);
            }
            catch (SourceException sourceException) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String string3 = null;
        String string4 = null;
        if (bl6) {
            boolean bl9 = bl;
            boolean bl10 = bl2;
            if (!bl7) {
                if (bl9 && (string3 = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(propertyPattern.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    bl9 = false;
                }
                if (bl10 && (string4 = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(propertyPattern.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    bl10 = false;
                }
            } else {
                if (bl9 && (string3 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(propertyPattern.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    bl9 = false;
                }
                if (bl10 && (string4 = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(propertyPattern.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    bl10 = false;
                }
            }
            if (bl9) {
                string3 = BeanPatternGenerator.supportField(propertyPattern.getDeclaringClass());
            }
            if (bl10) {
                string4 = BeanPatternGenerator.vetoSupportField(propertyPattern.getDeclaringClass());
            }
            if (bl9) {
                BeanPatternGenerator.supportListenerMethods(propertyPattern.getDeclaringClass(), string3);
            }
            if (bl10) {
                BeanPatternGenerator.vetoSupportListenerMethods(propertyPattern.getDeclaringClass(), string4);
            }
        }
        if (n == 1 || n == 2) {
            propertyPattern.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(string, bl4, !bl8), true);
        }
        if (n == 1 || n == 4) {
            propertyPattern.generateSetterMethod(BeanPatternGenerator.propertySetterBody(string, propertyPattern.getType(), bl, bl2, bl5, bl6, string3, string4, !bl8), bl2, true);
        }
        return propertyPattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws SourceException {
        Identifier identifier;
        if (!Utilities.isJavaIdentifier((String)string)) {
            throw new SourceException("Invalid event source name");
        }
        string = Pattern.capitalizeFirstLetter(string);
        if (this.getterMethod != null) {
            identifier = Identifier.create((String)((this.getterMethod.getName().getName().startsWith("get") ? "get" : "is") + string));
            this.getterMethod.setName(identifier);
        }
        if (this.setterMethod != null) {
            identifier = Identifier.create((String)("set" + string));
            this.setterMethod.setName(identifier);
        }
        this.name = Introspector.decapitalize(string);
        if (this.estimatedField != null) {
            identifier = new ElementFormat("{m} {t} {n}");
            String string2 = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldName"), identifier.format((Element)this.estimatedField));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0);
            if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                this.estimatedField.setName(Identifier.create((String)Introspector.decapitalize(string)));
            }
        }
    }

    public int getMode() {
        if (this.setterMethod != null && this.getterMethod != null) {
            return 1;
        }
        if (this.getterMethod != null && this.setterMethod == null) {
            return 2;
        }
        if (this.setterMethod != null && this.getterMethod == null) {
            return 4;
        }
        return 0;
    }

    public void setMode(int n) throws SourceException {
        if (this.getMode() == n) {
            return;
        }
        switch (n) {
            case 1: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod(null, true);
                }
                if (this.setterMethod != null) break;
                this.generateSetterMethod(null, false, true);
                break;
            }
            case 2: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod(null, true);
                }
                if (this.setterMethod == null) break;
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                this.deleteSetterMethod();
                break;
            }
            case 4: {
                if (this.setterMethod == null) {
                    this.generateSetterMethod(null, false, true);
                }
                if (this.getterMethod == null) break;
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                this.deleteGetterMethod();
            }
        }
    }

    public MethodElement getGetterMethod() {
        return this.getterMethod;
    }

    public MethodElement getSetterMethod() {
        return this.setterMethod;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) throws SourceException {
        String string;
        Object object;
        Object object2;
        if (this.type.compareTo(type, true)) {
            return;
        }
        if (this.getterMethod != null) {
            if (this.type.compareTo(Type.BOOLEAN, false)) {
                this.getterMethod.setName(Identifier.create((String)("get" + Pattern.capitalizeFirstLetter(this.getName()))));
            } else if (type.compareTo(Type.BOOLEAN, false)) {
                object2 = MessageFormat.format(PatternNode.getString("FMT_ChangeToIs"), Pattern.capitalizeFirstLetter(this.getName()));
                object = new NotifyDescriptor.Confirmation(object2, 0);
                TopManager.getDefault().notify((NotifyDescriptor)object);
                if (object.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    this.getterMethod.setName(Identifier.create((String)("is" + Pattern.capitalizeFirstLetter(this.getName()))));
                }
            }
            this.getterMethod.setReturn(type);
        }
        if (this.setterMethod != null && ((MethodParameter[])(object2 = this.setterMethod.getParameters())).length > 0) {
            object = object2[0].getType();
            object2[0].setType(type);
            this.setterMethod.setParameters((MethodParameter[])object2);
            string = this.setterMethod.getBody();
            System.out.println("PropertyPattern " + this.setterMethod);
            if (string != null && (string.indexOf(PROPERTY_CHANGE) != -1 || string.indexOf(VETOABLE_CHANGE) != -1)) {
                String string2 = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName().getName());
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0);
                TopManager.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    String string3 = this.regeneratePropertySupport(this.setterMethod.getBody(), null, object2[0].getName(), type, (Type)object);
                    if (string3 != null) {
                        this.setterMethod.setBody(string3);
                    }
                    if ((string3 = this.regeneratePropertySupport(this.setterMethod.getBody(), PROPERTY_CHANGE, object2[0].getName(), type, (Type)object)) != null) {
                        this.setterMethod.setBody(string3);
                    }
                    if ((string3 = this.regeneratePropertySupport(this.setterMethod.getBody(), VETOABLE_CHANGE, object2[0].getName(), type, (Type)object)) != null) {
                        this.setterMethod.setBody(string3);
                    }
                }
            }
        }
        this.type = type;
        if (this.estimatedField != null) {
            object2 = new ElementFormat("{m} {t} {n}");
            object = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldType"), object2.format((Element)this.estimatedField));
            string = new NotifyDescriptor.Confirmation(object, 0);
            if (TopManager.getDefault().notify((NotifyDescriptor)string).equals(NotifyDescriptor.YES_OPTION)) {
                this.estimatedField.setType(type);
            } else {
                this.estimatedField = null;
            }
        }
    }

    protected String regeneratePropertySupport(String string, String string2, String string3, Type type, Type type2) {
        if (string == null) {
            return null;
        }
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        String string4 = PropertyActionSettings.getDefault().getPropStyle();
        if (type2.isArray()) {
            type2 = PropertyPattern.getPrimitiveType(type2);
        }
        if (string2 != null) {
            n = string.indexOf(string2);
            if (n == -1) {
                return null;
            }
        } else {
            String string5 = " old" + Pattern.capitalizeFirstLetter(string3) + " = " + string4 + string3;
            n = string.indexOf(type2.toString() + string5 + ";");
            if (n == -1) {
                n = string.indexOf(type2.toString() + string5 + "[index];");
                if (n == -1) {
                    n = string.indexOf(type2.toString() + "[]" + string5 + ";");
                    if (n == -1) {
                        return null;
                    }
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
        }
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(59, n);
        if (n >= n2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (string2 != null) {
            stringBuffer.append(string2 + " (\"").append(string3).append("\", ");
            if (type.isPrimitive()) {
                stringBuffer.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                stringBuffer.append("old").append(Pattern.capitalizeFirstLetter(string3));
                stringBuffer.append("), ");
                stringBuffer.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                stringBuffer.append(string3).append("))");
            } else {
                stringBuffer.append("old").append(Pattern.capitalizeFirstLetter(string3));
                stringBuffer.append(", ").append(string3).append(")");
            }
        } else {
            stringBuffer.append(type.toString());
            stringBuffer.append(" old").append(Pattern.capitalizeFirstLetter(string3));
            stringBuffer.append(" = ").append(string4).append(string3);
            if (bl) {
                stringBuffer.append("[index]");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.delete(n, n2);
        stringBuffer2.insert(n, (Object)stringBuffer);
        return stringBuffer2.toString();
    }

    private static Type getPrimitiveType(Type type) {
        if (type.isArray()) {
            return PropertyPattern.getPrimitiveType(type.getElementType());
        }
        return type;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (this.getterMethod != null) {
            return this.getterMethod.getCookie(clazz);
        }
        if (this.setterMethod != null) {
            return this.setterMethod.getCookie(clazz);
        }
        return null;
    }

    public FieldElement getEstimatedField() {
        return this.estimatedField;
    }

    void setEstimatedField(FieldElement fieldElement) {
        this.estimatedField = fieldElement;
    }

    public void destroy() throws SourceException {
        if (this.estimatedField != null) {
            ElementFormat elementFormat = new ElementFormat("{m} {t} {n}");
            String string = MessageFormat.format(PatternNode.getString("FMT_DeleteField"), elementFormat.format((Element)this.estimatedField));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
            if (TopManager.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                this.deleteEstimatedField();
            }
        }
        this.deleteGetterMethod();
        this.deleteSetterMethod();
    }

    PropertyPattern(PropertyPattern propertyPattern, PropertyPattern propertyPattern2) {
        super(propertyPattern2.patternAnalyser);
        MethodElement methodElement = propertyPattern.getterMethod;
        MethodElement methodElement2 = propertyPattern2.getterMethod;
        this.getterMethod = methodElement;
        if (methodElement2 != null) {
            this.getterMethod = methodElement2;
        }
        if (methodElement != null && methodElement2 != null && methodElement.getDeclaringClass() == methodElement2.getDeclaringClass() && methodElement.getReturn().compareTo(Type.BOOLEAN, false) && methodElement2.getReturn().compareTo(Type.BOOLEAN, false) && methodElement.getName().getName().indexOf("is") == 0 && methodElement2.getName().getName().indexOf("get") == 0) {
            this.getterMethod = methodElement;
        }
        this.setterMethod = propertyPattern.getSetterMethod();
        if (propertyPattern2.getSetterMethod() != null) {
            this.setterMethod = propertyPattern2.getSetterMethod();
        }
        try {
            this.type = this.findPropertyType();
        }
        catch (IntrospectionException introspectionException) {
            throw new InternalError("Mixing invalid PropertyPattrens" + introspectionException);
        }
        this.name = this.findPropertyName();
    }

    Type findPropertyType() throws IntrospectionException {
        Type type = null;
        if (this.getterMethod != null) {
            if (this.getterMethod.getParameters().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            type = this.getterMethod.getReturn();
            if (type.compareTo(Type.VOID, false)) {
                throw new IntrospectionException("read method " + this.getterMethod.getName().getName() + " returns void");
            }
        }
        if (this.setterMethod != null) {
            MethodParameter[] methodParameterArray = this.setterMethod.getParameters();
            if (methodParameterArray.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (type != null && !type.compareTo(methodParameterArray[0].getType(), false)) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            type = methodParameterArray[0].getType();
        }
        return type;
    }

    String findPropertyName() {
        String string = null;
        if (this.getterMethod != null) {
            string = this.getterMethod.getName().getName();
        } else if (this.setterMethod != null) {
            string = this.setterMethod.getName().getName();
        } else {
            return null;
        }
        return string.startsWith("is") ? Introspector.decapitalize(string.substring(2)) : Introspector.decapitalize(string.substring(3));
    }

    void generateGetterMethod() throws SourceException {
        this.generateGetterMethod(null, false);
    }

    void generateGetterMethod(String string, boolean bl) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)((this.type == Type.BOOLEAN ? "is" : "get") + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(this.type);
        methodElement.setModifiers(1);
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (bl) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), this.getName());
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.getterMethod = classElement.getMethod(methodElement.getName(), PropertyPattern.getParameterTypes(methodElement));
    }

    void generateSetterMethod() throws SourceException {
        this.generateSetterMethod(null, false, false);
    }

    void generateSetterMethod(String string, boolean bl, boolean bl2) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)("set" + Pattern.capitalizeFirstLetter(this.getName()))));
        methodElement.setReturn(Type.VOID);
        methodElement.setModifiers(1);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter(this.name, this.type, false)});
        if (bl) {
            methodElement.setExceptions(new Identifier[]{Identifier.create((String)"java.beans.PropertyVetoException")});
        }
        if (classElement.isInterface()) {
            methodElement.setBody(null);
        } else if (string != null) {
            methodElement.setBody(string);
        }
        if (bl2) {
            String string2 = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), this.getName(), this.name);
            if (bl) {
                string2 = string2 + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            methodElement.getJavaDoc().setRawText(string2);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.addMethod(methodElement);
        this.setterMethod = classElement.getMethod(methodElement.getName(), PropertyPattern.getParameterTypes(methodElement));
    }

    void generateField() throws SourceException {
        this.generateField(false);
    }

    void generateField(boolean bl) throws SourceException {
        String string;
        ClassElement classElement = this.getDeclaringClass();
        FieldElement fieldElement = new FieldElement();
        String string2 = this.getName();
        if (PropertyActionSettings.getDefault().getPropStyle().equals("_")) {
            string2 = "_" + string2;
        }
        fieldElement.setName(Identifier.create((String)Introspector.decapitalize(string2)));
        fieldElement.setType(this.type);
        fieldElement.setModifiers(2);
        if (bl) {
            string = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), string2);
            fieldElement.getJavaDoc().setRawText(string);
        }
        if (classElement == null) {
            throw new SourceException();
        }
        if (classElement.getField(fieldElement.getName()) == null) {
            classElement.addField(fieldElement);
            this.estimatedField = classElement.getField(fieldElement.getName());
        } else {
            string = classElement.getField(fieldElement.getName());
            if ((string.getModifiers() & 8) != 0) {
                throw new SourceException();
            }
            if (!string.getType().getFullString().equals(fieldElement.getType().getFullString())) {
                throw new SourceException();
            }
        }
    }

    void deleteEstimatedField() throws SourceException {
        if (this.estimatedField == null) {
            return;
        }
        ClassElement classElement = this.getDeclaringClass();
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.removeField(this.estimatedField);
        this.estimatedField = null;
    }

    void deleteGetterMethod() throws SourceException {
        if (this.getterMethod == null) {
            return;
        }
        ClassElement classElement = this.getDeclaringClass();
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.removeMethod(this.getterMethod);
        this.getterMethod = null;
    }

    void deleteSetterMethod() throws SourceException {
        if (this.setterMethod == null) {
            return;
        }
        ClassElement classElement = this.getDeclaringClass();
        if (classElement == null) {
            throw new SourceException();
        }
        classElement.removeMethod(this.setterMethod);
        this.setterMethod = null;
    }

    static Type[] getParameterTypes(MethodElement methodElement) {
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray == null ? 0 : methodParameterArray.length];
        int n = 0;
        while (n < methodParameterArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        return typeArray;
    }

    void copyProperties(PropertyPattern propertyPattern) {
        boolean bl;
        boolean bl2 = !propertyPattern.getType().equals((Object)this.getType()) || !propertyPattern.getName().equals(this.getName()) || propertyPattern.getMode() != this.getMode() || !(propertyPattern.getEstimatedField() != null ? propertyPattern.getEstimatedField().equals(this.estimatedField) : this.estimatedField == null) ? true : (bl = false);
        if (propertyPattern.getGetterMethod() != this.getterMethod) {
            this.getterMethod = propertyPattern.getGetterMethod();
        }
        if (propertyPattern.getSetterMethod() != this.setterMethod) {
            this.setterMethod = propertyPattern.getSetterMethod();
        }
        if (propertyPattern.getEstimatedField() != this.estimatedField) {
            this.estimatedField = propertyPattern.getEstimatedField();
        }
        if (bl) {
            try {
                this.type = this.findPropertyType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.name = this.findPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

