/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jndi;

import java.util.ArrayList;
import java.util.Collections;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import org.netbeans.modules.jndi.JndiFailedNode;
import org.netbeans.modules.jndi.JndiKey;
import org.netbeans.modules.jndi.JndiLeafNode;
import org.netbeans.modules.jndi.JndiNode;
import org.netbeans.modules.jndi.JndiObjectCreator;
import org.netbeans.modules.jndi.JndiRootNode;
import org.netbeans.modules.jndi.WaitNode;
import org.netbeans.modules.jndi.utils.APCTarget;
import org.netbeans.modules.jndi.utils.Request;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public final class JndiChildren
extends Children.Keys
implements APCTarget {
    public static final String CONTEXT_CLASS_NAME = "javax.naming.Context";
    private static Class ctxClass;
    private final Context thisContext;
    private ArrayList keys;
    private WaitNode waitNode;
    private CompositeName offset;

    public JndiChildren(Context context, CompositeName compositeName) {
        this.thisContext = context;
        this.offset = compositeName;
        this.keys = new ArrayList();
    }

    protected void addNotify() {
        this.waitNode = new WaitNode();
        this.add(new Node[]{this.waitNode});
        this.prepareKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    public CompositeName getOffset() {
        return this.offset;
    }

    public String getOffsetAsString() {
        return JndiObjectCreator.stringifyCompositeName(this.offset);
    }

    public Context getContext() {
        return this.thisContext;
    }

    public void prepareKeys() {
        JndiRootNode.getDefault();
        RequestProcessor.postRequest((Runnable)new Request(this));
    }

    public Node[] createNodes(Object object) {
        Binding binding = null;
        Object var3_3 = null;
        Object var4_4 = null;
        if (object == null) {
            return null;
        }
        if (!(object instanceof JndiKey)) {
            return null;
        }
        binding = ((JndiKey)object).name;
        try {
            if (((JndiKey)object).failed) {
                return new Node[]{new JndiFailedNode((JndiKey)object, this.offset)};
            }
            if (JndiChildren.isContext(binding)) {
                return new Node[]{new JndiNode((JndiKey)object, this.offset)};
            }
            return new Node[]{new JndiLeafNode((JndiKey)object, this.offset)};
        }
        catch (InvalidNameException invalidNameException) {
            return new Node[0];
        }
    }

    static boolean isContext(Binding binding) {
        String string = binding.getClassName();
        if (string.equals(CONTEXT_CLASS_NAME)) {
            return true;
        }
        if (JndiChildren.isPrimitive(string)) {
            return false;
        }
        return binding.getObject() instanceof Context;
    }

    private static boolean isPrimitive(String string) {
        if (string.indexOf(46) >= 0) {
            return false;
        }
        return string.equals("int") || string.equals("short") || string.equals("long") || string.equals("byte") || string.equals("char") || string.equals("float") || string.equals("double") || string.equals("boolean");
    }

    static Class getCtxClass() throws ClassNotFoundException {
        if (ctxClass == null) {
            ctxClass = Class.forName(CONTEXT_CLASS_NAME);
        }
        return ctxClass;
    }

    public void preAction() throws Exception {
    }

    /*
     * Unable to fully structure code
     */
    public void performAction() throws Exception {
        var1_1 = this.thisContext.listBindings("");
        this.keys.clear();
        if (var1_1 != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.keys.add(new JndiKey(var1_1.next()));
lbl7:
            // 2 sources

            ** while (var1_1.hasMore())
        }
lbl8:
        // 1 sources

    }

    public void postAction() throws Exception {
        this.setKeys(this.keys);
        if (this.waitNode != null) {
            this.remove(new Node[]{this.waitNode});
        }
    }

    public final Node getOwner() {
        return this.getNode();
    }

    public void updateKey(Object object) {
        this.refreshKey(object);
    }
}

