/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.PropertyBundleSupport;
import org.netbeans.modules.properties.StructHandler;
import org.openide.util.WeakListener;

public class BundleStructure {
    PropertiesDataObject obj;
    private PropertiesFileEntry[] entries;
    private ArrayList keyList;
    private KeyComparator comparator = new KeyComparator(0, true);
    private PropertyBundleSupport propBundleSupport = new PropertyBundleSupport(this);
    private PropertyChangeListener propListener;

    public BundleStructure(PropertiesDataObject propertiesDataObject) {
        this.obj = propertiesDataObject;
        this.updateEntries();
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    BundleStructure.this.updateEntries();
                    BundleStructure.this.propBundleSupport.fireBundleStructureChanged();
                }
            }
        };
        propertiesDataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)propertiesDataObject)));
    }

    public PropertiesFileEntry getNthEntry(int n) {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        try {
            return this.entries[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int getEntryIndexByFileName(String string) {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        int n = 0;
        while (n < this.getEntryCount()) {
            if (this.entries[n].getFile().getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String string) {
        int n = this.getEntryIndexByFileName(string);
        return n == -1 ? null : this.entries[n];
    }

    public int getEntryCount() {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        return this.entries.length;
    }

    public String[] getKeys() {
        if (this.keyList == null) {
            throw new IllegalStateException("Resource Bundles: KeyList not initialized");
        }
        Object[] objectArray = this.keyList.toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public String getNthKey(int n) {
        if (this.keyList == null) {
            throw new IllegalStateException("Resource Bundles: KeyList not initialized");
        }
        if (n >= this.keyList.size() || n < 0) {
            return null;
        }
        return (String)this.keyList.get(n);
    }

    public int getKeyIndexByName(String string) {
        return this.keyList.indexOf(string);
    }

    public Element.ItemElem getItem(int n, int n2) {
        PropertiesFileEntry propertiesFileEntry = this.getNthEntry(n);
        if (propertiesFileEntry == null) {
            return null;
        }
        String string = this.getNthKey(n2);
        PropertiesStructure propertiesStructure = propertiesFileEntry.getHandler().getStructure();
        if (propertiesStructure != null) {
            return propertiesStructure.getItem(string);
        }
        return null;
    }

    public int getKeyCount() {
        if (this.keyList != null) {
            return this.keyList.size();
        }
        throw new IllegalStateException("Resource Bundles: KeyList not initialized");
    }

    public void sort(int n) {
        if (n >= 0) {
            this.comparator.setIndex(n);
        }
        Collections.sort(this.keyList, this.comparator);
        this.propBundleSupport.fireBundleDataChanged();
    }

    public int getSortIndex() {
        return this.comparator.getIndex();
    }

    public boolean getSortOrder() {
        return this.comparator.isAscending();
    }

    private void updateEntries() {
        TreeMap<String, PropertiesFileEntry> treeMap = new TreeMap<String, PropertiesFileEntry>(PropertiesDataObject.getSecondaryFilesComparator());
        Iterator iterator = this.obj.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            PropertiesFileEntry propertiesFileEntry = (PropertiesFileEntry)((Object)iterator.next());
            treeMap.put(propertiesFileEntry.getFile().getName(), propertiesFileEntry);
        }
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            this.entries = new PropertiesFileEntry[treeMap.size() + 1];
            this.entries[0] = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            int n = 0;
            Iterator iterator2 = treeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                this.entries[++n] = (PropertiesFileEntry)((Object)treeMap.get(iterator2.next()));
            }
        }
        this.buildKeySet();
    }

    private void buildKeySet() {
        this.keyList = new ArrayList(){

            public boolean equals(Object object) {
                if (!(object instanceof ArrayList)) {
                    return false;
                }
                ArrayList arrayList = (ArrayList)object;
                if (this.size() != arrayList.size()) {
                    return false;
                }
                int n = 0;
                while (n < this.size()) {
                    if (!this.contains(arrayList.get(n)) || !arrayList.contains(this.get(n))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        };
        int n = 0;
        while (n < this.getEntryCount()) {
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(n);
            PropertiesStructure propertiesStructure = propertiesFileEntry.getHandler().getStructure();
            if (propertiesStructure != null) {
                Iterator iterator = propertiesStructure.allItems();
                while (iterator.hasNext()) {
                    String string;
                    Element.ItemElem itemElem = (Element.ItemElem)iterator.next();
                    if (itemElem == null || (string = itemElem.getKey()) == null || this.keyList.contains(string)) continue;
                    this.keyList.add(itemElem.getKey());
                }
            }
            ++n;
        }
        Collections.sort(this.keyList, this.comparator);
    }

    public void addPropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        this.propBundleSupport.addPropertyBundleListener(propertyBundleListener);
    }

    public void removePropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        this.propBundleSupport.removePropertyBundleListener(propertyBundleListener);
    }

    void itemChanged(Element.ItemElem itemElem) {
        this.propBundleSupport.fireItemChanged(itemElem.getParent().getParent().getEntry().getFile().getName(), itemElem.getKey());
    }

    void oneFileChanged(StructHandler structHandler) {
        ArrayList arrayList = this.keyList;
        this.buildKeySet();
        if (!((AbstractList)this.keyList).equals(arrayList)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(structHandler.getEntry().getFile().getName());
        }
    }

    void oneFileChanged(StructHandler structHandler, Map map, Map map2, Map map3) {
        this.buildKeySet();
        this.propBundleSupport.fireBundleDataChanged();
    }

    private final class KeyComparator
    implements Comparator {
        private int index;
        private boolean ascending;

        public KeyComparator(int n, boolean bl) {
            this.index = n;
            this.ascending = bl;
        }

        public void setIndex(int n) {
            if (this.index == n) {
                if (this.ascending) {
                    this.ascending = false;
                } else {
                    n = -1;
                    this.ascending = true;
                }
            } else {
                this.ascending = true;
            }
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2;
            Element.ItemElem itemElem;
            Element.ItemElem itemElem2;
            if (this.index < 0) {
                itemElem2 = BundleStructure.this.getItem(0, BundleStructure.this.getKeyIndexByName((String)object));
                itemElem = BundleStructure.this.getItem(0, BundleStructure.this.getKeyIndexByName((String)object2));
                if (itemElem2 != null && itemElem != null) {
                    int n;
                    int n2 = itemElem2.getBounds().getBegin().getOffset();
                    if (n2 < (n = itemElem.getBounds().getBegin().getOffset())) {
                        return -1;
                    }
                    if (n2 == n) {
                        return 0;
                    }
                    return 1;
                }
                if (itemElem2 != null) {
                    return -1;
                }
                if (itemElem != null) {
                    return 1;
                }
                string2 = (String)object;
                string = (String)object2;
            }
            if (this.index == 0) {
                string2 = (String)object;
                string = (String)object2;
            } else {
                itemElem2 = BundleStructure.this.getItem(this.index - 1, BundleStructure.this.getKeyIndexByName((String)object));
                itemElem = BundleStructure.this.getItem(this.index - 1, BundleStructure.this.getKeyIndexByName((String)object2));
                if (itemElem2 == null) {
                    if (itemElem == null) {
                        return 0;
                    }
                    return this.ascending ? 1 : -1;
                }
                if (itemElem == null) {
                    return this.ascending ? -1 : 1;
                }
                string2 = itemElem2.getValue();
                string = itemElem.getValue();
            }
            if (string2 == null) {
                if (string == null) {
                    return 0;
                }
                return this.ascending ? 1 : -1;
            }
            if (string == null) {
                return this.ascending ? -1 : 1;
            }
            int n = string2.compareToIgnoreCase(string);
            return this.ascending ? n : -n;
        }
    }
}

