/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormCookie;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelAdapter;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.actions.FormEditorAction;
import org.netbeans.modules.form.palette.PaletteTopComponent;
import org.netbeans.modules.java.JavaEditor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class FormEditorSupport
extends JavaEditor
implements FormCookie,
EditCookie {
    private FormModel formModel;
    private FormDataObject formDataObject;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private PersistenceManager saveManager;
    private boolean formLoaded = false;
    private static boolean openOnEditing = false;
    private FormModelListener formListener;
    private static PropertyChangeListener workspacesListener;
    private static PropertyChangeListener settingsListener;
    private static PropertyChangeListener topcompsListener;
    private UndoRedo.Manager undoManager;
    private static Hashtable openForms;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$FormEditorAction;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public FormEditorSupport(MultiDataObject.Entry entry, FormDataObject formDataObject) {
        super(entry);
        this.formDataObject = formDataObject;
        this.formLoaded = false;
    }

    private void superOpen() {
        super.open();
    }

    public void open() {
        TopManager.getDefault().setStatusText(MessageFormat.format(FormEditor.getFormBundle().getString("FMT_OpeningForm"), this.formDataObject.getName()));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FormEditorSupport.this.loadFormImpl();
                boolean bl = FormEditorSupport.this.formLoaded && FormEditorSupport.this.activateWorkspace();
                FormEditorSupport.this.superOpen();
                if (bl) {
                    FormEditorSupport.this.openGUI();
                }
                TopManager.getDefault().setStatusText("");
            }
        });
    }

    public boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            this.loadFormImpl();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        FormEditorSupport.this.loadFormImpl();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    public void edit() {
        super.open();
    }

    public boolean isOpened() {
        return this.formLoaded;
    }

    public void saveDocument() throws IOException {
        this.saveForm();
        super.saveDocument();
    }

    protected void saveDocumentIfNecessary(boolean bl) throws IOException {
        this.saveForm();
        super.saveDocumentIfNecessary(bl);
    }

    public FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public Node getFormRootNode() {
        return this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.formDesigner == null) {
            this.formDesigner = new FormDesigner(this.formModel);
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
    }

    boolean supportsAdvancedFeatures() {
        return this.saveManager.supportsAdvancedFeatures();
    }

    void markFormModified() {
        if (this.formLoaded && !this.formDataObject.isModified()) {
            super.notifyModified();
        }
    }

    void updateFormName(String string) {
        if (!this.formLoaded) {
            return;
        }
        this.formModel.setName(string);
        this.formModel.getFormDesigner().updateName(string);
        this.formRootNode.updateName(string);
        this.formModel.fireFormChanged();
    }

    void updateNodeChildren(ComponentContainer componentContainer) {
        FormNode formNode = componentContainer == null || componentContainer == this.formModel.getModelContainer() ? (this.formRootNode != null ? this.formRootNode.getOthersNode() : null) : (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : null);
        if (formNode != null) {
            formNode.updateChildren();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.undoManager = super.createUndoRedoManager();
        return this.undoManager;
    }

    UndoRedo.Manager getUndoManager() {
        return this.undoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormModel[] getOpenedForms() {
        Hashtable hashtable = openForms;
        synchronized (hashtable) {
            Object object;
            Collection collection = openForms.values();
            ArrayList<FormModel> arrayList = new ArrayList<FormModel>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (FormEditorSupport)iterator.next();
                if (!((FormEditorSupport)object).formLoaded) continue;
                arrayList.add(((FormEditorSupport)object).getFormModel());
            }
            object = new FormModel[arrayList.size()];
            arrayList.toArray((T[])object);
            Object object2 = object;
            return object2;
        }
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditorSupport formEditorSupport = (FormEditorSupport)openForms.get(formModel);
        return formEditorSupport != null ? formEditorSupport.getFormDesigner() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditorSupport formEditorSupport = (FormEditorSupport)openForms.get(formModel);
        return formEditorSupport != null ? formEditorSupport.getFormDataObject() : null;
    }

    public static FormEditorSupport getSupport(FormModel formModel) {
        return (FormEditorSupport)openForms.get(formModel);
    }

    private void openForm(final boolean bl) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FormEditorSupport.this.loadFormImpl();
                if (FormEditorSupport.this.formLoaded) {
                    boolean bl2 = bl && FormEditorSupport.this.activateWorkspace();
                    FormEditorSupport.this.superOpen();
                    if (bl2) {
                        FormEditorSupport.this.openGUI();
                    }
                }
            }
        });
    }

    private void loadFormImpl() {
        if (this.formLoaded) {
            return;
        }
        PersistenceManager[] persistenceManagerArray = this.recognizeForm(this.formDataObject);
        if (persistenceManagerArray == null) {
            return;
        }
        PersistenceManager persistenceManager = persistenceManagerArray[0];
        this.saveManager = persistenceManagerArray[1];
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        openForms.put(this.formModel, this);
        try {
            persistenceManager.loadForm(this.formDataObject, this.formModel);
            this.reportErrors(false, null);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.saveManager = null;
            openForms.remove(this.formModel);
            this.formModel = null;
            this.reportErrors(true, throwable);
            return;
        }
        this.formLoaded = true;
        this.formModel.fireFormLoaded();
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        FormEditorSupport.attachSettingsListener();
        FormEditorSupport.attachTopComponentsListener();
    }

    private PersistenceManager[] recognizeForm(FormDataObject formDataObject) {
        Object object;
        PersistenceManager persistenceManager = null;
        PersistenceManager persistenceManager2 = null;
        Iterator iterator = PersistenceManager.getManagers();
        while (iterator.hasNext()) {
            object = (PersistenceManager)iterator.next();
            try {
                if (!((PersistenceManager)object).canLoadForm(formDataObject)) continue;
                persistenceManager = object;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (persistenceManager == null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormEditor.getFormBundle().getString("MSG_ERR_NotRecognizedForm"), 0));
            return null;
        }
        if (!persistenceManager.supportsAdvancedFeatures() && NotifyDescriptor.YES_OPTION.equals(object = TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)FormEditor.getFormBundle().getString("MSG_ConvertForm"), 0, 3)))) {
            persistenceManager2 = new GandalfPersistenceManager();
        }
        if (persistenceManager2 == null) {
            persistenceManager2 = persistenceManager;
        }
        return new PersistenceManager[]{persistenceManager, persistenceManager2};
    }

    private void reportErrors(boolean bl, Throwable throwable) {
        if (bl) {
            if (throwable == null) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(FormEditor.getFormBundle().getString("FMT_ERR_LoadingForm"), this.formDataObject.getName()), 0));
            } else {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    throwable.printStackTrace();
                }
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(FormEditor.getFormBundle().getString("FMT_ERR_LoadingFormDetails"), this.formDataObject.getName(), Utilities.getShortClassName(throwable.getClass()), throwable.getMessage()), 0));
            }
        } else {
            FormEditor.displayErrorLog();
        }
    }

    private boolean activateWorkspace() {
        FormEditorSupport.attachWorkspacesListener();
        if (FormEditorSupport.isCurrentWorkspaceEditing()) {
            Workspace workspace;
            String string = FormEditor.getFormSettings().getWorkspace();
            if (!string.equalsIgnoreCase(FormEditor.getFormBundle().getString("VALUE_WORKSPACE_NONE")) && (workspace = TopManager.getDefault().getWindowManager().findWorkspace(string)) != null) {
                workspace.activate();
            }
            return true;
        }
        openOnEditing = true;
        return false;
    }

    private static boolean isCurrentWorkspaceEditing() {
        String string = TopManager.getDefault().getWindowManager().getCurrentWorkspace().getName();
        return "Editing".equals(string) || "Visual".equals(string) || FormEditor.getFormSettings().getWorkspace().equals(string);
    }

    private void openGUI() {
        FormDesigner formDesigner = FormEditorSupport.getFormDesigner(this.formModel);
        formDesigner.initialize();
        formDesigner.open();
        ComponentInspector.getInstance().open();
        ComponentInspector.getInstance().focusForm(this, true);
        PaletteTopComponent.getInstance().open();
        formDesigner.requestFocus();
    }

    private void saveForm() {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly()) {
            this.formModel.fireFormToBeSaved();
            try {
                this.saveManager.saveForm(this.formDataObject, this.formModel);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void notifyClose() {
        super.notifyClose();
        if (this.formLoaded) {
            this.closeForm();
        }
    }

    protected Task reloadDocumentTask() {
        boolean bl = this.formLoaded;
        if (this.formLoaded) {
            this.closeForm();
        }
        Task task = super.reloadDocumentTask();
        if (bl) {
            this.openForm(true);
        }
        return task;
    }

    private void closeForm() {
        openForms.remove(this.formModel);
        if (this.formDataObject.isValid()) {
            this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{this.formRootNode});
        }
        this.detachFormListener();
        if (openForms.isEmpty()) {
            ComponentInspector.getInstance().focusForm(null, false);
            FormEditorSupport.detachWorkspacesListener();
            FormEditorSupport.detachSettingsListener();
            FormEditorSupport.detachTopComponentsListener();
            PaletteTopComponent paletteTopComponent = PaletteTopComponent.getInstance();
            paletteTopComponent.setCloseOperation(0);
            paletteTopComponent.close();
        } else {
            FormEditorSupport formEditorSupport = (FormEditorSupport)openForms.values().iterator().next();
            ComponentInspector.getInstance().focusForm(formEditorSupport);
        }
        if (this.formDesigner != null) {
            this.formDesigner.setCloseOperation(0);
            this.formDesigner.close();
            this.formDesigner = null;
        }
        this.formRootNode = null;
        this.formDesigner = null;
        this.saveManager = null;
        this.formLoaded = false;
        this.formModel = null;
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelAdapter(){

            public void formChanged(FormModelEvent formModelEvent) {
                FormEditorSupport.this.markFormModified();
            }

            public void containerLayoutChanged(FormModelEvent formModelEvent) {
                FormEditorSupport.this.updateNodeChildren(formModelEvent.getContainer());
            }

            public void componentLayoutChanged(FormModelEvent formModelEvent) {
                FormEditorSupport.this.updateNodeChildren(formModelEvent.getContainer());
            }

            public void componentAdded(FormModelEvent formModelEvent) {
                FormEditorSupport.this.updateNodeChildren(formModelEvent.getContainer());
            }

            public void componentRemoved(FormModelEvent formModelEvent) {
                FormEditorSupport.this.updateNodeChildren(formModelEvent.getContainer());
            }

            public void componentsReordered(FormModelEvent formModelEvent) {
                FormEditorSupport.this.updateNodeChildren(formModelEvent.getContainer());
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    private static void attachWorkspacesListener() {
        if (workspacesListener != null) {
            return;
        }
        workspacesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!"currentWorkspace".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                if (openOnEditing && FormEditorSupport.isCurrentWorkspaceEditing()) {
                    openOnEditing = false;
                    FormEditorAction formEditorAction = (FormEditorAction)SharedClassObject.findObject((Class)(class$org$netbeans$modules$form$actions$FormEditorAction == null ? (class$org$netbeans$modules$form$actions$FormEditorAction = FormEditorSupport.class$("org.netbeans.modules.form.actions.FormEditorAction")) : class$org$netbeans$modules$form$actions$FormEditorAction), (boolean)true);
                    formEditorAction.performAction();
                } else {
                    Workspace workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
                    if (FormEditor.getFormSettings().getWorkspace().equals(workspace.getName())) {
                        return;
                    }
                    Mode mode = workspace.findMode("Form");
                    if (mode != null) {
                        boolean bl = false;
                        TopComponent[] topComponentArray = mode.getTopComponents();
                        int n = 0;
                        while (n < topComponentArray.length) {
                            if (topComponentArray[n].isOpened(workspace)) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (bl) {
                            FormModel[] formModelArray = FormEditorSupport.getOpenedForms();
                            int n2 = 0;
                            while (n2 < formModelArray.length) {
                                FormDesigner formDesigner = FormEditorSupport.getFormDesigner(formModelArray[n2]);
                                if (formDesigner != null) {
                                    formDesigner.open(workspace);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
        };
        TopManager.getDefault().getWindowManager().addPropertyChangeListener(workspacesListener);
    }

    private static void detachWorkspacesListener() {
        if (workspacesListener != null) {
            TopManager.getDefault().getWindowManager().removePropertyChangeListener(workspacesListener);
            workspacesListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Enumeration enumeration = openForms.keys();
                while (enumeration.hasMoreElements()) {
                    FormModel formModel = (FormModel)enumeration.nextElement();
                    String string = propertyChangeEvent.getPropertyName();
                    if ("useIndentEngine".equals(string) || "generateOnSave".equals(string) || "variablesModifier".equals(string) || "variablesLocal".equals(string)) {
                        formModel.fireSyntheticPropertyChanged(null, string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                        continue;
                    }
                    if ("selectionBorderSize".equals(string) || "selectionBorderColor".equals(string) || "connectionBorderColor".equals(string)) {
                        formModel.getFormDesigner().repaint();
                        continue;
                    }
                    if ("formDesignerBackgroundColor".equals(string)) {
                        formModel.getFormDesigner().getFormDesignerPanel().updateBackgroundColor();
                        continue;
                    }
                    if (!"formDesignerBorderColor".equals(string)) continue;
                    formModel.getFormDesigner().getFormDesignerPanel().updateBorderColor();
                }
            }
        };
        FormEditor.getFormSettings().addPropertyChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormEditor.getFormSettings().removePropertyChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    if (!(topComponent instanceof JavaEditor.JavaEditorComponent)) {
                        return;
                    }
                    Node[] nodeArray = topComponent.getActivatedNodes();
                    if (nodeArray == null || nodeArray.length != 1) {
                        return;
                    }
                    SourceCookie sourceCookie = (SourceCookie)nodeArray[0].getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = FormEditorSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                    if (sourceCookie == null) {
                        return;
                    }
                    DataObject dataObject = (DataObject)sourceCookie.getSource().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FormEditorSupport.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dataObject == null) {
                        return;
                    }
                    FormEditorSupport formEditorSupport = ComponentInspector.getInstance().getFocusedForm();
                    Iterator iterator = openForms.values().iterator();
                    while (iterator.hasNext()) {
                        FormEditorSupport formEditorSupport2 = (FormEditorSupport)iterator.next();
                        if (formEditorSupport2.getFormDataObject() != dataObject) continue;
                        if (formEditorSupport2 == formEditorSupport) break;
                        formEditorSupport2.gotoForm();
                        ComponentInspector.getInstance().focusForm(formEditorSupport2);
                        break;
                    }
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
        }
    }

    public void gotoEditor() {
        super.open();
    }

    public void gotoForm() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (FormEditorSupport.this.formModel != null && FormEditorSupport.this.formModel.getFormDesigner().isOpened()) {
                    FormEditorSupport.this.formModel.getFormDesigner().requestVisible();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        openForms = new Hashtable();
    }
}

