/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.ComponentDragger;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.TopManager;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class HandleLayer
extends JPanel {
    static final int COMP_DEEPEST = 0;
    static final int COMP_SELECTED = 1;
    static final int COMP_ABOVE_SELECTED = 2;
    static final int COMP_UNDER_SELECTED = 3;
    private FormDesigner formDesigner;
    private boolean viewOnly;
    private ComponentDragger componentDragger;
    private Point lastLeftMousePoint;
    private Point prevLeftMousePoint;
    private boolean draggingCanceled = false;
    private int resizeType;
    private FormDesigner.Resizer fdResizer;
    private int designerResizeType;
    private boolean wasDragged = false;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$javax$swing$JComponent;

    HandleLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.addMouseListener(new HandleLayerMouseListener());
        this.addMouseMotionListener(new HandleLayerMouseMotionListener());
        this.setLayout(null);
        Method method = null;
        try {
            method = this.getClass().getMethod("setFocusTraversalKeys", Integer.TYPE, class$java$util$Set == null ? (class$java$util$Set = HandleLayer.class$("java.util.Set")) : class$java$util$Set);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            try {
                Class<?> clazz = Class.forName("java.awt.AWTKeyStroke");
                Method method2 = clazz.getMethod("getAWTKeyStroke", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                hashSet.add(method2.invoke(null, new Integer(9), new Integer(128), Boolean.TRUE));
                method.invoke((Object)this, new Integer(0), hashSet);
                hashSet.clear();
                hashSet.add(method2.invoke(null, new Integer(9), new Integer(192), Boolean.TRUE));
                method.invoke((Object)this, new Integer(1), hashSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.getAccessibleContext().setAccessibleName(FormEditor.getFormBundle().getString("ACSN_HandleLayer"));
        this.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_HandleLayer"));
    }

    void setViewOnly(boolean bl) {
        this.viewOnly = bl;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(formSettings.getSelectionBorderSize()));
        RADComponent rADComponent = this.formDesigner.getConnectionSource();
        RADComponent rADComponent2 = this.formDesigner.getConnectionTarget();
        if (rADComponent != null || rADComponent2 != null) {
            graphics2D.setColor(formSettings.getConnectionBorderColor());
            if (rADComponent != null) {
                this.paintSelection(graphics2D, rADComponent);
            }
            if (rADComponent2 != null) {
                this.paintSelection(graphics2D, rADComponent2);
            }
        } else {
            graphics2D.setColor(formSettings.getSelectionBorderColor());
            Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
            while (iterator.hasNext()) {
                this.paintSelection(graphics2D, (RADComponent)iterator.next());
            }
        }
        if (this.componentDragger != null) {
            this.componentDragger.paintDragFeedback(graphics2D);
        }
    }

    private void paintSelection(Graphics2D graphics2D, RADComponent rADComponent) {
        Object object = this.formDesigner.getComponent(rADComponent);
        if (!(object instanceof Component)) {
            return;
        }
        Component component = (Component)object;
        Container container = component.getParent();
        if (container != null && component.isShowing()) {
            Rectangle rectangle = component.getBounds();
            rectangle = SwingUtilities.convertRectangle(container, rectangle, this);
            Rectangle rectangle2 = new Rectangle(new Point(0, 0), container.getSize());
            rectangle2 = SwingUtilities.convertRectangle(container, rectangle2, this);
            Rectangle2D rectangle2D = rectangle.createIntersection(rectangle2);
            int n = formSettings.getSelectionBorderSize() % 2;
            graphics2D.draw(new Rectangle2D.Double(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)n, rectangle2D.getHeight() + (double)n));
        }
    }

    public boolean isOpaque() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9 || keyEvent.getKeyChar() == '\t') {
            if (keyEvent.getID() == 401) {
                if ((keyEvent.getModifiers() & 2) == 2) {
                    if ((keyEvent.getModifiers() & 1) != 1) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                    }
                } else {
                    RADVisualComponent rADVisualComponent = this.formDesigner.getNextVisualComponent((keyEvent.getModifiers() & 1) != 1);
                    if (rADVisualComponent != null) {
                        this.formDesigner.setSelectedComponent(rADVisualComponent);
                    }
                }
            }
            keyEvent.consume();
        } else if (n == 32) {
            Iterator iterator;
            if (!this.viewOnly && keyEvent.getID() == 402 && (iterator = this.formDesigner.getSelectedComponents().iterator()).hasNext()) {
                RADComponent rADComponent = (RADComponent)iterator.next();
                if (!iterator.hasNext()) {
                    this.formDesigner.startInPlaceEditing(rADComponent);
                }
            }
            keyEvent.consume();
        } else if (n == 27) {
            if (this.cancelDragging()) {
                keyEvent.consume();
            }
        } else if (n == 121) {
            if ((keyEvent.getModifiers() & 1) != 0) {
                Point point = null;
                Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
                if (iterator.hasNext()) {
                    RADComponent rADComponent = (RADComponent)iterator.next();
                    Component component = (Component)this.formDesigner.getComponent(rADComponent);
                    if (component instanceof Component) {
                        Component component2 = component;
                        point = SwingUtilities.convertPoint(component2.getParent(), component2.getLocation(), this);
                    } else {
                        point = new Point(0, 0);
                    }
                    this.showContextMenu(point);
                    keyEvent.consume();
                }
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private RADComponent getMetaComponentAt(Point point, int n) {
        ComponentLayer componentLayer = this.formDesigner.getComponentLayer();
        point = SwingUtilities.convertPoint(this, point, componentLayer);
        Component component = SwingUtilities.getDeepestComponentAt(componentLayer, point.x, point.y);
        RADVisualComponent rADVisualComponent = this.formDesigner.getTopDesignComponent();
        RADComponent rADComponent = null;
        RADComponent rADComponent2 = null;
        while (component != null) {
            RADComponent rADComponent3 = this.formDesigner.getMetaComponent(component);
            if (rADComponent3 != null) {
                if (rADComponent == null) {
                    rADComponent = rADComponent3;
                }
                switch (n) {
                    case 0: {
                        return rADComponent3;
                    }
                    case 1: {
                        if (this.formDesigner.isComponentSelected(rADComponent3)) {
                            return rADComponent3;
                        }
                        if (rADComponent3 != rADVisualComponent) break;
                        return rADComponent;
                    }
                    case 2: {
                        if (rADComponent2 != null && this.formDesigner.isComponentSelected(rADComponent2)) {
                            return rADComponent3;
                        }
                        if (rADComponent3 != rADVisualComponent) break;
                        return rADComponent;
                    }
                    case 3: {
                        if (this.formDesigner.isComponentSelected(rADComponent3)) {
                            return rADComponent2 != null ? rADComponent2 : rADVisualComponent;
                        }
                        if (rADComponent3 != rADVisualComponent) break;
                        return rADVisualComponent;
                    }
                }
                rADComponent2 = rADComponent3;
            }
            component = component.getParent();
        }
        return rADComponent;
    }

    RADVisualContainer getMetaContainerAt(Point point) {
        RADComponent rADComponent = this.getMetaComponentAt(point, 0);
        if (rADComponent == null) {
            return null;
        }
        if (rADComponent instanceof RADVisualContainer) {
            return (RADVisualContainer)rADComponent;
        }
        if (rADComponent instanceof RADVisualComponent) {
            return (RADVisualContainer)rADComponent.getParentComponent();
        }
        return null;
    }

    private RADComponent selectComponent(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = mouseEvent.isControlDown() && !mouseEvent.isAltDown();
        boolean bl3 = bl = mouseEvent.isAltDown() && !mouseEvent.isControlDown();
        int n = bl2 ? 3 : (bl ? 2 : 0);
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), n);
        if (mouseEvent.isShiftDown()) {
            if (this.formDesigner.isComponentSelected(rADComponent)) {
                this.formDesigner.removeComponentFromSelection(rADComponent);
            } else {
                this.formDesigner.addComponentToSelection(rADComponent);
            }
        } else if (rADComponent != null) {
            if (this.formDesigner.isComponentSelected(rADComponent)) {
                if (mouseEvent.getID() == 502) {
                    this.formDesigner.setSelectedComponent(rADComponent);
                }
            } else {
                this.formDesigner.setSelectedComponent(rADComponent);
            }
        } else {
            this.formDesigner.clearSelection();
        }
        this.repaint();
        return rADComponent;
    }

    private void selectOtherComponentsNode() {
        FormEditorSupport formEditorSupport = FormEditorSupport.getSupport(this.formDesigner.getModel());
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        Node[] nodeArray = new Node[]{((FormRootNode)formEditorSupport.getFormRootNode()).getOthersNode()};
        try {
            componentInspector.setSelectedNodes(nodeArray, formEditorSupport);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.formDesigner.setActivatedNodes(nodeArray);
    }

    private void processDoubleClick(MouseEvent mouseEvent) {
        SystemAction systemAction;
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            return;
        }
        RADComponent rADComponent = this.getMetaComponentAt(mouseEvent.getPoint(), 1);
        if (rADComponent == null) {
            return;
        }
        if (mouseEvent.isAltDown() && rADComponent instanceof RADVisualComponent && (rADComponent = rADComponent.getParentComponent()) == null) {
            return;
        }
        RADComponentNode rADComponentNode = rADComponent.getNodeReference();
        if (rADComponentNode != null && (systemAction = rADComponentNode.getDefaultAction()) != null) {
            systemAction.actionPerformed(new ActionEvent(rADComponentNode, 1001, ""));
        }
    }

    private void processMouseClickInLayoutSupport(RADComponent rADComponent, MouseEvent mouseEvent) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return;
        }
        if (rADComponent instanceof RADVisualContainer) {
            rADVisualContainer = (RADVisualContainer)rADComponent;
        } else {
            rADVisualContainer = (RADVisualContainer)rADComponent.getParentComponent();
            if (rADVisualContainer == null) {
                return;
            }
        }
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager.supportsArranging()) {
            Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), container);
            layoutSupportManager.processMouseClick(point, container);
        }
    }

    private void showContextMenu(Point point) {
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != this.formDesigner && topComponent != componentInspector) {
            return;
        }
        this.formDesigner.componentActivated();
        Node[] nodeArray = componentInspector.getSelectedNodes();
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])nodeArray);
        if (jPopupMenu != null) {
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    private ComponentDragger createComponentDragger(Point point) {
        Serializable serializable;
        List list = this.formDesigner.getSelectedComponents();
        if (list.size() == 0) {
            return null;
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            serializable = (RADComponent)iterator.next();
            if (!(serializable instanceof RADVisualComponent)) continue;
            if (serializable != this.formDesigner.getTopDesignComponent()) {
                arrayList.add(serializable);
                continue;
            }
            return null;
        }
        serializable = new HashSet();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RADComponent rADComponent2 = (RADComponent)iterator2.next();
                if (rADComponent2 == rADComponent || !rADComponent.isParentComponent(rADComponent2)) continue;
                serializable.add(rADComponent2);
            }
        }
        arrayList.removeAll((Collection<?>)((Object)serializable));
        if (arrayList.isEmpty()) {
            return null;
        }
        this.draggingCanceled = false;
        return new ComponentDragger(this.formDesigner, this, arrayList.toArray(new RADVisualComponent[arrayList.size()]), point, this.resizeType);
    }

    private boolean cancelDragging() {
        if (this.componentDragger != null) {
            this.componentDragger = null;
            this.repaint();
            this.draggingCanceled = true;
            return true;
        }
        return false;
    }

    private boolean validDesignerResizing(int n) {
        return n == 10 || n == 2 || n == 8;
    }

    private void checkDesignerResizing(Point point) {
        int n = this.getSelectionResizable(point, this.formDesigner.getComponentLayer(), 7);
        if (this.validDesignerResizing(n)) {
            this.setResizingCursor(n);
        } else {
            Cursor cursor = this.getCursor();
            if (cursor != null && cursor.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.designerResizeType = n;
    }

    private void checkResizing(Point point) {
        Object object;
        RADComponent rADComponent;
        this.checkDesignerResizing(point);
        RADComponent rADComponent2 = null;
        Iterator iterator = this.formDesigner.getSelectedComponents().iterator();
        while (iterator.hasNext()) {
            rADComponent = (RADComponent)iterator.next();
            if (!(rADComponent instanceof RADVisualComponent) || !(rADComponent2 == null ? (rADComponent2 = rADComponent.getParentComponent()) == null : rADComponent.getParentComponent() != rADComponent2)) continue;
            return;
        }
        rADComponent = this.getMetaComponentAt(point, 1);
        if (!(rADComponent instanceof RADVisualComponent)) {
            return;
        }
        Object object2 = (RADVisualComponent)rADComponent;
        int n = 0;
        if (!this.formDesigner.isComponentSelected((RADComponent)object2)) {
            if (object2 instanceof RADVisualContainer) {
                object = ((RADVisualContainer)object2).getSubComponents();
            } else {
                RADVisualContainer rADVisualContainer = ((RADVisualComponent)object2).getParentContainer();
                if (rADVisualContainer != null) {
                    object = rADVisualContainer.getSubComponents();
                } else {
                    return;
                }
            }
            int n2 = 0;
            while (n2 < ((RADVisualComponent[])object).length) {
                object2 = object[n2];
                n = this.getComponentResizable(point, (RADVisualComponent)object2);
                if (n == 0) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            n = this.getComponentResizable(point, (RADVisualComponent)object2);
        }
        if (n != 0) {
            this.setResizingCursor(n);
        } else {
            object = this.getCursor();
            if (object != null && ((Cursor)object).getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.resizeType = n;
    }

    private int getComponentResizable(Point point, RADVisualComponent rADVisualComponent) {
        if (!this.formDesigner.isComponentSelected(rADVisualComponent)) {
            return 0;
        }
        RADVisualContainer rADVisualContainer = (RADVisualContainer)rADVisualComponent.getParentComponent();
        if (rADVisualContainer == null || rADVisualComponent == this.formDesigner.getTopDesignComponent()) {
            return 0;
        }
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        if (layoutSupportManager == null) {
            return 0;
        }
        Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
        int n = layoutSupportManager.getResizableDirections(component, rADVisualContainer.getIndexOf(rADVisualComponent));
        if (n != 0) {
            n &= this.getSelectionResizable(point, component, 2);
        }
        return n;
    }

    private int getSelectionResizable(Point point, Component component, int n) {
        if (component == null) {
            return 0;
        }
        Rectangle rectangle = component.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle = SwingUtilities.convertRectangle(component, rectangle, this);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(rectangle);
        rectangle2.grow(n, n);
        rectangle3.grow(-3, -3);
        if (rectangle3.width < 0) {
            rectangle3.width = 0;
        }
        if (rectangle3.height < 0) {
            rectangle3.height = 0;
        }
        int n2 = 0;
        if (rectangle2.contains(point)) {
            if (point.y >= rectangle3.y + rectangle3.height) {
                n2 |= 2;
            } else if (point.y < rectangle3.y) {
                n2 |= 1;
            }
            if (point.x >= rectangle3.x + rectangle3.width) {
                n2 |= 8;
            } else if (point.x < rectangle3.x) {
                n2 |= 4;
            }
        }
        return n2;
    }

    private void setResizingCursor(int n) {
        Cursor cursor = null;
        if ((n & 1) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(6) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(7) : Cursor.getPredefinedCursor(8));
        } else if ((n & 2) != 0) {
            cursor = (n & 4) != 0 ? Cursor.getPredefinedCursor(4) : ((n & 8) != 0 ? Cursor.getPredefinedCursor(5) : Cursor.getPredefinedCursor(9));
        } else if ((n & 4) != 0) {
            cursor = Cursor.getPredefinedCursor(10);
        } else if ((n & 8) != 0) {
            cursor = Cursor.getPredefinedCursor(11);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    private LayoutConstraints getConstraintsAtPoint(RADComponent rADComponent, Point point) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent)) {
            return null;
        }
        RADVisualContainer rADVisualContainer2 = rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        if (rADVisualContainer == null) {
            return null;
        }
        Container container = (Container)this.formDesigner.getComponent(rADVisualContainer);
        Container container2 = rADVisualContainer.getContainerDelegate(container);
        Point point2 = SwingUtilities.convertPoint(this, point, container2);
        return rADVisualContainer.getLayoutSupport().getNewConstraints(container, container2, null, -1, point2, null);
    }

    private void showAddHint(RADComponent rADComponent, Point point, PaletteItem paletteItem) {
        RADVisualContainer rADVisualContainer;
        if (!(rADComponent instanceof RADVisualComponent) && rADComponent != null || paletteItem.getItemClass() == null) {
            TopManager.getDefault().setStatusText("");
            return;
        }
        if (rADComponent == null) {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{paletteItem.getDisplayName()});
            return;
        }
        RADVisualContainer rADVisualContainer2 = rADVisualContainer = rADComponent instanceof RADVisualContainer ? (RADVisualContainer)rADComponent : (RADVisualContainer)rADComponent.getParentComponent();
        if (paletteItem.isLayout()) {
            if (rADVisualContainer != null) {
                if (!rADVisualContainer.getLayoutSupport().isDedicated()) {
                    HandleLayer.setStatusText("FMT_MSG_SetLayout", new Object[]{paletteItem.getDisplayName(), rADVisualContainer.getName()});
                } else {
                    HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{rADVisualContainer.getName()});
                }
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetLayout", new Object[]{rADComponent.getName()});
            }
        } else if (paletteItem.isBorder()) {
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = HandleLayer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isAssignableFrom(rADComponent.getBeanClass())) {
                HandleLayer.setStatusText("FMT_MSG_SetBorder", new Object[]{paletteItem.getDisplayName(), rADComponent.getName()});
            } else {
                HandleLayer.setStatusText("FMT_MSG_CannotSetBorder", new Object[]{rADComponent.getName()});
            }
        } else if (rADVisualContainer != null && (paletteItem.isMenu() && rADVisualContainer.getContainerMenu() == null && rADVisualContainer.canHaveMenu(paletteItem.getItemClass()) || paletteItem.isVisual() && !paletteItem.isMenu())) {
            HandleLayer.setStatusText("FMT_MSG_AddComponent", new Object[]{paletteItem.getDisplayName(), rADVisualContainer.getName()});
        } else {
            HandleLayer.setStatusText("FMT_MSG_AddToOthers", new Object[]{paletteItem.getDisplayName()});
        }
    }

    private static void setStatusText(String string, Object[] objectArray) {
        TopManager.getDefault().setStatusText(MessageFormat.format(FormEditor.getFormBundle().getString(string), objectArray));
    }

    private boolean mouseOnComponentLayer(Point point) {
        Rectangle rectangle = this.formDesigner.getComponentLayer().getBounds();
        return rectangle.contains(point);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HandleLayerMouseMotionListener
    implements MouseMotionListener {
        private HandleLayerMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            HandleLayer.this.wasDragged = true;
            if (HandleLayer.this.fdResizer != null) {
                HandleLayer.this.fdResizer.dropDesigner(mouseEvent.getPoint(), false);
            } else if (HandleLayer.this.componentDragger == null && HandleLayer.this.lastLeftMousePoint != null && (HandleLayer.this.resizeType != 0 || HandleLayer.this.lastLeftMousePoint.distance(point) > 6.0) && CPManager.getDefault().getMode() == 0) {
                HandleLayer.this.componentDragger = HandleLayer.this.createComponentDragger(HandleLayer.this.lastLeftMousePoint);
            }
            if (HandleLayer.this.componentDragger != null) {
                HandleLayer.this.componentDragger.mouseDragged(point);
            }
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            CPManager cPManager = CPManager.getDefault();
            if (cPManager.getMode() == 2) {
                RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), mouseEvent.isControlDown() || mouseEvent.isAltDown() ? 1 : 0);
                HandleLayer.this.showAddHint(rADComponent, mouseEvent.getPoint(), cPManager.getSelectedItem());
            } else if (cPManager.getMode() == 0) {
                HandleLayer.this.checkResizing(mouseEvent.getPoint());
            }
        }
    }

    private class HandleLayerMouseListener
    implements MouseListener {
        private HandleLayerMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent) && HandleLayer.this.componentDragger == null) {
                HandleLayer.this.showContextMenu(mouseEvent.getPoint());
            }
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isLeftMouseButton((MouseEvent)mouseEvent)) {
                CPManager cPManager;
                if (HandleLayer.this.fdResizer != null) {
                    if (HandleLayer.this.wasDragged) {
                        HandleLayer.this.fdResizer.dropDesigner(mouseEvent.getPoint(), true);
                    }
                    HandleLayer.this.fdResizer.hideCurrentSizeInStatus();
                    HandleLayer.this.fdResizer = null;
                    HandleLayer.this.wasDragged = false;
                }
                if ((cPManager = CPManager.getDefault()).getMode() == 0) {
                    if (HandleLayer.this.componentDragger != null) {
                        HandleLayer.this.componentDragger.dropComponents(mouseEvent.getPoint());
                        HandleLayer.this.componentDragger = null;
                        HandleLayer.this.repaint();
                    } else if (HandleLayer.this.draggingCanceled) {
                        HandleLayer.this.draggingCanceled = false;
                    } else if (HandleLayer.this.prevLeftMousePoint != null && mouseEvent.getClickCount() == 1 && HandleLayer.this.prevLeftMousePoint.distance(mouseEvent.getPoint()) <= 2.0 && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
                        HandleLayer.this.formDesigner.startInPlaceEditing(HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), 1));
                    }
                }
                if ((mouseEvent.getModifiers() & 1) == 0 && cPManager.getMode() == 2) {
                    cPManager.setMode(0);
                }
                HandleLayer.this.prevLeftMousePoint = HandleLayer.this.lastLeftMousePoint;
                HandleLayer.this.lastLeftMousePoint = null;
            }
            mouseEvent.consume();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TopManager.getDefault().setStatusText("");
        }

        public void mousePressed(MouseEvent mouseEvent) {
            HandleLayer.this.formDesigner.componentActivated();
            if (!HandleLayer.this.isVisible()) {
                return;
            }
            if (MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                if (HandleLayer.this.componentDragger == null) {
                    if (!HandleLayer.this.mouseOnComponentLayer(mouseEvent.getPoint())) {
                        HandleLayer.this.selectOtherComponentsNode();
                    } else {
                        RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), 1);
                        if (rADComponent != null && !HandleLayer.this.formDesigner.isComponentSelected(rADComponent)) {
                            HandleLayer.this.formDesigner.setSelectedComponent(rADComponent);
                        }
                    }
                }
                mouseEvent.consume();
            } else if (MouseUtils.isLeftMouseButton((MouseEvent)mouseEvent)) {
                CPManager cPManager;
                int n;
                boolean bl;
                boolean bl2 = bl = mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown();
                if (!bl) {
                    HandleLayer.this.lastLeftMousePoint = mouseEvent.getPoint();
                }
                if ((n = (cPManager = CPManager.getDefault()).getMode()) == 0) {
                    if (!bl) {
                        HandleLayer.this.checkResizing(mouseEvent.getPoint());
                    }
                    if (!HandleLayer.this.mouseOnComponentLayer(mouseEvent.getPoint())) {
                        if (HandleLayer.this.designerResizeType == 0) {
                            HandleLayer.this.selectOtherComponentsNode();
                        }
                    } else if (HandleLayer.this.resizeType == 0) {
                        if (mouseEvent.getClickCount() == 2) {
                            HandleLayer.this.processDoubleClick(mouseEvent);
                        } else {
                            RADComponent rADComponent = HandleLayer.this.selectComponent(mouseEvent);
                            if (rADComponent != null && !bl) {
                                HandleLayer.this.processMouseClickInLayoutSupport(rADComponent, mouseEvent);
                            }
                        }
                    }
                    if (HandleLayer.this.fdResizer == null && HandleLayer.this.lastLeftMousePoint != null && HandleLayer.this.validDesignerResizing(HandleLayer.this.designerResizeType)) {
                        HandleLayer.this.fdResizer = new FormDesigner.Resizer(HandleLayer.this.formDesigner, HandleLayer.this.designerResizeType);
                        HandleLayer.this.fdResizer.showCurrentSizeInStatus();
                    }
                } else if (!HandleLayer.this.viewOnly) {
                    if (cPManager.getMode() == 1) {
                        HandleLayer.this.selectComponent(mouseEvent);
                    } else if (n == 2) {
                        RADComponent rADComponent = HandleLayer.this.getMetaComponentAt(mouseEvent.getPoint(), mouseEvent.isControlDown() || mouseEvent.isAltDown() ? 1 : 0);
                        PaletteItem paletteItem = cPManager.getSelectedItem();
                        LayoutConstraints layoutConstraints = !paletteItem.isMenu() && paletteItem.isVisual() ? HandleLayer.this.getConstraintsAtPoint(rADComponent, mouseEvent.getPoint()) : null;
                        if (!HandleLayer.this.mouseOnComponentLayer(mouseEvent.getPoint())) {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(paletteItem.getInstanceCookie(), null, null);
                        } else {
                            HandleLayer.this.formDesigner.getModel().getComponentCreator().createComponent(paletteItem.getInstanceCookie(), rADComponent, (Object)layoutConstraints);
                        }
                    }
                }
                mouseEvent.consume();
            }
        }
    }
}

