/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ParametersPicker
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final long serialVersionUID = 1116033799965380000L;
    private JRadioButton valueButton;
    private JTextField valueField;
    private JRadioButton beanButton;
    private JComboBox beanCombo;
    private JRadioButton propertyButton;
    private JTextField propertyLabel;
    private JButton propertyDetailsButton;
    private JRadioButton methodButton;
    private JTextField methodLabel;
    private JButton methodDetailsButton;
    private JRadioButton codeButton;
    private JScrollPane codeScrollPane;
    private JEditorPane codeArea;
    private JLabel paramLabel;
    private FormModel formModel;
    private Class requiredType;
    private PropertyPicker propertyPicker;
    private MethodPicker methodPicker;
    private String selectedPropertyText = null;
    private ArrayList listeners;
    private boolean currentFilledState;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private ArrayList beansList;
    private DefaultComboBoxModel beanComboModel;
    static /* synthetic */ Class class$java$lang$String;

    public ParametersPicker(FormModel formModel, Class clazz) {
        this.initComponents();
        this.requiredType = clazz;
        this.formModel = formModel;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.valueButton);
        buttonGroup.add(this.beanButton);
        buttonGroup.add(this.propertyButton);
        buttonGroup.add(this.methodButton);
        buttonGroup.add(this.codeButton);
        if (!clazz.isPrimitive() && !clazz.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
            this.valueButton.setEnabled(false);
            this.propertyButton.setSelected(true);
        }
        this.paramLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_GetParametersFrom"));
        this.paramLabel.setLabelFor(this);
        this.valueButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Value"));
        this.beanButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Bean"));
        this.propertyButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Property"));
        this.propertyLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoProperty"));
        this.methodButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Method"));
        this.methodLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoMethod"));
        this.codeButton.setText(FormEditor.getFormBundle().getString("CTL_CW_UserCode"));
        this.valueButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_CW_Value_Mnemonic").charAt(0));
        this.beanButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_CW_Bean_Mnemonic").charAt(0));
        this.propertyButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_CW_Property_Mnemonic").charAt(0));
        this.methodButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_CW_Method_Mnemonic").charAt(0));
        this.codeButton.setMnemonic(FormEditor.getFormBundle().getString("CTL_CW_UserCode_Mnemonic").charAt(0));
        this.beansList = new ArrayList();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(FormEditor.getFormBundle().getString("CTL_CW_SelectBean"));
        Iterator iterator = formModel.getMetaComponents().iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            if (!clazz.isAssignableFrom(rADComponent.getBeanClass())) continue;
            this.beansList.add(rADComponent);
            if (rADComponent == formModel.getTopRADComponent()) {
                defaultComboBoxModel.addElement(FormEditor.getFormBundle().getString("CTL_FormTopContainerName"));
                continue;
            }
            defaultComboBoxModel.addElement(rADComponent.getName());
        }
        if (this.beansList.size() > 0) {
            this.beanCombo.setModel(defaultComboBoxModel);
            this.beanCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = ParametersPicker.this.beanCombo.getSelectedIndex();
                    if (n == 0) {
                        ParametersPicker.this.selectedComponent = null;
                    } else {
                        ParametersPicker.this.selectedComponent = (RADComponent)ParametersPicker.this.beansList.get(n - 1);
                    }
                    ParametersPicker.this.fireStateChange();
                }
            });
        } else {
            this.beanButton.setEnabled(false);
        }
        this.codeArea.setContentType("text/x-java");
        this.updateParameterTypes();
        this.currentFilledState = this.isFilled();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.source.modifying.property");
        this.valueButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_Value"));
        this.beanButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_Bean"));
        this.propertyButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_Property"));
        this.methodButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_Method"));
        this.codeButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_UserCode"));
        this.valueField.getAccessibleContext().setAccessibleName(this.valueButton.getText());
        this.valueField.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_ValueField"));
        this.beanCombo.getAccessibleContext().setAccessibleName(this.beanButton.getText());
        this.beanCombo.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_BeanCombo"));
        this.propertyLabel.getAccessibleContext().setAccessibleName(this.propertyButton.getText());
        this.propertyLabel.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_PropertyLabel"));
        this.methodLabel.getAccessibleContext().setAccessibleName(this.methodButton.getText());
        this.methodLabel.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_MethodLabel"));
        this.codeArea.getAccessibleContext().setAccessibleName(this.codeButton.getText());
        this.codeArea.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_UserCodeArea"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_PropertyButton"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_CTL_CW_MethodButton"));
        this.getAccessibleContext().setAccessibleDescription(FormEditor.getFormBundle().getString("ACSD_ParametersPicker"));
    }

    public void setPropertyValue(RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue) {
        if (rADConnectionDesignValue == null) {
            return;
        }
        switch (rADConnectionDesignValue.type) {
            case 3: {
                this.valueButton.setSelected(true);
                this.valueField.setText(rADConnectionDesignValue.value);
                break;
            }
            case 4: {
                this.beanButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                int n = this.beansList.indexOf(this.selectedComponent);
                if (n == -1) {
                    this.beanCombo.setSelectedIndex(0);
                    break;
                }
                this.beanCombo.setSelectedIndex(n + 1);
                break;
            }
            case 0: {
                this.propertyButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedProperty = rADConnectionDesignValue.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyLabel.setText(FormEditor.getFormBundle().getString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyLabel.setText(this.selectedProperty.getName());
                } else {
                    this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                }
                this.propertyLabel.selectAll();
                break;
            }
            case 1: {
                this.methodButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedMethod = rADConnectionDesignValue.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodLabel.setText(FormEditor.getFormBundle().getString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodLabel.setText(this.selectedMethod.getName());
                } else {
                    this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
                }
                this.methodLabel.selectAll();
                break;
            }
            default: {
                this.codeButton.setSelected(true);
                this.codeArea.setText(rADConnectionDesignValue.userCode);
            }
        }
        this.updateParameterTypes();
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (!this.isFilled()) {
            IllegalStateException illegalStateException = new IllegalStateException();
            TopManager.getDefault().getErrorManager().annotate((Throwable)illegalStateException, 256, null, FormEditor.getFormBundle().getString("ERR_NothingEntered"), null, null);
            throw illegalStateException;
        }
        if (this.valueButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.requiredType, this.valueField.getText());
        }
        if (this.beanButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent);
        }
        if (this.codeButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codeArea.getText());
        }
        if (this.propertyButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty);
        }
        if (this.methodButton.isSelected()) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod);
        }
        return null;
    }

    public String getPreviewText() {
        if (!this.isFilled()) {
            return FormEditor.getFormBundle().getString("CTL_CW_NotSet");
        }
        if (this.codeButton.isSelected()) {
            return FormEditor.getFormBundle().getString("CTL_CW_Code");
        }
        return this.getText();
    }

    public String getText() {
        if (!this.isFilled()) {
            return FormEditor.getFormBundle().getString("CTL_CW_NotSet");
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                String string = this.valueField.getText();
                string = Utilities.replaceString((String)string, (String)"\\", (String)"\\\\");
                string = Utilities.replaceString((String)string, (String)"\"", (String)"\\\"");
                return "\"" + string + "\"";
            }
            return this.valueField.getText() != null ? this.valueField.getText() : "";
        }
        if (this.codeButton.isSelected()) {
            return this.codeArea.getText();
        }
        if (this.beanButton.isSelected()) {
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                return "this";
            }
            return this.selectedComponent.getName();
        }
        if (this.propertyButton.isSelected()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                stringBuffer.append(this.selectedComponent.getName());
                stringBuffer.append(".");
            }
            if (this.selectedProperty != null) {
                stringBuffer.append(this.selectedProperty.getReadMethod().getName());
                stringBuffer.append("()");
            } else {
                stringBuffer.append("???");
            }
            return stringBuffer.toString();
        }
        if (this.methodButton.isSelected()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                stringBuffer.append(this.selectedComponent.getName());
                stringBuffer.append(".");
            }
            stringBuffer.append(this.selectedMethod.getName());
            stringBuffer.append("()");
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean isFilled() {
        if (this.codeButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                return true;
            }
            return !"".equals(this.codeArea.getText());
        }
        if (this.beanButton.isSelected()) {
            return this.selectedComponent != null;
        }
        if (this.propertyButton.isSelected()) {
            return this.selectedProperty != null;
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(class$java$lang$String == null ? (class$java$lang$String = ParametersPicker.class$("java.lang.String")) : class$java$lang$String)) {
                return true;
            }
            return !"".equals(this.valueField.getText());
        }
        if (this.methodButton.isSelected()) {
            return this.selectedMethod != null;
        }
        return false;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    private synchronized void fireStateChange() {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.valueButton = new JRadioButton();
        this.valueField = new JTextField();
        this.beanButton = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyButton = new JRadioButton();
        this.propertyLabel = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodButton = new JRadioButton();
        this.methodLabel = new JTextField();
        this.methodDetailsButton = new JButton();
        this.codeButton = new JRadioButton();
        this.codeScrollPane = new JScrollPane();
        this.codeArea = new JEditorPane();
        this.paramLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.valueButton.setSelected(true);
        this.valueButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Value"));
        this.valueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.valueButton, gridBagConstraints);
        this.valueField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                ParametersPicker.this.updateState(caretEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.valueField, gridBagConstraints);
        this.beanButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Bean"));
        this.beanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.beanButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.beanCombo, gridBagConstraints);
        this.propertyButton.setText(FormEditor.getFormBundle().getString("CTL_CW_Property"));
        this.propertyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertyButton, gridBagConstraints);
        this.propertyLabel.setEditable(false);
        this.propertyLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoProperty"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.propertyLabel, gridBagConstraints);
        this.propertyDetailsButton.setText("...");
        this.propertyDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.propertyDetailsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.propertyDetailsButton, gridBagConstraints);
        this.methodButton.setText(FormEditor.getFormBundle().getString("CTL_CW_MethodCall"));
        this.methodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.methodButton, gridBagConstraints);
        this.methodLabel.setEditable(false);
        this.methodLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoMethod"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.methodLabel, gridBagConstraints);
        this.methodDetailsButton.setText("...");
        this.methodDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.methodDetailsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.methodDetailsButton, gridBagConstraints);
        this.codeButton.setText(FormEditor.getFormBundle().getString("CTL_CW_UserCode"));
        this.codeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.codeButton, gridBagConstraints);
        this.codeArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                ParametersPicker.this.updateState(caretEvent);
            }
        });
        this.codeScrollPane.setViewportView(this.codeArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.codeScrollPane, gridBagConstraints);
        this.paramLabel.setText("label1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.paramLabel, gridBagConstraints);
    }

    private void methodDetailsButtonActionPerformed(ActionEvent actionEvent) {
        MethodPicker methodPicker = new MethodPicker(this.formModel, null, this.requiredType);
        methodPicker.setSelectedComponent(this.selectedComponent);
        methodPicker.setSelectedMethod(this.selectedMethod);
        String string = MessageFormat.format(FormEditor.getFormBundle().getString("CTL_FMT_CW_SelectMethod"), Utilities.getShortClassName((Class)this.requiredType));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)methodPicker, string);
        dialogDescriptor.setValid(methodPicker.isPickerValid());
        methodPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = methodPicker.getSelectedComponent();
            this.selectedMethod = methodPicker.getSelectedMethod();
            this.methodLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodLabel.setText(this.selectedMethod.getName());
            } else {
                this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            this.methodLabel.repaint();
            this.fireStateChange();
        }
    }

    private void updateState(CaretEvent caretEvent) {
        this.fireStateChange();
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent actionEvent) {
        if (this.propertyPicker == null) {
            this.propertyPicker = new PropertyPicker(this.formModel, null, this.requiredType);
        }
        this.propertyPicker.setSelectedComponent(this.selectedComponent);
        this.propertyPicker.setSelectedProperty(this.selectedProperty);
        String string = MessageFormat.format(FormEditor.getFormBundle().getString("CTL_FMT_CW_SelectProperty"), Utilities.getShortClassName((Class)this.requiredType));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.propertyPicker, string);
        dialogDescriptor.setValid(this.propertyPicker.isPickerValid());
        this.propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = this.propertyPicker.getSelectedComponent();
            this.selectedProperty = this.propertyPicker.getSelectedProperty();
            this.propertyLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyLabel.setText(this.selectedProperty.getName());
            } else {
                this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
            }
            this.propertyLabel.repaint();
            this.fireStateChange();
        }
    }

    private void typeButtonPressed(ActionEvent actionEvent) {
        this.updateParameterTypes();
        if (this.beanButton.isSelected()) {
            this.beanCombo.requestFocus();
        } else if (this.codeButton.isSelected()) {
            this.codeArea.requestFocus();
        } else if (this.propertyButton.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        } else if (this.methodButton.isSelected()) {
            this.methodDetailsButton.requestFocus();
        } else if (this.valueButton.isSelected()) {
            this.valueField.requestFocus();
        }
    }

    private void updateParameterTypes() {
        this.valueField.setEnabled(this.valueButton.isSelected());
        this.beanCombo.setEnabled(this.beanButton.isSelected());
        if (!this.propertyButton.isSelected()) {
            this.propertyLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoProperty"));
        }
        this.propertyLabel.setEnabled(this.propertyButton.isSelected());
        this.propertyLabel.repaint();
        this.propertyDetailsButton.setEnabled(this.propertyButton.isSelected());
        if (!this.methodButton.isSelected()) {
            this.methodLabel.setText(FormEditor.getFormBundle().getString("CTL_CW_NoMethod"));
        }
        this.methodLabel.setEnabled(this.methodButton.isSelected());
        this.methodLabel.repaint();
        this.methodDetailsButton.setEnabled(this.methodButton.isSelected());
        this.codeArea.setEnabled(this.codeButton.isSelected());
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
        this.fireStateChange();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

