/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.form.palette.AlignedList;

public class AlignedListUI
extends BasicListUI {
    int lastDimension;
    int rowCount;
    int columnCount;

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        ListModel<Object> listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || listModel.getSize() == 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        int n2 = this.convertYToRow(rectangle2.y);
        int n3 = this.convertYToRow(rectangle2.y + rectangle2.height - 1);
        int n4 = this.convertXToColumn(rectangle2.x);
        int n5 = this.convertXToColumn(rectangle2.x + rectangle2.width - 1);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.rowCount - 1;
        }
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.columnCount - 1;
        }
        if ((rectangle = this.getCellBounds((JList)this.list, n = this.convertCellToIndex(n4, n2), n)) == null) {
            return;
        }
        int n6 = this.list.getLeadSelectionIndex();
        int n7 = rectangle.y;
        int n8 = n4;
        while (n8 <= n5) {
            int n9 = n2;
            while (n9 <= n3) {
                int n10 = this.convertCellToIndex(n8, n9);
                if (n10 == -1) break;
                rectangle.height = this.getRowHeight(n9);
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                this.paintCell(graphics, n10, rectangle, listCellRenderer, listModel, listSelectionModel, n6);
                rectangle.y += rectangle.height;
                ++n9;
            }
            rectangle.y = n7;
            rectangle.width = this.getColumnWidth(n8);
            rectangle.x += rectangle.width;
            ++n8;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        return new Dimension(this.columnCount * this.cellWidth + insets.left + insets.right, this.rowCount * this.cellHeight + insets.top + insets.bottom);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AlignedListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertCellToIndex(this.convertXToColumn(point.x), this.convertYToRow(point.y));
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        int n2 = this.convertColumnToX(this.convertIndexToColumn(n));
        int n3 = this.convertRowToY(this.convertIndexToRow(n));
        return n3 == -1 || n2 == -1 ? null : new Point(n2, n3);
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.convertRowToY(this.convertIndexToRow(n3));
        int n6 = this.convertRowToY(this.convertIndexToRow(n4));
        int n7 = this.convertColumnToX(this.convertIndexToColumn(n3));
        int n8 = this.convertColumnToX(this.convertIndexToColumn(n4));
        if (n5 == -1 || n6 == -1 || n7 == -1 || n8 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n9 = n7;
        int n10 = n5;
        int n11 = n8 + this.getColumnWidth(this.convertIndexToColumn(n4)) - n7;
        int n12 = n6 + this.getRowHeight(this.convertIndexToRow(n4)) - n5;
        return new Rectangle(n9, n10, n11, n12);
    }

    protected int getRowHeight(int n) {
        if (n < 0 || n >= this.rowCount) {
            return -1;
        }
        return this.cellHeight;
    }

    protected int getColumnWidth(int n) {
        if (n < 0 || n >= this.columnCount) {
            return -1;
        }
        return this.cellWidth;
    }

    protected int convertIndexToRow(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            return this.rowCount <= 0 ? -1 : n % this.rowCount;
        }
        return this.columnCount <= 0 ? -1 : n / this.columnCount;
    }

    protected int convertIndexToColumn(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            return this.rowCount <= 0 ? -1 : n / this.rowCount;
        }
        return this.columnCount <= 0 ? -1 : n % this.columnCount;
    }

    protected int convertCellToIndex(int n, int n2) {
        if (n < 0 || n >= this.columnCount || n2 < 0 || n2 >= this.rowCount) {
            return -1;
        }
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        int n3 = ((AlignedList)this.list).getAlignStyle() == 1 ? n * this.rowCount + n2 : n2 * this.columnCount + n;
        return n3 < this.list.getModel().getSize() ? n3 : -1;
    }

    protected int convertYToRow(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.cellHeight == 0 ? -1 : (n - this.list.getInsets().top) / this.cellHeight;
        return n2 >= 0 && n2 < this.rowCount ? n2 : -1;
    }

    protected int convertXToColumn(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.cellWidth == 0 ? -1 : (n - this.list.getInsets().left) / this.cellWidth;
        return n2 >= 0 && n2 < this.columnCount ? n2 : -1;
    }

    protected int convertRowToY(int n) {
        if (n < 0 || n >= this.rowCount) {
            return -1;
        }
        return this.list.getInsets().top + n * this.cellHeight;
    }

    protected int convertColumnToX(int n) {
        if (n < 0 || n >= this.columnCount) {
            return -1;
        }
        return this.list.getInsets().left + n * this.cellWidth;
    }

    protected void maybeUpdateLayoutState() {
        int n;
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        int n2 = n = ((AlignedList)this.list).getAlignStyle() == 1 ? this.list.getHeight() : this.list.getWidth();
        if (this.lastDimension != n) {
            this.lastDimension = n;
            this.updateLayoutState();
        } else {
            super.maybeUpdateLayoutState();
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        this.cellWidth = n2 != -1 ? n2 : -1;
        this.cellHeight = n != -1 ? n : -1;
        this.cellHeight = n != -1 ? n : -1;
        this.cellHeight = n2 != -1 ? n2 : -1;
        if (n2 == -1 || n == -1) {
            ListModel<Object> listModel = this.list.getModel();
            int n3 = listModel.getSize();
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                int n4 = 0;
                while (n4 < n3) {
                    Object object = listModel.getElementAt(n4);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n4, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1) {
                        this.cellHeight = Math.max(dimension.height, this.cellHeight);
                    }
                    ++n4;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeight == -1) {
                    this.cellHeight = 0;
                }
            }
        }
        if (this.updateAlignment()) {
            this.list.revalidate();
        } else {
            this.list.invalidate();
        }
    }

    private boolean updateAlignment() {
        int n = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            int n2 = this.list.getHeight() - (insets.top + insets.bottom);
            this.rowCount = this.cellHeight <= 0 ? 0 : (n2 < this.cellHeight ? 1 : n2 / this.cellHeight);
            this.rowCount = Math.min(n, this.rowCount);
            int n3 = this.columnCount;
            this.columnCount = this.rowCount == 0 ? 0 : (n + this.rowCount - 1) / this.rowCount;
            return n3 != this.columnCount;
        }
        int n4 = this.list.getWidth() - (insets.left + insets.right);
        this.columnCount = this.cellWidth <= 0 ? 0 : (n4 < this.cellWidth ? 1 : n4 / this.cellWidth);
        this.columnCount = Math.min(n, this.columnCount);
        int n5 = this.rowCount;
        this.rowCount = this.columnCount == 0 ? 0 : (n + this.columnCount - 1) / this.columnCount;
        return n5 != this.rowCount;
    }

    protected MouseInputListener createMouseInputListener() {
        return new AlignedListMouseInputHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new AlignedListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new AlignedListDataHandler();
    }

    private void repaintList(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n = n == -1 ? 0 : n;
        n2 = n2 == -1 ? this.list.getModel().getSize() - 1 : n2;
        AlignedList cfr_ignored_0 = (AlignedList)this.list;
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            n3 = Math.max(0, this.convertColumnToX(this.convertIndexToColumn(n)));
            int n7 = this.convertIndexToColumn(n2);
            n5 = Math.min(this.list.getWidth(), this.convertColumnToX(n7) + this.getColumnWidth(n7)) - n3;
            n6 = this.list.getHeight();
        } else {
            n4 = Math.max(0, this.convertRowToY(this.convertIndexToRow(n)));
            int n8 = this.convertIndexToRow(n2);
            n6 = Math.min(this.list.getHeight(), this.convertRowToY(n8) + this.getRowHeight(n8)) - n4;
            n5 = this.list.getWidth();
        }
        this.list.revalidate();
        this.list.repaint(n3, n4, n5, n6);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new AlignedListPropertyChangeHandler();
    }

    public class AlignedListPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public AlignedListPropertyChangeHandler() {
            super(AlignedListUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("rolloverIndex")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                int n2 = (Integer)propertyChangeEvent.getOldValue();
                AlignedListUI.this.repaintList(Math.min(n, n2), Math.max(n, n2));
            } else if (string.equals("alignStyle")) {
                AlignedListUI.this.redrawList();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    public class AlignedListDataHandler
    extends BasicListUI.ListDataHandler {
        public AlignedListDataHandler() {
            super(AlignedListUI.this);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            AlignedListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = AlignedListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
            AlignedListUI.this.repaintList(n, AlignedListUI.this.list.getModel().getSize() - 1);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            AlignedListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = AlignedListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            AlignedListUI.this.repaintList(Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1()), AlignedListUI.this.list.getModel().getSize() - 1);
        }
    }

    public class AlignedListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AlignedListUI.this.maybeUpdateLayoutState();
            AlignedListUI.this.repaintList(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
        }
    }

    public class AlignedListMouseInputHandler
    extends BasicListUI.MouseInputHandler {
        public AlignedListMouseInputHandler() {
            super(AlignedListUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            if (!AlignedListUI.this.list.hasFocus()) {
                AlignedListUI.this.list.requestFocus();
            }
            if ((n = AlignedListUI.this.convertCellToIndex(AlignedListUI.this.convertXToColumn(mouseEvent.getX()), AlignedListUI.this.convertYToRow(mouseEvent.getY()))) != -1) {
                AlignedListUI.this.list.setValueIsAdjusting(true);
                int n2 = AlignedListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (AlignedListUI.this.list.isSelectedIndex(n)) {
                        AlignedListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        AlignedListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    AlignedListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    AlignedListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(-1);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = AlignedListUI.this.convertCellToIndex(AlignedListUI.this.convertXToColumn(mouseEvent.getX()), AlignedListUI.this.convertYToRow(mouseEvent.getY()));
            if (n != -1 && (rectangle = AlignedListUI.this.getCellBounds(AlignedListUI.this.list, n, n)) != null) {
                AlignedListUI.this.list.scrollRectToVisible(rectangle);
                AlignedListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEntered(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(AlignedListUI.this.locationToIndex(AlignedListUI.this.list, mouseEvent.getPoint()));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(-1);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            AlignedListUI.this.list.setValueIsAdjusting(false);
        }
    }
}

