/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.AlignedList;
import org.netbeans.modules.form.palette.AlignedListUI;
import org.netbeans.modules.form.palette.CPComponent;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.CategoryPopupMenu;
import org.netbeans.modules.form.palette.ItemPopupMenu;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PalettePopupMenu;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class CPComponentLarge
extends CPComponent {
    protected static CPComponent instance;
    protected JTabbedPane tabbedPane;
    protected NodeListModel tabbedPaneModel;
    protected ArrayList alignedLists = new ArrayList(6);
    private Listener listener = new Listener();
    private static String SHOW_NAMES;
    private PaletteListRenderer listRenderer;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;

    private CPComponentLarge(CPManagerInterface cPManagerInterface) {
        super(cPManagerInterface);
        this.setCPLayout();
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener(this.listener);
        this.updateShowNames(this.manager.getShowComponentsNames());
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.listener);
    }

    private void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(410, 50));
        this.tabbedPaneModel = new NodeListModel();
        this.tabbedPaneModel.addListDataListener(this.listener);
        this.tabbedPaneModel.setNode((Node)this.paletteNode);
        this.tabbedPane.addChangeListener(this.listener);
        this.tabbedPane.addMouseListener(this.listener);
        this.tabbedPane.getAccessibleContext().setAccessibleName(CPManager.getBundle().getString("ACS_PaletteTabbedPane"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteTabbedPane"));
    }

    private Component createPaletteTab(int n, Node node) {
        CPComponent.t("creating palette tab");
        Node[] nodeArray = this.paletteNode.getCategoriesNodes();
        AlignedList alignedList = this.createCategoryList(node);
        this.alignedLists.add(n, alignedList);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(alignedList);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    private AlignedList createCategoryList(Node node) {
        NodeListModel nodeListModel = new NodeListModel();
        nodeListModel.setNode(node);
        AlignedList alignedList = new AlignedList();
        alignedList.setModel(nodeListModel);
        nodeListModel.addListDataListener(this.listener);
        alignedList.setUI(new AlignedListUI());
        alignedList.setOpaque(false);
        alignedList.setAlignStyle(0);
        alignedList.setVisibleRowCount(2);
        alignedList.setSelectionMode(0);
        alignedList.addListSelectionListener(this.listener);
        alignedList.addMouseListener(this.listener);
        if (this.listRenderer == null) {
            this.listRenderer = new PaletteListRenderer();
            this.listRenderer.setShowNames(this.manager.getShowComponentsNames());
        }
        alignedList.setCellRenderer(this.listRenderer);
        ToolTipManager.sharedInstance().registerComponent(alignedList);
        alignedList.getAccessibleContext().setAccessibleName(MessageFormat.format(CPManager.getBundle().getString("ACS_PaletteBeansList"), node.getDisplayName()));
        alignedList.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteBeansList"));
        return alignedList;
    }

    private void clearSelection() {
        int n = 0;
        while (n < this.alignedLists.size()) {
            ((AlignedList)this.alignedLists.get(n)).clearSelection();
            ++n;
        }
    }

    protected void updateSelectedItem(PaletteItem paletteItem) {
        super.updateSelectedItem(paletteItem);
        if (paletteItem == null) {
            this.clearSelection();
        } else {
            List<Node> list = Arrays.asList(this.paletteNode.getChildren().getNodes());
            int n = list.indexOf(paletteItem.getCategoryNode());
            if (n != -1) {
                this.tabbedPane.removeChangeListener(this.listener);
                this.tabbedPane.setSelectedIndex(n);
                this.tabbedPane.addChangeListener(this.listener);
                ((AlignedList)this.alignedLists.get(n)).setSelectedValue(paletteItem.getItemNode(), true);
            }
        }
    }

    void showMenuOnCategory(Component component, Point point) {
        int n = this.tabbedPane.getSelectedIndex();
        Node[] nodeArray = this.paletteNode.getChildren().getNodes();
        if (n < 0 || nodeArray == null || n >= nodeArray.length) {
            return;
        }
        new CategoryPopupMenu(nodeArray[n]).show(component, point.x, point.y);
    }

    void showMenuOnPalette(Component component, Point point) {
        new PalettePopupMenu().show(component, point.x, point.y);
    }

    void showMenuOnItem(Node node, Component component, Point point) {
        ItemPopupMenu itemPopupMenu = new ItemPopupMenu(node);
        ((Container)((Object)itemPopupMenu)).add(new JSeparator());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(CPManager.getBundle().getString("CTL_ShowNames"));
        jCheckBoxMenuItem.setSelected(this.listRenderer.isShowNames());
        jCheckBoxMenuItem.setActionCommand(SHOW_NAMES);
        jCheckBoxMenuItem.addActionListener(this.listener);
        ((JPopupMenu)((Object)itemPopupMenu)).add(jCheckBoxMenuItem);
        ((JPopupMenu)((Object)itemPopupMenu)).show(component, point.x, point.y);
    }

    public static boolean isCreated() {
        return instance != null;
    }

    public static synchronized JComponent getComponent(CPManagerInterface cPManagerInterface) {
        CPComponent.t("Large: getComponent");
        if (instance == null) {
            instance = new CPComponentLarge(cPManagerInterface);
        }
        return instance;
    }

    protected void setCPLayout() {
        CPComponent.t("Large: setCPLayout-BEG");
        if (CPComponentLarge.isCreated()) {
            this.removeAll();
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.createControls();
        this.setStatusLabelSize();
        jPanel.add((Component)this.selectionButton);
        jPanel.add((Component)this.connectionButton);
        jPanel.add(Box.createHorizontalStrut(5));
        TestAction testAction = (TestAction)SystemAction.get((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = CPComponentLarge.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction));
        jPanel.add(testAction.getToolbarPresenter());
        jPanel.add(Box.createHorizontalStrut(5));
        this.add(jPanel);
        this.createTabbedPane();
        this.add(this.tabbedPane);
        this.setLayout(new PaletteLayout(jPanel, this.tabbedPane));
        CPComponent.t("Large: setCPLayout-END");
    }

    private void revalidateLists() {
        int n = 0;
        while (n < this.alignedLists.size()) {
            AlignedList alignedList = (AlignedList)this.alignedLists.get(n);
            alignedList.setSize(0, 0);
            ++n;
        }
        int n2 = this.tabbedPane.getSelectedIndex();
        AlignedList alignedList = (AlignedList)this.alignedLists.get(n2);
        alignedList.revalidate();
        alignedList.repaint();
    }

    private void updateShowNames(boolean bl) {
        if (this.listRenderer != null) {
            this.listRenderer.setShowNames(bl);
            this.revalidateLists();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SHOW_NAMES = "SHOW_NAMES";
    }

    private static class PaletteLayout
    implements LayoutManager {
        Component buttons;
        Component tabs;

        public PaletteLayout(Component component, Component component2) {
            this.buttons = component;
            this.tabs = component2;
        }

        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = insets.top;
                int n2 = container.getHeight() - insets.bottom;
                int n3 = insets.left;
                int n4 = container.getWidth() - insets.right;
                int n5 = n2 - n;
                int n6 = n4 - n3;
                if (this.buttons != null) {
                    Dimension dimension = this.buttons.getPreferredSize();
                    if (dimension.width * n5 >= dimension.height * n6) {
                        this.buttons.setBounds(n3, n, n6, dimension.height);
                        n += dimension.height;
                        n5 -= dimension.height;
                    } else {
                        this.buttons.setBounds(n3, n + 5, dimension.width, n5 - 5);
                        n3 += dimension.width;
                        n6 -= dimension.width;
                    }
                }
                if (this.tabs != null) {
                    this.tabs.setBounds(n3, n, n6, n5);
                }
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Cloneable cloneable;
                Dimension dimension = new Dimension();
                if (this.buttons != null) {
                    cloneable = this.buttons.getPreferredSize();
                    dimension.width += cloneable.width;
                }
                if (this.tabs != null) {
                    cloneable = this.tabs.getPreferredSize();
                    dimension.width += cloneable.width;
                    dimension.height = cloneable.height;
                }
                cloneable = container.getInsets();
                dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                Dimension dimension2 = dimension;
                return dimension2;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener,
    ChangeListener,
    ListDataListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            int n = jList.getSelectedIndex();
            if (n == -1) {
                if (CPComponentLarge.this.tabbedPane.getSelectedIndex() == CPComponentLarge.this.alignedLists.indexOf(jList)) {
                    CPComponentLarge.this.manager.setSelectedItem(null);
                    CPComponentLarge.this.manager.setMode(0);
                }
            } else {
                Node node = Visualizer.findNode(jList.getModel().getElementAt(n));
                PaletteItem paletteItem = CPManager.createPaletteItem(node);
                CPComponentLarge.this.manager.setSelectedItem(paletteItem);
                CPComponentLarge.this.manager.setMode(2);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!MouseUtils.isRightMouseButton((MouseEvent)mouseEvent)) {
                return;
            }
            if (mouseEvent.getSource() == CPComponentLarge.this.tabbedPane) {
                int n = CPComponentLarge.this.tabbedPane.getSelectedIndex();
                if (n >= 0) {
                    Rectangle rectangle = CPComponentLarge.this.tabbedPane.getBoundsAt(n);
                    Point point = mouseEvent.getPoint();
                    if (point.y < rectangle.y || point.y < rectangle.y + rectangle.height && (point.x < rectangle.x || point.x >= rectangle.x + rectangle.width)) {
                        CPComponentLarge.this.showMenuOnPalette(mouseEvent.getComponent(), mouseEvent.getPoint());
                        return;
                    }
                }
                CPComponentLarge.this.showMenuOnCategory(mouseEvent.getComponent(), mouseEvent.getPoint());
            }
            if (mouseEvent.getSource() instanceof AlignedList) {
                AlignedList alignedList = (AlignedList)mouseEvent.getSource();
                int n = alignedList.locationToIndex(mouseEvent.getPoint());
                if (n == -1) {
                    CPComponentLarge.this.showMenuOnCategory(mouseEvent.getComponent(), mouseEvent.getPoint());
                } else {
                    CPComponentLarge.this.showMenuOnItem(Visualizer.findNode(alignedList.getModel().getElementAt(n)), mouseEvent.getComponent(), mouseEvent.getPoint());
                }
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            if (listDataEvent.getSource() == CPComponentLarge.this.tabbedPaneModel) {
                int n = listDataEvent.getIndex1();
                int n2 = listDataEvent.getIndex0();
                while (n2 <= n) {
                    Node node = Visualizer.findNode((Object)CPComponentLarge.this.tabbedPaneModel.getElementAt(n2));
                    CPComponentLarge.this.tabbedPane.insertTab(node.getDisplayName(), null, CPComponentLarge.this.createPaletteTab(n2, node), null, n2);
                    ++n2;
                }
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            if (listDataEvent.getSource() == CPComponentLarge.this.tabbedPaneModel) {
                int n = listDataEvent.getIndex0();
                int n2 = listDataEvent.getIndex1();
                while (n2 >= n) {
                    CPComponentLarge.this.tabbedPane.removeTabAt(n2);
                    CPComponentLarge.this.alignedLists.remove(n2);
                    --n2;
                }
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            if (listDataEvent.getSource() != CPComponentLarge.this.tabbedPaneModel) {
                return;
            }
            int n = listDataEvent.getIndex1();
            if (n < 0) {
                return;
            }
            int n2 = listDataEvent.getIndex0();
            while (n2 <= n) {
                Node node = Visualizer.findNode((Object)CPComponentLarge.this.tabbedPaneModel.getElementAt(n2));
                CPComponentLarge.this.tabbedPane.setTitleAt(n2, node.getDisplayName());
                ((NodeListModel)((AlignedList)CPComponentLarge.this.alignedLists.get(n2)).getModel()).setNode(node);
                ++n2;
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (actionEvent.getActionCommand().equals(SHOW_NAMES)) {
                CPComponentLarge.this.listRenderer.setShowNames(jCheckBoxMenuItem.isSelected());
                CPComponentLarge.this.manager.setShowComponentsNames(jCheckBoxMenuItem.isSelected());
            }
            CPComponentLarge.this.revalidateLists();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("showComponentsNames".equals(propertyChangeEvent.getPropertyName())) {
                CPComponentLarge.this.updateShowNames((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class PaletteListRenderer
    implements ListCellRenderer {
        private JToggleButton button = new JToggleButton();
        private Border buttonBorder;
        private Border emptyBorder;
        private int iconSize;
        private boolean showNames = false;

        public PaletteListRenderer() {
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.buttonBorder = this.button.getBorder();
            this.emptyBorder = new EmptyBorder(this.buttonBorder.getBorderInsets(this.button));
            this.setIconSize(1);
            this.setShowNames(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Node node = Visualizer.findNode((Object)object);
            if (bl || n == ((AlignedList)jList).getRolloverIndex()) {
                this.button.setBorder(this.buttonBorder);
            } else {
                this.button.setBorder(this.emptyBorder);
            }
            if (this.showNames) {
                this.button.setText(node.getDisplayName());
            }
            this.button.setIcon(new ImageIcon(node.getIcon(this.iconSize)));
            this.button.setSelected(bl);
            this.button.setToolTipText(node.getShortDescription().replace('-', '.'));
            return this.button;
        }

        public void setIconSize(int n) {
            if (n == 1) {
                this.button.setHorizontalAlignment(2);
                this.button.setVerticalTextPosition(0);
                this.button.setHorizontalTextPosition(4);
            } else {
                this.button.setHorizontalAlignment(0);
                this.button.setVerticalTextPosition(3);
                this.button.setHorizontalTextPosition(0);
            }
            this.iconSize = n;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public void setShowNames(boolean bl) {
            if (!bl) {
                this.button.setText(null);
            }
            this.showNames = bl;
        }

        public boolean isShowNames() {
            return this.showNames;
        }
    }
}

