/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.palette.CPElements;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.CPManagerListener;
import org.netbeans.modules.form.palette.PaletteCategoryNode;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.NbBundle;

public class CPManager
implements CPManagerInterface {
    private static CPManager instance;
    private int paletteMode = 0;
    private PaletteItem selectedPaletteItem = null;
    private static final int CATEGORIES_ADDED = 1;
    private static final int CATEGORIES_REMOVED = 2;
    private static final int CATEGORIES_REORDERED = 3;
    private static final int ITEMS_CHANGED = 4;
    private static final int ITEMS_REORDERED = 5;
    private static final int SWITCH_UI = 6;
    private static final String PALETTE_UI_FOLDER_NAME = "PaletteUI";
    private PropertyChangeSupport propertySupport;
    private transient Vector listeners;
    private Set updateNodes = new HashSet(11);
    private static ResourceBundle bundle;
    private NodeListener categoryNodeListener;
    private PaletteNode paletteNode;
    private JComponent palette = new JPanel();
    private JComponent component;
    private CPElements.Palette[] registeredPalettes = null;
    private CPElements.Palette selectedPalette = null;
    private PaletteItem[] allItems = null;
    private PaletteCategoryNode[] changedCategories = null;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$org$netbeans$modules$form$palette$CPManager;

    private CPManager() {
        CPManager.t("<init>-BEG");
        this.propertySupport = new PropertyChangeSupport(this);
        this.paletteNode = PaletteNode.getPaletteNode();
        this.createListener4FormSettings();
        this.createListeners4PaletteNodes();
        boolean bl = this.checkAvailablePalettes();
        if (bl) {
            this.loadPalette(FormEditor.getFormSettings().getSelectedPalette());
        } else {
            InternalError internalError = new InternalError("Any palette was not found!");
            TopManager.getDefault().getErrorManager().notify((Throwable)internalError);
        }
        CPManager.t("<init>-END");
    }

    public static synchronized CPManager getDefault() {
        CPManager.t("getDefault");
        if (instance == null) {
            instance = new CPManager();
        }
        return instance;
    }

    private boolean loadSelectedPalette(CPElements.Palette palette) {
        CPManager.t("registerCPComponent-BEG");
        try {
            Class<?> clazz = Class.forName(palette.clazz, true, TopManager.getDefault().currentClassLoader());
            String string = "org.netbeans.modules.form.palette.CPManagerInterface";
            Class<?> clazz2 = Class.forName(string, true, TopManager.getDefault().currentClassLoader());
            Method method = clazz.getMethod("getComponent", clazz2);
            this.component = null;
            this.component = (JComponent)method.invoke(null, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CPManager.t("registerCPComponent-ClassNotFoundException-END");
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            CPManager.t("registerCPComponent-IllegalAccessException-END");
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            CPManager.t("registerCPComponent-NoSuchMethodException-END");
            return false;
        }
        catch (SecurityException securityException) {
            CPManager.t("registerCPComponent-SecurityException-END");
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            CPManager.t("registerCPComponent-InvocationTargetException-END");
            return false;
        }
        this.runInEventQueue(6);
        this.selectedPalette = palette;
        CPManager.t("registerCPComponent-END");
        return true;
    }

    public void setSelectedPalette(CPElements.Palette palette) {
        CPManager.t("setSelectedPalette-BEG");
        int n = 0;
        while (n < this.registeredPalettes.length) {
            if (this.registeredPalettes[n].getPaletteName().equals(palette.getPaletteName())) {
                FormEditor.getFormSettings().setSelectedPalette(n);
                return;
            }
            ++n;
        }
        FormEditor.getFormSettings().setSelectedPalette(0);
        CPManager.t("setSelectedPalette-END");
    }

    public CPElements.Palette getSelectedPalette() {
        return this.selectedPalette;
    }

    public CPElements.Palette[] getRegisteredPalettes() {
        return this.registeredPalettes;
    }

    public void setShowComponentsNames(boolean bl) {
        FormEditor.getFormSettings().setShowComponentsNames(bl);
    }

    public boolean getShowComponentsNames() {
        return FormEditor.getFormSettings().getShowComponentsNames();
    }

    public PaletteNode getCPRoot() {
        CPManager.t("getCPRoot");
        return this.paletteNode;
    }

    public JComponent getComponent() {
        CPManager.t("getComponent");
        return this.palette;
    }

    public PaletteItem getSelectedItem() {
        return this.selectedPaletteItem;
    }

    public void setSelectedItem(PaletteItem paletteItem) {
        if (paletteItem == this.selectedPaletteItem) {
            return;
        }
        PaletteItem paletteItem2 = this.selectedPaletteItem;
        this.selectedPaletteItem = paletteItem;
        this.propertySupport.firePropertyChange("selectedItem", paletteItem2, paletteItem);
    }

    public int getMode() {
        return this.paletteMode;
    }

    public void setMode(int n) {
        if (n == this.paletteMode) {
            return;
        }
        int n2 = this.paletteMode;
        this.paletteMode = n;
        FormDesigner formDesigner = this.getDesigner();
        if (formDesigner != null) {
            formDesigner.resetConnection();
            if (n == 1) {
                formDesigner.clearSelection();
            }
        }
        this.propertySupport.firePropertyChange("mode", n2, n);
    }

    public PaletteItem[] getAllItems() {
        if (this.allItems == null) {
            Node[] nodeArray = this.paletteNode.getCategoriesNodes();
            ArrayList<PaletteItem> arrayList = new ArrayList<PaletteItem>(80);
            HashSet<String> hashSet = new HashSet<String>(80);
            int n = 0;
            while (n < nodeArray.length) {
                Node[] nodeArray2 = nodeArray[n].getChildren().getNodes();
                int n2 = 0;
                while (n2 < nodeArray2.length) {
                    Class clazz;
                    Node node = nodeArray2[n2];
                    PaletteItem paletteItem = CPManager.createPaletteItem(node);
                    if (paletteItem != null && (clazz = paletteItem.getItemClass()) != null && !hashSet.contains(clazz.getName())) {
                        hashSet.add(clazz.getName());
                        arrayList.add(paletteItem);
                    }
                    ++n2;
                }
                ++n;
            }
            this.allItems = new PaletteItem[arrayList.size()];
            arrayList.toArray(this.allItems);
        }
        return this.allItems;
    }

    public static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$form$palette$CPManager == null ? (class$org$netbeans$modules$form$palette$CPManager = CPManager.class$("org.netbeans.modules.form.palette.CPManager")) : class$org$netbeans$modules$form$palette$CPManager));
        }
        return bundle;
    }

    public static PaletteItem createPaletteItem(Node node) {
        try {
            return new PaletteItem(node);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CPManager.t("createPaletteItem-ClassNotFoundException");
        }
        catch (InstantiationException instantiationException) {
            CPManager.t("createPaletteItem-InstantiationException");
        }
        catch (IOException iOException) {
            CPManager.t("createPaletteItem-IOException");
        }
        return null;
    }

    private DataFolder getPaletteUIFolder() {
        DataFolder dataFolder = null;
        try {
            FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource(PALETTE_UI_FOLDER_NAME);
            if (fileObject == null) {
                fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot().createFolder(PALETTE_UI_FOLDER_NAME);
            }
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
            return dataFolder;
        }
        catch (IOException iOException) {
            throw new InternalError("Folder not found and cannot be created: PaletteUI");
        }
    }

    private boolean checkAvailablePalettes() {
        DataObject[] dataObjectArray = null;
        DataFolder dataFolder = null;
        dataFolder = this.getPaletteUIFolder();
        if (dataFolder == null) {
            return false;
        }
        dataObjectArray = dataFolder.getChildren();
        if (dataObjectArray == null) {
            return false;
        }
        ArrayList<CPElements.Palette> arrayList = new ArrayList<CPElements.Palette>();
        int n = 0;
        int n2 = 0;
        while (n2 < dataObjectArray.length) {
            Node node = dataObjectArray[n2].getNodeDelegate();
            if (node != null) {
                String string = node.getName();
                String string2 = node.getDisplayName();
                FileObject fileObject = dataObjectArray[n2].getPrimaryFile();
                Object object = fileObject.getAttribute("defaultDisplayName");
                if ("instance".equals(fileObject.getExt()) && object != null) {
                    if (string.equals(string2)) {
                        string2 = object.toString();
                    }
                    string = string.replace('-', '.');
                    if (string2 != null && string != null && !string2.equals("") && !string.equals("")) {
                        arrayList.add(n, new CPElements.Palette(string2, string));
                        ++n;
                    }
                }
            }
            ++n2;
        }
        if (n < 1) {
            return false;
        }
        this.registeredPalettes = new CPElements.Palette[n];
        int n3 = 0;
        while (n3 < n) {
            this.registeredPalettes[n3] = (CPElements.Palette)arrayList.get(n3);
            ++n3;
        }
        return true;
    }

    private void loadPalette(int n) {
        CPElements.Palette palette = n < this.registeredPalettes.length ? this.registeredPalettes[n] : this.registeredPalettes[0];
        boolean bl = this.loadSelectedPalette(palette);
        if (bl) {
            CPManager.t("Palette successful loaded!");
            Node[] nodeArray = this.paletteNode.getCategoriesNodes();
        } else {
            CPManager.t("Palette loading failed!");
            InternalError internalError = new InternalError("Palette loading failed!");
            TopManager.getDefault().getErrorManager().notify((Throwable)internalError);
        }
    }

    private void switchUI() {
        CPManager.t("switchUI-BEG");
        this.setSelectedItem(null);
        this.setMode(0);
        this.palette.removeAll();
        this.palette.setLayout(new BorderLayout());
        this.palette.add(this.component);
        this.palette.revalidate();
        this.palette.repaint();
        CPManager.t("switchUI-END");
    }

    private FormDesigner getDesigner() {
        Node node = ComponentInspector.getInstance().getExplorerManager().getRootContext();
        if (!(node instanceof FormNode)) {
            return null;
        }
        return ((FormNode)node).getFormModel().getFormDesigner();
    }

    private void createListener4FormSettings() {
        FormEditor.getFormSettings().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedPalette".equals(propertyChangeEvent.getPropertyName())) {
                    CPManager.this.loadPalette((Integer)propertyChangeEvent.getNewValue());
                } else if ("showComponentsNames".equals(propertyChangeEvent.getPropertyName())) {
                    CPManager.this.propertySupport.firePropertyChange("showComponentsNames", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    private void createListeners4PaletteNodes() {
        CPManager.t("createListeners4PaletteNodes-BEG");
        this.categoryNodeListener = new NodeAdapter(){

            public synchronized void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                CPManager.t("beans added to: " + ((FeatureDescriptor)((Object)((PaletteCategoryNode)((Object)nodeMemberEvent.getSource())))).getName());
                CPManager.this.updateCategoryInEventQueue((PaletteCategoryNode)((Object)nodeMemberEvent.getSource()));
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                CPManager.t("beans removed from: " + ((FeatureDescriptor)((Object)((PaletteCategoryNode)((Object)nodeMemberEvent.getSource())))).getName());
                CPManager.this.updateCategoryInEventQueue((PaletteCategoryNode)((Object)nodeMemberEvent.getSource()));
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                CPManager.t("beans reordered in: " + ((FeatureDescriptor)((Object)((PaletteCategoryNode)((Object)nodeReorderEvent.getSource())))).getName());
                CPManager.this.updateCategoryInEventQueue((PaletteCategoryNode)((Object)nodeReorderEvent.getSource()));
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName()) || "displayName".equals(propertyChangeEvent.getPropertyName())) {
                    CPManager.t("category " + propertyChangeEvent.getOldValue() + " renamed to " + propertyChangeEvent.getNewValue());
                    CPManager.this.updateCategoryInEventQueue((PaletteCategoryNode)((Object)propertyChangeEvent.getSource()));
                }
            }
        };
        this.paletteNode.addNodeListener((NodeListener)new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                CPManager.t("addListenersToNodes:childrenAdded");
                Node[] nodeArray = nodeMemberEvent.getDelta();
                int n = 0;
                while (n < nodeArray.length) {
                    nodeArray[n].addNodeListener(CPManager.this.categoryNodeListener);
                    ++n;
                }
                CPManager.this.runInEventQueue(1);
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                CPManager.t("addListenersToNodes:childrenRemoved");
                Node[] nodeArray = nodeMemberEvent.getDelta();
                int n = 0;
                while (n < nodeArray.length) {
                    nodeArray[n].removeNodeListener(CPManager.this.categoryNodeListener);
                    ++n;
                }
                CPManager.this.runInEventQueue(2);
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                CPManager.t("addListenersToNodes:childrenReordered");
                CPManager.this.runInEventQueue(3);
            }
        });
        CPManager.t("createListeners4PaletteNodes-END");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addManagerListener(CPManagerListener cPManagerListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(cPManagerListener);
    }

    public void removeManagerListener(CPManagerListener cPManagerListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(cPManagerListener);
    }

    private void updateCategoryInEventQueue(PaletteCategoryNode paletteCategoryNode) {
        Set set = this.updateNodes;
        boolean bl = this.updateNodes.size() == 0;
        this.updateNodes.add(paletteCategoryNode);
        CPManager.t("added category to update: " + ((FeatureDescriptor)((Object)paletteCategoryNode)).getName());
        if (bl || set != this.updateNodes) {
            this.runInEventQueue(4);
        }
        this.allItems = null;
    }

    private void runInEventQueue(int n) {
        CPManager.t("placing task, id: " + n);
        EventQueue.invokeLater(new PaletteTask(n));
    }

    private static void t(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bundle = null;
    }

    private class PaletteTask
    implements Runnable {
        int whatToDo;

        PaletteTask(int n) {
            this.whatToDo = n;
        }

        public void run() {
            Vector vector;
            CPManager.t("performing task, id: " + this.whatToDo);
            if (this.whatToDo == 6) {
                CPManager.this.switchUI();
            }
            if (CPManager.this.listeners == null) {
                return;
            }
            PaletteTask paletteTask = this;
            synchronized (paletteTask) {
                vector = (Vector)CPManager.this.listeners.clone();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CPManagerListener cPManagerListener = (CPManagerListener)enumeration.nextElement();
                if (this.whatToDo == 4) {
                    Set set = CPManager.this.updateNodes;
                    CPManager.this.updateNodes = new HashSet(11);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        PaletteCategoryNode paletteCategoryNode = (PaletteCategoryNode)((Object)iterator.next());
                        cPManagerListener.itemsChanged(paletteCategoryNode);
                    }
                    continue;
                }
                if (this.whatToDo == 5) {
                    cPManagerListener.itemsReordered(CPManager.this.changedCategories[0]);
                    continue;
                }
                if (this.whatToDo == 1) {
                    cPManagerListener.categoriesAdded(CPManager.this.changedCategories);
                    continue;
                }
                if (this.whatToDo == 2) {
                    cPManagerListener.categoriesRemoved(CPManager.this.changedCategories);
                    continue;
                }
                if (this.whatToDo != 3) continue;
                cPManagerListener.categoriesReordered();
            }
            CPManager.t(null);
        }
    }
}

