/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteCategoryNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class PaletteNode
extends DataFolder.FolderNode {
    private static PaletteNode sharedPaletteNode;
    private static String iconURL;
    private static String icon32URL;
    private static final String PALETTE_FOLDER_NAME = "Palette";
    private static final Node.PropertySet[] NO_PROPERTIES;
    private static SystemAction[] staticActions;
    private static DataFolder paletteFolder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;

    public PaletteNode() {
        this(PaletteNode.getPaletteFolder());
    }

    PaletteNode(DataFolder dataFolder) {
        super(dataFolder, (Children)new PaletteNodeChildren(dataFolder));
        this.setDisplayName(CPManager.getBundle().getString("CTL_Component_palette"));
        if (sharedPaletteNode == null) {
            sharedPaletteNode = this;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public static PaletteNode getPaletteNode() {
        if (sharedPaletteNode == null) {
            new PaletteNode();
        }
        return sharedPaletteNode;
    }

    public Node[] getCategoriesNodes() {
        Node[] nodeArray = this.getChildren().getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
        int n = 0;
        while (n < nodeArray.length) {
            if (nodeArray[n] instanceof PaletteCategoryNode) {
                arrayList.add(nodeArray[n]);
            }
            ++n;
        }
        return (Node[])arrayList.toArray(new PaletteCategoryNode[arrayList.size()]);
    }

    static DataFolder getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource(PALETTE_FOLDER_NAME);
            if (fileObject == null) {
                fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot().createFolder(PALETTE_FOLDER_NAME);
            }
            paletteFolder = DataFolder.findFolder((FileObject)fileObject);
            return paletteFolder;
        }
        catch (IOException iOException) {
            throw new InternalError("Folder not found and cannot be created: Palette");
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        DataFolder dataFolder;
        if ((class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = PaletteNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index).isAssignableFrom(clazz) && (dataFolder = (DataFolder)super.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteNode.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            return new PaletteIndex(dataFolder, (PaletteNodeChildren)this.getChildren());
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int n) {
        if (n == 1 || n == 3) {
            return Utilities.loadImage((String)iconURL);
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewCategory()};
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = PaletteNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = PaletteNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = PaletteNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = PaletteNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = PaletteNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction))};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    void createNewCategory() throws IOException {
        ResourceBundle resourceBundle = CPManager.getBundle();
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(resourceBundle.getString("CTL_NewCategoryName"), resourceBundle.getString("CTL_NewCategoryTitle"));
        inputLine.setInputText(resourceBundle.getString("CTL_NewCategoryValue"));
        while (TopManager.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            if (!PaletteCategoryNode.checkCategoryName(string, null)) continue;
            String string2 = PaletteCategoryNode.convertToFolderName(string, null);
            FileObject fileObject = PaletteNode.getPaletteFolder().getPrimaryFile().createFolder(string2);
            if (string2.equals(string)) break;
            fileObject.setAttribute("categoryName", (Object)string);
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        iconURL = "/org/netbeans/modules/form/resources/palette.gif";
        icon32URL = "/org/netbeans/modules/form/resources/palette32.gif";
        NO_PROPERTIES = new Node.PropertySet[0];
    }

    private final class NewCategory
    extends NewType {
        static /* synthetic */ Class class$org$netbeans$modules$form$palette$PaletteNode$NewCategory;

        private NewCategory() {
        }

        public String getName() {
            return CPManager.getBundle().getString("CTL_NewCategory");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$form$palette$PaletteNode$NewCategory == null ? (class$org$netbeans$modules$form$palette$PaletteNode$NewCategory = NewCategory.class$("org.netbeans.modules.form.palette.PaletteNode$NewCategory")) : class$org$netbeans$modules$form$palette$PaletteNode$NewCategory);
        }

        public void create() throws IOException {
            PaletteNode.this.createNewCategory();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static final class PaletteIndex
    extends DataFolder.Index {
        PaletteNodeChildren children;

        PaletteIndex(DataFolder dataFolder, PaletteNodeChildren paletteNodeChildren) {
            super(dataFolder);
            this.children = paletteNodeChildren;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static final class PaletteNodeChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        public PaletteNodeChildren(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder dataFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteNodeChildren.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                return new PaletteCategoryNode(dataFolder);
            }
            return node.cloneNode();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

