/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.netbeans.modules.javadoc.search.JavaDocFSNode;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class JavaDocChildren
extends Children.Keys
implements RepositoryListener {
    private PropertyChangeListener fsPCL = new fsChangeListener();
    private PropertyChangeListener wFsPCL = WeakListener.propertyChange((PropertyChangeListener)this.fsPCL, null);
    private PropertyChangeListener capabilityPCL = new capChangeListener();
    private PropertyChangeListener wCapabilityPCL = WeakListener.propertyChange((PropertyChangeListener)this.capabilityPCL, null);

    public JavaDocChildren() {
        Repository repository = TopManager.getDefault().getRepository();
        repository.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)repository));
        Enumeration enumeration = repository.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.addPropertyChangeListener(this.wFsPCL);
            fileSystem.getCapability().addPropertyChangeListener(this.wCapabilityPCL);
        }
    }

    protected void addNotify() {
        this.setKeys(this.getDocFileSystems());
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object object) {
        try {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)((FileSystem)object).getRoot());
            return new Node[]{new JavaDocFSNode(dataFolder, this.getFSChildren((FileSystem)object))};
        }
        catch (IntrospectionException introspectionException) {
            return new Node[0];
        }
    }

    private Collection getDocFileSystems() {
        Enumeration enumeration = FileSystemCapability.DOC.fileSystems();
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            arrayList.add(fileSystem);
        }
        return arrayList;
    }

    void refreshFs(Object object) {
        this.refreshKey(object);
    }

    private Children getFSChildren(FileSystem fileSystem) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileSystem.getRoot());
        return dataFolder.createNodeChildren(DataFilter.ALL);
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        fileSystem.addPropertyChangeListener(this.wFsPCL);
        fileSystem.getCapability().addPropertyChangeListener(this.wCapabilityPCL);
        this.setKeys(this.getDocFileSystems());
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        this.setKeys(this.getDocFileSystems());
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        fileSystem.removePropertyChangeListener(this.wFsPCL);
        fileSystem.getCapability().removePropertyChangeListener(this.wCapabilityPCL);
        this.setKeys(this.getDocFileSystems());
    }

    void refreshAll() {
        this.setKeys(this.getDocFileSystems());
    }

    class capChangeListener
    implements PropertyChangeListener {
        capChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("doc")) {
                JavaDocChildren.this.refreshAll();
            }
        }
    }

    class fsChangeListener
    implements PropertyChangeListener {
        fsChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("root")) {
                JavaDocChildren.this.refreshFs(propertyChangeEvent.getSource());
            }
        }
    }
}

