/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$SignVerifier == null ? (class$org$netbeans$modules$autoupdate$SignVerifier = SignVerifier.class$("org.netbeans.modules.autoupdate.SignVerifier")) : class$org$netbeans$modules$autoupdate$SignVerifier));
    private static final String KS_PSSWD = "open4all";
    private static final String NBM_BIN = "netbeans/bin";
    private static final String NBM_LIB = "netbeans/lib";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    ProgressDialog progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private long totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$SignVerifier;

    SignVerifier(ProgressDialog progressDialog, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = progressDialog;
    }

    void doVerify() {
        this.verifyCanceled = false;
        Runnable runnable = new Runnable(){

            public void run() {
                SignVerifier.this.progressDialog.setLabelText(1, bundle.getString("CTL_PreparingVerify_Label"));
                SignVerifier.this.verifySize = SignVerifier.this.getTotalVerifySize();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.verifyAll();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(runnable);
    }

    int getTotalVerifySize() {
        long l = 0L;
        this.modulesCount = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || !moduleUpdate.isDownloadOK() || moduleUpdate.getSecurity() != -1 && moduleUpdate.getSecurity() != 0) continue;
            File file = Downloader.getNBM(moduleUpdate);
            l += file.length();
            ++this.modulesCount;
        }
        return (int)(l / 1024L);
    }

    void verifyAll() {
        Object object;
        this.progressDialog.setGaugeBounds(2, 0, this.verifySize);
        this.progressDialog.setGaugeValue(2, 0);
        this.progressDialog.setLabelText(2, "");
        this.progressDialog.setGaugeValue(1, 0);
        int n = 0;
        this.totalVerified = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || !((ModuleUpdate)object).isDownloadOK() || ((ModuleUpdate)object).getSecurity() != -1 && ((ModuleUpdate)object).getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setGaugeValue(1, 0);
            this.progressDialog.setLabelText(1, ((ModuleUpdate)object).getName() + " [" + (n + 1) + "/" + this.modulesCount + "]");
            File file = Downloader.getNBM((ModuleUpdate)object);
            try {
                Collection collection = this.verifyJar(file, (ModuleUpdate)object);
                if (collection == null) {
                    ((ModuleUpdate)object).setSecurity(2);
                    ((ModuleUpdate)object).setInstallApproved(false);
                } else {
                    ((ModuleUpdate)object).setCerts(collection);
                    if (this.isTrusted(collection)) {
                        ((ModuleUpdate)object).setSecurity(4);
                        ((ModuleUpdate)object).setInstallApproved(true);
                    } else {
                        ((ModuleUpdate)object).setSecurity(3);
                        ((ModuleUpdate)object).setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException securityException) {
                ((ModuleUpdate)object).setSecurity(1);
                ((ModuleUpdate)object).setInstallApproved(false);
            }
            catch (IOException iOException) {
                ((ModuleUpdate)object).setSecurity(0);
                ((ModuleUpdate)object).setInstallApproved(false);
                ((ModuleUpdate)object).setDownloadOK(false);
            }
            ++n;
        }
        this.progressDialog.setGaugeValue(2, this.verifySize);
        object = MessageFormat.format(bundle.getString("FMT_VerifiedTotal"), new Integer(this.verifySize), new Integer(this.verifySize));
        this.progressDialog.setLabelText(2, (String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection verifyJar(File var1_1, ModuleUpdate var2_2) throws SecurityException, IOException {
        block18: {
            var3_3 = null;
            var4_4 = false;
            var5_5 = false;
            var6_6 = 0;
            var7_7 = (int)var1_1.length();
            this.progressDialog.setGaugeBounds(1, 0, var7_7 / 1024);
            var8_8 = new JarFile(var1_1);
            var9_9 = var8_8.getManifest();
            var10_10 = var8_8.entries();
            var11_11 = new LinkedList<Cloneable>();
            var12_12 = new byte[8192];
            try {
                while (true) {
                    if (!var10_10.hasMoreElements()) {
                        if (!this.verifyCanceled) break block18;
                        var13_13 = null;
                        break;
                    }
                    var13_13 = var10_10.nextElement();
                    if (var13_13.getName().startsWith("netbeans/lib") || var13_13.getName().startsWith("netbeans/bin")) {
                        var2_2.setDepending(true);
                    }
                    this.progressDialog.setGaugeValue(1, var6_6 / 1024);
                    var11_11.add(var13_13);
                    var14_14 = var8_8.getInputStream((ZipEntry)var13_13);
                    try {
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var17_29) {
                        var18_17 = null;
                        var14_14.close();
                        this.totalVerified += var13_13.getCompressedSize();
                        var6_6 = (int)((long)var6_6 + var13_13.getCompressedSize());
                        var19_20 = MessageFormat.format(SignVerifier.bundle.getString("FMT_VerifiedTotal"), new Object[]{new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize)});
                        this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                        this.progressDialog.setLabelText(2, var19_20);
                        this.progressDialog.setGaugeValue(1, var6_6 / 1024);
                        throw var17_29;
                    }
lbl39:
                    // 1 sources

                    while (true) {
                        var14_14.close();
                        this.totalVerified += var13_13.getCompressedSize();
                        var6_6 = (int)((long)var6_6 + var13_13.getCompressedSize());
                        var19_20 = MessageFormat.format(SignVerifier.bundle.getString("FMT_VerifiedTotal"), new Object[]{new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize)});
                        this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                        this.progressDialog.setLabelText(2, var19_20);
                        this.progressDialog.setGaugeValue(1, var6_6 / 1024);
                        var21_25 = null;
                        var8_8.close();
                        if (this.wizardCanceled == false) return var16_23;
                        Downloader.getNBM(var2_2).delete();
                        return var16_23;
                    }
lbl-1000:
                    // 1 sources

                    {
                        block20: {
                            do {
                                if ((var15_15 = var14_14.read(var12_12, 0, var12_12.length)) == -1) break block20;
                            } while (!this.verifyCanceled);
                            var16_23 = null;
                            var18_17 = null;
                            ** continue;
                        }
                        var18_17 = null;
                        var14_14.close();
                        this.totalVerified += var13_13.getCompressedSize();
                        var6_6 = (int)((long)var6_6 + var13_13.getCompressedSize());
                        var19_20 = MessageFormat.format(SignVerifier.bundle.getString("FMT_VerifiedTotal"), new Object[]{new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize)});
                        this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                        this.progressDialog.setLabelText(2, var19_20);
                        this.progressDialog.setGaugeValue(1, var6_6 / 1024);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var20_31) {
                var21_28 = null;
                var8_8.close();
                if (this.wizardCanceled == false) throw var20_31;
                Downloader.getNBM(var2_2).delete();
                throw var20_31;
            }
            var21_26 = null;
            var8_8.close();
            if (this.wizardCanceled == false) return var13_13;
            Downloader.getNBM(var2_2).delete();
            return var13_13;
        }
        var21_27 = null;
        var8_8.close();
        if (this.wizardCanceled) {
            Downloader.getNBM(var2_2).delete();
        }
        var13_13 = new HashSet<E>();
        if (var9_9 != null) {
            var14_14 = var11_11.iterator();
            while (var14_14.hasNext()) {
                var15_16 = (JarEntry)var14_14.next();
                var16_24 = var15_16.getName();
                var17_30 = var15_16.getCertificates();
                var18_19 = var17_30 != null && var17_30.length > 0;
                var4_4 |= var18_19;
                if (var17_30 != null) {
                    var19_22 = 0;
                    while (var19_22 < var17_30.length) {
                        var13_13.add(var17_30[var19_22]);
                        if (this.verifyCanceled) {
                            return null;
                        }
                        ++var19_22;
                    }
                    continue;
                }
                if (var15_16.isDirectory() || var16_24.toUpperCase().startsWith("META-INF/")) continue;
                var5_5 = true;
            }
        }
        if (var4_4 && var5_5) {
            throw new SecurityException(SignVerifier.bundle.getString("EXC_NotSignedEntity"));
        }
        this.progressDialog.setGaugeValue(1, var7_7 / 1024 + 10);
        if (var4_4 == false) return null;
        v0 = var13_13;
        return v0;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 300);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (certificate instanceof X509Certificate) {
                try {
                    stringBuffer.append("\n\n");
                    stringBuffer.append(SignVerifier.X509CertToString((X509Certificate)certificate));
                }
                catch (Exception exception) {
                    stringBuffer.append(certificate.toString());
                }
            } else {
                stringBuffer.append(certificate.toString());
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    boolean isTrusted(Collection collection) {
        Collection collection2 = this.getTrustedCerts();
        if (collection2.size() <= 0 || collection.size() <= 0) {
            return false;
        }
        return collection2.containsAll(collection);
    }

    static void addCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (keyStore.getCertificateAlias(certificate) != null) continue;
            String string = null;
            int n = 0;
            while (n < 9999) {
                string = "genAlias" + n;
                if (!keyStore.containsAlias(string)) break;
                ++n;
            }
            if (string == null) {
                throw new KeyStoreException(bundle.getString("EXC_TooManyCertificates"));
            }
            keyStore.setCertificateEntry(string, certificate);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            String string = keyStore.getCertificateAlias(certificate);
            if (string == null) continue;
            keyStore.deleteEntry(string);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList arrayList = new ArrayList(10);
        File file = Autoupdater.Support.getCentralKSFile();
        File file2 = Autoupdater.Support.getUserKSFile();
        try {
            KeyStore keyStore;
            if (file.canRead()) {
                keyStore = SignVerifier.getKeyStore(file, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
            if (file2.canRead() && !file2.equals(file)) {
                keyStore = SignVerifier.getKeyStore(file2, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return arrayList;
    }

    private static KeyStore getKeyStore(File file, String string, String string2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (string2 == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, string.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String string, String string2) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        keyStore.store(fileOutputStream, string.toCharArray());
        ((OutputStream)fileOutputStream).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(10);
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    void cancelVerify(boolean bl) {
        this.verifyCanceled = true;
        this.wizardCanceled = bl;
    }

    private static String X509CertToString(X509Certificate x509Certificate) throws Exception {
        return bundle.getString("MSG_Owner") + SPACE + x509Certificate.getSubjectDN() + NEW_LINE + bundle.getString("MSG_Issuer") + SPACE + x509Certificate.getIssuerDN() + NEW_LINE + bundle.getString("MSG_SerNumber") + SPACE + x509Certificate.getSerialNumber().toString(16) + NEW_LINE + bundle.getString("MSG_Valid") + SPACE + x509Certificate.getNotBefore().toString() + SPACE + bundle.getString("MSG_Until") + SPACE + x509Certificate.getNotAfter().toString() + NEW_LINE + bundle.getString("MSG_CertFinger") + NEW_LINE + SPACE + TAB + bundle.getString("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", x509Certificate) + NEW_LINE + SPACE + TAB + bundle.getString("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", x509Certificate);
    }

    private static String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return SignVerifier.toHexString(byArray2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignVerifier.byte2hex(byArray[n2], stringBuffer);
            if (n2 < n - 1) {
                stringBuffer.append(":");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

