/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cvsclient.commands.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.netbeans.lib.cvsclient.command.PipedFileInformation;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.modules.cvsclient.commands.diff.AbstractDiffJavaCvs;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DiffDisplayer {
    private Debug E;
    private Debug D;
    DiffCommand command;
    FileSystemCommand fsCommand;
    DiffInformation diffInfo;
    AbstractDiffJavaCvs diff;
    boolean finishedOk;
    ArrayList resultList;
    private File startFile;
    private StringBuffer bufLeft;
    private StringBuffer bufRight;
    private int fileLineCount;
    private int leftLineCount;
    private int rightLineCount;
    private File file1;
    private File file2;
    static /* synthetic */ Class class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer;
    static /* synthetic */ Class class$org$netbeans$modules$javacvs$commands$CvsDiff;

    public DiffDisplayer(DiffCommand diffCommand) {
        this.D = this.E = new Debug("DiffDisplayer", true);
        this.D.deb("Constructor");
        this.command = diffCommand;
    }

    private PipedFileInformation findUpdInfo(LinkedList linkedList, String string) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PipedFileInformation pipedFileInformation = (PipedFileInformation)iterator.next();
            if (!pipedFileInformation.getRepositoryFileName().equals(string)) continue;
            return pipedFileInformation;
        }
        return null;
    }

    public void displayOutputData() {
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer == null ? (class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer = DiffDisplayer.class$("org.netbeans.modules.cvsclient.commands.diff.DiffDisplayer")) : class$org$netbeans$modules$cvsclient$commands$diff$DiffDisplayer)).getString("LBL_WorkingFile");
        String string2 = this.diffInfo.getRightRevision() != null ? this.diffInfo.getRightRevision() : string;
        String string3 = this.diffInfo.getLeftRevision() != null ? this.diffInfo.getLeftRevision() : string;
        this.diff.open(this.getName() + " " + this.diffInfo.getFile().getName(), this.getMIMEType(this.diffInfo), this.file1.getAbsolutePath(), this.file2.getAbsolutePath(), string3, string2);
    }

    protected String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$javacvs$commands$CvsDiff == null ? (class$org$netbeans$modules$javacvs$commands$CvsDiff = DiffDisplayer.class$("org.netbeans.modules.javacvs.commands.CvsDiff")) : class$org$netbeans$modules$javacvs$commands$CvsDiff)).getString("CvsDiff.name");
    }

    public AbstractDiffJavaCvs createAbstractDiff() {
        return new AbstractDiffJavaCvs();
    }

    public void setData(DiffInformation diffInformation, DiffCommand diffCommand, PipedFileInformation pipedFileInformation) {
        this.D.deb("setData() beginning");
        File file = diffInformation.getFile();
        if (pipedFileInformation != null) {
            if (!file.exists()) {
                file = pipedFileInformation.getTempFile();
            }
            if (diffCommand.getBeforeDate1() != null || diffCommand.getRevision2() != null) {
                file = pipedFileInformation.getTempFile();
            }
        }
        if (file == null) {
            return;
        }
        this.diffInfo = diffInformation;
        this.processDocuments(this.diffInfo, file);
        this.file1 = this.saveToFile(this.bufLeft);
        this.D.deb("file left=" + this.file1.getAbsolutePath());
        this.file2 = this.saveToFile(this.bufRight);
        this.D.deb("file right=" + this.file2.getAbsolutePath());
        this.diff = this.createAbstractDiff();
        DiffInformation.DiffChange diffChange = this.diffInfo.getFirstChange();
        while (diffChange != null) {
            if (diffChange.getType() == 0) {
                this.diff.addAddAction(diffChange.getLeftMin(), diffChange.getRightMin(), diffChange.getRightMax());
            }
            if (diffChange.getType() == 2) {
                this.diff.addChangeAction(diffChange.getLeftMin(), diffChange.getLeftMax(), diffChange.getRightMin(), diffChange.getRightMax());
            }
            if (diffChange.getType() == 1) {
                this.diff.addDeleteAction(diffChange.getLeftMin(), diffChange.getLeftMax(), diffChange.getRightMin());
            }
            diffChange = this.diffInfo.getNextChange();
        }
    }

    private String getMIMEType(DiffInformation diffInformation) {
        String string;
        File file = diffInformation.getFile();
        if (file == null) {
            return "text/plain";
        }
        String string2 = file.getName();
        String string3 = null;
        this.D.deb("tempStr=" + string2);
        int n = string2.indexOf(46);
        if (n > 0) {
            string3 = string2.substring(n + 1);
        }
        this.D.deb("extension=" + string3);
        if (string3 == null) {
            string3 = "text/plain";
        }
        if ((string = FileUtil.getMIMEType((String)string3)) == null) {
            string = "text/plain";
        }
        return string;
    }

    private File saveToFile(StringBuffer stringBuffer) {
        long l;
        String string = System.getProperty("netbeans.user") + File.separator + "system" + File.separator + "javacvs" + File.separator + "tmp";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        do {
            l = 10000L * (1L + Math.round(Math.random() * 8.0)) + Math.round(Math.random() * 1000.0);
        } while (new File(string + File.separator + "tmp" + l).exists());
        String string2 = string + File.separator + "tmp" + l;
        File file2 = new File(string2);
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2), true);
            printWriter.print(stringBuffer);
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2;
    }

    private void processDocuments(DiffInformation diffInformation, File file) {
        BufferedReader bufferedReader = null;
        this.leftLineCount = 0;
        this.rightLineCount = 0;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        this.bufLeft = new StringBuffer();
        this.bufRight = new StringBuffer();
        try {
            int n;
            this.fileLineCount = 0;
            DiffInformation.DiffChange diffChange = diffInformation.getFirstChange();
            while (diffChange != null) {
                int n2;
                boolean bl = diffChange.getType() == 1;
                int n3 = n2 = bl ? diffChange.getMainBeginning() : diffChange.getMainBeginning() - 1;
                if (diffChange.getMainBeginning() >= this.fileLineCount) {
                    n = this.fillFromFile(n2, bufferedReader);
                    this.D.deb("filled = " + n);
                }
                if (diffChange.getType() == 0) {
                    this.D.deb("we got ADD change here!");
                    n = this.parseAddChange(diffChange, true);
                    this.skipGap(n, bufferedReader);
                }
                if (diffChange.getType() == 1) {
                    this.D.deb("we got DELETE change here!");
                    n = this.parseDeleteChange(diffChange, true);
                }
                if (diffChange.getType() == 2) {
                    this.D.deb("we got CHANGE change here!");
                    n = this.parseChangedChange(diffChange);
                    this.skipGap(n, bufferedReader);
                }
                diffChange = diffInformation.getNextChange();
            }
            n = this.fillFromFile(-1, bufferedReader);
        }
        catch (IOException iOException) {
            Thread.dumpStack();
        }
    }

    private void skipGap(int n, BufferedReader bufferedReader) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            String string = bufferedReader.readLine();
            ++this.fileLineCount;
            this.D.deb("skipped one line=" + string);
            ++n2;
        }
    }

    private int fillFromFile(int n, BufferedReader bufferedReader) throws IOException {
        this.D.deb("fillingGap...");
        int n2 = 0;
        int n3 = n;
        while (this.fileLineCount < n3 || n3 == -1) {
            String string = bufferedReader.readLine();
            if (string == null) break;
            ++this.fileLineCount;
            this.D.deb("reading linenum=" + ++n2 + "  line=" + string);
            ++this.leftLineCount;
            this.bufLeft.append(string + "\n");
            ++this.rightLineCount;
            this.bufRight.append(string + "\n");
        }
        return n2;
    }

    private int parseAddChange(DiffInformation.DiffChange diffChange, boolean bl) {
        int n = diffChange.getRightMin();
        while (n <= diffChange.getRightMax()) {
            this.bufRight.append(diffChange.getLine(n, false) + "\n");
            ++this.rightLineCount;
            this.D.deb("adding to main=" + diffChange.getLine(n, false));
            ++n;
        }
        int n2 = n - diffChange.getRightMin();
        this.D.deb("final ADDED gap =" + n2);
        return n2;
    }

    private int parseDeleteChange(DiffInformation.DiffChange diffChange, boolean bl) {
        int n = diffChange.getLeftMin();
        while (n <= diffChange.getLeftMax()) {
            ++this.leftLineCount;
            this.bufLeft.append(diffChange.getLine(n, true) + "\n");
            this.D.deb("addding to diff=" + diffChange.getLine(n, true));
            ++n;
        }
        int n2 = n - diffChange.getLeftMin();
        this.D.deb("final DELETE gap =" + n2);
        return n2;
    }

    private int parseChangedChange(DiffInformation.DiffChange diffChange) {
        int n;
        int n2 = n = this.parseAddChange(diffChange, false);
        int n3 = this.parseDeleteChange(diffChange, false);
        return n2;
    }

    public void setCommand(DiffCommand diffCommand) {
        this.command = diffCommand;
    }

    public void setFileSystemCommand(FileSystemCommand fileSystemCommand) {
        this.fsCommand = fileSystemCommand;
    }

    public File getFileDisplayed() {
        if (this.diffInfo == null) {
            return null;
        }
        return this.diffInfo.getFile();
    }

    public Object getComparisonData() {
        return this.diffInfo;
    }

    public JComponent getComponent() {
        return null;
    }

    public boolean equalDisplayedData(File file, Class clazz, Object object) {
        if (!this.getClass().equals(clazz)) {
            return false;
        }
        return this.diffInfo != null && this.diffInfo.getFile() != null && this.diffInfo.getFile().equals(file);
    }

    public FileSystemCommand getFileSystemCommand() {
        return this.fsCommand;
    }

    public String getCommandSwitches() {
        return this.command.getCVSArguments();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

