/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Vector;
import org.netbeans.modules.javacvs.JavaCvsFileSystem;
import org.netbeans.modules.javacvs.caching.CommandLocker;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.caching.CvsCacheFile;
import org.netbeans.modules.javacvs.caching.JavaCvsCache;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.javacvs.commands.FileSystemCommand;
import org.netbeans.modules.javacvs.commands.FileSystemCommandImpl;
import org.netbeans.modules.javacvs.commands.JavaCvsStatusManager;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakListener;

public class CvsFsCache
implements CachedFileSystem {
    private static CommandLocker refreshLocker = new CommandLocker();
    protected AbstractFileSystem cvsfs;
    private PropertyChangeListener list;
    protected boolean offLine;
    protected boolean hideShadowFiles;
    protected int autoRefresh;
    protected File fsRootFile;

    public CvsFsCache(AbstractFileSystem abstractFileSystem, File file) {
        this.cvsfs = abstractFileSystem;
        this.list = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CvsFsCache.this.propertiesChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        abstractFileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.list, (Object)abstractFileSystem));
    }

    public void setOffLine(boolean bl) {
        this.offLine = bl;
    }

    public void setAutoRefresh(int n) {
        this.autoRefresh = n;
    }

    public void setHideShadowFiles(boolean bl) {
        this.hideShadowFiles = bl;
    }

    public void setFsRootFile(File file) {
        this.fsRootFile = file;
    }

    public static JavaCvsCache getCacheObject() {
        FileSystemCache fileSystemCache = CacheHandler.getInstance().getCache("javacvs");
        JavaCvsCache javaCvsCache = fileSystemCache == null ? new JavaCvsCache() : (JavaCvsCache)fileSystemCache;
        return javaCvsCache;
    }

    protected JavaCvsStatusManager getStatusManager() {
        return JavaCvsStatusManager.getInstance();
    }

    private void propertiesChanged(String string, Object object, Object object2) {
        Comparable<Boolean> comparable;
        if (string == null) {
            return;
        }
        if (string.equals("OffLine")) {
            comparable = (Boolean)object2;
            this.offLine = (Boolean)comparable;
        }
        if (string.equals("AutoRefresh")) {
            comparable = (Integer)object2;
            this.autoRefresh = (Integer)comparable;
        }
        if (string.equals("hideShadowFiles")) {
            comparable = (Boolean)object2;
            this.hideShadowFiles = (Boolean)comparable;
        }
        if (string.equals("root")) {
            File file;
            comparable = (FileObject)object2;
            this.fsRootFile = file = FileSystemCommand.toFile(comparable);
        }
    }

    protected int adjustStrategy(int n) {
        if (n > 3 && this.offLine) {
            return 3;
        }
        return n;
    }

    protected boolean permitAction(int n) {
        return n <= 3 || !this.offLine;
    }

    public String getFileStatusOnly(Vector vector) {
        File file;
        Object object;
        String string;
        int n = 3;
        String string2 = " ";
        int n2 = vector.size();
        CacheFile cacheFile = null;
        if (n2 < 1) {
            return "Unknown";
        }
        if (this.autoRefresh == 1) {
            string = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getAbsolutePath(), string);
            if (((File)object).getParent() != null) {
                object = ((File)object).getParentFile();
                file = new File(((File)object).getAbsolutePath(), "CVS");
                File file2 = new File(((File)object).getAbsolutePath(), "CVS/netbeans.cache");
                if (file.exists() && !file2.exists()) {
                    try {
                        file2.createNewFile();
                        this.doRefresh(new File[]{object}, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if (n2 == 1) {
            string = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getAbsolutePath(), string);
            if (object != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile((File)object, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            String string3 = cacheFile != null ? cacheFile.getStatus() : "";
            return string3;
        }
        object = "NotInSynch";
        string = (String)vector.elementAt(0);
        file = new File(this.fsRootFile.getAbsolutePath(), string);
        if (file != null) {
            cacheFile = CacheHandler.getInstance().getCacheFile(file, this.adjustStrategy(n), (CachedFileSystem)this);
        }
        String string4 = cacheFile != null ? cacheFile.getStatus() : "";
        int n3 = 1;
        while (n3 < n2) {
            String string5;
            String string6 = (String)vector.elementAt(n3);
            File file3 = new File(this.fsRootFile.getAbsolutePath(), string6);
            if (file3 != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile(file3, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            if (!(string5 = cacheFile != null ? cacheFile.getStatus() : "").equals(string4)) {
                return object;
            }
            ++n3;
        }
        return string4;
    }

    public String getStatus(String string, Vector vector) {
        File file;
        Object object;
        String string2;
        int n = 3;
        String string3 = "";
        int n2 = vector.size();
        CacheFile cacheFile = null;
        if (n2 < 1) {
            return this.getStatusManager().getStatus("Unknown");
        }
        if (this.autoRefresh == 1) {
            string2 = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getAbsolutePath(), string2);
            if (((File)object).getParent() != null) {
                object = ((File)object).getParentFile();
                file = new File(((File)object).getAbsolutePath(), "CVS");
                File file2 = new File(((File)object).getAbsolutePath(), "CVS/netbeans.cache");
                if (file.exists() && !file2.exists()) {
                    try {
                        file2.createNewFile();
                        this.doRefresh(new File[]{object}, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if (n2 == 1) {
            string2 = (String)vector.elementAt(0);
            object = new File(this.fsRootFile.getAbsolutePath(), string2);
            if (object != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile((File)object, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            String string4 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "";
            return string4;
        }
        object = this.getStatusManager().getStatus("NotInSynch");
        string2 = (String)vector.elementAt(0);
        file = new File(this.fsRootFile.getAbsolutePath(), string2);
        if (file != null) {
            cacheFile = CacheHandler.getInstance().getCacheFile(file, this.adjustStrategy(n), (CachedFileSystem)this);
        }
        String string5 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "";
        int n3 = 1;
        while (n3 < n2) {
            String string6;
            String string7 = (String)vector.elementAt(n3);
            File file3 = new File(this.fsRootFile.getAbsolutePath(), string7);
            if (file3 != null) {
                cacheFile = CacheHandler.getInstance().getCacheFile(file3, this.adjustStrategy(n), (CachedFileSystem)this);
            }
            if (!(string6 = cacheFile != null ? this.getStatusManager().getStatus(cacheFile.getStatus()) : "").equals(string5)) {
                return object;
            }
            ++n3;
        }
        return string5;
    }

    public String[] getDirContent(File file) {
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file, 0, (CachedFileSystem)this);
        if (cvsCacheDir != null) {
            return cvsCacheDir.getDirContentNames(this.hideShadowFiles);
        }
        return null;
    }

    public void addToCache(File file) {
        File file2 = file.getParentFile();
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file2, 0, (CachedFileSystem)this);
        if (cvsCacheDir == null) {
            return;
        }
        cvsCacheDir.setComplete(false);
    }

    public void removeFromCache(File file, boolean bl) {
        File file2 = file.getParentFile();
        CvsCacheDir cvsCacheDir = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file2, 0, (CachedFileSystem)this);
        if (cvsCacheDir == null) {
            CvsCacheDir cvsCacheDir2 = (CvsCacheDir)CacheHandler.getInstance().getCacheFile(file, 0, (CachedFileSystem)this);
            CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir((CacheDir)cvsCacheDir2);
            return;
        }
        if (bl) {
            cvsCacheDir.removeChildDir(file.getName(), true);
        } else {
            cvsCacheDir.removeFile(file.getName(), true);
        }
        cvsCacheDir.setComplete(false);
    }

    public void removeFromCache(CacheFile cacheFile) {
        CacheDir cacheDir = cacheFile.getParent();
        if (cacheFile instanceof CacheDir) {
            if (cacheDir == null) {
                CacheDir cacheDir2 = (CacheDir)cacheFile;
                CacheHandler.getInstance().getCache((CachedFileSystem)this).unregisterDir(cacheDir2);
                return;
            }
            cacheDir.removeChildDir(cacheFile.getName(), true);
        } else if (cacheDir != null) {
            cacheDir.removeFile(cacheFile.getName(), true);
        }
        cacheDir.setComplete(false);
    }

    public void renameTo(File file, File file2) {
        File file3 = file.getParentFile();
        CacheDir cacheDir = (CacheDir)CacheHandler.getInstance().getCacheFile(file3, 0, (CachedFileSystem)this);
        if (cacheDir == null) {
            return;
        }
        if (!file2.isDirectory()) {
            cacheDir.removeFile(file.getName(), true);
            CvsCacheFile cvsCacheFile = new CvsCacheFile(this.getCacheId(), file2.getName());
            cacheDir.addFile((CacheFile)cvsCacheFile, true);
            return;
        }
        CacheDir cacheDir2 = cacheDir.getSubDir(file.getName());
        cacheDir.removeChildDir(cacheDir2.getName(), false);
        cacheDir2.rename(new File(cacheDir.getAbsolutePath() + File.separator + file2.getName()));
        cacheDir.addChildDir(cacheDir2, false);
        cacheDir2.renameChildDirs(cacheDir2, false);
        cacheDir.setModified(true);
        cacheDir.writeToDisk();
    }

    public String getLocker(Vector vector) {
        return "";
    }

    public void saveToDisk() {
        if (!CacheHandler.getInstance().getCache((CachedFileSystem)this).isWrittenToDisk()) {
            CacheHandler.getInstance().getCache((CachedFileSystem)this).writeAllToDisk();
        }
    }

    public void saveToDiskFromNode(String string) {
        File file = new File(this.fsRootFile.getAbsolutePath(), string);
        CacheDir cacheDir = (CacheDir)CacheHandler.getInstance().getCacheFile(file, -1, (CachedFileSystem)this);
        if (cacheDir != null) {
            cacheDir.writeToDiskRecursively();
        }
    }

    public void fileModified(File file) {
        CacheFile cacheFile = CacheHandler.getInstance().getCacheFile(file, -1, (CachedFileSystem)this);
        if (cacheFile != null) {
            String string = cacheFile.getStatus();
            if (string.equals("Local") || string.equals("Unknown")) {
                return;
            }
            if (string.equals("NPatch")) {
                cacheFile.setStatus("NMerge");
            } else {
                cacheFile.setStatus("LMod");
            }
            CvsFsCache.getCacheObject().fireCacheHandlerEvent(2, cacheFile);
        }
    }

    public void addRefreshDisplayers(CvsStatus cvsStatus) {
    }

    public void doRefresh(File[] fileArray, boolean bl) {
        JavaCvsFileSystem javaCvsFileSystem = (JavaCvsFileSystem)this.cvsfs;
        if (javaCvsFileSystem == null) {
            return;
        }
        FileSystemCommandImpl fileSystemCommandImpl = (FileSystemCommandImpl)((Object)javaCvsFileSystem.createRefresh());
        CvsStatus cvsStatus = (CvsStatus)fileSystemCommandImpl.getOuterClassInstance();
        cvsStatus.setRecursive(bl);
        cvsStatus.setRefreshing(false);
        if (fileArray != null && fileArray.length > 0 && fileArray[0].isDirectory()) {
            cvsStatus.setRefreshing(true);
        }
        cvsStatus.setFiles(fileArray);
        this.addRefreshDisplayers(cvsStatus);
        refreshLocker.addToQueueAndRun(cvsStatus);
    }

    public String getCacheId() {
        return "javacvs";
    }

    public Reference createReference(FileObject fileObject) {
        File file = new File(this.fsRootFile.getAbsolutePath(), fileObject.getPackageNameExt(File.separatorChar, '.'));
        return CacheHandler.getInstance().createReference((Object)fileObject, file, this.getCacheId());
    }

    public void removeNotify() {
        CvsFsCache.getCacheObject().unregisterFileSystem((FileSystem)this.cvsfs);
        this.list = null;
        this.cvsfs = null;
    }
}

