/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacvs.caching;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.modules.javacvs.caching.CvsCacheDir;
import org.netbeans.modules.javacvs.commands.CvsStatus;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.filesystems.FileSystem;

public class JavaCvsCache
extends FileSystemCache {
    public static final int STRAT_COMMANDS = 6;
    public static final String JAVA_CACHE_NAME = "javacvs";
    private HashMap cacheDirs = new HashMap(50);
    private HashMap fileSystems = new HashMap();
    private Client cacheClient;

    public JavaCvsCache() {
        super(JAVA_CACHE_NAME);
    }

    public CacheFile getCacheFile(File file, int n) {
        String string = file.isDirectory() && file.getParentFile() == null ? file.getAbsolutePath() : (file.isDirectory() && n <= 0 ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath());
        CacheDir cacheDir = this.getDir(string);
        if (cacheDir == null) {
            cacheDir = this.initCacheDir(new File(string), n);
        }
        this.loadDir(cacheDir, n);
        if (cacheDir == null) {
            return null;
        }
        if (file.isDirectory()) {
            if (file.getParentFile() == null || n <= 0) {
                return cacheDir;
            }
            return cacheDir.getSubDir(file.getName());
        }
        return cacheDir.getFile(file.getName());
    }

    private CacheDir initCacheDir(File file, int n) {
        File file2 = file.getParentFile();
        CacheDir cacheDir = null;
        if (file2 != null) {
            cacheDir = this.getDir(file2.getAbsolutePath());
        }
        CvsCacheDir cvsCacheDir = null;
        if (cacheDir == null || cacheDir.getAppliedLevel() == -1 || !cacheDir.isComplete()) {
            cvsCacheDir = new CvsCacheDir(this.getId(), file);
            cvsCacheDir.setParent(null);
            cvsCacheDir.setComplete(true);
            if (n != -1) {
                this.registerDir(cvsCacheDir);
            }
        } else {
            cvsCacheDir = cacheDir.getSubDir(file.getName());
            if (cvsCacheDir == null) {
                cvsCacheDir = new CvsCacheDir(this.getId(), file);
                cacheDir.addChildDir((CacheDir)cvsCacheDir, false);
                if (n == -1) {
                    this.unregisterDir(cvsCacheDir);
                }
            }
        }
        return cvsCacheDir;
    }

    public CacheDir getDir(String string) {
        CacheDir cacheDir = (CacheDir)this.cacheDirs.get(string);
        return cacheDir;
    }

    public void addRefreshDisplayers(CvsStatus cvsStatus) {
    }

    public synchronized void writeAllToDisk() {
        Collection collection = this.cacheDirs.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheDir cacheDir = (CacheDir)iterator.next();
            cacheDir.writeToDisk();
        }
    }

    public synchronized void registerDir(CacheDir cacheDir) {
        this.cacheDirs.put(cacheDir.getAbsolutePath(), cacheDir);
    }

    public synchronized void unregisterDir(CacheDir cacheDir) {
        if (cacheDir != null) {
            this.cacheDirs.remove(cacheDir.getAbsolutePath());
        }
    }

    public void registerFileSystem(FileSystem fileSystem) {
        this.fileSystems.put(fileSystem, fileSystem);
    }

    public void unregisterFileSystem(FileSystem fileSystem) {
        this.fileSystems.remove(fileSystem);
        if (this.fileSystems.size() == 0) {
            CacheHandler.getInstance().unregistedType(JAVA_CACHE_NAME);
        }
    }

    protected void loadDir(CacheDir cacheDir, int n) {
        if (cacheDir == null) {
            return;
        }
        boolean bl = false;
        if (cacheDir.getAppliedLevel() > -1) {
            bl = true;
        }
        if (cacheDir.isLocal() && n >= 0) {
            cacheDir.setAppliedLevel(-1);
        }
        super.loadDir(cacheDir, n);
        if (n == 0 && bl) {
            CvsCacheDir cvsCacheDir = (CvsCacheDir)cacheDir;
            cvsCacheDir.repopulate();
            cvsCacheDir.readFromDisk();
        }
    }
}

