/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.jarpackager.FileObjectFilter;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.REFilter;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FilterEditor
extends JPanel
implements PropertyEditor {
    protected JRadioButton filterRadio;
    protected JCheckBox negativeCheckBox;
    protected JRadioButton regExpRadio;
    protected JTextField regExpTextField;
    protected JComboBox filtersComboBox;
    private FileObjectFilter value;
    private DefaultComboBoxModel model;
    private PropertyChangeSupport support;
    private boolean isValid = true;
    private PropertySheetSettings pss = (PropertySheetSettings)PropertySheetSettings.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = FilterEditor.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings), (boolean)true);
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarPackagerModule == null ? (class$org$netbeans$modules$jarpackager$JarPackagerModule = FilterEditor.class$("org.netbeans.modules.jarpackager.JarPackagerModule")) : class$org$netbeans$modules$jarpackager$JarPackagerModule));
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$FilterEditor;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarPackagerModule;

    private void initComponents() {
        this.filterRadio = new JRadioButton();
        this.filtersComboBox = new JComboBox();
        this.regExpRadio = new JRadioButton();
        this.regExpTextField = new JTextField();
        this.negativeCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.filterRadio.setToolTipText(bundle.getString("CTL_CommonFilterTip"));
        this.filterRadio.setText(bundle.getString("CTL_CommonFilter"));
        this.filterRadio.setMnemonic(bundle.getString("MNM_Common").charAt(0));
        this.filterRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.filterRadioActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.filterRadio, gridBagConstraints);
        this.filtersComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACCN_FilterList"));
        this.filtersComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.filtersComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.filtersComboBox, gridBagConstraints);
        this.regExpRadio.setToolTipText(bundle.getString("CTL_RegExpTip"));
        this.regExpRadio.setText(bundle.getString("CTL_RegExp"));
        this.regExpRadio.setMnemonic(bundle.getString("MNM_Regular").charAt(0));
        this.regExpRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.regExpRadioActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.regExpRadio, gridBagConstraints);
        this.regExpTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACCN_Expression"));
        this.regExpTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.regExpTextFieldActionPerformed(actionEvent);
            }
        });
        this.regExpTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FilterEditor.this.regExpTextFieldFocusLost(focusEvent);
            }
        });
        this.regExpTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                FilterEditor.this.regExpTextFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.regExpTextField, gridBagConstraints);
        this.negativeCheckBox.setToolTipText(bundle.getString("CTL_NegativeTip"));
        this.negativeCheckBox.setText(bundle.getString("CTL_Negative"));
        this.negativeCheckBox.setMnemonic(bundle.getString("MNM_Negative").charAt(0));
        this.negativeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.negativeCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.negativeCheckBox, gridBagConstraints);
    }

    private void negativeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void regExpTextFieldFocusLost(FocusEvent focusEvent) {
        this.updateValue();
    }

    private void regExpTextFieldActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void filtersComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
    }

    private void regExpTextFieldKeyReleased(KeyEvent keyEvent) {
        this.regExpTextField.setForeground(this.checkValid() ? this.pss.getValueColor() : Color.red);
    }

    private void filterRadioActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
        this.checkValid();
        this.updateFilteringControlStates();
    }

    private void regExpRadioActionPerformed(ActionEvent actionEvent) {
        this.updateValue();
        this.checkValid();
        this.updateFilteringControlStates();
    }

    public FilterEditor() {
        this.initComponents();
        this.localize();
        this.model = new DefaultComboBoxModel();
        this.model.addElement(JarContent.DEFAULT);
        this.model.addElement(JarContent.CLASSES_ONLY);
        this.model.addElement(JarContent.ALL);
        this.filtersComboBox.setModel(this.model);
        this.setValue(JarContent.DEFAULT);
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$FilterEditor == null ? (class$org$netbeans$modules$jarpackager$FilterEditor = FilterEditor.class$("org.netbeans.modules.jarpackager.FilterEditor")) : class$org$netbeans$modules$jarpackager$FilterEditor).getName());
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("CTL_FilterTip"));
    }

    public boolean isValid() {
        return this.isValid;
    }

    private boolean checkValid() {
        boolean bl = true;
        if (this.regExpRadio.isSelected()) {
            bl = REFilter.checkRegExp(this.regExpTextField.getText());
        }
        if (bl != this.isValid) {
            this.isValid = bl;
            this.support().firePropertyChange("propertyValueValid", !this.isValid, this.isValid);
        }
        return this.isValid;
    }

    private void localize() {
        this.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(Color.white, new Color(134, 134, 134)), NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$FilterEditor == null ? (class$org$netbeans$modules$jarpackager$FilterEditor = FilterEditor.class$("org.netbeans.modules.jarpackager.FilterEditor")) : class$org$netbeans$modules$jarpackager$FilterEditor)).getString("CTL_FilterEditor")), new EmptyBorder(new Insets(0, 8, 7, 8))));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.filterRadio);
        buttonGroup.add(this.regExpRadio);
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String[] getTags() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support().addPropertyChangeListener(propertyChangeListener);
    }

    public void setValue(Object object) {
        this.doSetValue(object);
        this.updateGui(object);
    }

    public Object getValue() {
        return this.value;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        if (this.value instanceof REFilter) {
            return ((REFilter)this.value).getSummary();
        }
        return this.value.toString();
    }

    public void addFilter(FileObjectFilter fileObjectFilter) {
        this.model.addElement(fileObjectFilter);
    }

    public void removeFilter(FileObjectFilter fileObjectFilter) {
        this.model.removeElement(fileObjectFilter);
    }

    void doSetValue(Object object) {
        if (this.model.getIndexOf(object) < 0 && !(object instanceof REFilter)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.value = (FileObjectFilter)object;
        this.support().firePropertyChange("", null, null);
    }

    private PropertyChangeSupport support() {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        return this.support;
    }

    void updateFilteringControlStates() {
        boolean bl = this.regExpRadio.isSelected();
        this.regExpTextField.setEnabled(bl);
        this.negativeCheckBox.setEnabled(bl);
        this.filtersComboBox.setEnabled(this.filterRadio.isSelected() && this.model.getSize() > 0);
    }

    void updateValue() {
        boolean bl = this.regExpRadio.isSelected();
        FileObjectFilter fileObjectFilter = null;
        if (bl) {
            String string = this.regExpTextField.getText();
            try {
                fileObjectFilter = new REFilter(string);
                ((REFilter)fileObjectFilter).setNegative(this.negativeCheckBox.isSelected());
            }
            catch (RESyntaxException rESyntaxException) {
                return;
            }
        } else {
            fileObjectFilter = (FileObjectFilter)this.model.getSelectedItem();
        }
        this.doSetValue(fileObjectFilter);
    }

    void updateGui(Object object) {
        boolean bl = object instanceof REFilter;
        this.regExpRadio.setSelected(bl);
        this.filterRadio.setSelected(!bl);
        this.filtersComboBox.setEnabled(!bl);
        this.regExpTextField.setEnabled(bl);
        this.negativeCheckBox.setEnabled(bl);
        if (bl) {
            REFilter rEFilter = (REFilter)object;
            this.regExpTextField.setText(rEFilter.toString());
            this.negativeCheckBox.setSelected(rEFilter.isNegative());
        } else {
            this.model.setSelectedItem(object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

