/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.jarpackager.DataObjectListEditor;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarContentChildren;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.util.BadgeIconCache;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.ExecSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class JarChildren
extends Children.Keys {
    private JarDataObject recipe;
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarPackagerModule == null ? (class$org$netbeans$modules$jarpackager$JarPackagerModule = JarChildren.class$("org.netbeans.modules.jarpackager.JarPackagerModule")) : class$org$netbeans$modules$jarpackager$JarPackagerModule));
    public Object GENERATEJAR_KEY = new Object();
    public Object CONTENTS_KEY = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarPackagerModule;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$MountJarAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject$JarNode;
    static /* synthetic */ Class class$org$openide$loaders$ExecSupport;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarContent;

    public JarChildren(JarDataObject jarDataObject) {
        this.recipe = jarDataObject;
    }

    private void refreshKeys() {
        this.setKeys(new Object[]{this.GENERATEJAR_KEY, this.CONTENTS_KEY});
    }

    protected void addNotify() {
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(new ArrayList());
    }

    protected Node[] createNodes(Object object) {
        if (object == this.GENERATEJAR_KEY) {
            return new Node[]{new GeneratedJarNode(this.recipe)};
        }
        if (object == this.CONTENTS_KEY) {
            return new Node[]{new RecipeContentsNode(this.recipe)};
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RecipeContentsNode
    extends AbstractNode
    implements PropertyChangeListener {
        private JarDataObject recipe;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/content";
        private static final String BADGE_DATAOBJECT_INVALID = "org/netbeans/modules/jarpackager/resources/dataobject-invalid";
        private static final int BADGE_DATAOBJECT_INVALID_KEY = 1;
        private static BadgeIconCache badgeCache;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RecipeContentsNode(JarDataObject jarDataObject) {
            super((Children)new JarContentChildren(jarDataObject));
            this.recipe = jarDataObject;
            super.setName(bundle.getString("PROP_Contents"));
            this.setIconBase(JAR_ICON_BASE);
            Class clazz = class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarChildren$RecipeContentsNode")) : class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode;
            synchronized (clazz) {
                if (badgeCache == null) {
                    this.loadBadges();
                }
            }
            this.recipe.addPropertyChangeListener(this);
        }

        protected int loadBadges() {
            badgeCache = new BadgeIconCache(JAR_ICON_BASE);
            badgeCache.registerBadge(BADGE_DATAOBJECT_INVALID, 1, 16, 8);
            return 4;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            int n2 = 0;
            if (!this.recipe.allValid()) {
                n2 |= 1;
            }
            Image image2 = badgeCache.getIcon(image, n2);
            return image2;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public SystemAction[] getActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = JarChildren.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarChildren.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public boolean canDestroy() {
            return false;
        }

        public final boolean canCopy() {
            return false;
        }

        public final boolean canCut() {
            return false;
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            Node[] nodeArray;
            Node[] nodeArray2 = NodeTransfer.nodes((Transferable)transferable, (int)1);
            if (nodeArray2 != null) {
                list.add(new PasteType(this, nodeArray2){
                    private final /* synthetic */ Node[] val$ns;
                    private final /* synthetic */ RecipeContentsNode this$0;
                    {
                        this.this$0 = recipeContentsNode;
                        this.val$ns = nodeArray;
                    }

                    public Transferable paste() throws IOException {
                        Node[] nodeArray = new Node[this.val$ns.length];
                        int n = 0;
                        while (n < nodeArray.length) {
                            if (this.val$ns[n] instanceof DataNode) {
                                RecipeContentsNode.access$400(this.this$0).getJarContent().addDataObject(((DataNode)this.val$ns[n]).getDataObject());
                            } else if (this.val$ns[n] instanceof JarContentChildren.ContentMemberNode) {
                                RecipeContentsNode.access$400(this.this$0).getJarContent().addDataObject(((JarContentChildren.ContentMemberNode)this.val$ns[n]).getDataObject());
                            }
                            ++n;
                        }
                        RecipeContentsNode.access$501(this.this$0, "contents", null, null);
                        RecipeContentsNode.access$400(this.this$0).setModified(true, "contents");
                        return null;
                    }
                });
            }
            if ((nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)6)) != null) {
                list.add(new PasteType(this, nodeArray){
                    private final /* synthetic */ Node[] val$nds;
                    private final /* synthetic */ RecipeContentsNode this$0;
                    {
                        this.this$0 = recipeContentsNode;
                        this.val$nds = nodeArray;
                    }

                    public Transferable paste() throws IOException {
                        int n = 0;
                        while (n < this.val$nds.length) {
                            if (this.val$nds[n] instanceof JarContentChildren.ContentMemberNode) {
                                RecipeContentsNode.access$400(this.this$0).getJarContent().addDataObject(((JarContentChildren.ContentMemberNode)this.val$nds[n]).getDataObject());
                                this.val$nds[n].destroy();
                            }
                            ++n;
                        }
                        RecipeContentsNode.access$400(this.this$0).setModified(true, "contents");
                        return null;
                    }
                });
            }
            super.createPasteTypes(transferable, list);
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            sheet.get("properties").put(this.createContentsProperty());
            return sheet;
        }

        public Node.Property createContentsProperty() {
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, "contents", class$org$netbeans$modules$jarpackager$JarContent == null ? (class$org$netbeans$modules$jarpackager$JarContent = JarChildren.class$("org.netbeans.modules.jarpackager.JarContent")) : class$org$netbeans$modules$jarpackager$JarContent, bundle.getString("PROP_Contents"), bundle.getString("CTL_ContentsTip")){
                private final /* synthetic */ RecipeContentsNode this$0;
                {
                    this.this$0 = recipeContentsNode;
                }

                public Object getValue() {
                    return RecipeContentsNode.access$400(this.this$0).getJarContent().makeCopy();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof JarContent)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        RecipeContentsNode.access$400(this.this$0).getJarContent().setContentList(((JarContent)object).getContentList());
                        RecipeContentsNode.access$601(this.this$0, "contents", null, null);
                        RecipeContentsNode.access$400(this.this$0).setModified(true, "contents");
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new DataObjectListEditor();
                }
            };
            readWrite.setValue("canEditAsText", (Object)Boolean.FALSE);
            return readWrite;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarChildren$RecipeContentsNode")) : class$org$netbeans$modules$jarpackager$JarChildren$RecipeContentsNode);
        }

        static /* synthetic */ JarDataObject access$400(RecipeContentsNode recipeContentsNode) {
            return recipeContentsNode.recipe;
        }

        static /* synthetic */ void access$501(RecipeContentsNode recipeContentsNode, String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        static /* synthetic */ void access$601(RecipeContentsNode recipeContentsNode, String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public static class GeneratedJarNode
    extends AbstractNode
    implements PropertyChangeListener,
    NodeTransfer.Paste {
        private JarDataObject recipe;
        private static final String ICON_BASE = "org/netbeans/modules/jarpackager/resources/";
        private static final String JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/jar";
        private static final String GREY_JAR_ICON_BASE = "org/netbeans/modules/jarpackager/resources/greyjar";
        private boolean fileExists;
        private IconRefresher refresher;

        public GeneratedJarNode(JarDataObject jarDataObject) {
            super(Children.LEAF);
            this.recipe = jarDataObject;
            this.refresher = new IconRefresher(this);
            this.setIcon(true);
            if (this.recipe != null) {
                if (this.recipe.getJarContent() != null && this.recipe.getJarContent().getTargetFile() != null) {
                    this.setName(this.recipe.getJarContent().getTargetFile().toString());
                } else {
                    this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarChildren$GeneratedJarNode")) : class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode)).getString("GeneratedJarNode.defaultName"));
                }
                this.recipe.addPropertyChangeListener(this);
                this.getCookieSet().add((Node.Cookie)this.recipe);
                this.getCookieSet().add((Node.Cookie)new JarDataObject.JarExecSupport(this.recipe.getPrimaryEntry()));
            }
        }

        public SystemAction[] getActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = JarChildren.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = JarChildren.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$MountJarAction == null ? (class$org$netbeans$modules$jarpackager$actions$MountJarAction = JarChildren.class$("org.netbeans.modules.jarpackager.actions.MountJarAction")) : class$org$netbeans$modules$jarpackager$actions$MountJarAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarChildren.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setDisplayName(this.recipe.getJarContent().getTarget());
            this.setIcon(false);
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            PropertySupport.ReadWrite readWrite = (PropertySupport.ReadWrite)this.createLocationProperty();
            readWrite.setValue("files", (Object)Boolean.TRUE);
            readWrite.setValue("directories", (Object)Boolean.FALSE);
            sheet.get("properties").put((Node.Property)readWrite);
            Sheet.Set set = new Sheet.Set();
            set.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarChildren.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject)).getString("CTL_ExecutionSet"));
            set.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("PROP_executionSetName"));
            set.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataObject$JarNode == null ? (class$org$netbeans$modules$jarpackager$JarDataObject$JarNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarDataObject$JarNode")) : class$org$netbeans$modules$jarpackager$JarDataObject$JarNode)).getString("HINT_executionSetName"));
            ExecSupport execSupport = (ExecSupport)this.getCookie(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = JarChildren.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport);
            if (execSupport != null) {
                execSupport.addProperties(set);
                set.remove("debuggerType");
            }
            sheet.put(set);
            return sheet;
        }

        public Node.Property createLocationProperty() {
            return new PropertySupport.ReadWrite(this, "location", class$java$io$File == null ? (class$java$io$File = JarChildren.class$("java.io.File")) : class$java$io$File, bundle.getString("PROP_Location"), bundle.getString("CTL_LocationTip")){
                private final /* synthetic */ GeneratedJarNode this$0;
                {
                    this.this$0 = generatedJarNode;
                }

                public Object getValue() {
                    return GeneratedJarNode.access$100(this.this$0).getJarContent().getTargetFile();
                }

                public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    if (!(object instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        JarContent jarContent = GeneratedJarNode.access$100(this.this$0).getJarContent();
                        jarContent.setTargetFile((File)object);
                        GeneratedJarNode.access$100(this.this$0).setModified(true, "location");
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException();
                    }
                }
            };
        }

        public final boolean canCopy() {
            this.setIcon(false);
            return this.fileExists;
        }

        boolean checkFile() {
            boolean bl;
            try {
                bl = this.recipe.getJarContent().getTargetFile().exists();
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
            return bl;
        }

        public Image getIcon(int n) {
            return super.getIcon(n);
        }

        synchronized void setIcon(boolean bl) {
            boolean bl2 = this.fileExists;
            this.fileExists = this.checkFile();
            if (bl || this.fileExists != bl2) {
                this.setIconBase(this.fileExists ? JAR_ICON_BASE : GREY_JAR_ICON_BASE);
            }
        }

        public Transferable clipboardCopy() throws IOException {
            return NodeTransfer.createPaste((NodeTransfer.Paste)this);
        }

        public PasteType[] types(Node node) {
            if (node instanceof DataNode) {
                FileObject fileObject = ((DataNode)node).getDataObject().getPrimaryFile();
                File file = this.recipe.getJarContent().getTargetFile();
                if (fileObject != null && fileObject.isFolder() && file.exists()) {
                    return new PasteType[]{new GeneratedJarPasteType(file, fileObject)};
                }
            }
            return new PasteType[0];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode == null ? (class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode = JarChildren.class$("org.netbeans.modules.jarpackager.JarChildren$GeneratedJarNode")) : class$org$netbeans$modules$jarpackager$JarChildren$GeneratedJarNode);
        }

        static /* synthetic */ JarDataObject access$100(GeneratedJarNode generatedJarNode) {
            return generatedJarNode.recipe;
        }

        static class IconRefresher
        implements Runnable {
            private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.LocalFileSystem.REFRESH_TIME", 15000);
            private WeakReference nodeRef;

            IconRefresher(GeneratedJarNode generatedJarNode) {
                if (REFRESH_TIME > 0) {
                    this.nodeRef = new WeakReference<GeneratedJarNode>(generatedJarNode);
                    this.schedule();
                }
            }

            private void schedule() {
                RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)this, (int)REFRESH_TIME);
            }

            public void run() {
                GeneratedJarNode generatedJarNode = (GeneratedJarNode)this.nodeRef.get();
                if (generatedJarNode != null) {
                    generatedJarNode.setIcon(false);
                    this.schedule();
                }
            }
        }

        public static class GeneratedJarPasteType
        extends PasteType {
            private File generatedJar;
            private FileObject target;

            public GeneratedJarPasteType(File file, FileObject fileObject) {
                this.generatedJar = file;
                this.target = fileObject;
            }

            public Transferable paste() {
                try {
                    FileSystem fileSystem = this.target.getFileSystem();
                    fileSystem.runAtomicAction(new FileSystem.AtomicAction(this){
                        private final /* synthetic */ GeneratedJarPasteType this$0;
                        {
                            this.this$0 = generatedJarPasteType;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() throws IOException {
                            FileLock fileLock = null;
                            try {
                                try {
                                    FileInputStream fileInputStream = new FileInputStream(GeneratedJarPasteType.access$200(this.this$0));
                                    FileObject fileObject = FileUtil.createData((FileObject)GeneratedJarPasteType.access$300(this.this$0), (String)GeneratedJarPasteType.access$200(this.this$0).getName());
                                    fileLock = fileObject.lock();
                                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                                    FileUtil.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                                    fileLock.releaseLock();
                                }
                                catch (IOException iOException) {
                                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
                                    Object var6_7 = null;
                                    if (fileLock == null) return;
                                    fileLock.releaseLock();
                                    return;
                                }
                                Object var6_6 = null;
                                if (fileLock == null) return;
                            }
                            catch (Throwable throwable) {
                                Object var6_8 = null;
                                if (fileLock == null) throw throwable;
                                fileLock.releaseLock();
                                throw throwable;
                            }
                            fileLock.releaseLock();
                        }
                    });
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
                }
                return null;
            }

            public String getName() {
                return "Jar File";
            }

            static /* synthetic */ File access$200(GeneratedJarPasteType generatedJarPasteType) {
                return generatedJarPasteType.generatedJar;
            }

            static /* synthetic */ FileObject access$300(GeneratedJarPasteType generatedJarPasteType) {
                return generatedJarPasteType.target;
            }
        }
    }
}

