/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.JarPackagerModule;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public class JarDataLoader
extends MultiFileLoader {
    private static final long serialVersionUID = 7727866549739434470L;
    public static final String JAR_EXTENSION = "jar";
    public static final String CONTENT_EXTENSION = "jarContent";
    private String extension;
    private String archiveExt;
    static /* synthetic */ Class class$org$openide$actions$SaveAction;
    static /* synthetic */ Class class$org$openide$actions$CompileAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$MountJarAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataLoader;

    public JarDataLoader() {
        this("org.netbeans.modules.jarpackager.JarDataObject");
    }

    public JarDataLoader(String string) {
        super(string);
    }

    public JarDataLoader(Class clazz) {
        super(clazz);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$SaveAction == null ? (class$org$openide$actions$SaveAction = JarDataLoader.class$("org.openide.actions.SaveAction")) : class$org$openide$actions$SaveAction)), null, SystemAction.get((Class)(class$org$openide$actions$CompileAction == null ? (class$org$openide$actions$CompileAction = JarDataLoader.class$("org.openide.actions.CompileAction")) : class$org$openide$actions$CompileAction)), SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = JarDataLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = JarDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$MountJarAction == null ? (class$org$netbeans$modules$jarpackager$actions$MountJarAction = JarDataLoader.class$("org.netbeans.modules.jarpackager.actions.MountJarAction")) : class$org$netbeans$modules$jarpackager$actions$MountJarAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction == null ? (class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction = JarDataLoader.class$("org.netbeans.modules.jarpackager.actions.RefreshJarContentAction")) : class$org$netbeans$modules$jarpackager$actions$RefreshJarContentAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = JarDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = JarDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = JarDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = JarDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = JarDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = JarDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = JarDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = JarDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataLoader.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString("PROP_JarLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws IOException {
        return new JarDataObject(fileObject, this);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
            if (objectInput.available() > 0) {
                this.extension = objectInput.readUTF();
                this.archiveExt = objectInput.readUTF();
            }
        }
        catch (SafeException safeException) {
            String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataLoader.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString("MSG_ResetDataActions");
            JarPackagerModule.err.annotate((Throwable)safeException, 1, string, null, null, null);
            JarPackagerModule.err.notify(1, (Throwable)safeException);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.getExtension());
        objectOutput.writeUTF(this.getArchiveExt());
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        String string = fileObject.getExt();
        String string2 = this.getExtension();
        if (string2.equals(string)) {
            return fileObject;
        }
        if (this.getArchiveExt().equals(string)) {
            return FileUtil.findBrother((FileObject)fileObject, (String)string2);
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        fileObject.setImportant(true);
        return new JarContentEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new JarFileEntry(multiDataObject, fileObject);
    }

    public String getExtension() {
        if (this.extension == null) {
            this.extension = CONTENT_EXTENSION;
        }
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getArchiveExt() {
        if (this.archiveExt == null) {
            this.archiveExt = JAR_EXTENSION;
        }
        return this.archiveExt;
    }

    public void setArchiveExt(String string) {
        this.archiveExt = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class JarFileEntry
    extends FileEntry {
        public JarFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public void delete() throws IOException {
            try {
                super.delete();
            }
            catch (IOException iOException) {
                File file = NbClassPath.toFile((FileObject)this.getFile());
                String string = JarUtils.getMountedJarFS(file) != null ? "FMT_JarFileMounted" : (this.isLocked() ? "FMT_JarFileLocked" : "FMT_CantDeleteJarFile");
                String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarDataLoader == null ? (class$org$netbeans$modules$jarpackager$JarDataLoader = JarDataLoader.class$("org.netbeans.modules.jarpackager.JarDataLoader")) : class$org$netbeans$modules$jarpackager$JarDataLoader)).getString(string);
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.annotate((Throwable)iOException, MessageFormat.format(string2, file.getPath()));
                throw iOException;
            }
        }
    }

    private static final class JarContentEntry
    extends FileEntry {
        public JarContentEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public FileObject rename(String string) throws IOException {
            JarDataObject jarDataObject = (JarDataObject)this.getDataObject();
            boolean bl = jarDataObject.usesDefaultArchiveFile();
            if (jarDataObject.isModified()) {
                jarDataObject.save();
            }
            FileObject fileObject = super.rename(string);
            if (bl) {
                this.syncTargetFileField(jarDataObject.getJarContent(), fileObject);
            }
            return fileObject;
        }

        public FileObject copy(FileObject fileObject, String string) throws IOException {
            JarDataObject jarDataObject = (JarDataObject)this.getDataObject();
            boolean bl = jarDataObject.usesDefaultArchiveFile();
            if (jarDataObject.isModified()) {
                jarDataObject.save();
            }
            FileObject fileObject2 = super.copy(fileObject, string);
            if (bl) {
                this.syncTargetFileField(jarDataObject.getJarContent().makeCopy(), fileObject2);
            }
            return fileObject2;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            JarDataObject jarDataObject = (JarDataObject)this.getDataObject();
            boolean bl = jarDataObject.usesDefaultArchiveFile();
            if (jarDataObject.isModified()) {
                jarDataObject.save();
            }
            FileObject fileObject2 = super.move(fileObject, string);
            if (bl) {
                this.syncTargetFileField(jarDataObject.getJarContent(), fileObject2);
            }
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            FileLock fileLock;
            FileObject fileObject2;
            block5: {
                File file;
                fileObject2 = super.createFromTemplate(fileObject, string);
                JarContent jarContent = JarContent.readFromFile(this.getFile());
                if (jarContent == null) {
                    jarContent = new JarContent();
                }
                if ((file = JarDataObject.defaultArchiveFile(NbClassPath.toFile((FileObject)fileObject2), this.getArchiveExtension())) != null) {
                    jarContent.setTargetFile(file);
                }
                fileLock = fileObject2.lock();
                ObjectOutputStream objectOutputStream = null;
                try {
                    objectOutputStream = new ObjectOutputStream(fileObject2.getOutputStream(fileLock));
                    jarContent.writeContent(objectOutputStream, fileObject2);
                    Object var9_8 = null;
                    if (objectOutputStream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    fileLock.releaseLock();
                    throw throwable;
                }
                objectOutputStream.close();
            }
            fileLock.releaseLock();
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void syncTargetFileField(JarContent jarContent, FileObject fileObject) throws IOException {
            String string = ((JarDataLoader)this.getDataObject().getLoader()).getArchiveExt();
            File file = NbClassPath.toFile((FileObject)fileObject);
            if (file != null) {
                FileLock fileLock;
                block4: {
                    File file2 = new File(file.getParentFile(), fileObject.getName() + "." + string);
                    jarContent.setTargetFile(file2);
                    fileLock = fileObject.lock();
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        objectOutputStream = new ObjectOutputStream(fileObject.getOutputStream(fileLock));
                        jarContent.writeContent(objectOutputStream, fileObject);
                        Object var9_8 = null;
                        if (objectOutputStream == null) break block4;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        fileLock.releaseLock();
                        throw throwable;
                    }
                    objectOutputStream.close();
                }
                fileLock.releaseLock();
                {
                }
            }
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Name", string);
            MapFormat mapFormat = new MapFormat(hashMap);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            mapFormat.setExactMatch(false);
            return mapFormat;
        }

        private String getContentExtension() {
            String string = JarDataLoader.CONTENT_EXTENSION;
            DataLoader dataLoader = this.getDataObject().getLoader();
            if (dataLoader instanceof JarDataLoader) {
                string = ((JarDataLoader)dataLoader).extension;
            }
            return string;
        }

        private String getArchiveExtension() {
            String string = JarDataLoader.JAR_EXTENSION;
            DataLoader dataLoader = this.getDataObject().getLoader();
            if (dataLoader instanceof JarDataLoader) {
                string = ((JarDataLoader)dataLoader).archiveExt;
            }
            return string;
        }
    }
}

