/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ui;

import java.beans.FeatureDescriptor;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ServerRegistryNode
extends AbstractNode {
    static final String REGISTRY_ICON_BASE = "org/netbeans/modules/j2ee/ui/resources/ServerRegistry";
    static final String INSTALLED_ICON_BASE = "org/netbeans/modules/j2ee/ui/resources/InstalledServers";
    static final String DEFAULT_ICON_BASE = "org/netbeans/modules/j2ee/ui/resources/DefaultServers";
    static final String APP_ICON_BASE = "org/netbeans/modules/j2ee/ui/resources/J2EEServer16";
    static final String WEB_ICON_BASE = "org/netbeans/modules/j2ee/ui/resources/WebApplicationServer";
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$j2ee$ui$ServerRegistryNode == null ? (class$org$netbeans$modules$j2ee$ui$ServerRegistryNode = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.ServerRegistryNode")) : class$org$netbeans$modules$j2ee$ui$ServerRegistryNode));
    private transient ServerChildren appChildren;
    private transient ServerChildren webChildren;
    private transient ServerChildren allChildren;
    private transient AbstractNode webNode;
    private transient AbstractNode appNode;
    private transient AbstractNode allNode;
    private transient ServerDefaultNode webDefaultNode;
    private transient ServerDefaultNode appDefaultNode;
    private transient ServerRegistryImpl.ServerRegistryListener listener;
    private Set keys = new HashSet();
    private Node[] nodes = null;
    private HelpCtx helpCtx;
    static final Object childkey = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$ServerRegistryNode;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$actions$SetDefaultWebServerAction;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$actions$SetDefaultAppServerAction;

    public ServerRegistryNode() {
        super((Children)new RegistryChildren());
        RegistryChildren registryChildren = (RegistryChildren)this.getChildren();
        registryChildren.setSRN(this);
        this.setDisplayName(bundle.getString("SERVER_REGISTRY_NODE_NAME"));
        this.setName("");
        this.setIconBase(REGISTRY_ICON_BASE);
    }

    synchronized Node[] createKeyNodes() {
        if (this.nodes != null) {
            return this.nodes;
        }
        try {
            this.appChildren = new ServerChildren(true, false);
            this.allChildren = new ServerChildren(true, true);
            this.webChildren = new ServerChildren(false, true);
            this.webNode = new ServerDisplayNode("WEBSERVER_REGISTRY_NODE", (Children)this.webChildren);
            this.webNode.setIconBase(WEB_ICON_BASE);
            this.appNode = new ServerDisplayNode("APPSERVER_REGISTRY_NODE", (Children)this.appChildren);
            this.appNode.setIconBase(APP_ICON_BASE);
            this.allNode = new ServerDisplayNode("INSTALLED_SERVERS_NODE_NAME", (Children)this.allChildren, "nodes_installed_servers_node_html");
            this.allNode.setIconBase(INSTALLED_ICON_BASE);
            Children.Array array = new Children.Array();
            ServerDisplayNode serverDisplayNode = new ServerDisplayNode("DEFAULT_SERVERS_NODE_NAME", (Children)array, "nodes_default_servers_node_html");
            serverDisplayNode.setIconBase(DEFAULT_ICON_BASE);
            this.webDefaultNode = new ServerDefaultNode("WEB_DEFAULT_NODE_NAME", "nodes_web_applications_defsrv_node_html");
            this.webDefaultNode.setIconBase(WEB_ICON_BASE);
            this.appDefaultNode = new ServerDefaultNode("APP_DEFAULT_NODE_NAME", "nodes_j2ee_applications_defsrv_node_html");
            this.appDefaultNode.setIconBase(APP_ICON_BASE);
            array.add(new Node[]{this.appDefaultNode, this.webDefaultNode});
            this.webDefaultNode.setActions(new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$SetDefaultWebServerAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$SetDefaultWebServerAction = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.actions.SetDefaultWebServerAction")) : class$org$netbeans$modules$j2ee$ui$actions$SetDefaultWebServerAction)), SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.actions.NodeHelpAction")) : class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction))});
            this.webDefaultNode.setInstance(ServerRegistryImpl.getRegistry().getDefaultWebInstance());
            this.appDefaultNode.setActions(new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$SetDefaultAppServerAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$SetDefaultAppServerAction = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.actions.SetDefaultAppServerAction")) : class$org$netbeans$modules$j2ee$ui$actions$SetDefaultAppServerAction)), SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.actions.NodeHelpAction")) : class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction))});
            this.appDefaultNode.setInstance(ServerRegistryImpl.getRegistry().getDefaultAppInstance());
            this.listener = new ServerRegistryImpl.ServerRegistryListener(){

                public void setAppDefault(ServerRegistryImpl.InstanceEvent instanceEvent) {
                    ServerRegistryNode.this.fireAppDefault(instanceEvent.getInstance());
                }

                public void setWebDefault(ServerRegistryImpl.InstanceEvent instanceEvent) {
                    ServerRegistryNode.this.fireWebDefault(instanceEvent.getInstance());
                }

                public void added(ServerRegistryImpl.ServerEvent serverEvent) {
                    ServerRegistryNode.this.add(serverEvent.getServer());
                }

                public void removed(ServerRegistryImpl.ServerEvent serverEvent) {
                    ServerRegistryNode.this.remove(serverEvent.getServer());
                }
            };
            Server[] serverArray = ServerRegistryImpl.getRegistry().getServers(this.listener);
            int n = 0;
            while (n < serverArray.length) {
                this.add(serverArray[n]);
                ++n;
            }
            this.nodes = new Node[]{serverDisplayNode, this.allNode};
            return this.nodes;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void fireAppDefault(ServerInstance serverInstance) {
        this.appDefaultNode.setInstance(serverInstance);
    }

    private void fireWebDefault(ServerInstance serverInstance) {
        this.webDefaultNode.setInstance(serverInstance);
    }

    private void updateKeys() {
        this.webChildren.updateKeys();
        this.allChildren.updateKeys();
        this.appChildren.updateKeys();
    }

    private void add(Server server) {
        this.keys.add(server);
        this.updateKeys();
    }

    public void remove(Server server) {
        this.keys.remove(server);
        this.updateKeys();
    }

    Node getWebNode() {
        this.createKeyNodes();
        return this.webNode;
    }

    Node getAppNode() {
        this.createKeyNodes();
        return this.appNode;
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction = ServerRegistryNode.class$("org.netbeans.modules.j2ee.ui.actions.NodeHelpAction")) : class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction))};
    }

    public HelpCtx getHelpCtx() {
        if (this.helpCtx == null) {
            this.helpCtx = new HelpCtx("nodes_server_registry_node_html");
        }
        return this.helpCtx;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class RegistryChildren
    extends Children.Keys {
        ServerRegistryNode node = null;

        RegistryChildren() {
        }

        void setSRN(ServerRegistryNode serverRegistryNode) {
            this.node = serverRegistryNode;
        }

        protected void addNotify() {
            this.setKeys(new Object[]{childkey});
        }

        public Node[] createNodes(Object object) {
            if (object == childkey) {
                return this.node.createKeyNodes();
            }
            return null;
        }
    }

    class ServerDisplayNode
    extends AbstractNode {
        private HelpCtx helpCtx;
        private String helpId;
        static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction;

        ServerDisplayNode(String string, Children children) {
            this(string, children, null);
        }

        ServerDisplayNode(String string, Children children, String string2) {
            super(children);
            this.setName(string);
            this.setDisplayName(bundle.getString(string));
            this.helpId = string2;
        }

        public HelpCtx getHelpCtx() {
            if (this.helpCtx == null && this.helpId != null) {
                this.helpCtx = new HelpCtx(this.helpId);
            }
            return this.helpCtx;
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction == null ? (class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction = ServerDisplayNode.class$("org.netbeans.modules.j2ee.ui.actions.NodeHelpAction")) : class$org$netbeans$modules$j2ee$ui$actions$NodeHelpAction))};
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ServerDefaultNode
    extends AbstractNode {
        private HelpCtx helpCtx;
        private String helpId;
        static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$ServerRegistryNode;

        ServerDefaultNode(String string) {
            this(string, null);
        }

        ServerDefaultNode(String string, String string2) {
            super(Children.LEAF);
            this.setName(string);
            this.setInstance(null);
            this.helpId = string2;
        }

        public void setActions(SystemAction[] systemActionArray) {
            this.systemActions = systemActionArray;
        }

        public void setInstance(ServerInstance serverInstance) {
            String string = bundle.getString("SERVER_NO_DEFAULT");
            if (serverInstance != null) {
                string = serverInstance.getDisplayName();
            }
            this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerRegistryNode == null ? (class$org$netbeans$modules$j2ee$ui$ServerRegistryNode = ServerDefaultNode.class$("org.netbeans.modules.j2ee.ui.ServerRegistryNode")) : class$org$netbeans$modules$j2ee$ui$ServerRegistryNode), (String)((FeatureDescriptor)((Object)this)).getName(), (Object)string));
        }

        public HelpCtx getHelpCtx() {
            if (this.helpCtx == null && this.helpId != null) {
                this.helpCtx = new HelpCtx(this.helpId);
            }
            return this.helpCtx;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ServerChildren
    extends Children.Keys {
        private final boolean app;
        private final boolean web;

        public ServerChildren(boolean bl, boolean bl2) {
            this.app = bl;
            this.web = bl2;
            this.updateKeys();
        }

        public void updateKeys() {
            this.setKeys(ServerRegistryNode.this.keys);
        }

        protected Node[] createNodes(Object object) {
            Server server = (Server)object;
            if (this.app & server.supportsEarFiles()) {
                return new Node[]{new FilterNode(server.getNode())};
            }
            if (this.web & server.supportsWarFiles()) {
                return new Node[]{new FilterNode(server.getNode())};
            }
            return new Node[0];
        }
    }
}

