/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class DelegatingFileSystem
extends MultiFileSystem
implements FileSystem.Status,
FileStatusListener {
    static final long serialVersionUID = 3521863383479243345L;
    protected String rootFolder;
    protected transient FileSystem delegateeFs;
    private transient PropertyChangeListener pcl;
    private transient boolean removable = false;
    static /* synthetic */ Class class$org$openide$filesystems$FileStatusEvent;

    public DelegatingFileSystem(FileObject fileObject) throws IOException {
        this(fileObject.getFileSystem(), fileObject.getPackageName('/'));
    }

    public DelegatingFileSystem(FileSystem fileSystem, String string) throws IOException {
        super(new FileSystem[]{fileSystem});
        this.rootFolder = string;
        this.init();
    }

    private void init() throws IOException {
        this.delegateeFs = this.createWritableOn("");
        try {
            this.setSystemName(this.computeSystemName());
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        if (this.delegateeFs != null) {
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                        try {
                            DelegatingFileSystem.this.setCorrectName();
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            propertyVetoException.printStackTrace();
                        }
                    }
                }
            };
            this.delegateeFs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.pcl, (Object)((Object)this)));
            this.delegateeFs.addFileStatusListener((FileStatusListener)this);
        }
    }

    public void prepareEnvironment(final FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        if (this.delegateeFs != null) {
            this.delegateeFs.prepareEnvironment(new FileSystem.Environment(){

                public void addClassPath(String string) {
                    String string2 = string.endsWith(File.separator) ? string : string + File.separator;
                    string2 = string2 + DelegatingFileSystem.this.rootFolder.replace('/', File.separatorChar);
                    environment.addClassPath(string2);
                }
            });
        }
    }

    void setCorrectName() throws PropertyVetoException {
        this.setSystemName(this.computeSystemName());
    }

    protected String computeSystemName() {
        return this.delegateeFs.getSystemName() + ":" + this.rootFolder;
    }

    public String getDisplayName() {
        return this.delegateeFs == null ? super.getDisplayName() : this.delegateeFs.getDisplayName() + " : /" + this.rootFolder;
    }

    public SystemAction[] getActions(Set set) {
        return this.delegateeFs.getActions(this.translateFiles(set, false));
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        return fileSystem.findResource(this.rootFolder + "/" + string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public boolean correspondsTo(FileSystem fileSystem) {
        if (fileSystem instanceof DelegatingFileSystem) {
            return this.delegateeFs == ((DelegatingFileSystem)fileSystem).delegateeFs && this.rootFolder.equals(((DelegatingFileSystem)fileSystem).rootFolder);
        }
        if (fileSystem instanceof LocalFileSystem && this.delegateeFs instanceof LocalFileSystem) {
            File file = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            if (file == null) {
                return false;
            }
            FileObject fileObject = this.delegateeFs.find(this.rootFolder.replace('/', '.'), null, null);
            if (fileObject == null) {
                return false;
            }
            File file2 = NbClassPath.toFile((FileObject)fileObject);
            if (file2 == null) {
                return false;
            }
            return file.equals(file2);
        }
        return false;
    }

    public boolean delegatesTo(FileSystem fileSystem) {
        if (fileSystem instanceof LocalFileSystem && this.delegateeFs instanceof LocalFileSystem) {
            File file = NbClassPath.toFile((FileObject)fileSystem.getRoot());
            if (file == null) {
                return false;
            }
            return file.equals(NbClassPath.toFile((FileObject)this.delegateeFs.getRoot()));
        }
        return false;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String string, Set set) {
        return this.delegateeFs.getStatus().annotateName(string, this.translateFiles(set, false));
    }

    public Image annotateIcon(Image image, int n, Set set) {
        return this.delegateeFs.getStatus().annotateIcon(image, n, this.translateFiles(set, false));
    }

    protected Set translateFiles(Set set, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if ((fileObject = this.translateFile(fileObject, bl)) == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    protected FileObject translateFile(FileObject fileObject, boolean bl) {
        if (bl) {
            String string = fileObject.getPackageNameExt('/', '.');
            fileObject = null;
            if (string.startsWith(this.rootFolder)) {
                fileObject = "".equals(string = string.substring(this.rootFolder.length())) ? this.getRoot() : this.findResource(string.substring(1));
            }
        } else {
            fileObject = this.delegateeFs.findResource(this.rootFolder + '/' + fileObject.getPackageNameExt('/', '.'));
        }
        return fileObject;
    }

    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        try {
            Field field = (class$org$openide$filesystems$FileStatusEvent == null ? (class$org$openide$filesystems$FileStatusEvent = DelegatingFileSystem.class$("org.openide.filesystems.FileStatusEvent")) : class$org$openide$filesystems$FileStatusEvent).getDeclaredField("files");
            ((AccessibleObject)field).setAccessible(true);
            Set set = (Set)field.get(fileStatusEvent);
            this.fireFileStatusChanged(set == null ? new FileStatusEvent((FileSystem)this, fileStatusEvent.isIconChange(), fileStatusEvent.isNameChange()) : new FileStatusEvent((FileSystem)this, this.translateFiles(set, true), fileStatusEvent.isIconChange(), fileStatusEvent.isNameChange()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

