/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.context;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.impl.ServerExecSupport;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.web.context.DelegatingFileSystem;
import org.netbeans.modules.web.context.DelegatingFileSystemVcs;
import org.netbeans.modules.web.context.LibJarContentObject;
import org.netbeans.modules.web.context.LibJarObject;
import org.netbeans.modules.web.context.MountMessagePanel;
import org.netbeans.modules.web.context.PackageWar;
import org.netbeans.modules.web.context.WebContextEvent;
import org.netbeans.modules.web.context.WebContextListener;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.context.WebModuleCookie;
import org.netbeans.modules.web.core.ServletSettings;
import org.netbeans.modules.web.core.jsploader.ServletSupport;
import org.netbeans.modules.web.webdata.WebDataFactory;
import org.netbeans.modules.web.webdata.WebDataFactoryImpl;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.netbeans.modules.web.xmlutils.XMLJ2eeDataObject;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebContextObject
extends DataFolder
implements ServerRegistryImpl.ServerRegistryListener,
PropertyChangeListener {
    public static final String VCS_PROVIDER_ATTRIBUTE = "VCS Provider";
    public static final String PROP_DOCBASE = "documentBase";
    public static final String PROP_APPNAME = "appName";
    public static final String FOLDER_WEB_INF = "WEB-INF";
    public static final String FOLDER_CLASSES = "classes";
    public static final String FOLDER_LIB = "lib";
    public static final String SUFFIX_JAR = "jar";
    public static final String SUFFIX_JAR_CONTENT = "jarContent";
    private static final String ATTR_OLD_SERVER_INSTANCE_DATA = "ATTR_OLD_SERVER_INSTANCE_DATA";
    public static final String PROP_NEW_SERVER_INSTANCE = "PROP_NEW_SERVER_INSTANCE";
    private static final boolean debug = false;
    private static final boolean debugdetail = false;
    private transient FileSystem documentBase;
    private transient FileObject classesDir;
    private transient FileObject libDir;
    private transient String appName;
    private transient FileSystem classesFS;
    private transient Hashtable libs = new Hashtable();
    private transient WebModuleCookie cookie;
    private transient ServerExecSupport serverExecSupport;
    private static transient Set listenerSet;
    private static transient WebContextPackager packager;
    public static final String PROP_URI = "URI_CHANGE";
    private transient DataObject oldWebAppDataObject = null;
    private DataObject deploymentDescriptor;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerExecSupport;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebModuleCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$ServletSettings;
    static /* synthetic */ Class class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$core$jsploader$ServletDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;
    static /* synthetic */ Class class$org$netbeans$modules$web$context$WebContextObject;

    public WebContextObject(FileObject fileObject, DataLoader dataLoader) throws IOException {
        super(fileObject, dataLoader);
        this.documentBase = fileObject.getFileSystem();
        this.init();
    }

    private void init() throws IOException {
        WebContextObject.checkOrCreateWebContext(this.documentBase);
        this.mountClasses();
        this.mountAllLibs();
        this.addLibraryListener();
        this.addServerChangesListeners();
        this.addWebAppChangesListeners();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                WebContextObject.this.mkProjectView();
                WebContextObject.this.checkServlets();
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.disable();
    }

    public void disable() {
        this.removeProjectView();
        this.unmountFS();
        this.removeServerChangesListeners();
        this.removeWebAppChangesListeners();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$netbeans$modules$j2ee$impl$ServerExecSupport == null ? (class$org$netbeans$modules$j2ee$impl$ServerExecSupport = WebContextObject.class$("org.netbeans.modules.j2ee.impl.ServerExecSupport")) : class$org$netbeans$modules$j2ee$impl$ServerExecSupport)) {
            return this.getServerExecSupport();
        }
        if (clazz.isAssignableFrom(class$org$netbeans$modules$web$context$WebModuleCookie == null ? (class$org$netbeans$modules$web$context$WebModuleCookie = WebContextObject.class$("org.netbeans.modules.web.context.WebModuleCookie")) : class$org$netbeans$modules$web$context$WebModuleCookie)) {
            return this.getWebModuleCookie();
        }
        return super.getCookie(clazz);
    }

    private ServerExecSupport getServerExecSupport() {
        if (this.serverExecSupport == null) {
            this.serverExecSupport = new ServerExecSupport((DataObject)this);
            this.serverExecSupport.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.serverExecSupport;
    }

    public String getAppFileName() {
        return URLEncoder.encode(this.documentBase.getSystemName());
    }

    private FileObject getViewFile(DataFolder dataFolder) {
        if (dataFolder == null) {
            return null;
        }
        return dataFolder.getPrimaryFile().getFileObject(this.getAppFileName(), "warImage");
    }

    FileObject getProjectViewFileObject() {
        DataFolder dataFolder = (DataFolder)TopManager.getDefault().getPlaces().nodes().projectDesktop().getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = WebContextObject.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        FileObject fileObject = this.getViewFile(dataFolder);
        return fileObject;
    }

    private void removeProjectView() {
        final FileObject fileObject = this.getProjectViewFileObject();
        if (fileObject != null) {
            try {
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        try {
                            DataObject.find((FileObject)fileObject).delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeCorrespondingJarFromProjectView(FileObject fileObject) {
        try {
            String string;
            FileObject fileObject2;
            FileObject fileObject3;
            FileObject fileObject4 = this.getProjectViewFileObject();
            FileObject fileObject5 = fileObject4.getFileObject(FOLDER_WEB_INF, null);
            FileObject fileObject6 = fileObject3 = fileObject5 != null ? fileObject4.getFileObject(FOLDER_LIB, null) : null;
            if (fileObject3 != null && (fileObject2 = fileObject3.getFileObject(string = fileObject.getName(), SUFFIX_JAR)) != null) {
                DataObject.find((FileObject)fileObject2).delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mkProjectView() {
        try {
            ServletSettings servletSettings = (ServletSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$web$core$ServletSettings == null ? (class$org$netbeans$modules$web$core$ServletSettings = WebContextObject.class$("org.netbeans.modules.web.core.ServletSettings")) : class$org$netbeans$modules$web$core$ServletSettings));
            DataFolder dataFolder = (DataFolder)TopManager.getDefault().getPlaces().nodes().projectDesktop().getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = WebContextObject.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (this.handleCreateShadow(dataFolder) != null && servletSettings.getShowMessageDialog()) {
                this.showNotifyDialog();
            }
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        FileObject fileObject = this.getViewFile(dataFolder);
        if (fileObject == null) {
            return DataShadow.create((DataFolder)dataFolder, (String)this.getAppFileName(), (DataObject)this, (String)"warImage");
        }
        try {
            DataObject.find((FileObject)fileObject).setValid(false);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return null;
    }

    private static String readResource(String string, ClassLoader classLoader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(string)));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(string2);
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void checkOrCreateWebContext(FileSystem fileSystem) throws IOException {
        FileObject fileObject;
        FileObject fileObject2;
        FileObject fileObject3;
        FileObject fileObject4 = fileSystem.find(FOLDER_WEB_INF, null, null);
        if (fileObject4 == null) {
            fileObject4 = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)FOLDER_WEB_INF);
        }
        if ((fileObject3 = fileSystem.find("WEB-INF.classes", null, null)) == null) {
            fileObject3 = FileUtil.createFolder((FileObject)fileObject4, (String)FOLDER_CLASSES);
        }
        if ((fileObject2 = fileSystem.find("WEB-INF.lib", null, null)) == null) {
            fileObject2 = FileUtil.createFolder((FileObject)fileObject4, (String)FOLDER_LIB);
        }
        if ((fileObject = fileSystem.find(FOLDER_WEB_INF, "web", "xml")) == null) {
            String string = WebContextObject.readResource("org/netbeans/modules/web/core/resources/web.xml", TopManager.getDefault().systemClassLoader());
            fileObject = FileUtil.createData((FileObject)fileObject4, (String)"web.xml");
            FileLock fileLock = fileObject.lock();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                bufferedWriter.write(string);
                bufferedWriter.close();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            {
            }
        }
    }

    static void addFS(final FileSystem fileSystem) {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                try {
                    TopManager.getDefault().getRepository().addFileSystem(fileSystem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void removeFS(FileSystem fileSystem) {
        FSRemover fSRemover = new FSRemover(fileSystem, null);
        RequestProcessor.postRequest((Runnable)fSRemover, (int)5000);
    }

    private void mountClasses() throws IOException {
        this.classesDir = this.documentBase.find("WEB-INF.classes", null, null);
        DelegatingFileSystem delegatingFileSystem = WebContextObject.createDelegatingFileSystem(this.classesDir);
        delegatingFileSystem.setHidden(true);
        this.classesFS = this.mountFS((FileSystem)delegatingFileSystem, false);
    }

    private static DelegatingFileSystem createDelegatingFileSystem(FileObject fileObject) throws IOException {
        Object object = null;
        try {
            BeanDescriptor beanDescriptor;
            BeanInfo beanInfo = Utilities.getBeanInfo(fileObject.getFileSystem().getClass());
            if (beanInfo != null && (beanDescriptor = beanInfo.getBeanDescriptor()) != null) {
                object = beanDescriptor.getValue(VCS_PROVIDER_ATTRIBUTE);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!Boolean.TRUE.equals(object)) {
            return new DelegatingFileSystem(fileObject);
        }
        return new DelegatingFileSystemVcs(fileObject);
    }

    private void mountAllLibs() throws IOException {
        DataFolder dataFolder = this.getLibraries();
        FileObject[] fileObjectArray = dataFolder.getPrimaryFile().getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            try {
                if (fileObjectArray[n].hasExt(SUFFIX_JAR) && this.noJarContentFileExists(fileObjectArray[n])) {
                    this.mountLib(fileObjectArray[n]);
                    DataObject dataObject = DataObject.find((FileObject)fileObjectArray[n]);
                    if (!(dataObject instanceof LibJarObject) && !(dataObject instanceof LibJarContentObject)) {
                        dataObject.setValid(false);
                    }
                } else if (fileObjectArray[n].hasExt(SUFFIX_JAR) && !this.noJarContentFileExists(fileObjectArray[n])) {
                    this.fireWebContextEvent(new WebContextEvent(this, fileObjectArray[n], true));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private boolean noJarContentFileExists(FileObject fileObject) {
        boolean bl = fileObject.existsExt(SUFFIX_JAR_CONTENT);
        return !bl;
    }

    private void addLibraryListener() throws IOException {
        FileObject fileObject = this.getLibraries().getPrimaryFile();
        fileObject.addFileChangeListener(new FileChangeListener(){

            public void fileFolderCreated(FileEvent fileEvent) {
            }

            public void fileDataCreated(FileEvent fileEvent) {
                try {
                    WebContextObject.this.mountAllLibs();
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
                }
            }

            public void fileChanged(FileEvent fileEvent) {
                try {
                    WebContextObject.this.mountAllLibs();
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
                }
            }

            public void fileDeleted(FileEvent fileEvent) {
                WebContextObject.this.unmountLib(fileEvent.getFile());
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
            }

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            }
        });
    }

    private void fireWebContextEvent(WebContextEvent webContextEvent) {
        if (listenerSet != null) {
            Iterator iterator = listenerSet.iterator();
            while (iterator.hasNext()) {
                ((WebContextListener)iterator.next()).fireWebContextEvent(webContextEvent);
            }
        }
    }

    private void checkServlets() {
        try {
            DataObject dataObject = this.getDeploymentDescriptor();
            XMLJ2eeDataObject xMLJ2eeDataObject = (XMLJ2eeDataObject)dataObject.getCookie(class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject == null ? (class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject = WebContextObject.class$("org.netbeans.modules.web.xmlutils.XMLJ2eeDataObject")) : class$org$netbeans$modules$web$xmlutils$XMLJ2eeDataObject);
            if (xMLJ2eeDataObject == null) {
                return;
            }
            Document document = xMLJ2eeDataObject.getDocument();
            if (document == null) {
                return;
            }
            NodeList nodeList = document.getElementsByTagName("servlet-class");
            int n = 0;
            while (n < nodeList.getLength()) {
                block9: {
                    String string;
                    int n2;
                    FileObject fileObject;
                    Node node = nodeList.item(n).getFirstChild();
                    if (node instanceof Text && (fileObject = (n2 = (string = ((Text)node).getData()).lastIndexOf(46)) != -1 ? this.getClassesBase().find(string.substring(0, n2), string.substring(n2 + 1), "java") : this.getClassesBase().find("", string, "java")) != null) {
                        DataObject dataObject2;
                        try {
                            dataObject2 = DataObject.find((FileObject)fileObject);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            break block9;
                        }
                        if (dataObject2.getCookie(class$org$netbeans$modules$web$core$jsploader$ServletDataObject == null ? WebContextObject.class$("org.netbeans.modules.web.core.jsploader.ServletDataObject") : class$org$netbeans$modules$web$core$jsploader$ServletDataObject) == null && dataObject2.getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? WebContextObject.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject) != null) {
                            TopManager.getDefault().getErrorManager().log(1, MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject") : class$org$netbeans$modules$web$context$WebContextObject)).getString("MSG_ConvertingServlet"), string));
                            ServletSupport.convertJavaToServlet((JavaDataObject)dataObject2, false);
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
        }
    }

    void unmountLib(FileObject fileObject) {
        FileSystem fileSystem = this.removeLib(fileObject);
        WebContextObject.removeFS(fileSystem);
    }

    FileSystem removeLib(FileObject fileObject) {
        this.fireWebContextEvent(new WebContextEvent(this, fileObject, false));
        FileSystem fileSystem = (FileSystem)this.libs.get(fileObject);
        this.libs.remove(fileObject);
        return fileSystem;
    }

    public synchronized void mountLib(final FileObject fileObject) throws IOException {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                try {
                    WebContextObject.this.mountLibImpl(fileObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean waitAndSetJarFile(JarFileSystem jarFileSystem, FileObject fileObject, File file, long l) throws IOException {
        if (l > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        FileLock fileLock = null;
        try {
            try {
                fileLock = fileObject.lock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                jarFileSystem.setJarFile(file);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (fileLock != null) {
                fileLock.releaseLock();
                return true;
            }
            Object var9_9 = null;
            if (fileLock == null) return true;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized FileSystem mountLibImpl(FileObject var1_1) throws IOException {
        block7: {
            if (this.libs.containsKey(var1_1)) {
                return (FileSystem)this.libs.get(var1_1);
            }
            var2_2 = new JarFileSystem();
            var3_3 = NbClassPath.toFile((FileObject)var1_1);
            try {
                this.waitAndSetJarFile(var2_2, var1_1, var3_3, 0L);
                break block7;
            }
            catch (Exception var4_4) {
                var5_6 = 20;
                var6_7 = 0;
                ** while (var6_7 < var5_6)
            }
lbl-1000:
            // 1 sources

            {
                block8: {
                    try {
                        if (this.waitAndSetJarFile(var2_2, var1_1, var3_3, 1000L)) {
                            break;
                        }
                    }
                    catch (IOException var7_8) {
                        if (var6_7 != var5_6 - 1) break block8;
                        throw var7_8;
                    }
                }
                ++var6_7;
                continue;
            }
        }
        var4_5 = this.mountFS((FileSystem)var2_2);
        this.libs.put(var1_1, var4_5);
        this.fireWebContextEvent(new WebContextEvent(this, var1_1, true));
        return var4_5;
    }

    void unmountFS(FileSystem fileSystem) {
        WebContextObject.removeFS(fileSystem);
    }

    void replaceFS(FileSystem fileSystem, FileSystem fileSystem2) {
        FSRemover fSRemover = new FSRemover(fileSystem, fileSystem2);
        RequestProcessor.postRequest((Runnable)fSRemover);
    }

    public void unmountFS() {
        this.unmountFS(this.classesFS);
        Object[] objectArray = this.libs.values().toArray();
        this.libs.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.unmountFS((FileSystem)objectArray[n]);
            ++n;
        }
    }

    private FileSystem mountFS(FileSystem fileSystem) throws IOException {
        return this.mountFS(fileSystem, true);
    }

    private FileSystem mountFS(FileSystem fileSystem, boolean bl) throws IOException {
        DelegatingFileSystem delegatingFileSystem = null;
        if (fileSystem instanceof DelegatingFileSystem) {
            delegatingFileSystem = (DelegatingFileSystem)fileSystem;
        }
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem2 = (FileSystem)enumeration.nextElement();
            if (!fileSystem2.getSystemName().equals(fileSystem.getSystemName()) && (delegatingFileSystem == null || !delegatingFileSystem.correspondsTo(fileSystem2))) continue;
            if (bl) {
                return fileSystem2;
            }
            this.replaceFS(fileSystem2, fileSystem);
            return fileSystem;
        }
        WebContextObject.addFS(fileSystem);
        return fileSystem;
    }

    public DataObject getDeploymentDescriptor() throws IOException {
        if (this.deploymentDescriptor != null) {
            return this.deploymentDescriptor;
        }
        FileObject fileObject = this.documentBase.find(FOLDER_WEB_INF, "web", "xml");
        if (fileObject == null) {
            throw new IOException();
        }
        this.deploymentDescriptor = DataObject.find((FileObject)fileObject);
        return this.deploymentDescriptor;
    }

    public DataFolder getLibraries() throws IOException {
        FileObject fileObject = this.documentBase.find("WEB-INF.lib", null, null);
        if (fileObject == null) {
            throw new IOException();
        }
        return (DataFolder)DataObject.find((FileObject)fileObject);
    }

    public WebStandardData.WebModule getStandardData() {
        return WebDataFactory.getFactory().findWebModule(this.getPrimaryFile());
    }

    public FileSystem getClassesBase() throws IOException {
        return this.classesFS;
    }

    public FileSystem getDocumentBase() {
        return this.documentBase;
    }

    public WebInfObject getInfObject() {
        try {
            return (WebInfObject)DataObject.find((FileObject)this.getPrimaryFile().getFileObject(FOLDER_WEB_INF));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ServerInstance getServerInstance() {
        return this.getInfObject().getServerInstance();
    }

    public static void addWebContextListener(WebContextListener webContextListener) {
        if (listenerSet == null) {
            listenerSet = new HashSet();
        }
        Set set = listenerSet;
        synchronized (set) {
            listenerSet.add(webContextListener);
        }
    }

    public static void removeWebContextListener(WebContextListener webContextListener) {
        Set set = listenerSet;
        synchronized (set) {
            listenerSet.remove(webContextListener);
        }
    }

    public static void setPackager(WebContextPackager webContextPackager) {
        packager = webContextPackager;
    }

    public static WebContextPackager getPackager() {
        if (packager == null) {
            packager = new PackageWar();
        }
        return packager;
    }

    public WebModuleCookie getWebModuleCookie() {
        if (this.cookie == null) {
            this.cookie = new WebModuleCookieSupport(this);
        }
        return this.cookie;
    }

    private void showNotifyDialog() {
        final Dialog[] dialogArray = new Dialog[1];
        final ServletSettings servletSettings = (ServletSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$web$core$ServletSettings == null ? (class$org$netbeans$modules$web$core$ServletSettings = WebContextObject.class$("org.netbeans.modules.web.core.ServletSettings")) : class$org$netbeans$modules$web$core$ServletSettings));
        final MountMessagePanel mountMessagePanel = new MountMessagePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mountMessagePanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$web$context$WebContextObject == null ? (class$org$netbeans$modules$web$context$WebContextObject = WebContextObject.class$("org.netbeans.modules.web.context.WebContextObject")) : class$org$netbeans$modules$web$context$WebContextObject)).getString("CTL_TITLE"), false, -1, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                servletSettings.setShowMessageDialog(mountMessagePanel.getShowDialog());
                dialogArray[0].dispose();
            }
        });
        dialogDescriptor.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
        dialogDescriptor.setMessageType(1);
        dialogArray[0] = TopManager.getDefault().createDialog(dialogDescriptor);
        ((Component)dialogArray[0]).setSize(580, 180);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dialogArray[0].show();
            }
        });
    }

    public String getURIParameter() {
        FileObject fileObject = this.getPrimaryFile();
        try {
            String string = (String)fileObject.getAttribute(PROP_URI);
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void setURIParameter(String string) {
        FileObject fileObject = this.getPrimaryFile();
        try {
            fileObject.setAttribute(PROP_URI, (Object)string);
            this.firePropertyChange(PROP_URI, "", string);
            this.serverChanged();
        }
        catch (Exception exception) {
            TopManager.getDefault().notifyException((Throwable)exception);
        }
    }

    private void addServerChangesListeners() {
        ServerRegistryImpl.getRegistry().addServerRegistryListener((ServerRegistryImpl.ServerRegistryListener)this);
    }

    private void removeServerChangesListeners() {
        ServerRegistryImpl.getRegistry().removeServerRegistryListener((ServerRegistryImpl.ServerRegistryListener)this);
    }

    private void addWebAppChangesListeners() {
        FileObject fileObject = (FileObject)this.getPrimaryFile().getAttribute("NbAttrWebApp");
        if (fileObject != null) {
            try {
                this.oldWebAppDataObject = DataObject.find((FileObject)fileObject);
                this.oldWebAppDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private void removeWebAppChangesListeners() {
        if (this.oldWebAppDataObject != null) {
            this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.oldWebAppDataObject = null;
    }

    public void added(ServerRegistryImpl.ServerEvent serverEvent) {
        this.serverChanged();
    }

    public void setAppDefault(ServerRegistryImpl.InstanceEvent instanceEvent) {
        this.serverChanged();
    }

    public void setWebDefault(ServerRegistryImpl.InstanceEvent instanceEvent) {
        this.serverChanged();
    }

    public void removed(ServerRegistryImpl.ServerEvent serverEvent) {
        this.serverChanged();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("serverInstnace")) {
            this.serverChanged();
        }
        if (string.equals("PROP_LOCAL_WEB_APP")) {
            FileObject fileObject = (FileObject)this.getPrimaryFile().getAttribute("NbAttrWebApp");
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    dataObject.addPropertyChangeListener((PropertyChangeListener)this);
                    if (this.oldWebAppDataObject != null) {
                        this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.oldWebAppDataObject = dataObject;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            } else {
                if (this.oldWebAppDataObject != null) {
                    this.oldWebAppDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.oldWebAppDataObject = null;
            }
            this.serverChanged();
        }
    }

    private void serverChanged() {
        ServerInstanceData serverInstanceData = (ServerInstanceData)this.getPrimaryFile().getAttribute(ATTR_OLD_SERVER_INSTANCE_DATA);
        WebDataFactoryImpl webDataFactoryImpl = WebDataFactory.getFactory();
        WebModuleImpl webModuleImpl = webDataFactoryImpl.findWebModule(this.getPrimaryFile());
        ServerInstance serverInstance = webDataFactoryImpl.findServerInstance((WebStandardData)webModuleImpl);
        ServerInstanceData serverInstanceData2 = null;
        if (serverInstance != null) {
            serverInstanceData2 = new ServerInstanceData(serverInstance.getServer().getID(), serverInstance.getID());
        }
        if (serverInstanceData != null) {
            if (!serverInstanceData.equals(serverInstanceData2)) {
                this.firePropertyChange(PROP_NEW_SERVER_INSTANCE, null, serverInstanceData2);
                try {
                    this.getPrimaryFile().setAttribute(ATTR_OLD_SERVER_INSTANCE_DATA, (Object)serverInstanceData2);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
                }
            }
        } else if (serverInstanceData2 != null) {
            this.firePropertyChange(PROP_NEW_SERVER_INSTANCE, null, serverInstanceData2);
            try {
                this.getPrimaryFile().setAttribute(ATTR_OLD_SERVER_INSTANCE_DATA, (Object)serverInstanceData2);
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ FileSystem access$200(WebContextObject webContextObject) {
        return webContextObject.documentBase;
    }

    static {
        packager = new PackageWar();
    }

    public static interface WebContextPackager {
        public WebStandardData.FileArchiveResource getResource(WebContextObject var1, Server var2);

        public WebStandardData.FileArchiveResource getResource(WebContextObject var1, Server var2, File var3);
    }

    public static class WebModuleCookieSupport
    implements WebModuleCookie {
        private final WebContextObject context;

        public WebModuleCookieSupport(WebContextObject webContextObject) {
            this.context = webContextObject;
        }

        public WebContextObject getContext() {
            return this.context;
        }

        public WebStandardData.WebModule getStandardData() {
            return this.context.getStandardData();
        }
    }

    static class FSRemover
    implements Runnable {
        FileSystem rem;
        FileSystem rep;

        public FSRemover(FileSystem fileSystem, FileSystem fileSystem2) {
            this.rem = fileSystem;
            this.rep = fileSystem2;
        }

        public void run() {
            try {
                TopManager.getDefault().getRepository().removeFileSystem(this.rem);
                if (this.rep != null) {
                    TopManager.getDefault().getRepository().addFileSystem(this.rep);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

