/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.TreeMap;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Parser;
import org.netbeans.modules.web.core.jsploader.AnalyzerCompilerContext;
import org.netbeans.modules.web.core.jsploader.AnalyzerParseEventListener;
import org.netbeans.modules.web.core.jsploader.ContextDescriptor;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.jsploader.OptionsImpl;
import org.netbeans.modules.web.core.jsploader.ParsingDescriptor;
import org.netbeans.modules.web.core.jsploader.TagLibraryInfoSupport;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie {
    private JspDataObject jspdo;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private WeakReference tagLibEditorDataRef;

    public TagLibParseSupport(JspDataObject jspDataObject) {
        this.jspdo = jspDataObject;
    }

    public TagLibEditorData getTagLibEditorData() {
        return this.getTagLibEditorData(true);
    }

    TagLibEditorData getTagLibEditorData(boolean bl) {
        Object object;
        if (this.tagLibEditorDataRef != null && (object = this.tagLibEditorDataRef.get()) != null) {
            return (TagLibEditorData)object;
        }
        object = new TagLibEditorData(this);
        this.tagLibEditorDataRef = new WeakReference(object);
        if (bl) {
            this.prepare();
        }
        return object;
    }

    synchronized void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    boolean isDocumentDirty() {
        return this.documentDirty;
    }

    RequestProcessor.Task autoParse() {
        return this.parseObject(1);
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    private synchronized RequestProcessor.Task parseObject(int n) {
        RequestProcessor.Task task = this.parsingTask;
        if (task != null) {
            task.setPriority(Math.max(task.getPriority(), n));
            return task;
        }
        this.setDocumentDirty(false);
        this.parsingTask = task = RequestProcessor.postRequest((Runnable)new ParsingRunnable(), (int)0, (int)n);
        return this.parsingTask;
    }

    private JspInfo parsePage(String string) throws Exception {
        OptionsImpl optionsImpl = new OptionsImpl((DataObject)this.jspdo);
        ParsingDescriptor parsingDescriptor = new ParsingDescriptor(JspCompileUtil.getContextRoot(this.jspdo.getPrimaryFile()).getFileSystem(), string);
        String string2 = JspCompileUtil.getContextPath(this.jspdo.getPrimaryFile());
        AnalyzerCompilerContext analyzerCompilerContext = new AnalyzerCompilerContext(string2, parsingDescriptor, optionsImpl);
        JspReader jspReader = JspReader.createJspReader(string2, analyzerCompilerContext, "8859_1");
        analyzerCompilerContext.setReader(jspReader);
        AnalyzerParseEventListener analyzerParseEventListener = new AnalyzerParseEventListener(jspReader, analyzerCompilerContext, false, 1);
        Parser parser = new Parser(jspReader, analyzerParseEventListener);
        analyzerParseEventListener.beginPageProcessing();
        parser.parse();
        analyzerParseEventListener.endPageProcessing();
        return analyzerParseEventListener.getJspInfo();
    }

    public static class TagData {
        private String tagName;
        private String bodyContent;

        public TagData(String string, String string2) {
            this.tagName = string;
            this.bodyContent = string2;
        }

        boolean equalsColoringInformation(TagData tagData) {
            return this.tagName.equals(tagData.tagName) && this.bodyContent.equals(tagData.bodyContent);
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getBodyContent() {
            return this.bodyContent;
        }
    }

    public static class TagLibData {
        private String prefix;
        private TagLibraryInfo tagLibraryInfo;
        private TreeMap tagMap = new TreeMap();

        public TagLibData(JspInfo.TagLibraryData tagLibraryData, FileSystem fileSystem) {
            TagInfo[] tagInfoArray;
            this.prefix = tagLibraryData.getPrefix();
            this.tagLibraryInfo = null;
            ContextDescriptor contextDescriptor = new ContextDescriptor(fileSystem);
            FileObject fileObject = contextDescriptor.getResourceAsObject(tagLibraryData.getResolvedURI());
            if (fileObject != null) {
                try {
                    tagInfoArray = DataObject.find((FileObject)fileObject);
                    TagLibraryInfoSupport tagLibraryInfoSupport = TagLibraryInfoSupport.getTagLibraryInfoSupport((DataObject)tagInfoArray);
                    if (tagLibraryInfoSupport != null) {
                        this.tagLibraryInfo = tagLibraryInfoSupport.getTagLibraryInfo(this.prefix, tagLibraryData.getUnresolvedURI());
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (this.tagLibraryInfo != null) {
                tagInfoArray = this.tagLibraryInfo.getTags();
                int n = 0;
                while (n < tagInfoArray.length) {
                    String string = tagInfoArray[n].getTagName();
                    this.tagMap.put(string, new TagData(string, tagInfoArray[n].getBodyContent()));
                    ++n;
                }
            }
        }

        boolean equalsColoringInformation(TagLibData tagLibData) {
            TagData[] tagDataArray;
            if (!this.prefix.equals(tagLibData.prefix)) {
                return false;
            }
            TagData[] tagDataArray2 = this.getTagData();
            if (tagDataArray2.length != (tagDataArray = tagLibData.getTagData()).length) {
                return false;
            }
            int n = 0;
            while (n < tagDataArray2.length) {
                if (!tagDataArray2[n].equalsColoringInformation(tagDataArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public TagData[] getTagData() {
            return this.tagMap.values().toArray(new TagData[this.tagMap.size()]);
        }

        public TagData getTagData(String string) {
            return (TagData)this.tagMap.get(string);
        }

        public TagLibraryInfo getTagLibraryInfo() {
            return this.tagLibraryInfo;
        }
    }

    public static class TagLibEditorData
    extends PropertyChangeSupport {
        public static final String PROP_COLORING_CHANGE = "coloringChange";
        private TreeMap libraryMap = new TreeMap();
        private JspInfo.BeanData[] beanData = new JspInfo.BeanData[0];

        TagLibEditorData(Object object) {
            super(object);
        }

        public void setBeanData(JspInfo.BeanData[] beanDataArray) {
            this.beanData = beanDataArray;
        }

        public JspInfo.BeanData[] getBeanData() {
            return this.beanData;
        }

        void applyParsedData(JspInfo.TagLibraryData[] tagLibraryDataArray, FileSystem fileSystem) {
            TreeMap<String, TagLibData> treeMap = new TreeMap<String, TagLibData>();
            int n = 0;
            while (n < tagLibraryDataArray.length) {
                String string = tagLibraryDataArray[n].getPrefix();
                treeMap.put(string, new TagLibData(tagLibraryDataArray[n], fileSystem));
                ++n;
            }
            boolean bl = false;
            if (this.libraryMap.size() != treeMap.size()) {
                bl = true;
            } else {
                TagLibData[] tagLibDataArray = this.getTagLibData();
                TagLibData[] tagLibDataArray2 = treeMap.values().toArray(new TagLibData[treeMap.size()]);
                int n2 = 0;
                while (n2 < tagLibDataArray.length) {
                    if (!tagLibDataArray[n2].equalsColoringInformation(tagLibDataArray2[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.libraryMap = treeMap;
            if (bl) {
                this.firePropertyChange(PROP_COLORING_CHANGE, null, null);
            }
        }

        public TagLibData[] getTagLibData() {
            return this.libraryMap.values().toArray(new TagLibData[this.libraryMap.size()]);
        }

        public TagLibData getTagLibData(String string) {
            return (TagLibData)this.libraryMap.get(string);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    private class ParsingRunnable
    implements Runnable {
        private ParsingRunnable() {
        }

        public void run() {
            TagLibParseSupport tagLibParseSupport;
            try {
                block9: {
                    try {
                        JspInfo jspInfo = TagLibParseSupport.this.parsePage(JspCompileUtil.getContextPath(TagLibParseSupport.this.jspdo.getPrimaryFile()));
                        TagLibParseSupport.this.getTagLibEditorData(false).applyParsedData(jspInfo.getTagLibraryData(), TagLibParseSupport.this.jspdo.getPrimaryFile().getFileSystem());
                        TagLibParseSupport.this.getTagLibEditorData(false).setBeanData(jspInfo.getBeans());
                    }
                    catch (Exception exception) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                        TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
                    }
                }
                Object var3_3 = null;
                tagLibParseSupport = TagLibParseSupport.this;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                TagLibParseSupport tagLibParseSupport2 = TagLibParseSupport.this;
                synchronized (tagLibParseSupport2) {
                    TagLibParseSupport.this.parsingTask = null;
                }
                throw throwable;
            }
            synchronized (tagLibParseSupport) {
                TagLibParseSupport.this.parsingTask = null;
            }
        }
    }
}

