/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.web.core.jsploader.TagLibFormatException;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TagLibraryInfoSupport
implements Node.Cookie {
    private static final String TLD = "META-INF/taglib.tld";
    public static final String PROP_TAGLIBRARYINFO = "tagLibraryInfo";
    protected DataObject dobj;
    protected TagLibraryInfoInternal tagLibraryInfo;
    private transient PropertyChangeSupport pcs;
    private static Map supportInstances;

    public TagLibraryInfoSupport(DataObject dataObject) {
        this.dobj = dataObject;
        dataObject.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                TagLibraryInfoSupport.this.invalidate();
            }

            public void fileDeleted(FileEvent fileEvent) {
                TagLibraryInfoSupport.this.invalidate();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                TagLibraryInfoSupport.this.invalidate();
            }
        });
    }

    public TagLibraryInfo getTagLibraryInfo(String string, String string2) {
        if (this.tagLibraryInfo == null) {
            TagLibraryInfoSupport tagLibraryInfoSupport = this;
            synchronized (tagLibraryInfoSupport) {
                if (this.tagLibraryInfo == null) {
                    this.tagLibraryInfo = this.createTagLibraryInfo();
                }
            }
        }
        return this.tagLibraryInfo == null ? null : new TagLibraryInfoExternal(this.tagLibraryInfo, string, string2);
    }

    private TagLibraryInfoInternal createTagLibraryInfo() {
        block6: {
            try {
                ErrorHandler errorHandler = new ErrorHandler(){

                    public void error(SAXParseException sAXParseException) throws SAXException {
                    }

                    public void fatalError(SAXParseException sAXParseException) throws SAXException {
                        throw sAXParseException;
                    }

                    public void warning(SAXParseException sAXParseException) throws SAXException {
                    }
                };
                Document document = "jar".equals(this.dobj.getPrimaryFile().getExt()) ? TagLibraryInfoSupport.parse(new InputSource(this.getInputStreamFromJar()), errorHandler, true) : TagLibraryInfoSupport.parse(new InputSource(this.dobj.getPrimaryFile().getInputStream()), errorHandler, true);
                return new TagLibraryInfoInternal(document);
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)sAXException);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)parserConfigurationException);
            }
            catch (TagLibFormatException tagLibFormatException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)tagLibFormatException);
            }
        }
        return null;
    }

    private InputStream getInputStreamFromJar() throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(this.dobj.getPrimaryFile().getInputStream());
        ByteArrayInputStream byteArrayInputStream = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream;
            if (zipEntry.getName().equals(TLD)) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                while (zipInputStream.available() != 0) {
                    n = ((InflaterInputStream)zipInputStream).read();
                    if (n == -1) break;
                    byteArrayOutputStream.write(n);
                }
                byteArrayOutputStream.close();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                while (zipInputStream.available() != 0) {
                    n = ((InflaterInputStream)zipInputStream).read();
                    if (n == -1) break;
                    byteArrayOutputStream.write(n);
                }
                byteArrayOutputStream.close();
            }
            zipInputStream.closeEntry();
        }
        return byteArrayInputStream;
    }

    private static Document parse(InputSource inputSource, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException, ParserConfigurationException {
        return TagLibraryInfoSupport.parseXMLDocJaxp(inputSource, "org/netbeans/modules/web/core/resources/web-jsptaglib_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", bl, errorHandler);
    }

    private static Document parseXMLDocJaxp(InputSource inputSource, String string, String string2, boolean bl, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        MyEntityResolver myEntityResolver = new MyEntityResolver(string2, string);
        documentBuilder.setEntityResolver(myEntityResolver);
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    private synchronized void invalidate() {
        this.tagLibraryInfo = null;
        this.fireTagLibraryInfoChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    void fireTagLibraryInfoChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_TAGLIBRARYINFO, null, null);
        }
    }

    public static TagLibraryInfoSupport getTagLibraryInfoSupport(DataObject dataObject) {
        TagLibraryInfoSupport tagLibraryInfoSupport;
        if (supportInstances == null) {
            supportInstances = new WeakHashMap();
        }
        if ((tagLibraryInfoSupport = (TagLibraryInfoSupport)supportInstances.get(dataObject)) == null) {
            tagLibraryInfoSupport = new TagLibraryInfoSupport(dataObject);
            supportInstances.put(dataObject, tagLibraryInfoSupport);
        }
        return tagLibraryInfoSupport;
    }

    static class MyEntityResolver
    implements EntityResolver {
        String dtdId;
        String dtdResource;

        public MyEntityResolver(String string, String string2) {
            this.dtdId = string;
            this.dtdResource = string2;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string.equals(this.dtdId)) {
                InputStream inputStream = TopManager.getDefault().systemClassLoader().getResourceAsStream(this.dtdResource);
                InputSource inputSource = new InputSource(inputStream);
                return inputSource;
            }
            return null;
        }
    }

    private static class TagLibraryInfoExternal
    extends TagLibraryInfo {
        TagLibraryInfoExternal(TagLibraryInfoInternal tagLibraryInfoInternal, String string, String string2) {
            super(string, string2);
            this.tags = tagLibraryInfoInternal.getTags();
            this.tlibversion = tagLibraryInfoInternal.getTLibVersion();
            this.jspversion = tagLibraryInfoInternal.getRequiredVersion();
            this.shortname = tagLibraryInfoInternal.getShortName();
            this.urn = tagLibraryInfoInternal.getReliableURN();
            this.info = tagLibraryInfoInternal.getInfoString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[TagLibraryInfoExternal\n    prefix = ");
            stringBuffer.append(this.prefix);
            stringBuffer.append("\n    uri = ");
            stringBuffer.append(this.uri);
            stringBuffer.append("\n    tlibversion = ");
            stringBuffer.append(this.tlibversion);
            stringBuffer.append("\n    jspversion = ");
            stringBuffer.append(this.jspversion);
            stringBuffer.append("\n    shortname = ");
            stringBuffer.append(this.shortname);
            stringBuffer.append("\n    urn = ");
            stringBuffer.append(this.urn);
            stringBuffer.append("\n    info = ");
            stringBuffer.append(this.info);
            stringBuffer.append("\n    TAGS:\n");
            TagInfo[] tagInfoArray = this.getTags();
            int n = 0;
            while (n < tagInfoArray.length) {
                stringBuffer.append("        ");
                stringBuffer.append(tagInfoArray[n].toString());
                stringBuffer.append("\n");
                ++n;
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static class TagLibraryInfoInternal
    extends TagLibraryInfo {
        TagLibraryInfoInternal(Document document) throws TagLibFormatException {
            super(null, null);
            this.processTLD(document);
        }

        private ClassLoader getTagLibClassLoader() {
            return TopManager.getDefault().currentClassLoader();
        }

        private void processTLD(Document document) throws TagLibFormatException {
            Vector<TagInfo> vector = new Vector<TagInfo>();
            NodeList nodeList = document.getElementsByTagName("taglib");
            if (nodeList.getLength() != 1) {
                throw new TagLibFormatException();
            }
            Element element = (Element)nodeList.item(0);
            nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    Text text;
                    Element element2 = (Element)node;
                    String string = element2.getTagName();
                    if (string.equals("tlibversion")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            this.tlibversion = text.getData();
                        }
                    } else if (string.equals("jspversion")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            this.jspversion = text.getData();
                        }
                    } else if (string.equals("shortname")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            this.shortname = text.getData();
                        }
                    } else if (string.equals("urn")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            this.urn = text.getData();
                        }
                    } else if (string.equals("info")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            this.info = text.getData();
                        }
                    } else if (string.equals("tag")) {
                        vector.addElement(this.createTagInfo(element2));
                    } else {
                        this.tagLibWarning(null);
                    }
                }
                ++n;
            }
            this.tags = new TagInfo[vector.size()];
            vector.copyInto(this.tags);
        }

        private TagInfo createTagInfo(Element element) throws TagLibFormatException {
            Object object;
            Element element2;
            Object object2;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = "JSP";
            String string5 = null;
            Vector<TagAttributeInfo> vector = new Vector<TagAttributeInfo>();
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                object2 = nodeList.item(n);
                if (object2 instanceof Element) {
                    Text text;
                    element2 = (Element)object2;
                    object = element2.getTagName();
                    if (((String)object).equals("name")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string = text.getData();
                        }
                    } else if (((String)object).equals("tagclass")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string2 = text.getData();
                        }
                    } else if (((String)object).equals("teiclass")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string3 = text.getData();
                        }
                    } else if (((String)object).equals("bodycontent")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string4 = text.getData();
                        }
                    } else if (((String)object).equals("info")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string5 = text.getData();
                        }
                    } else if (((String)object).equals("attribute")) {
                        vector.addElement(this.createAttribute(element2));
                    } else {
                        this.tagLibWarning(null);
                    }
                }
                ++n;
            }
            object2 = new TagAttributeInfo[vector.size()];
            vector.copyInto((Object[])object2);
            element2 = null;
            if (string3 != null && !string3.equals("")) {
                try {
                    object = this.getTagLibClassLoader().loadClass(string3);
                    element2 = (TagExtraInfo)((Class)object).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.tagLibWarning(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.tagLibWarning(null);
                }
                catch (InstantiationException instantiationException) {
                    this.tagLibWarning(null);
                }
            }
            object = new TagInfo(string, string2, string4, string5, (TagLibraryInfo)this, (TagExtraInfo)element2, object2);
            return object;
        }

        TagAttributeInfo createAttribute(Element element) {
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = null;
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    Text text;
                    Element element2 = (Element)node;
                    String string3 = element2.getTagName();
                    if (string3.equals("name")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string = text.getData();
                        }
                    } else if (string3.equals("required")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            bl = Boolean.valueOf(text.getData());
                        }
                    } else if (string3.equals("rtexprvalue")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            bl2 = Boolean.valueOf(text.getData());
                        }
                    } else if (string3.equals("type")) {
                        text = (Text)element2.getFirstChild();
                        if (text != null) {
                            string2 = text.getData();
                        }
                    } else {
                        this.tagLibWarning(null);
                    }
                }
                ++n;
            }
            return new TagAttributeInfo(string, bl, string2, bl2);
        }

        String getTLibVersion() {
            return this.tlibversion;
        }

        private void tagLibWarning(String string) {
        }
    }
}

