/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Requestor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.explorer.propertysheet.editors.ChoicePropertyEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;

public class ClassBreakpoint
extends CoreBreakpoint.Event
implements Executor,
StopEvent,
InfoProducer,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = -1921042297280923010L;
    public static final String PROP_TYPE = "type";
    public static final String PROP_CLASS_FILTER = "classFilter";
    public static final String PROP_EXCLUSION_FILTER = "exclusionFilter";
    public static final int TYPE_PREPARE = 1;
    public static final int TYPE_UNLOAD = 2;
    public static final String TYPE_NAME = "java-class";
    private transient ThreadReference thread;
    private Requestor requestor;
    private int type = 1;
    private boolean exclusionFilter = false;
    private String classFilter = "";
    private transient String action;
    private transient String className;
    private transient CoreBreakpoint.Action[] actions;
    protected transient BreakpointUpdater updater;
    static /* synthetic */ Class class$java$lang$String;

    public ClassBreakpoint() {
        this.initUpdater();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initUpdater();
    }

    protected void initUpdater() {
        this.updater = new BreakpointUpdater((CoreBreakpoint.Event)this, "setClassFilterByUpdater", this.className);
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        super.dispose();
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getClassFilter() == null || this.getClassFilter().trim().length() < 1) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new Requestor(jPDADebugger.requestManager, jPDADebugger.operator, this);
        }
        try {
            EventRequest eventRequest;
            this.requestor.removeRequests();
            if ((this.type & 1) != 0) {
                eventRequest = jPDADebugger.requestManager.createClassPrepareRequest();
                eventRequest.setSuspendPolicy(2);
                if (this.exclusionFilter) {
                    eventRequest.addClassExclusionFilter(this.getClassFilter());
                } else {
                    eventRequest.addClassFilter(this.getClassFilter());
                }
                this.requestor.add(eventRequest);
                eventRequest.enable();
            }
            if ((this.type & 2) != 0) {
                eventRequest = jPDADebugger.requestManager.createClassUnloadRequest();
                eventRequest.setSuspendPolicy(2);
                if (this.exclusionFilter) {
                    eventRequest.addClassExclusionFilter(this.getClassFilter());
                } else {
                    eventRequest.addClassFilter(this.getClassFilter());
                }
                this.requestor.add(eventRequest);
                eventRequest.enable();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return true;
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ClassBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CLASS_FILTER, (String)JPDADebugger.getLocString("PROP_class_filter"), (String)JPDADebugger.getLocString("HINT_class_filter"), (String)"getClassFilter", (String)"setClassFilter"), Utils.createProperty((Object)this, Boolean.TYPE, (String)PROP_EXCLUSION_FILTER, (String)JPDADebugger.getLocString("PROP_class_exclusion_filter"), (String)JPDADebugger.getLocString("HINT_class_exclusion_filter"), (String)"getExclusionFilter", (String)"setExclusionFilter"), new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_class_type"), JPDADebugger.getLocString("HINT_class_type")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ClassBreakpoint.this.getType());
            }

            public void setValue(Object object) throws IllegalArgumentException {
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                ClassBreakpoint.this.setType((Integer)object);
            }

            public PropertyEditor getPropertyEditor() {
                return new ChoicePropertyEditor(new int[]{1, 2, 3}, new String[]{JPDADebugger.getLocString("CTL_Breakpoint_type_class_prepare"), JPDADebugger.getLocString("CTL_Breakpoint_type_class_unload"), JPDADebugger.getLocString("CTL_Breakpoint_type_class_both")});
            }
        }};
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actionArray = this.getBreakpoint().getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof JavaStopAction) {
                ((JavaStopAction)actionArray[n]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++n;
        }
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Class_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JPDADebugger.getLocString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Class_prepare_event_name")).format(new Object[]{this.getClassFilter()});
        }
        if (this.type == 2) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Class_unload_event_name")).format(new Object[]{this.getClassFilter()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Class_event_name")).format(new Object[]{this.getClassFilter()});
    }

    public String getIconBase() {
        return "/org/netbeans/modules/debugger/resources/breakpointOnClass";
    }

    public JComponent getCustomizer() {
        this.setClassFilter(JUtils.getCurrentClassName());
        return new ClassBreakpointPanel(this);
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new ClassPrintAction()};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void synchronizeWith(CoreBreakpoint.Event event) {
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            this.thread = ((ClassPrepareEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Prepared");
            this.className = ((ClassPrepareEvent)event).referenceType().name();
        } else {
            this.action = JPDADebugger.getLocString("CTL_Unload");
            this.className = ((ClassUnloadEvent)event).className();
        }
        if (this.classFilter.indexOf(42) < 0 && !this.className.equals(this.classFilter)) {
            ((JPDADebugger)this.getDebugger()).operator.resume();
            return;
        }
        this.perform();
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n == this.type) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.type;
        this.type = n;
        this.firePropertyChange(PROP_TYPE, new Integer(n2), new Integer(n));
    }

    public boolean getExclusionFilter() {
        return this.exclusionFilter;
    }

    public void setExclusionFilter(boolean bl) {
        if (bl == this.exclusionFilter) {
            return;
        }
        boolean bl2 = this.exclusionFilter;
        this.exclusionFilter = bl;
        this.firePropertyChange(PROP_EXCLUSION_FILTER, new Boolean(bl2), new Boolean(bl));
    }

    public String getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(String string) {
        this.setClassFilter(string, true);
    }

    public void setClassFilterByUpdater(String string) {
        this.setClassFilter(string, false);
    }

    public void setClassFilter(String string, boolean bl) {
        if (string != null) {
            string = string.trim();
        }
        if (this.classFilter == string || this.classFilter != null && string != null && string.equals(this.classFilter)) {
            return;
        }
        String string2 = this.classFilter;
        this.classFilter = string;
        if (bl) {
            this.updater.setClassName(string);
        }
        this.firePropertyChange(PROP_CLASS_FILTER, string2, string);
    }

    public String toString() {
        return "JPDAClassBreakpoint " + this.getClassFilter();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ClassPrintAction
    extends PrintAction {
        static final long serialVersionUID = 1241425759801080117L;

        ClassPrintAction() {
            super(JPDADebugger.getLocString("CTL_Class_print_name"));
        }

        protected void resolveTag(String string, CoreBreakpoint.Event event, StringBuffer stringBuffer) {
            if (string.equals("className")) {
                stringBuffer.append(((ClassBreakpoint)event).className);
            } else if (string.equals("action")) {
                stringBuffer.append(((ClassBreakpoint)event).action);
            } else {
                super.resolveTag(string, event, stringBuffer);
            }
        }
    }
}

