/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Requestor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.MethodBreakpointEvent;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class MethodBreakpoint
extends MethodBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -2226362778610894492L;
    public static final String PROP_ALL_METHODS = "allMethods";
    public static final String PROP_CONDITION = "condition";
    private transient ThreadReference thread;
    private Requestor requestor;
    private ReferenceType tryClass;
    private LinkedList lines = new LinkedList();
    private Line[] linesArray;
    private boolean allMethods = false;
    private boolean methodEntry = true;
    private String condition = "";
    private transient CoreBreakpoint.Action[] actions;
    private HashSet refTypesWithBreakpoint;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$VariableBreakpoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$MethodBreakpoint;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$LineBreakpoint;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.virtualMachine == null || jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (!(this.getAllMethods() || this.getMethodName() != null && this.getMethodName().trim().length() >= 1)) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new Requestor(jPDADebugger.requestManager, jPDADebugger.operator, this);
        }
        try {
            ReferenceType referenceType;
            String string;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            String string2 = string = this.getApplyToAnonymousInnerClasses() ? this.getClassName() + '*' : this.getClassName();
            if (this.allMethods) {
                EventRequest eventRequest;
                if (this.methodEntry) {
                    MethodEntryRequest methodEntryRequest = jPDADebugger.requestManager.createMethodEntryRequest();
                    methodEntryRequest.addClassFilter(string);
                    eventRequest = methodEntryRequest;
                } else {
                    MethodExitRequest methodExitRequest = jPDADebugger.requestManager.createMethodExitRequest();
                    methodExitRequest.addClassFilter(string);
                    eventRequest = methodExitRequest;
                }
                eventRequest.setSuspendPolicy(2);
                this.requestor.add(eventRequest);
                eventRequest.enable();
                return true;
            }
            ClassPrepareRequest classPrepareRequest = jPDADebugger.requestManager.createClassPrepareRequest();
            classPrepareRequest.addClassFilter(string);
            classPrepareRequest.setSuspendPolicy(2);
            this.requestor.add(classPrepareRequest);
            classPrepareRequest.enable();
            List<ReferenceType> list = jPDADebugger.virtualMachine.classesByName(this.getClassName());
            if (list.size() == 0) {
                return false;
            }
            boolean bl = false;
            if (!this.getApplyToAnonymousInnerClasses()) {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    ReferenceType referenceType2 = list.get(n2);
                    if (this.set(referenceType2)) {
                        bl = true;
                    }
                    ++n2;
                }
                return bl;
            }
            ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
            int n = list.size();
            int n3 = 0;
            while (n3 < n) {
                referenceType = list.get(n3);
                if (this.set(referenceType)) {
                    bl = true;
                }
                try {
                    arrayList.addAll(Utils.anonymousInnerClasses((String)referenceType.name(), referenceType.nestedTypes()));
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < arrayList.size()) {
                referenceType = (ReferenceType)arrayList.get(n3);
                if (this.set(referenceType)) {
                    bl = true;
                }
                try {
                    arrayList.addAll(referenceType.nestedTypes());
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n3;
            }
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
        this.linesArray = null;
        this.lines = new LinkedList();
    }

    public Node.Property[] getProperties() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$VariableBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$VariableBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.VariableBreakpoint")) : class$org$netbeans$modules$debugger$jpda$VariableBreakpoint));
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)resourceBundle.getString("PROP_breakpoint_class_name"), (String)resourceBundle.getString("HINT_breakpoint_class_name"), (String)"getClassName", (String)"setClassName"), Utils.createProperty((Object)this, Boolean.TYPE, (String)"includingAnonymousInnerClasses", (String)resourceBundle.getString("PROP_breakpoint_apply_to_anonymous_inner"), (String)resourceBundle.getString("HINT_breakpoint_apply_to_anonymous_inner"), (String)"getApplyToAnonymousInnerClasses", (String)"setApplyToAnonymousInnerClasses"), Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"methodName", (String)resourceBundle.getString("PROP_breakpoint_method_name"), (String)resourceBundle.getString("HINT_breakpoint_method_name"), (String)"getMethodName", (String)"setMethodName"), Utils.createProperty((Object)this, Boolean.TYPE, (String)PROP_ALL_METHODS, (String)resourceBundle.getString("PROP_breakpoint_all_methods"), (String)resourceBundle.getString("HINT_breakpoint_all_methods"), (String)"getAllMethods", (String)"setAllMethods"), Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)resourceBundle.getString("PROP_condition"), (String)resourceBundle.getString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public Line[] getLines() {
        if (this.linesArray != null) {
            return this.linesArray;
        }
        if (this.lines.size() == 0) {
            return null;
        }
        this.linesArray = this.lines.toArray(new Line[this.lines.size()]);
        return this.linesArray;
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getCurrentClassName());
        this.setMethodName(JUtils.getCurrentMethodName());
        return new MethodBreakpointPanel(this);
    }

    public String getDisplayName() {
        if (this.getAllMethods()) {
            return new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$MethodBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$MethodBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.MethodBreakpoint")) : class$org$netbeans$modules$debugger$jpda$MethodBreakpoint)).getString("CTL_All_method_event_name")).format(new Object[]{this.getClassName()});
        }
        return new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$MethodBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$MethodBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.MethodBreakpoint")) : class$org$netbeans$modules$debugger$jpda$MethodBreakpoint)).getString("CTL_Method_event_name")).format(new Object[]{this.getClassName(), this.getMethodName()});
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_METHOD_TEXT)};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
            JPDAWatch jPDAWatch = new JPDAWatch(jPDADebugger, true);
            jPDAWatch.setVariableName(this.condition);
            jPDAWatch.refreshValue((JPDAThread)this.getThread());
            String string = jPDAWatch.getType();
            String string2 = jPDAWatch.getAsText();
            if (string != null && string.equals("boolean") && string2 != null && string2.equals("false")) {
                this.stop(false);
                return;
            }
            if (string == null || !string.equals("boolean")) {
                ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.LineBreakpoint")) : class$org$netbeans$modules$debugger$jpda$LineBreakpoint));
                jPDADebugger.getIOManager().println(resourceBundle.getString("CTL_Incorrect_condition") + ": " + resourceBundle.getString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public void exec(Event event) {
        boolean bl;
        boolean bl2 = event instanceof ClassPrepareEvent;
        boolean bl3 = event instanceof BreakpointEvent;
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        if (!bl3) {
            if (bl2) {
                this.tryClass = ((ClassPrepareEvent)event).referenceType();
            } else {
                Method method = event instanceof MethodEntryEvent ? ((MethodEntryEvent)event).method() : ((MethodExitEvent)event).method();
                this.tryClass = method.declaringType();
            }
            String string = this.tryClass.name();
            if (string.equals(this.getClassName())) {
                bl = false;
            } else if (!this.getApplyToAnonymousInnerClasses()) {
                bl = true;
            } else {
                String string2 = this.getClassName() + '$';
                boolean bl4 = bl = !string.startsWith(string2) || Character.isJavaIdentifierStart(string.charAt(string2.length()));
            }
            if (bl) {
                jPDADebugger.operator.resume();
                return;
            }
        }
        if (bl2) {
            bl = this.set(this.tryClass);
            if (bl && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            jPDADebugger.operator.resume();
        } else {
            this.thread = ((LocatableEvent)event).thread();
            if (jPDADebugger.virtualMachine.canGetSyntheticAttribute()) {
                try {
                    if (this.thread.frame(0).location().method().isSynthetic()) {
                        jPDADebugger.operator.resume();
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jPDADebugger.resolveCanBeCurrent(this.thread)) {
                return;
            }
            this.perform();
        }
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    public boolean getAllMethods() {
        return this.allMethods;
    }

    public void setAllMethods(boolean bl) {
        if (this.allMethods == bl) {
            return;
        }
        boolean bl2 = this.allMethods;
        this.allMethods = bl;
        this.firePropertyChange(PROP_ALL_METHODS, new Boolean(bl2), new Boolean(this.allMethods));
    }

    public boolean getMethodEntry() {
        return this.methodEntry;
    }

    public void setMethodEntry(boolean bl) {
        if (this.methodEntry == bl) {
            return;
        }
        boolean bl2 = this.methodEntry;
        this.methodEntry = bl;
        this.firePropertyChange(PROP_ALL_METHODS, new Boolean(bl2), new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(ReferenceType referenceType) {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        if (jPDADebugger.virtualMachine == null) return false;
        if (jPDADebugger.isDisconnected()) {
            return false;
        }
        if (!this.getAllMethods()) {
            if (this.getMethodName() == null) return false;
            if (this.getMethodName().trim().length() < 1) {
                return false;
            }
        }
        MethodBreakpoint methodBreakpoint = this;
        synchronized (methodBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(referenceType)) {
                        return true;
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(referenceType);
        }
        String string = this.getMethodName();
        try {
            List<Method> list = referenceType.methods();
            boolean bl = false;
            int n = list.size();
            int n2 = 0;
            while (true) {
                Location location;
                if (n2 >= n) {
                    return bl;
                }
                Method method = list.get(n2);
                if (method.name().equals(string) && (location = method.location()) != null) {
                    BreakpointRequest breakpointRequest = jPDADebugger.requestManager.createBreakpointRequest(location);
                    breakpointRequest.setSuspendPolicy(2);
                    this.requestor.add(breakpointRequest);
                    breakpointRequest.enable();
                    bl = true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "JPDAMethodBreakpoint " + this.getClassName() + "." + this.getMethodName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

