/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InsertI18nStringAction;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class I18nManager {
    public static final String I18N_MODE = "internationalization";
    private static I18nManager manager;
    private I18nSupport support;
    private WeakReference i18nPanelWRef = new WeakReference<Object>(null);
    private WeakReference topComponentWRef = new WeakReference<Object>(null);
    private WeakReference caretWRef;
    private HardCodedString hcString;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nManager;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$InsertI18nStringAction;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    private I18nManager() {
    }

    public static I18nManager getDefault() {
        if (manager == null) {
            Class clazz = class$org$netbeans$modules$i18n$I18nManager == null ? (class$org$netbeans$modules$i18n$I18nManager = I18nManager.class$("org.netbeans.modules.i18n.I18nManager")) : class$org$netbeans$modules$i18n$I18nManager;
            synchronized (clazz) {
                if (manager == null) {
                    manager = new I18nManager();
                }
            }
        }
        return manager;
    }

    private void initSupport(DataObject dataObject) throws IOException {
        I18nSupport.Factory factory = FactoryRegistry.getFactory(dataObject.getClass());
        this.support = factory.create(dataObject);
    }

    public void internationalize(final DataObject dataObject) {
        ((InsertI18nStringAction)SystemAction.get((Class)(class$org$netbeans$modules$i18n$InsertI18nStringAction == null ? (class$org$netbeans$modules$i18n$InsertI18nStringAction = I18nManager.class$("org.netbeans.modules.i18n.InsertI18nStringAction")) : class$org$netbeans$modules$i18n$InsertI18nStringAction))).cancel();
        this.closeDialog();
        try {
            this.initSupport(dataObject);
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("I18N: Document could not be loaded for " + dataObject.getName());
            }
            return;
        }
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = I18nManager.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (editorCookie == null) {
            return;
        }
        if (this.find()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    I18nManager.this.initCaret(editorCookie);
                    I18nManager.this.highlightHCString();
                    I18nManager.this.getDialog(dataObject.getName());
                    I18nManager.this.fillDialogValues();
                }
            });
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_NoInternationalizableString"), 1);
            TopManager.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void initCaret(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CouldNotOpen"), 0);
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        this.caretWRef = new WeakReference<Caret>(jEditorPaneArray[0].getCaret());
    }

    private void highlightHCString() {
        HardCodedString hardCodedString = this.hcString;
        if (hardCodedString == null) {
            return;
        }
        Caret caret = (Caret)this.caretWRef.get();
        if (caret != null) {
            caret.setDot(hardCodedString.getStartPosition().getOffset());
            caret.moveDot(hardCodedString.getEndPosition().getOffset());
        }
    }

    private boolean find() {
        this.hcString = this.support.getFinder().findNextHardCodedString();
        return this.hcString != null;
    }

    private void fillDialogValues() {
        I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        i18nPanel.setI18nString(this.support.getDefaultI18nString(this.hcString));
        this.showDialog();
    }

    private void replace() {
        I18nString i18nString = null;
        try {
            i18nString = ((I18nPanel)this.i18nPanelWRef.get()).getI18nString();
        }
        catch (IllegalStateException illegalStateException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("EXC_BadKey"), 0);
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        this.support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
        if (this.support.hasAdditionalCustomizer()) {
            this.support.performAdditionalChanges();
        }
        this.support.getReplacer().replace(this.hcString, i18nString);
        this.skip();
    }

    private void skip() {
        if (this.find()) {
            this.highlightHCString();
            this.fillDialogValues();
        } else {
            this.cancel();
        }
    }

    private void showInfo() {
        JPanel jPanel = this.support.getInfo(this.hcString);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, I18nUtil.getBundle().getString("CTL_InfoPanelTitle"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setOptionType(-1);
        dialogDescriptor.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
        dialogDescriptor.setAdditionalOptions(new Object[0]);
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        ((Component)dialog).setVisible(true);
    }

    public void cancel() {
        this.support = null;
        this.closeDialog();
    }

    private void getDialog(String string) {
        Workspace[] workspaceArray;
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        Workspace[] workspaceArray2 = (Workspace[])this.i18nPanelWRef.get();
        if (workspaceArray2 == null) {
            workspaceArray = workspaceArray2 = new I18nPanel(this.support.getPropertyPanel());
            ActionListener actionListener = new ActionListener((I18nPanel)workspaceArray){
                private final /* synthetic */ I18nPanel val$panel;
                {
                    this.val$panel = i18nPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.val$panel.getReplaceButton()) {
                        I18nManager.this.replace();
                    } else if (actionEvent.getSource() == this.val$panel.getSkipButton()) {
                        I18nManager.this.skip();
                    } else if (actionEvent.getSource() == this.val$panel.getInfoButton()) {
                        I18nManager.this.showInfo();
                    } else if (actionEvent.getSource() == this.val$panel.getCancelButton()) {
                        I18nManager.this.cancel();
                    }
                }
            };
            workspaceArray2.getReplaceButton().addActionListener(actionListener);
            workspaceArray2.getSkipButton().addActionListener(actionListener);
            workspaceArray2.getInfoButton().addActionListener(actionListener);
            workspaceArray2.getCancelButton().addActionListener(actionListener);
            this.i18nPanelWRef = new WeakReference<I18nPanel>((I18nPanel)workspaceArray2);
        }
        workspaceArray2.setI18nString(this.support.getDefaultI18nString());
        if (topComponent == null) {
            topComponent = new TopComponent(){

                public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
                }

                public void writeExternal(ObjectOutput objectOutput) throws IOException {
                }

                protected Object writeReplace() throws ObjectStreamException {
                    return null;
                }
            };
            topComponent.setCloseOperation(0);
            topComponent.setLayout(new BorderLayout());
            topComponent.add((Component)workspaceArray2, "Center");
            topComponent.setName(string);
            topComponent.setToolTipText(I18nUtil.getBundle().getString("CTL_I18nDialogTitle"));
            workspaceArray = TopManager.getDefault().getWindowManager().getWorkspaces();
            int n = workspaceArray.length;
            while (--n >= 0) {
                Mode mode = workspaceArray[n].findMode(I18N_MODE);
                if (mode == null) {
                    mode = workspaceArray[n].createMode(I18N_MODE, I18nUtil.getBundle().getString("CTL_I18nDialogTitle"), (class$org$netbeans$modules$i18n$I18nManager == null ? I18nManager.class$("org.netbeans.modules.i18n.I18nManager") : class$org$netbeans$modules$i18n$I18nManager).getResource("/org/netbeans/modules/i18n/i18nAction.gif"));
                }
                mode.dockInto(topComponent);
            }
            this.topComponentWRef = new WeakReference<TopComponent>(topComponent);
        }
        topComponent.open();
        topComponent.requestFocus();
    }

    private void showDialog() {
        Caret caret;
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        if (topComponent != null && !topComponent.isOpened()) {
            topComponent.open();
            topComponent.requestFocus();
        }
        if ((caret = (Caret)this.caretWRef.get()) != null && !caret.isVisible()) {
            caret.setVisible(true);
        }
    }

    private void closeDialog() {
        TopComponent topComponent = (TopComponent)this.topComponentWRef.get();
        if (topComponent != null) {
            topComponent.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

