/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourcePanel;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;

public class I18nPanel
extends JPanel {
    private I18nString i18nString;
    private static ResourceBundle bundle;
    private PropertyChangeListener propListener;
    static final long serialVersionUID = -6982482491017390786L;
    private JButton skipButton;
    private JButton cancelButton;
    private JButton replaceButton;
    private JPanel resourcePanel;
    private JButton infoButton;
    private JPanel propertyPanel;
    private JPanel jPanel1;
    private JPanel buttonsPanel;
    private JButton helpButton;

    public I18nPanel(PropertyPanel propertyPanel) {
        this(propertyPanel, true);
    }

    public I18nPanel(PropertyPanel propertyPanel, boolean bl) {
        bundle = I18nUtil.getBundle();
        this.propertyPanel = propertyPanel;
        this.initComponents();
        this.initAccessibility();
        if (!bl) {
            this.remove(this.buttonsPanel);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (SwingUtilities.isDescendingFrom(this.replaceButton, this)) {
            this.getRootPane().setDefaultButton(this.replaceButton);
        }
    }

    public I18nString getI18nString() {
        return this.i18nString;
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        ((PropertyPanel)this.propertyPanel).setI18nString(i18nString);
        ((ResourcePanel)this.resourcePanel).setI18nString(i18nString);
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("property_resource".equals(propertyChangeEvent.getPropertyName())) {
                    I18nPanel.this.replaceButton.setEnabled(propertyChangeEvent.getNewValue() != null);
                    ((PropertyPanel)I18nPanel.this.propertyPanel).updateBundleKeys();
                }
            }
        };
        this.resourcePanel.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)this.resourcePanel));
        this.replaceButton.setEnabled(i18nString.getSupport().getResourceHolder().getResource() != null);
    }

    JButton getReplaceButton() {
        return this.replaceButton;
    }

    JButton getSkipButton() {
        return this.skipButton;
    }

    JButton getInfoButton() {
        return this.infoButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    private void buttonsEnableDisable() {
        boolean bl = this.i18nString.getSupport().getResourceHolder().getResource() != null;
        this.replaceButton.setEnabled(bl);
    }

    private JPanel createResourcePanel() {
        return new ResourcePanel();
    }

    private JPanel createPropertyPanel() {
        return new PropertyPanel();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_I18nPanel"));
        this.skipButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_CTL_SkipButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_CTL_CancelButton"));
        this.replaceButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_CTL_ReplaceButton"));
        this.infoButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_CTL_InfoButton"));
        this.helpButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("ACS_CTL_HelpButton"));
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.replaceButton = new JButton();
        this.skipButton = new JButton();
        this.infoButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.propertyPanel = this.propertyPanel;
        this.resourcePanel = this.createResourcePanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new GridLayout(1, 5, 5, 0));
        this.replaceButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_ReplaceButton_Mnem").charAt(0));
        this.replaceButton.setText(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_ReplaceButton"));
        this.buttonsPanel.add(this.replaceButton);
        this.skipButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_SkipButton_Mnem").charAt(0));
        this.skipButton.setText(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_SkipButton"));
        this.buttonsPanel.add(this.skipButton);
        this.infoButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_InfoButton_Mnem").charAt(0));
        this.infoButton.setText(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_InfoButton"));
        this.buttonsPanel.add(this.infoButton);
        this.cancelButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_CancelButton_Mnem").charAt(0));
        this.cancelButton.setText(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_CancelButton"));
        this.buttonsPanel.add(this.cancelButton);
        this.helpButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_HelpButton_Mnem").charAt(0));
        this.helpButton.setText(ResourceBundle.getBundle("org/netbeans/modules/i18n/Bundle").getString("CTL_HelpButton"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18nPanel.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.helpButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 11, 11);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.resourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        HelpCtx helpCtx = new HelpCtx("internation.autoinsert");
        String string = System.getProperty("org.openide.actions.HelpAction.DEBUG");
        if ("true".equals(string) || "full".equals(string)) {
            System.err.println("I18n module: Help button showing: " + helpCtx);
        }
        TopManager.getDefault().showHelp(helpCtx);
    }
}

