/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class I18nSupport {
    private I18nFinder finder;
    private I18nReplacer replacer;
    protected DataObject sourceDataObject;
    protected StyledDocument document;
    protected final ResourceHolder resourceHolder;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public I18nSupport(DataObject dataObject) {
        this.sourceDataObject = dataObject;
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = I18nSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (editorCookie == null) {
            throw new IllegalArgumentException("I18N: Illegal data object type" + dataObject);
        }
        this.document = editorCookie.getDocument();
        this.resourceHolder = this.createResourceHolder();
    }

    private void loadDocument() throws IOException {
        if (this.document == null) {
            EditorCookie editorCookie = (EditorCookie)this.sourceDataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = I18nSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            if (editorCookie == null) {
                throw new IllegalArgumentException("I18N: Illegal data object type" + this.sourceDataObject);
            }
            this.document = editorCookie.openDocument();
        }
    }

    protected abstract I18nFinder createFinder();

    protected abstract I18nReplacer createReplacer();

    protected abstract ResourceHolder createResourceHolder();

    public final I18nFinder getFinder() {
        if (this.finder == null) {
            this.finder = this.createFinder();
        }
        return this.finder;
    }

    public final I18nReplacer getReplacer() {
        if (this.replacer == null) {
            this.replacer = this.createReplacer();
        }
        return this.replacer;
    }

    public final DataObject getSourceDataObject() {
        return this.sourceDataObject;
    }

    public final StyledDocument getDocument() {
        return this.document;
    }

    public I18nString getDefaultI18nString() {
        return this.getDefaultI18nString(null);
    }

    public abstract I18nString getDefaultI18nString(HardCodedString var1);

    public abstract JPanel getInfo(HardCodedString var1);

    public ResourceHolder getResourceHolder() {
        return this.resourceHolder;
    }

    public PropertyPanel getPropertyPanel() {
        return new PropertyPanel();
    }

    public boolean hasAdditionalCustomizer() {
        return false;
    }

    public JPanel getAdditionalCustomizer() {
        return null;
    }

    public void performAdditionalChanges() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class Factory {
        public I18nSupport create(DataObject dataObject) throws IOException {
            I18nSupport i18nSupport = this.createI18nSupport(dataObject);
            i18nSupport.loadDocument();
            return i18nSupport;
        }

        protected abstract I18nSupport createI18nSupport(DataObject var1);

        public abstract Class getDataObjectClass();
    }

    public static interface I18nReplacer {
        public void replace(HardCodedString var1, I18nString var2);
    }

    public static interface I18nFinder {
        public HardCodedString findNextHardCodedString();

        public HardCodedString[] findAllHardCodedStrings();

        public HardCodedString findNextI18nString();

        public HardCodedString[] findAllI18nStrings();
    }
}

