/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.UserCancelException;

public class ResourcePanel
extends JPanel {
    public static final String PROP_RESOURCE = "property_resource";
    private I18nString i18nString;
    private JButton newButton;
    private JButton browseButton;
    private JPanel jPanel1;
    private JTextField resourceText;
    private JLabel resourceLabel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public ResourcePanel() {
        this.initComponents();
        this.initAccessibility();
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateValues();
    }

    private void updateValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
    }

    private void changeResource(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException();
        }
        DataObject dataObject2 = this.i18nString.getSupport().getResourceHolder().getResource();
        if (dataObject2 != null && dataObject2.equals(dataObject)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(dataObject);
        this.updateValues();
        this.firePropertyChange(PROP_RESOURCE, dataObject2, dataObject);
        I18nUtil.getOptions().setLastResource(dataObject);
    }

    private void resourceTextActionPerformedDelegate(ActionEvent actionEvent) {
        DataObject dataObject = this.findResource(this.resourceText.getText());
        if (dataObject != null) {
            this.changeResource(dataObject);
        } else {
            this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        }
    }

    private DataObject findResource(String string) {
        try {
            string = string.replace('.', '/');
            String string2 = string + ".properties";
            FileObject fileObject = null;
            Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
            while (enumeration.hasMoreElements()) {
                fileObject = ((FileSystem)enumeration.nextElement()).findResource(string2);
                if (fileObject != null) break;
            }
            if (fileObject == null) {
                return null;
            }
            DataObject dataObject = TopManager.getDefault().getLoaderPool().findDataObject(fileObject);
            if (this.isResourceClass(dataObject.getClass())) {
                return dataObject;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject dataObject) {
        if (dataObject == null) {
            return "";
        }
        return dataObject.getPrimaryFile().getPackageName('.');
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourcePanel"));
        this.newButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_NewButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void initComponents() {
        this.resourceLabel = new JLabel();
        this.resourceText = new JTextField();
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.newButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.resourceLabel.setText(I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceLabel.setLabelFor(this.resourceText);
        this.resourceLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_BundleName_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.resourceLabel, gridBagConstraints);
        this.resourceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.resourceTextActionPerformed(actionEvent);
            }
        });
        this.resourceText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ResourcePanel.this.resourceTextFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.resourceText, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        this.browseButton.setMnemonic(I18nUtil.getBundle().getString("CTL_BrowseButton_Mnem").charAt(0));
        this.browseButton.setText(I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.browseButton);
        this.newButton.setMnemonic(I18nUtil.getBundle().getString("CTL_NewButton_Mnem").charAt(0));
        this.newButton.setText(I18nUtil.getBundle().getString("CTL_NewButton"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.newButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 0, 11, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataObject dataObject = this.i18nString.getSupport().getResourceHolder().getTemplate(this.i18nString.getSupport().getResourceHolder().getResourceClasses()[0]);
            DataObject dataObject2 = ResourcePanel.instantiateTemplate(dataObject);
            if (dataObject2 != null) {
                this.changeResource(dataObject2);
            }
        }
        catch (UserCancelException userCancelException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("I18N module: User cancelled selection");
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        block3: {
            DataFilter dataFilter = new DataFilter(){

                public boolean acceptDataObject(DataObject dataObject) {
                    return dataObject instanceof DataFolder || ResourcePanel.this.isResourceClass(dataObject.getClass());
                }
            };
            Node node = TopManager.getDefault().getPlaces().nodes().repository(dataFilter);
            try {
                DataObject dataObject = (DataObject)TopManager.getDefault().getNodeOperation().select(I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_Title"), I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_RootTitle"), node, new NodeAcceptor(){
                    static /* synthetic */ Class class$org$openide$loaders$DataObject;

                    public boolean acceptNodes(Node[] nodeArray) {
                        if (nodeArray == null || nodeArray.length != 1) {
                            return false;
                        }
                        Node.Cookie cookie = nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 6.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                        if (cookie == null) {
                            return false;
                        }
                        return ResourcePanel.this.isResourceClass(cookie.getClass());
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                })[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourcePanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (dataObject != null) {
                    this.changeResource(dataObject);
                }
            }
            catch (UserCancelException userCancelException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                System.err.println("I18N module: User cancelled selection");
            }
        }
    }

    private void resourceTextFocusLost(FocusEvent focusEvent) {
        this.resourceTextActionPerformedDelegate(new ActionEvent(focusEvent.getSource(), focusEvent.getID(), null));
    }

    private void resourceTextActionPerformed(ActionEvent actionEvent) {
        this.resourceTextActionPerformedDelegate(actionEvent);
    }

    public static DataObject instantiateTemplate(DataObject dataObject) throws IOException {
        ObjectNameInputPanel objectNameInputPanel = new ObjectNameInputPanel();
        DataFilter dataFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject dataObject) {
                return dataObject instanceof DataFolder;
            }
        };
        Node node = TopManager.getDefault().getPlaces().nodes().repository(dataFilter);
        DataFolder dataFolder = (DataFolder)TopManager.getDefault().getNodeOperation().select(I18nUtil.getBundle().getString("CTL_Template_Dialog_Title"), I18nUtil.getBundle().getString("CTL_Template_Dialog_RootTitle"), node, new NodeAcceptor(){
            static /* synthetic */ Class class$org$openide$loaders$DataFolder;

            public boolean acceptNodes(Node[] nodeArray) {
                if (nodeArray == null || nodeArray.length != 1) {
                    return false;
                }
                DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 8.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                return dataFolder != null && !dataFolder.getPrimaryFile().isReadOnly();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, (Component)objectNameInputPanel)[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ResourcePanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        String string = objectNameInputPanel.getText();
        DataObject dataObject2 = string.equals("") ? dataObject.createFromTemplate(dataFolder) : dataObject.createFromTemplate(dataFolder, string);
        try {
            return dataObject2;
        }
        catch (ClassCastException classCastException) {
            throw new UserCancelException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ObjectNameInputPanel
    extends JPanel {
        static final long serialVersionUID = 1980214734060402958L;
        JTextField text;

        public ObjectNameInputPanel() {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            borderLayout.setHgap(5);
            this.setLayout(borderLayout);
            String string = I18nUtil.getBundle().getString("LBL_TemplateName");
            JLabel jLabel = new JLabel(string.replace('&', ' '));
            this.text = new JTextField();
            this.text.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_TEXT_ObjectNameInputPanel"));
            jLabel.setDisplayedMnemonic(string.charAt(string.indexOf(38) + 1));
            jLabel.setLabelFor(this.text);
            this.add("West", jLabel);
            this.add("Center", this.text);
        }

        public void requestFocus() {
            this.text.requestFocus();
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String string) {
            this.setText(string);
        }
    }
}

