/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.NbDocument;
import org.openide.util.MapFormat;

public class JavaI18nSupport
extends I18nSupport {
    protected int modifiers = 26;
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public JavaI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    public I18nString getDefaultI18nString(HardCodedString hardCodedString) {
        JavaI18nString javaI18nString = new JavaI18nString(this);
        if (javaI18nString.getSupport().getResourceHolder().getResource() == null && I18nUtil.getOptions().getLastResource() != null) {
            javaI18nString.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource());
        }
        if (hardCodedString == null) {
            return javaI18nString;
        }
        javaI18nString.setComment("");
        javaI18nString.setKey(hardCodedString.getText().replace(' ', '_'));
        javaI18nString.setValue(hardCodedString.getText());
        if (this.isGenerateField() && javaI18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
            javaI18nString.setReplaceFormat((String)I18nUtil.getReplaceFormatItems().get(0));
        }
        return javaI18nString;
    }

    public JPanel getInfo(HardCodedString hardCodedString) {
        return new JavaInfoPanel(hardCodedString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean bl) {
        this.generateField = bl;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String string) {
        this.initFormat = string;
    }

    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    public boolean hasAdditionalCustomizer() {
        return true;
    }

    public JPanel getAdditionalCustomizer() {
        return new JavaReplacePanel(this);
    }

    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String string;
        try {
            string = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException nullPointerException) {
            this.identifier = "";
            return;
        }
        string = string.length() > 0 ? string.substring(0, 1).toLowerCase() + string.substring(1) : string.toLowerCase();
        this.identifier = string;
    }

    private void createField() {
        block7: {
            if (!this.isGenerateField()) {
                return;
            }
            ClassElement classElement = this.getSourceClassElement();
            if (classElement.getField(Identifier.create((String)this.getIdentifier())) != null) {
                return;
            }
            try {
                FieldElement fieldElement = new FieldElement();
                fieldElement.setName(Identifier.create((String)this.getIdentifier()));
                fieldElement.setModifiers(this.getModifiers());
                fieldElement.setType(Type.parse((String)"java.util.ResourceBundle"));
                fieldElement.setInitValue(this.getInitString());
                if (classElement != null) {
                    classElement.addField(fieldElement);
                }
            }
            catch (SourceException sourceException) {
                if (I18nUtil.isDebug()) {
                    sourceException.printStackTrace();
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!I18nUtil.isDebug()) break block7;
                nullPointerException.printStackTrace();
            }
        }
    }

    public String getInitString() {
        String string = this.getInitFormat();
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("bundleNameSlashes", this.resourceHolder.getResource().getPrimaryFile().getPackageName('/'));
        hashMap.put("bundleNameDots", this.resourceHolder.getResource().getPrimaryFile().getPackageName('.'));
        hashMap.put("sourceFileName", this.sourceDataObject == null ? "" : this.sourceDataObject.getPrimaryFile().getName());
        return MapFormat.format((String)string, hashMap);
    }

    private ClassElement getSourceClassElement() {
        SourceElement sourceElement = ((SourceCookie)this.sourceDataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JavaI18nSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)).getSource();
        ClassElement classElement = sourceElement.getClass(Identifier.create((String)this.sourceDataObject.getName()));
        if (classElement != null) {
            return classElement;
        }
        ClassElement[] classElementArray = sourceElement.getClasses();
        int n = 0;
        while (n < classElementArray.length) {
            int n2 = classElementArray[n].getModifiers();
            if (classElementArray[n].isClass() && Modifier.isPublic(n2)) {
                classElement = classElementArray[n];
                break;
            }
            ++n;
        }
        return classElement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Factory
    extends I18nSupport.Factory {
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, TopManager.getDefault().systemClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
            super(hardCodedString, styledDocument);
        }

        protected void setHardCodedString(HardCodedString hardCodedString, StyledDocument styledDocument) {
            String string;
            this.getStringText().setText(hardCodedString == null ? "" : hardCodedString.getText());
            if (hardCodedString.getStartPosition() == null) {
                string = "";
            } else {
                int n = hardCodedString.getStartPosition().getOffset();
                try {
                    Element element = styledDocument.getParagraphElement(n);
                    string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            }
            this.getFoundInText().setText(string);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        public void replace(HardCodedString hardCodedString, I18nString i18nString) {
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            String string = i18nString.getReplaceString();
            StyledDocument styledDocument = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(this, hardCodedString, styledDocument, string){
                private final /* synthetic */ HardCodedString val$hcString;
                private final /* synthetic */ StyledDocument val$document;
                private final /* synthetic */ String val$newCode;
                private final /* synthetic */ JavaI18nReplacer this$0;
                {
                    this.this$0 = javaI18nReplacer;
                    this.val$hcString = hardCodedString;
                    this.val$document = styledDocument;
                    this.val$newCode = string;
                }

                public void run() {
                    try {
                        if (this.val$hcString.getLength() > 0) {
                            this.val$document.remove(this.val$hcString.getStartPosition().getOffset(), this.val$hcString.getLength());
                        }
                        if (this.val$newCode != null && this.val$newCode.length() > 0) {
                            this.val$document.insertString(this.val$hcString.getEndPosition().getOffset(), this.val$newCode, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CouldNotReplace"), 0);
                        TopManager.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    public static class JavaI18nFinder
    implements I18nSupport.I18nFinder {
        protected static final int STATE_JAVA = 0;
        protected static final int STATE_JAVA_A_SLASH = 1;
        protected static final int STATE_LINECOMMENT = 2;
        protected static final int STATE_BLOCKCOMMENT = 3;
        protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
        protected static final int STATE_STRING = 5;
        protected static final int STATE_STRING_A_BSLASH = 6;
        protected static final int STATE_CHAR = 7;
        protected StyledDocument document;
        protected int state;
        protected boolean i18nSearch;
        protected Position lastPosition;
        protected StringBuffer lastJavaString;
        protected char[] buffer;
        protected int position;
        protected int currentStringStart;
        protected int currentStringEnd;

        public JavaI18nFinder(StyledDocument styledDocument) {
            this.document = styledDocument;
            this.init();
        }

        private void init() {
            this.state = 0;
            this.initJavaStringBuffer();
            this.lastPosition = null;
        }

        protected void reset() {
            this.init();
        }

        public HardCodedString[] findAllHardCodedStrings() {
            this.reset();
            this.i18nSearch = false;
            return this.findAllStrings();
        }

        public HardCodedString findNextHardCodedString() {
            this.i18nSearch = false;
            return this.findNextString();
        }

        public HardCodedString[] findAllI18nStrings() {
            this.reset();
            this.i18nSearch = true;
            return this.findAllStrings();
        }

        public HardCodedString findNextI18nString() {
            this.i18nSearch = true;
            return this.findNextString();
        }

        protected HardCodedString[] findAllStrings() {
            HardCodedString hardCodedString;
            ArrayList<HardCodedString> arrayList = new ArrayList<HardCodedString>();
            while ((hardCodedString = this.findNextString()) != null) {
                arrayList.add(hardCodedString);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            HardCodedString[] hardCodedStringArray = new HardCodedString[arrayList.size()];
            arrayList.toArray(hardCodedStringArray);
            return hardCodedStringArray;
        }

        protected HardCodedString findNextString() {
            try {
                this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exception")) {
                    badLocationException.printStackTrace();
                }
                return null;
            }
            this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            while (this.position < this.buffer.length) {
                char c = this.buffer[this.position];
                if (c != '\n') {
                    HardCodedString hardCodedString = this.handleCharacter(c);
                    if (hardCodedString != null) {
                        return hardCodedString;
                    }
                } else {
                    this.handleNewLineCharacter();
                }
                ++this.position;
            }
            return null;
        }

        protected HardCodedString handleCharacter(char c) {
            if (this.state == 0) {
                return this.handleStateJava(c);
            }
            if (this.state == 1) {
                return this.handleStateJavaASlash(c);
            }
            if (this.state == 7) {
                return this.handleStateChar(c);
            }
            if (this.state == 6) {
                return this.handleStateStringABSlash(c);
            }
            if (this.state == 2) {
                return this.handleStateLineComment(c);
            }
            if (this.state == 3) {
                return this.handleStateBlockComment(c);
            }
            if (this.state == 4) {
                return this.handleStateBlockCommentAStar(c);
            }
            if (this.state == 5) {
                return this.handleStateString(c);
            }
            return null;
        }

        protected void handleNewLineCharacter() {
            if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
                this.initJavaStringBuffer();
                this.currentStringStart = -1;
                this.currentStringEnd = -1;
                this.state = 0;
            } else if (this.state == 3 || this.state == 4) {
                this.state = 3;
            }
        }

        protected HardCodedString handleStateJava(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 1;
            } else if (c == '\"') {
                this.state = 5;
                if (this.currentStringStart == -1) {
                    this.currentStringStart = this.position;
                }
            } else if (c == '\'') {
                this.state = 7;
            }
            return null;
        }

        protected HardCodedString handleStateJavaASlash(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 2;
            } else if (c == '*') {
                this.state = 3;
            }
            return null;
        }

        protected HardCodedString handleStateChar(char c) {
            this.lastJavaString.append(c);
            if (c == '\'') {
                this.state = 0;
            }
            return null;
        }

        protected HardCodedString handleStateStringABSlash(char c) {
            this.state = 5;
            return null;
        }

        protected HardCodedString handleStateLineComment(char c) {
            return null;
        }

        protected HardCodedString handleStateBlockComment(char c) {
            if (c == '*') {
                this.state = 4;
            }
            return null;
        }

        protected HardCodedString handleStateBlockCommentAStar(char c) {
            if (c == '/') {
                this.state = 0;
                this.initJavaStringBuffer();
            } else if (c != '*') {
                this.state = 3;
            }
            return null;
        }

        protected HardCodedString handleStateString(char c) {
            if (c == '\\') {
                this.state = 6;
            } else if (c == '\"') {
                this.state = 0;
                if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                    this.currentStringEnd = this.position + 1;
                    int n = this.currentStringEnd - this.currentStringStart;
                    try {
                        try {
                            Position position = this.document.createPosition(this.currentStringStart);
                            Position position2 = this.document.createPosition(this.currentStringEnd);
                            String string = this.document.getText(position.getOffset(), n);
                            String string2 = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                            int n2 = string2.indexOf(10);
                            if (n2 == -1) {
                                n2 = string2.length();
                            }
                            this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, string.length()));
                            String string3 = this.document.getText(this.currentStringStart + 1 + string.length(), this.currentStringEnd + n2 - this.currentStringStart - string.length());
                            this.lastJavaString.append(string3.replace('\"', '_'));
                            if (this.isSearchedString(this.lastJavaString.toString(), string)) {
                                this.lastPosition = position2;
                                HardCodedString hardCodedString = new HardCodedString(this.extractString(string), position, position2);
                                Object var11_11 = null;
                                this.currentStringStart = -1;
                                this.currentStringEnd = -1;
                                this.initJavaStringBuffer();
                                return hardCodedString;
                            }
                            Object var11_12 = null;
                            this.currentStringStart = -1;
                            this.currentStringEnd = -1;
                            this.initJavaStringBuffer();
                        }
                        catch (BadLocationException badLocationException) {
                            if (I18nUtil.isDebug()) {
                                badLocationException.printStackTrace();
                            }
                            Object var11_13 = null;
                            this.currentStringStart = -1;
                            this.currentStringEnd = -1;
                            this.initJavaStringBuffer();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        this.currentStringStart = -1;
                        this.currentStringEnd = -1;
                        this.initJavaStringBuffer();
                        throw throwable;
                    }
                }
            }
            return null;
        }

        private void initJavaStringBuffer() {
            this.lastJavaString = new StringBuffer();
        }

        private String extractString(String string) {
            if (string == null) {
                return "";
            }
            if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        protected boolean isSearchedString(String string, String string2) {
            String string3 = this.createRegularExpression(string2);
            try {
                if (new RE(string3).match(UtilConvert.unicodesToChars((String)string))) {
                    return this.i18nSearch;
                }
            }
            catch (RESyntaxException rESyntaxException) {
                if (I18nUtil.isDebug()) {
                    rESyntaxException.printStackTrace();
                }
                String string4 = MessageFormat.format(I18nUtil.getBundle().getString("MSG_RegExpCompileError"), string2);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string4, 0, 0);
                return NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation));
            }
            return !this.i18nSearch;
        }

        private String createRegularExpression(String string) {
            string = JavaI18nFinder.escapeMetaCharacters(string);
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            hashMap.put("key", string);
            hashMap.put("hardString", string);
            return MapFormat.format((String)(this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression()), hashMap);
        }

        private static String escapeMetaCharacters(String string) {
            if (string == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

