/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AdditionalWizardPanel
extends JPanel {
    private final Map sourceMap = I18nUtil.createWizardSettings();
    private final Set viewedSources = new HashSet(0);
    private JComponent additionalComponent = EMPTY_COMPONENT;
    private static final JLabel EMPTY_COMPONENT = new JLabel(Util.getString("TXT_HasNoAdditonal"));
    private JComboBox sourceCombo;
    private JLabel sourceLabel;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel;

    private AdditionalWizardPanel() {
        this.initComponents();
        this.initA11Y();
        this.setComboModel(this.sourceMap);
    }

    private void initA11Y() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.sourceLabel.setDisplayedMnemonic(Util.getString("LBL_Source_Mnem").charAt(0));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_sourceCombo"));
    }

    private void setComboModel(Map map) {
        Object[] objectArray = map.keySet().toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (((SourceData)map.get(objectArray[n])).getSupport().hasAdditionalCustomizer()) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        Object object = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent(object);
    }

    Set getViewedSources() {
        return this.viewedSources;
    }

    Map getSourceMap() {
        return this.sourceMap;
    }

    void setSourceMap(Map map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.setComboModel(map);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.sourceLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel = AdditionalWizardPanel.class$("org.netbeans.modules.i18n.wizard.AdditionalWizardPanel")) : class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel)).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalWizardPanel.this.sourceComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent actionEvent) {
        Object object = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent(object);
    }

    private void updateAdditionalComponent(Object object) {
        I18nSupport i18nSupport = null;
        if (object != null) {
            i18nSupport = ((SourceData)this.sourceMap.get(object)).getSupport();
        }
        this.remove(this.additionalComponent);
        if (i18nSupport != null && i18nSupport.hasAdditionalCustomizer()) {
            this.additionalComponent = i18nSupport.getAdditionalCustomizer();
            this.viewedSources.add(object);
        } else {
            this.additionalComponent = EMPTY_COMPONENT;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.additionalComponent, gridBagConstraints);
        this.revalidate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final JLabel emptyLabel;
        private final AdditionalWizardPanel additionalPanel = new AdditionalWizardPanel();
        static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel;

        Panel() {
            this.emptyLabel = new JLabel(Util.getString("TXT_HasNoAdditonal"));
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        protected Component createComponent() {
            JPanel jPanel = new JPanel();
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.AdditionalWizardPanel")) : class$org$netbeans$modules$i18n$wizard$AdditionalWizardPanel)).getString("ACS_AdditionalWizardPanel"));
            jPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
            jPanel.setName(NbBundle.getBundle(this.getClass()).getString("TXT_ModifyAdditional"));
            jPanel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.additionalPanel, gridBagConstraints);
            return jPanel;
        }

        public void readSettings(Object object) {
            this.additionalPanel.setSourceMap((Map)object);
            JPanel jPanel = (JPanel)this.getComponent();
            if (Panel.hasAdditional((Map)object)) {
                if (jPanel.isAncestorOf(this.emptyLabel)) {
                    jPanel.remove(this.emptyLabel);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 1;
                    jPanel.add((Component)this.additionalPanel, gridBagConstraints);
                }
            } else if (jPanel.isAncestorOf(this.additionalPanel)) {
                jPanel.remove(this.additionalPanel);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                jPanel.add((Component)this.emptyLabel, gridBagConstraints);
            }
        }

        public void storeSettings(Object object) {
            Map map = this.additionalPanel.getSourceMap();
            Iterator iterator = this.additionalPanel.getViewedSources().iterator();
            while (iterator.hasNext()) {
                SourceData sourceData = (SourceData)map.get(iterator.next());
                Object[] objectArray = sourceData.getStringMap().keySet().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    sourceData.getStringMap().put(objectArray[n], sourceData.getSupport().getDefaultI18nString((HardCodedString)objectArray[n]));
                    ++n;
                }
            }
            ((Map)object).clear();
            ((Map)object).putAll(map);
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressWizardPanel = new ProgressWizardPanel(true);
            this.showProgressPanel(progressWizardPanel);
            progressWizardPanel.setMainText(NbBundle.getBundle(this.getClass()).getString("LBL_AdditionalIn"));
            progressWizardPanel.setMainProgress(0);
            Map map = ((AdditionalWizardPanel)this.getComponent()).getSourceMap();
            Iterator iterator = ((AdditionalWizardPanel)this.getComponent()).getViewedSources().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                DataObject dataObject = (DataObject)iterator.next();
                SourceData sourceData = (SourceData)map.get(dataObject);
                progressWizardPanel.setMainText(NbBundle.getBundle(this.getClass()).getString("LBL_AdditionalIn") + " " + dataObject.getPrimaryFile().getPackageName('.'));
                Object[] objectArray = sourceData.getStringMap().keySet().toArray();
                int n2 = 0;
                while (n < objectArray.length) {
                    sourceData.getStringMap().put(objectArray[n2], sourceData.getSupport().getDefaultI18nString((HardCodedString)objectArray[n2]));
                    ++n2;
                }
                progressWizardPanel.setMainProgress((int)((float)(n + 1) / (float)map.size() * 100.0f));
                ++n;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressWizardPanel) {
            ((Container)this.getComponent()).remove(this.additionalPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressWizardPanel, gridBagConstraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.additionalPanel)) {
                container.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                container.add((Component)this.additionalPanel, gridBagConstraints);
            }
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.wizard");
        }

        private static boolean hasAdditional(Map map) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                SourceData sourceData = (SourceData)map.get(iterator.next());
                if (!sourceData.getSupport().hasAdditionalCustomizer()) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

