/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.TopManager;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class SourceWizardPanel
extends JPanel {
    private final Map sourceMap = I18nUtil.createWizardSettings();
    private final Panel descPanel;
    private boolean testRole = false;
    private JList sourcesList;
    private JButton addButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTextArea descTextArea;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$SourceWizardPanel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    private SourceWizardPanel(Panel panel, boolean bl) {
        this.descPanel = panel;
        this.testRole = bl;
        this.initComponents();
        this.postInitComponents();
        this.initAccessibility();
        this.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
        this.initList();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.sourcesList.setListData(map.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private void postInitComponents() {
        this.addButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_AddSource_Mnem").charAt(0));
        this.removeButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_RemoveSource_Mnem").charAt(0));
    }

    private String getPanelDescription() {
        if (!this.testRole) {
            return Util.getString("MSG_SourcesPanel_desc");
        }
        return Util.getString("MSG_SourcesPanel_test_desc");
    }

    private void initList() {
        this.sourcesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SourceWizardPanel.this.removeButton.setEnabled(!SourceWizardPanel.this.sourcesList.isSelectionEmpty());
            }
        });
        this.removeButton.setEnabled(!this.sourcesList.isSelectionEmpty());
    }

    private void initAccessibility() {
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("ACS_CTL_AddSource"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("ACS_CTL_RemoveSource"));
        this.sourcesList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("ACS_sourcesList"));
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(this.getPanelDescription());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.sourcesList.setCellRenderer(new DataObjectListCellRenderer());
        this.jScrollPane1.setViewportView(this.sourcesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("CTL_AddSource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceWizardPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("CTL_RemoveSource"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceWizardPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.sourcesList.getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            this.sourceMap.remove(objectArray[n]);
            ++n;
        }
        this.sourcesList.setListData(this.sourceMap.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        block6: {
            DataFilter dataFilter = new DataFilter(){

                public boolean acceptDataObject(DataObject dataObject) {
                    return dataObject instanceof DataFolder || FactoryRegistry.hasFactory(dataObject.getClass());
                }
            };
            Node node = TopManager.getDefault().getPlaces().nodes().repository(dataFilter);
            try {
                Node[] nodeArray = TopManager.getDefault().getNodeOperation().select(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("LBL_SelectSources"), NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = SourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("LBL_Filesystems"), node, new NodeAcceptor(){
                    static /* synthetic */ Class class$org$openide$loaders$DataObject;

                    public boolean acceptNodes(Node[] nodeArray) {
                        if (nodeArray == null || nodeArray.length == 0) {
                            return false;
                        }
                        int n = 0;
                        while (n < nodeArray.length) {
                            DataObject dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? 5.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                            if (dataObject == null) {
                                return false;
                            }
                            if (dataObject instanceof DataFolder && I18nUtil.containsAcceptedDataObject((DataFolder)dataObject)) {
                                return true;
                            }
                            if (FactoryRegistry.hasFactory(dataObject.getClass())) {
                                return true;
                            }
                            ++n;
                        }
                        return false;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
                int n = 0;
                while (n < nodeArray.length) {
                    DataObject dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? SourceWizardPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (dataObject instanceof DataFolder) {
                        Iterator iterator = I18nUtil.getAcceptedDataObjects((DataFolder)dataObject).iterator();
                        while (iterator.hasNext()) {
                            I18nUtil.addSource(this.sourceMap, (DataObject)iterator.next());
                        }
                    } else {
                        I18nUtil.addSource(this.sourceMap, (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? SourceWizardPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject));
                    }
                    ++n;
                }
                this.sourcesList.setListData(this.sourceMap.keySet().toArray());
                this.descPanel.fireStateChanged();
            }
            catch (UserCancelException userCancelException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                System.err.println("I18N: User cancelled selection");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final boolean testWizard;
        static /* synthetic */ Class class$org$netbeans$modules$i18n$wizard$SourceWizardPanel;

        public Panel() {
            this(false);
        }

        public Panel(boolean bl) {
            this.testWizard = bl;
        }

        protected Component createComponent() {
            SourceWizardPanel sourceWizardPanel = new SourceWizardPanel(this, this.testWizard);
            if (this.testWizard) {
                sourceWizardPanel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("TXT_SelecTestSources"));
            } else {
                sourceWizardPanel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("TXT_SelectSources"));
            }
            ((Component)sourceWizardPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$SourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$SourceWizardPanel = Panel.class$("org.netbeans.modules.i18n.wizard.SourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$SourceWizardPanel)).getString("ACS_SourceWizardPanel"));
            return sourceWizardPanel;
        }

        public boolean isValid() {
            return !((SourceWizardPanel)this.getComponent()).getSourceMap().isEmpty();
        }

        public void readSettings(Object object) {
            ((SourceWizardPanel)this.getComponent()).setSourceMap((Map)object);
        }

        public void storeSettings(Object object) {
            ((Map)object).clear();
            ((Map)object).putAll(((SourceWizardPanel)this.getComponent()).getSourceMap());
        }

        public HelpCtx getHelp() {
            if (this.testWizard) {
                return new HelpCtx("internation.testing");
            }
            return new HelpCtx("internation.wizard");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class DataObjectListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            DataObject dataObject = (DataObject)object;
            if (dataObject != null) {
                jLabel.setText(dataObject.getPrimaryFile().getPackageName('.'));
                jLabel.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
            } else {
                jLabel.setText("");
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }
}

