/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class PyException
extends RuntimeException {
    public PyObject type;
    public PyObject value = Py.None;
    public PyTraceback traceback;
    private boolean instantiated = false;
    private boolean printingStackTrace = false;

    public void instantiate() {
        if (!this.instantiated) {
            if (!(!(this.type instanceof PyClass) || this.value instanceof PyInstance && __builtin__.isinstance(this.value, (PyClass)this.type))) {
                this.value = this.value instanceof PyTuple ? ((PyClass)this.type).__call__(((PyTuple)this.value).list) : (this.value == Py.None ? ((PyClass)this.type).__call__(Py.EmptyObjects) : ((PyClass)this.type).__call__(new PyObject[]{this.value}));
            }
            this.instantiated = true;
        }
    }

    public PyException() {
        this(Py.None, Py.None);
    }

    public PyException(PyObject pyObject) {
        this(pyObject, Py.None);
    }

    public PyException(PyObject pyObject, PyObject pyObject2) {
        this.type = pyObject;
        this.value = pyObject2;
        PyFrame pyFrame = Py.getFrame();
        this.traceback = new PyTraceback(pyFrame);
        if (pyFrame != null && pyFrame.tracefunc != null) {
            pyFrame.tracefunc = pyFrame.tracefunc.traceException(pyFrame, this);
        }
    }

    public PyException(PyObject pyObject, String string) {
        this(pyObject, new PyString(string));
    }

    public PyException(PyObject pyObject, PyObject pyObject2, PyTraceback pyTraceback) {
        this.type = pyObject;
        this.value = pyObject2;
        this.traceback = pyTraceback;
    }

    public void printStackTrace() {
        Py.printException(this);
    }

    public synchronized void printStackTrace(PrintStream printStream) {
        if (this.printingStackTrace) {
            super.printStackTrace(printStream);
        } else {
            try {
                this.printingStackTrace = true;
                Py.printException(this, null, new PyFile(printStream));
                Object var3_2 = null;
                this.printingStackTrace = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.printingStackTrace = false;
                throw throwable;
            }
        }
    }

    public synchronized void super__printStackTrace(PrintWriter printWriter) {
        try {
            this.printingStackTrace = true;
            super.printStackTrace(printWriter);
            Object var3_2 = null;
            this.printingStackTrace = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.printingStackTrace = false;
            throw throwable;
        }
    }

    public synchronized String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!this.printingStackTrace) {
            this.printStackTrace(new PrintStream(byteArrayOutputStream));
        }
        return byteArrayOutputStream.toString();
    }
}

