/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class codecs {
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath = new PyList();
    private static PyStringMap searchCache = new PyStringMap();
    private static String default_encoding = "ascii";
    private static boolean import_encodings_called = false;

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String string) {
        codecs.lookup(string);
        default_encoding = string;
    }

    public static void register(PyObject pyObject) {
        if (!pyObject.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(pyObject);
    }

    public static PyTuple lookup(String string) {
        codecs.import_encodings();
        PyString pyString = new PyString(codecs.normalizestring(string));
        PyObject pyObject = searchCache.__finditem__(pyString);
        if (pyObject != null) {
            return (PyTuple)pyObject;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding");
        }
        int n = 0;
        PyObject pyObject2 = null;
        while ((pyObject2 = searchPath.__finditem__(n)) != null) {
            pyObject = pyObject2.__call__(pyString);
            if (pyObject != Py.None) {
                if (pyObject instanceof PyTuple && pyObject.__len__() == 4) break;
                throw Py.TypeError("codec search functions must return 4-tuples");
            }
            ++n;
        }
        if (n == searchPath.__len__()) {
            throw new PyException(Py.LookupError, "unknown encoding " + string);
        }
        searchCache.__setitem__(pyString, pyObject);
        return (PyTuple)pyObject;
    }

    private static String normalizestring(String string) {
        return string.toLowerCase().replace(' ', '-');
    }

    private static void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    __builtin__.__import__("encodings");
                }
                catch (PyException pyException) {
                    if (pyException.type == Py.ImportError) break block3;
                    throw pyException;
                }
            }
        }
    }

    public static PyString decode(PyString pyString, String string, String string2) {
        if (string == null) {
            string = codecs.getDefaultEncoding();
        }
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (string.equals("ascii")) {
            return new PyString(codecs.PyUnicode_DecodeASCII(pyString.toString(), pyString.__len__(), string2));
        }
        PyObject pyObject = codecs.getDecoder(string);
        PyObject pyObject2 = pyObject.__call__(pyString, new PyString(string2));
        if (!(pyObject2 instanceof PyTuple) || pyObject2.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return pyObject2.__getitem__(0).__str__();
    }

    private static PyObject getDecoder(String string) {
        PyTuple pyTuple = codecs.lookup(string);
        return pyTuple.__getitem__(1);
    }

    public static PyString encode(PyString pyString, String string, String string2) {
        if (string == null) {
            string = codecs.getDefaultEncoding();
        }
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (string.equals("ascii")) {
            return new PyString(codecs.PyUnicode_EncodeASCII(pyString.toString(), pyString.__len__(), string2));
        }
        PyObject pyObject = codecs.getEncoder(string);
        PyObject pyObject2 = pyObject.__call__(pyString, new PyString(string2));
        if (!(pyObject2 instanceof PyTuple) || pyObject2.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        return pyObject2.__getitem__(0).__str__();
    }

    private static PyObject getEncoder(String string) {
        PyTuple pyTuple = codecs.lookup(string);
        return pyTuple.__getitem__(0);
    }

    public static String PyUnicode_DecodeASCII(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                stringBuffer.append(c);
            } else {
                codecs.decoding_error("ascii", stringBuffer, string2, "ordinal not in range(128)");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String PyUnicode_EncodeASCII(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= '\u0080') {
                codecs.encoding_error("ascii", stringBuffer, string2, "ordinal not in range(128)");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void encoding_error(String string, StringBuffer stringBuffer, String string2, String string3) {
        if (string2 == null || string2 == "strict") {
            throw Py.UnicodeError(string + " encoding error: " + string3);
        }
        if (string2 != "ignore") {
            if (string2 == "replace") {
                stringBuffer.append('?');
            } else {
                throw Py.ValueError(string + " encoding error; unknown error handling code: " + string2);
            }
        }
    }

    public static void decoding_error(String string, StringBuffer stringBuffer, String string2, String string3) {
        if (string2 == null || string2 == "strict") {
            throw Py.UnicodeError(string + " decoding error: " + string3);
        }
        if (string2 != "ignore") {
            if (string2 == "replace") {
                if (stringBuffer != null) {
                    stringBuffer.append(Py_UNICODE_REPLACEMENT_CHARACTER);
                }
            } else {
                throw Py.ValueError(string + " decoding error; unknown error handling code: " + string2);
            }
        }
    }
}

