/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammar;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.Visitor;

public class SimpleNode
implements Node {
    protected Node parent;
    public SimpleNode[] children;
    public int id;
    protected PythonGrammar parser;
    public int endLine;
    public int endColumn;
    public int beginLine;
    public int beginColumn;
    Object info;
    public int aug_tmp1;
    public int aug_tmp2;
    public int aug_tmp3;
    public int aug_tmp4;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(PythonGrammar pythonGrammar, int n) {
        this(n);
        this.parser = pythonGrammar;
    }

    public static Node jjtCreate(int n) {
        return new SimpleNode(n);
    }

    public static Node jjtCreate(PythonGrammar pythonGrammar, int n) {
        return new SimpleNode(pythonGrammar, n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new SimpleNode[n + 1];
        } else if (n >= this.children.length) {
            SimpleNode[] simpleNodeArray = new SimpleNode[n + 1];
            System.arraycopy(this.children, 0, simpleNodeArray, 0, this.children.length);
            this.children = simpleNodeArray;
        }
        this.children[n] = (SimpleNode)node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public SimpleNode getChild(int n) {
        return this.children[n];
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public void setString(String string, int n) {
        this.info = SimpleNode.parseString(string, n, this.beginLine, this.beginColumn);
    }

    public static String parseString(String string, int n, int n2, int n3) {
        int n4;
        char c = string.charAt(0);
        int n5 = 0;
        boolean bl = false;
        if (c == 'u' || c == 'U') {
            bl = true;
            ++n5;
        }
        if ((c = string.charAt(n5)) == 'r' || c == 'R') {
            return string.substring(n + n5 + 1, string.length() - n);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        int n6 = cArray.length - n;
        int n7 = n4 = n + n5;
        return PyString.decode_UnicodeEscape(string, n4, n6, "strict", bl);
    }

    public void setInteger(String string, int n) {
        if (string.endsWith("j") || string.endsWith("J")) {
            this.setFloat(string);
        } else if (string.endsWith("L") || string.endsWith("l")) {
            string = string.substring(0, string.length() - 1);
            if (n == 10) {
                this.setInfo(string);
            } else {
                this.setInfo(new BigInteger(string, n).toString());
            }
        } else {
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2 && string.charAt(n3) == '0') {
                ++n3;
            }
            if (n2 - n3 > 11) {
                throw Py.OverflowError("integer literal too large");
            }
            long l = Long.valueOf(string, n);
            if (l > 0xFFFFFFFFL || n == 10 && l > Integer.MAX_VALUE) {
                throw Py.OverflowError("integer literal too large");
            }
            this.setInfo(new Integer((int)l));
        }
    }

    public void setFloat(String string) {
        if (string.endsWith("j") || string.endsWith("J")) {
            this.setInfo(Double.valueOf(string.substring(0, string.length() - 1)));
            this.id = 93;
        } else {
            this.setInfo(Double.valueOf(string));
        }
    }

    public String toString() {
        return PythonGrammarTreeConstants.jjtNodeName[this.id] + ":" + this.info + " at line " + this.beginLine;
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public Object visit(Visitor visitor) throws Exception {
        switch (this.id) {
            case 0: {
                return visitor.single_input(this);
            }
            case 1: {
                return visitor.file_input(this);
            }
            case 2: {
                return visitor.eval_input(this);
            }
            case 3: {
                return visitor.funcdef(this);
            }
            case 5: {
                return visitor.varargslist(this);
            }
            case 6: {
                return visitor.ExtraArgList(this);
            }
            case 7: {
                return visitor.ExtraKeywordList(this);
            }
            case 8: {
                return visitor.defaultarg(this);
            }
            case 9: {
                return visitor.fplist(this);
            }
            case 10: {
                return visitor.expr_stmt(this);
            }
            case 22: {
                return visitor.print_stmt(this);
            }
            case 23: {
                return visitor.print_ext(this);
            }
            case 24: {
                return visitor.del_stmt(this);
            }
            case 25: {
                return visitor.pass_stmt(this);
            }
            case 26: {
                return visitor.break_stmt(this);
            }
            case 27: {
                return visitor.continue_stmt(this);
            }
            case 28: {
                return visitor.return_stmt(this);
            }
            case 29: {
                return visitor.raise_stmt(this);
            }
            case 30: {
                return visitor.Import(this);
            }
            case 31: {
                return visitor.ImportFrom(this);
            }
            case 33: {
                return visitor.dotted_name(this);
            }
            case 35: {
                return visitor.global_stmt(this);
            }
            case 36: {
                return visitor.exec_stmt(this);
            }
            case 37: {
                return visitor.assert_stmt(this);
            }
            case 38: {
                return visitor.if_stmt(this);
            }
            case 39: {
                return visitor.while_stmt(this);
            }
            case 40: {
                return visitor.for_stmt(this);
            }
            case 41: {
                return visitor.try_stmt(this);
            }
            case 42: {
                return visitor.except_clause(this);
            }
            case 43: {
                return visitor.suite(this);
            }
            case 44: {
                return visitor.or_boolean(this);
            }
            case 45: {
                return visitor.and_boolean(this);
            }
            case 46: {
                return visitor.not_1op(this);
            }
            case 47: {
                return visitor.comparision(this);
            }
            case 48: {
                return visitor.less_cmp(this);
            }
            case 49: {
                return visitor.greater_cmp(this);
            }
            case 50: {
                return visitor.equal_cmp(this);
            }
            case 51: {
                return visitor.greater_equal_cmp(this);
            }
            case 52: {
                return visitor.less_equal_cmp(this);
            }
            case 53: {
                return visitor.notequal_cmp(this);
            }
            case 54: {
                return visitor.in_cmp(this);
            }
            case 55: {
                return visitor.not_in_cmp(this);
            }
            case 56: {
                return visitor.is_not_cmp(this);
            }
            case 57: {
                return visitor.is_cmp(this);
            }
            case 58: {
                return visitor.or_2op(this);
            }
            case 59: {
                return visitor.xor_2op(this);
            }
            case 60: {
                return visitor.and_2op(this);
            }
            case 61: {
                return visitor.lshift_2op(this);
            }
            case 62: {
                return visitor.rshift_2op(this);
            }
            case 63: {
                return visitor.add_2op(this);
            }
            case 64: {
                return visitor.sub_2op(this);
            }
            case 65: {
                return visitor.mul_2op(this);
            }
            case 66: {
                return visitor.div_2op(this);
            }
            case 67: {
                return visitor.mod_2op(this);
            }
            case 68: {
                return visitor.pos_1op(this);
            }
            case 69: {
                return visitor.neg_1op(this);
            }
            case 70: {
                return visitor.invert_1op(this);
            }
            case 71: {
                return visitor.pow_2op(this);
            }
            case 72: {
                return visitor.Call_Op(this);
            }
            case 73: {
                return visitor.Index_Op(this);
            }
            case 74: {
                return visitor.Dot_Op(this);
            }
            case 75: {
                return visitor.tuple(this);
            }
            case 76: {
                return visitor.list(this);
            }
            case 77: {
                return visitor.dictionary(this);
            }
            case 78: {
                return visitor.str_1op(this);
            }
            case 79: {
                return visitor.strjoin(this);
            }
            case 80: {
                return visitor.lambdef(this);
            }
            case 81: {
                return visitor.Ellipses(this);
            }
            case 82: {
                return visitor.Slice(this);
            }
            case 83: {
                return visitor.Colon(this);
            }
            case 84: {
                return visitor.Comma(this);
            }
            case 86: {
                return visitor.classdef(this);
            }
            case 87: {
                return visitor.arglist(this);
            }
            case 90: {
                return visitor.Keyword(this);
            }
            case 91: {
                return visitor.Int(this);
            }
            case 92: {
                return visitor.Float(this);
            }
            case 93: {
                return visitor.Complex(this);
            }
            case 94: {
                return visitor.Name(this);
            }
            case 95: {
                return visitor.String(this);
            }
            case 11: {
                return visitor.aug_plus(this);
            }
            case 12: {
                return visitor.aug_minus(this);
            }
            case 13: {
                return visitor.aug_multiply(this);
            }
            case 14: {
                return visitor.aug_divide(this);
            }
            case 15: {
                return visitor.aug_modulo(this);
            }
            case 16: {
                return visitor.aug_and(this);
            }
            case 17: {
                return visitor.aug_or(this);
            }
            case 18: {
                return visitor.aug_xor(this);
            }
            case 19: {
                return visitor.aug_lshift(this);
            }
            case 20: {
                return visitor.aug_rshift(this);
            }
            case 21: {
                return visitor.aug_power(this);
            }
            case 85: {
                return visitor.list_iter(this);
            }
        }
        throw new ParseException("Unexpected node: " + this);
    }
}

