/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class InnerClassesEntry {
    private short innerClassInfoIndex;
    private short outerClassInfoIndex;
    private short innerNameIndex;
    private short innerClassAccessFlags;
    private ConstantPool constantPool;

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.innerClassInfoIndex);
        dataOutputStream.writeShort(this.outerClassInfoIndex);
        dataOutputStream.writeShort(this.innerNameIndex);
        dataOutputStream.writeShort(this.innerClassAccessFlags);
    }

    public void setInnerClassInfo(String string) {
        string = JVMUtilities.getName(string);
        this.innerClassInfoIndex = this.constantPool.put(new ClassIdentifier(string));
    }

    public void setOuterClassInfo(String string) {
        string = JVMUtilities.getName(string);
        this.outerClassInfoIndex = this.constantPool.put(new ClassIdentifier(string));
    }

    public void setInnerName(String string) {
        this.innerNameIndex = this.constantPool.putUTF8(string);
    }

    public void setInnerClassAccessFlags(short s) {
        this.innerClassAccessFlags = s;
    }

    public InnerClassesEntry(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }
}

