/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.util.AmbiguousFieldException;

public class ClassInfoUtilities {
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public static ConstructorInfo lookupConstructor(ClassInfo classInfo, ClassInfo[] classInfoArray) throws NoSuchMethodException {
        ConstructorInfo constructorInfo;
        List list = ClassInfoUtilities.getConstructors(classInfo, classInfoArray.length);
        LinkedList<ConstructorInfo> linkedList = new LinkedList<ConstructorInfo>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            constructorInfo = (ConstructorInfo)iterator.next();
            if (!ClassInfoUtilities.hasCompatibleSignatures(constructorInfo.getParameterTypes(), classInfoArray)) continue;
            linkedList.add(constructorInfo);
        }
        if (linkedList.isEmpty()) {
            throw new NoSuchMethodException(classInfo.getName() + " constructor");
        }
        iterator = linkedList.iterator();
        constructorInfo = (ConstructorInfo)iterator.next();
        while (iterator.hasNext()) {
            constructorInfo = ClassInfoUtilities.selectTheMostSpecificConstructor(constructorInfo, (ConstructorInfo)iterator.next());
        }
        return constructorInfo;
    }

    public static boolean isAssignableFrom(ClassInfo classInfo, ClassInfo classInfo2) {
        if (classInfo.isPrimitive()) {
            if (!classInfo.equals(classInfo2)) {
                if (classInfo2 == null || !classInfo2.isPrimitive()) {
                    return false;
                }
                Class clazz = classInfo.getJavaClass();
                Class clazz2 = classInfo2.getJavaClass();
                if (clazz == Short.TYPE) {
                    return clazz2 == Byte.TYPE;
                }
                if (clazz == Integer.TYPE) {
                    return clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Character.TYPE;
                }
                if (clazz == Long.TYPE) {
                    return clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE;
                }
                if (clazz == Float.TYPE) {
                    return clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Float.TYPE;
                }
                if (clazz == Double.TYPE) {
                    return clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE;
                }
                return false;
            }
            return true;
        }
        if (classInfo2 == null || classInfo.equals(classInfo2)) {
            return true;
        }
        return ClassInfoUtilities.isAncestorOf(classInfo, classInfo2) || ClassInfoUtilities.isInterfaceOf(classInfo, classInfo2);
    }

    public static FieldInfo getField(ClassInfo classInfo, String string) throws NoSuchFieldException, AmbiguousFieldException {
        ClassInfo classInfo2 = classInfo;
        while (classInfo2 != null) {
            FieldInfo[] fieldInfoArray = classInfo2.getFields();
            int n = 0;
            while (n < fieldInfoArray.length) {
                if (fieldInfoArray[n].getName().equals(string)) {
                    return fieldInfoArray[n];
                }
                ++n;
            }
            ClassInfo[] classInfoArray = classInfo2.getInterfaces();
            FieldInfo fieldInfo = null;
            int n2 = 0;
            while (n2 < classInfoArray.length) {
                FieldInfo fieldInfo2 = null;
                try {
                    fieldInfo2 = ClassInfoUtilities.getField(classInfoArray[n2], string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (fieldInfo2 != null) {
                    if (fieldInfo != null && !fieldInfo.equals(fieldInfo2)) {
                        throw new AmbiguousFieldException(string);
                    }
                    fieldInfo = fieldInfo2;
                }
                ++n2;
            }
            if (fieldInfo != null) {
                return fieldInfo;
            }
            classInfo2 = classInfo2.getSuperclass();
        }
        throw new NoSuchFieldException(string);
    }

    public static FieldInfo getOuterField(ClassInfo classInfo, String string) throws NoSuchFieldException, AmbiguousFieldException {
        boolean bl = Modifier.isStatic(classInfo.getModifiers());
        ClassInfo classInfo2 = classInfo != null ? classInfo.getDeclaringClass() : null;
        while (classInfo2 != null) {
            bl |= Modifier.isStatic(classInfo2.getModifiers());
            try {
                FieldInfo fieldInfo = ClassInfoUtilities.getField(classInfo2, string);
                if (!bl || Modifier.isStatic(fieldInfo.getModifiers())) {
                    return fieldInfo;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            classInfo2 = classInfo2.getDeclaringClass();
        }
        throw new NoSuchFieldException(string);
    }

    public static MethodInfo lookupMethod(ClassInfo classInfo, String string, ClassInfo[] classInfoArray) throws NoSuchMethodException {
        MethodInfo methodInfo;
        List list = ClassInfoUtilities.getMethods(classInfo, string, classInfoArray.length);
        LinkedList<MethodInfo> linkedList = new LinkedList<MethodInfo>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            methodInfo = (MethodInfo)iterator.next();
            if (!ClassInfoUtilities.hasCompatibleSignatures(methodInfo.getParameterTypes(), classInfoArray)) continue;
            linkedList.add(methodInfo);
        }
        if (linkedList.isEmpty()) {
            throw new NoSuchMethodException(string);
        }
        iterator = linkedList.iterator();
        methodInfo = (MethodInfo)iterator.next();
        while (iterator.hasNext()) {
            methodInfo = ClassInfoUtilities.selectTheMostSpecificMethod(methodInfo, (MethodInfo)iterator.next());
        }
        return methodInfo;
    }

    public static MethodInfo lookupOuterMethod(ClassInfo classInfo, String string, ClassInfo[] classInfoArray) throws NoSuchMethodException {
        boolean bl = Modifier.isStatic(classInfo.getModifiers());
        ClassInfo classInfo2 = classInfo != null ? classInfo.getDeclaringClass() : null;
        while (classInfo2 != null) {
            bl |= Modifier.isStatic(classInfo2.getModifiers());
            try {
                MethodInfo methodInfo = ClassInfoUtilities.lookupMethod(classInfo2, string, classInfoArray);
                if (!bl || Modifier.isStatic(methodInfo.getModifiers())) {
                    return methodInfo;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            classInfo2 = classInfo2.getDeclaringClass();
        }
        throw new NoSuchMethodException(string);
    }

    public static List getMethods(ClassInfo classInfo, String string, int n) {
        LinkedList<MethodInfo> linkedList = new LinkedList<MethodInfo>();
        if (classInfo.isInterface()) {
            MethodInfo[] methodInfoArray = classInfo.getMethods();
            int n2 = 0;
            while (n2 < methodInfoArray.length) {
                if (methodInfoArray[n2].getName().equals(string) && methodInfoArray[n2].getParameterTypes().length == n) {
                    linkedList.add(methodInfoArray[n2]);
                }
                ++n2;
            }
            ClassInfo[] classInfoArray = classInfo.getInterfaces();
            int n3 = 0;
            while (n3 < classInfoArray.length) {
                linkedList.addAll(ClassInfoUtilities.getMethods(classInfoArray[n3], string, n));
                ++n3;
            }
        } else {
            ClassInfo classInfo2 = classInfo;
            while (classInfo2 != null) {
                MethodInfo[] methodInfoArray = classInfo2.getMethods();
                int n4 = 0;
                while (n4 < methodInfoArray.length) {
                    if (methodInfoArray[n4].getName().equals(string) && methodInfoArray[n4].getParameterTypes().length == n) {
                        linkedList.add(methodInfoArray[n4]);
                    }
                    ++n4;
                }
                classInfo2 = classInfo2.getSuperclass();
            }
        }
        return linkedList;
    }

    private static List getConstructors(ClassInfo classInfo, int n) {
        LinkedList<ConstructorInfo> linkedList = new LinkedList<ConstructorInfo>();
        ConstructorInfo[] constructorInfoArray = classInfo.getConstructors();
        int n2 = 0;
        while (n2 < constructorInfoArray.length) {
            if (constructorInfoArray[n2].getParameterTypes().length == n) {
                linkedList.add(constructorInfoArray[n2]);
            }
            ++n2;
        }
        return linkedList;
    }

    private static ConstructorInfo selectTheMostSpecificConstructor(ConstructorInfo constructorInfo, ConstructorInfo constructorInfo2) {
        ClassInfo[] classInfoArray = constructorInfo.getParameterTypes();
        ClassInfo[] classInfoArray2 = constructorInfo2.getParameterTypes();
        int n = 0;
        while (n < classInfoArray.length) {
            if (classInfoArray[n] != classInfoArray2[n]) {
                return ClassInfoUtilities.isAssignableFrom(classInfoArray[n], classInfoArray2[n]) ? constructorInfo2 : constructorInfo;
            }
            ++n;
        }
        return constructorInfo;
    }

    private static MethodInfo selectTheMostSpecificMethod(MethodInfo methodInfo, MethodInfo methodInfo2) {
        ClassInfo[] classInfoArray = methodInfo.getParameterTypes();
        ClassInfo[] classInfoArray2 = methodInfo2.getParameterTypes();
        int n = 0;
        while (n < classInfoArray.length) {
            if (classInfoArray[n] != classInfoArray2[n]) {
                return ClassInfoUtilities.isAssignableFrom(classInfoArray[n], classInfoArray2[n]) ? methodInfo2 : methodInfo;
            }
            ++n;
        }
        return methodInfo;
    }

    private static boolean hasCompatibleSignatures(ClassInfo[] classInfoArray, ClassInfo[] classInfoArray2) {
        int n = 0;
        while (n < classInfoArray.length) {
            if (!ClassInfoUtilities.isAssignableFrom(classInfoArray[n], classInfoArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isAncestorOf(ClassInfo classInfo, ClassInfo classInfo2) {
        ClassInfo classInfo3 = classInfo2.getSuperclass();
        while (classInfo3 != null && !classInfo3.equals(new JavaClassInfo(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : ClassInfoUtilities.class$("java.lang.Object")))) {
            if (classInfo3.equals(classInfo)) {
                return true;
            }
            classInfo3 = classInfo3.getSuperclass();
        }
        return classInfo3 != null && classInfo3.equals(classInfo);
    }

    private static boolean isInterfaceOf(ClassInfo classInfo, ClassInfo classInfo2) {
        if (classInfo.isInterface()) {
            ClassInfo classInfo3 = classInfo2;
            while (classInfo3 != null && !classInfo3.equals(new JavaClassInfo(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : ClassInfoUtilities.class$("java.lang.Object")))) {
                ClassInfo[] classInfoArray = classInfo3.getInterfaces();
                int n = 0;
                while (n < classInfoArray.length) {
                    if (classInfoArray[n].equals(classInfo)) {
                        return true;
                    }
                    if (ClassInfoUtilities.isInterfaceOf(classInfo, classInfoArray[n])) {
                        return true;
                    }
                    ++n;
                }
                classInfo3 = classInfo3.getSuperclass();
            }
            return false;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ClassInfoUtilities() {
    }
}

