/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TypeVisitor;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;

public class TreeMethodInfo
implements MethodInfo {
    private MethodDeclaration methodTree;
    private ClassFinder classFinder;
    private ClassInfo[] parameters;
    private ClassInfo[] exceptions;
    private ClassInfo declaringClass;
    private TypeVisitor typeVisitor;

    public MethodDeclaration getMethodDeclaration() {
        return this.methodTree;
    }

    public int getModifiers() {
        return this.methodTree.getAccessFlags();
    }

    public ClassInfo getReturnType() {
        return (ClassInfo)this.methodTree.getReturnType().acceptVisitor(this.typeVisitor);
    }

    public String getName() {
        return this.methodTree.getName();
    }

    public ClassInfo[] getParameterTypes() {
        if (this.parameters == null) {
            List list = this.methodTree.getParameters();
            Iterator iterator = list.iterator();
            this.parameters = new ClassInfo[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                FormalParameter formalParameter = (FormalParameter)iterator.next();
                this.parameters[n++] = (ClassInfo)formalParameter.getType().acceptVisitor(this.typeVisitor);
            }
        }
        return (ClassInfo[])this.parameters.clone();
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.exceptions == null) {
            List list = this.methodTree.getExceptions();
            Iterator iterator = list.iterator();
            this.exceptions = new ClassInfo[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                this.exceptions[n++] = this.lookupClass((String)iterator.next(), this.declaringClass);
            }
        }
        return (ClassInfo[])this.exceptions.clone();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TreeMethodInfo)) {
            return false;
        }
        return this.methodTree.equals(((TreeMethodInfo)object).methodTree);
    }

    protected ClassInfo lookupClass(String string, ClassInfo classInfo) {
        try {
            if (classInfo == null) {
                return this.classFinder.lookupClass(string, classInfo);
            }
            return this.classFinder.lookupClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TreeMethodInfo(MethodDeclaration methodDeclaration, ClassFinder classFinder, ClassInfo classInfo) {
        this.methodTree = methodDeclaration;
        this.classFinder = classFinder;
        this.declaringClass = classInfo;
        this.typeVisitor = new TypeVisitor(this.classFinder, this.declaringClass);
    }
}

