/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TypeChecker;
import koala.dynamicjava.interpreter.UninitializedObject;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.throwable.BreakException;
import koala.dynamicjava.interpreter.throwable.ContinueException;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.Constants;
import koala.dynamicjava.util.ImportationManager;

public class EvaluationVisitor
extends VisitorObject {
    private Context context;
    private static /* synthetic */ Class class$Ljava$lang$Character;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(WhileStatement whileStatement) {
        while (true) {
            try {
                if (!((Boolean)whileStatement.getCondition().acceptVisitor(this)).booleanValue()) return null;
                try {
                    whileStatement.getBody().acceptVisitor(this);
                    continue;
                }
                catch (ContinueException continueException) {
                    if (continueException.isLabeled() && !whileStatement.hasLabel(continueException.getLabel())) throw continueException;
                    continue;
                }
            }
            catch (BreakException breakException) {
                if (!breakException.isLabeled() || whileStatement.hasLabel(breakException.getLabel())) return null;
                throw breakException;
            }
            break;
        }
    }

    public Object visit(ForStatement forStatement) {
        try {
            block11: {
                Object object;
                Set set = (Set)forStatement.getProperty("variables");
                this.context.enterScope(set);
                if (forStatement.getInitialization() != null) {
                    object = forStatement.getInitialization().iterator();
                    while (object.hasNext()) {
                        ((Node)object.next()).acceptVisitor(this);
                    }
                }
                try {
                    object = forStatement.getCondition();
                    List list = forStatement.getUpdate();
                    while (object == null || ((Boolean)((Node)object).acceptVisitor(this)).booleanValue()) {
                        block10: {
                            try {
                                forStatement.getBody().acceptVisitor(this);
                            }
                            catch (ContinueException continueException) {
                                if (!continueException.isLabeled() || forStatement.hasLabel(continueException.getLabel())) break block10;
                                throw continueException;
                            }
                        }
                        if (list == null) continue;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ((Node)iterator.next()).acceptVisitor(this);
                        }
                    }
                }
                catch (BreakException breakException) {
                    if (!breakException.isLabeled() || forStatement.hasLabel(breakException.getLabel())) break block11;
                    throw breakException;
                }
            }
            Object var3_8 = null;
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.context.leaveScope();
            throw throwable;
        }
        this.context.leaveScope();
        return null;
    }

    public Object visit(DoStatement doStatement) {
        block5: {
            try {
                do {
                    try {
                        doStatement.getBody().acceptVisitor(this);
                    }
                    catch (ContinueException continueException) {
                        if (!continueException.isLabeled() || doStatement.hasLabel(continueException.getLabel())) continue;
                        throw continueException;
                    }
                } while (((Boolean)doStatement.getCondition().acceptVisitor(this)).booleanValue());
            }
            catch (BreakException breakException) {
                if (!breakException.isLabeled() || doStatement.hasLabel(breakException.getLabel())) break block5;
                throw breakException;
            }
        }
        return null;
    }

    public Object visit(SwitchStatement switchStatement) {
        block15: {
            try {
                Object object;
                SwitchBlock switchBlock;
                boolean bl = false;
                Object object2 = switchStatement.getSelector().acceptVisitor(this);
                if (object2 instanceof Character) {
                    object2 = new Integer(((Character)object2).charValue());
                }
                Number number = (Number)object2;
                ListIterator listIterator = switchStatement.getBindings().listIterator();
                ListIterator listIterator2 = null;
                block2: while (listIterator.hasNext()) {
                    switchBlock = (SwitchBlock)listIterator.next();
                    object = null;
                    if (switchBlock.getExpression() != null) {
                        object2 = switchBlock.getExpression().acceptVisitor(this);
                        if (object2 instanceof Character) {
                            object2 = new Integer(((Character)object2).charValue());
                        }
                        object = (Number)object2;
                    } else {
                        listIterator2 = switchStatement.getBindings().listIterator(listIterator.nextIndex() - 1);
                    }
                    if (object == null || number.intValue() != ((Number)object).intValue()) continue;
                    bl = true;
                    while (true) {
                        if (switchBlock.getStatements() != null) {
                            Iterator iterator = switchBlock.getStatements().iterator();
                            while (iterator.hasNext()) {
                                ((Node)iterator.next()).acceptVisitor(this);
                            }
                        }
                        if (!listIterator.hasNext()) break block2;
                        switchBlock = (SwitchBlock)listIterator.next();
                    }
                }
                if (!bl && listIterator2 != null) {
                    switchBlock = (SwitchBlock)listIterator2.next();
                    while (true) {
                        if (switchBlock.getStatements() != null) {
                            object = switchBlock.getStatements().iterator();
                            while (object.hasNext()) {
                                ((Node)object.next()).acceptVisitor(this);
                            }
                        }
                        if (listIterator2.hasNext()) {
                            switchBlock = (SwitchBlock)listIterator2.next();
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (BreakException breakException) {
                if (!breakException.isLabeled()) break block15;
                throw breakException;
            }
        }
        return null;
    }

    public Object visit(LabeledStatement labeledStatement) {
        block2: {
            try {
                labeledStatement.getStatement().acceptVisitor(this);
            }
            catch (BreakException breakException) {
                if (breakException.isLabeled() && breakException.getLabel().equals(labeledStatement.getLabel())) break block2;
                throw breakException;
            }
        }
        return null;
    }

    public Object visit(SynchronizedStatement synchronizedStatement) {
        Object object = synchronizedStatement.getLock().acceptVisitor(this);
        synchronized (object) {
            synchronizedStatement.getBody().acceptVisitor(this);
        }
        return null;
    }

    public Object visit(BreakStatement breakStatement) {
        throw new BreakException("unexpected.break", breakStatement.getLabel());
    }

    public Object visit(ContinueStatement continueStatement) {
        throw new ContinueException("unexpected.continue", continueStatement.getLabel());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object visit(TryStatement tryStatement) {
        Node node;
        block13: {
            block14: {
                Node node2;
                block15: {
                    boolean bl = false;
                    try {
                        Iterator iterator;
                        Throwable throwable;
                        Throwable throwable22;
                        block12: {
                            try {
                                tryStatement.getTryBlock().acceptVisitor(this);
                            }
                            catch (Throwable throwable22) {
                                throwable = throwable22;
                                if (throwable22 instanceof ThrownException) {
                                    throwable = ((ThrownException)throwable22).getException();
                                } else if (throwable22 instanceof CatchedExceptionError) {
                                    throwable = ((CatchedExceptionError)throwable22).getException();
                                }
                                iterator = tryStatement.getCatchStatements().iterator();
                                break block12;
                            }
                            Object var4_3 = null;
                            if (!bl) break block13;
                            break block14;
                        }
                        while (iterator.hasNext()) {
                            CatchStatement catchStatement = (CatchStatement)iterator.next();
                            Class clazz = NodeProperties.getType(catchStatement.getException().getType());
                            if (!clazz.isAssignableFrom(throwable.getClass())) continue;
                            bl = true;
                            this.context.enterScope();
                            this.context.define(catchStatement.getException().getName(), throwable);
                            catchStatement.getBlock().acceptVisitor(this);
                            break;
                        }
                        if (!bl) {
                            if (throwable22 instanceof Error) {
                                throw (Error)throwable22;
                            }
                            if (!(throwable22 instanceof RuntimeException)) throw new CatchedExceptionError((Exception)throwable22, (Node)tryStatement);
                            throw (RuntimeException)throwable22;
                        }
                        Object var4_4 = null;
                        if (!bl) break block15;
                    }
                    catch (Throwable throwable) {
                        Node node3;
                        Object var4_5 = null;
                        if (bl) {
                            this.context.leaveScope();
                        }
                        if ((node3 = tryStatement.getFinallyBlock()) == null) throw throwable;
                        node3.acceptVisitor(this);
                        throw throwable;
                    }
                    this.context.leaveScope();
                }
                if ((node2 = tryStatement.getFinallyBlock()) == null) return null;
                node2.acceptVisitor(this);
                return null;
            }
            this.context.leaveScope();
        }
        if ((node = tryStatement.getFinallyBlock()) == null) return null;
        node.acceptVisitor(this);
        return null;
    }

    public Object visit(ThrowStatement throwStatement) {
        throw new ThrownException((Throwable)throwStatement.getExpression().acceptVisitor(this));
    }

    public Object visit(ReturnStatement returnStatement) {
        if (returnStatement.getExpression() != null) {
            throw new ReturnException("return.statement", returnStatement.getExpression().acceptVisitor(this), returnStatement);
        }
        throw new ReturnException("return.statement", returnStatement);
    }

    public Object visit(IfThenStatement ifThenStatement) {
        if (((Boolean)ifThenStatement.getCondition().acceptVisitor(this)).booleanValue()) {
            ifThenStatement.getThenStatement().acceptVisitor(this);
        }
        return null;
    }

    public Object visit(IfThenElseStatement ifThenElseStatement) {
        if (((Boolean)ifThenElseStatement.getCondition().acceptVisitor(this)).booleanValue()) {
            ifThenElseStatement.getThenStatement().acceptVisitor(this);
        } else {
            ifThenElseStatement.getElseStatement().acceptVisitor(this);
        }
        return null;
    }

    public Object visit(BlockStatement blockStatement) {
        try {
            Set set = (Set)blockStatement.getProperty("variables");
            this.context.enterScope(set);
            Iterator iterator = blockStatement.getStatements().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(this);
            }
        }
        finally {
            Object var3_4 = null;
            this.context.leaveScope();
        }
        return null;
    }

    public Object visit(Literal literal) {
        return literal.getValue();
    }

    public Object visit(VariableDeclaration variableDeclaration) {
        Class clazz = NodeProperties.getType(variableDeclaration.getType());
        if (variableDeclaration.getInitializer() != null) {
            Object object = EvaluationVisitor.performCast(clazz, variableDeclaration.getInitializer().acceptVisitor(this));
            if (variableDeclaration.isFinal()) {
                this.context.setConstant(variableDeclaration.getName(), object);
            } else {
                this.context.set(variableDeclaration.getName(), object);
            }
        } else if (variableDeclaration.isFinal()) {
            this.context.setConstant(variableDeclaration.getName(), UninitializedObject.INSTANCE);
        } else {
            this.context.set(variableDeclaration.getName(), UninitializedObject.INSTANCE);
        }
        return null;
    }

    public Object visit(ObjectFieldAccess objectFieldAccess) {
        Class clazz = NodeProperties.getType(objectFieldAccess.getExpression());
        Object object = objectFieldAccess.getExpression().acceptVisitor(this);
        if (!clazz.isArray()) {
            Field field = (Field)objectFieldAccess.getProperty("field");
            try {
                return field.get(object);
            }
            catch (Exception exception) {
                throw new CatchedExceptionError(exception, (Node)objectFieldAccess);
            }
        }
        return new Integer(Array.getLength(object));
    }

    public Object visit(ObjectMethodCall objectMethodCall) {
        Expression expression = objectMethodCall.getExpression();
        Object object = expression.acceptVisitor(this);
        if (objectMethodCall.hasProperty("method")) {
            Method method = (Method)objectMethodCall.getProperty("method");
            Class<?>[] classArray = method.getParameterTypes();
            List list = objectMethodCall.getArguments();
            Object[] objectArray = Constants.EMPTY_OBJECT_ARRAY;
            if (list != null) {
                objectArray = new Object[list.size()];
                Iterator iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Object object2 = ((Expression)iterator.next()).acceptVisitor(this);
                    objectArray[n] = EvaluationVisitor.performCast(classArray[n], object2);
                    ++n;
                }
            }
            try {
                return method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof Error) {
                    throw (Error)invocationTargetException.getTargetException();
                }
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                throw new ThrownException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new CatchedExceptionError(exception, (Node)objectMethodCall);
            }
        }
        Class clazz = NodeProperties.getType(expression);
        int n = Array.getLength(object);
        Object object3 = Array.newInstance(clazz.getComponentType(), n);
        int n2 = 0;
        while (n2 < n) {
            Array.set(object3, n2, Array.get(object, n2));
            ++n2;
        }
        return object3;
    }

    public Object visit(StaticFieldAccess staticFieldAccess) {
        Field field = (Field)staticFieldAccess.getProperty("field");
        try {
            return field.get(null);
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)staticFieldAccess);
        }
    }

    public Object visit(SuperFieldAccess superFieldAccess) {
        Field field = (Field)superFieldAccess.getProperty("field");
        try {
            return field.get(this.context.getHiddenArgument());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)superFieldAccess);
        }
    }

    public Object visit(SuperMethodCall superMethodCall) {
        Method method = (Method)superMethodCall.getProperty("method");
        List list = superMethodCall.getArguments();
        Object[] objectArray = Constants.EMPTY_OBJECT_ARRAY;
        if (list != null) {
            Iterator iterator = list.iterator();
            int n = 0;
            objectArray = new Object[list.size()];
            while (iterator.hasNext()) {
                objectArray[n] = ((Expression)iterator.next()).acceptVisitor(this);
                ++n;
            }
        }
        try {
            return method.invoke(this.context.getHiddenArgument(), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new ThrownException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)superMethodCall);
        }
    }

    public Object visit(StaticMethodCall staticMethodCall) {
        Method method = (Method)staticMethodCall.getProperty("method");
        List list = staticMethodCall.getArguments();
        Object[] objectArray = Constants.EMPTY_OBJECT_ARRAY;
        if (list != null) {
            objectArray = new Object[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = ((Expression)iterator.next()).acceptVisitor(this);
                ++n;
            }
        }
        try {
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new ThrownException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)staticMethodCall);
        }
    }

    public Object visit(SimpleAssignExpression simpleAssignExpression) {
        Expression expression = simpleAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        leftHandSideModifier.prepare(this, this.context);
        Object object = simpleAssignExpression.getRightExpression().acceptVisitor(this);
        object = EvaluationVisitor.performCast(NodeProperties.getType(simpleAssignExpression), object);
        leftHandSideModifier.modify(this.context, object);
        return object;
    }

    public Object visit(QualifiedName qualifiedName) {
        Object object = this.context.get(qualifiedName.getRepresentation());
        if (object == UninitializedObject.INSTANCE) {
            qualifiedName.setProperty("errorStrings", new String[]{qualifiedName.getRepresentation()});
            throw new ExecutionError("uninitialized.variable", qualifiedName);
        }
        return object;
    }

    public Object visit(TypeExpression typeExpression) {
        return typeExpression.getProperty("value");
    }

    public Object visit(SimpleAllocation simpleAllocation) {
        List list = simpleAllocation.getArguments();
        Object[] objectArray = Constants.EMPTY_OBJECT_ARRAY;
        if (list != null) {
            objectArray = new Object[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n++] = ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        return this.context.invokeConstructor(simpleAllocation, objectArray);
    }

    public Object visit(ArrayAllocation arrayAllocation) {
        Serializable serializable;
        if (arrayAllocation.getInitialization() != null) {
            return arrayAllocation.getInitialization().acceptVisitor(this);
        }
        int[] nArray = new int[arrayAllocation.getSizes().size()];
        Iterator iterator = arrayAllocation.getSizes().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            serializable = (Number)((Expression)iterator.next()).acceptVisitor(this);
            nArray[n++] = ((Number)serializable).intValue();
        }
        if (arrayAllocation.getDimension() != nArray.length) {
            serializable = NodeProperties.getComponentType(arrayAllocation);
            serializable = Array.newInstance(serializable, 0).getClass();
            return Array.newInstance(serializable, nArray);
        }
        return Array.newInstance(NodeProperties.getComponentType(arrayAllocation), nArray);
    }

    public Object visit(ArrayInitializer arrayInitializer) {
        Object object = Array.newInstance(NodeProperties.getType(arrayInitializer.getElementType()), arrayInitializer.getCells().size());
        Iterator iterator = arrayInitializer.getCells().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object2 = ((Expression)iterator.next()).acceptVisitor(this);
            Array.set(object, n++, object2);
        }
        return object;
    }

    public Object visit(ArrayAccess arrayAccess) {
        Object object = arrayAccess.getExpression().acceptVisitor(this);
        Object object2 = arrayAccess.getCellNumber().acceptVisitor(this);
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        return Array.get(object, ((Number)object2).intValue());
    }

    public Object visit(InnerAllocation innerAllocation) {
        Constructor constructor = (Constructor)innerAllocation.getProperty("constructor");
        Class clazz = NodeProperties.getType(innerAllocation);
        List list = innerAllocation.getArguments();
        Object[] objectArray = null;
        if (list != null) {
            objectArray = new Object[list.size() + 1];
            objectArray[0] = innerAllocation.getExpression().acceptVisitor(this);
            Iterator iterator = list.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                objectArray[n++] = ((Expression)iterator.next()).acceptVisitor(this);
            }
        } else {
            objectArray = new Object[]{innerAllocation.getExpression().acceptVisitor(this)};
        }
        try {
            return constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new ThrownException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new CatchedExceptionError(exception, (Node)innerAllocation);
        }
    }

    public Object visit(ClassAllocation classAllocation) {
        List list = classAllocation.getArguments();
        Object[] objectArray = Constants.EMPTY_OBJECT_ARRAY;
        if (list != null) {
            objectArray = new Object[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n++] = ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        return this.context.invokeConstructor(classAllocation, objectArray);
    }

    public Object visit(NotExpression notExpression) {
        if (notExpression.hasProperty("value")) {
            return notExpression.getProperty("value");
        }
        Boolean bl = (Boolean)notExpression.getExpression().acceptVisitor(this);
        if (bl.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(ComplementExpression complementExpression) {
        if (complementExpression.hasProperty("value")) {
            return complementExpression.getProperty("value");
        }
        Class clazz = NodeProperties.getType(complementExpression);
        Object object = complementExpression.getExpression().acceptVisitor(this);
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(~((Number)object).intValue());
        }
        return new Long(((Number)object).longValue() ^ -1L);
    }

    public Object visit(PlusExpression plusExpression) {
        if (plusExpression.hasProperty("value")) {
            return plusExpression.getProperty("value");
        }
        return InterpreterUtilities.plus(NodeProperties.getType(plusExpression), plusExpression.getExpression().acceptVisitor(this));
    }

    public Object visit(MinusExpression minusExpression) {
        if (minusExpression.hasProperty("value")) {
            return minusExpression.getProperty("value");
        }
        return InterpreterUtilities.minus(NodeProperties.getType(minusExpression), minusExpression.getExpression().acceptVisitor(this));
    }

    public Object visit(AddExpression addExpression) {
        if (addExpression.hasProperty("value")) {
            return addExpression.getProperty("value");
        }
        return InterpreterUtilities.add(NodeProperties.getType(addExpression), addExpression.getLeftExpression().acceptVisitor(this), addExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(AddAssignExpression addAssignExpression) {
        Expression expression = addAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.add(NodeProperties.getType(addAssignExpression), object, addAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(SubtractExpression subtractExpression) {
        if (subtractExpression.hasProperty("value")) {
            return subtractExpression.getProperty("value");
        }
        return InterpreterUtilities.subtract(NodeProperties.getType(subtractExpression), subtractExpression.getLeftExpression().acceptVisitor(this), subtractExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(SubtractAssignExpression subtractAssignExpression) {
        Expression expression = subtractAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.subtract(NodeProperties.getType(subtractAssignExpression), object, subtractAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(MultiplyExpression multiplyExpression) {
        if (multiplyExpression.hasProperty("value")) {
            return multiplyExpression.getProperty("value");
        }
        return InterpreterUtilities.multiply(NodeProperties.getType(multiplyExpression), multiplyExpression.getLeftExpression().acceptVisitor(this), multiplyExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(MultiplyAssignExpression multiplyAssignExpression) {
        Expression expression = multiplyAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.multiply(NodeProperties.getType(multiplyAssignExpression), object, multiplyAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(DivideExpression divideExpression) {
        if (divideExpression.hasProperty("value")) {
            return divideExpression.getProperty("value");
        }
        return InterpreterUtilities.divide(NodeProperties.getType(divideExpression), divideExpression.getLeftExpression().acceptVisitor(this), divideExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(DivideAssignExpression divideAssignExpression) {
        Expression expression = divideAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.divide(NodeProperties.getType(divideAssignExpression), object, divideAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(RemainderExpression remainderExpression) {
        if (remainderExpression.hasProperty("value")) {
            return remainderExpression.getProperty("value");
        }
        return InterpreterUtilities.remainder(NodeProperties.getType(remainderExpression), remainderExpression.getLeftExpression().acceptVisitor(this), remainderExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(RemainderAssignExpression remainderAssignExpression) {
        Expression expression = remainderAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.remainder(NodeProperties.getType(remainderAssignExpression), object, remainderAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(EqualExpression equalExpression) {
        if (equalExpression.hasProperty("value")) {
            return equalExpression.getProperty("value");
        }
        Expression expression = equalExpression.getLeftExpression();
        Expression expression2 = equalExpression.getRightExpression();
        return InterpreterUtilities.equalTo(NodeProperties.getType(expression), NodeProperties.getType(expression2), expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(NotEqualExpression notEqualExpression) {
        if (notEqualExpression.hasProperty("value")) {
            return notEqualExpression.getProperty("value");
        }
        Expression expression = notEqualExpression.getLeftExpression();
        Expression expression2 = notEqualExpression.getRightExpression();
        return InterpreterUtilities.notEqualTo(NodeProperties.getType(expression), NodeProperties.getType(expression2), expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(LessExpression lessExpression) {
        if (lessExpression.hasProperty("value")) {
            return lessExpression.getProperty("value");
        }
        Expression expression = lessExpression.getLeftExpression();
        Expression expression2 = lessExpression.getRightExpression();
        return InterpreterUtilities.lessThan(expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(LessOrEqualExpression lessOrEqualExpression) {
        if (lessOrEqualExpression.hasProperty("value")) {
            return lessOrEqualExpression.getProperty("value");
        }
        Expression expression = lessOrEqualExpression.getLeftExpression();
        Expression expression2 = lessOrEqualExpression.getRightExpression();
        return InterpreterUtilities.lessOrEqual(expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(GreaterExpression greaterExpression) {
        if (greaterExpression.hasProperty("value")) {
            return greaterExpression.getProperty("value");
        }
        Expression expression = greaterExpression.getLeftExpression();
        Expression expression2 = greaterExpression.getRightExpression();
        return InterpreterUtilities.greaterThan(expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(GreaterOrEqualExpression greaterOrEqualExpression) {
        if (greaterOrEqualExpression.hasProperty("value")) {
            return greaterOrEqualExpression.getProperty("value");
        }
        Expression expression = greaterOrEqualExpression.getLeftExpression();
        Expression expression2 = greaterOrEqualExpression.getRightExpression();
        return InterpreterUtilities.greaterOrEqual(expression.acceptVisitor(this), expression2.acceptVisitor(this));
    }

    public Object visit(InstanceOfExpression instanceOfExpression) {
        Object object = instanceOfExpression.getExpression().acceptVisitor(this);
        Class clazz = NodeProperties.getType(instanceOfExpression.getReferenceType());
        return clazz.isInstance(object) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visit(ConditionalExpression conditionalExpression) {
        if (conditionalExpression.hasProperty("value")) {
            return conditionalExpression.getProperty("value");
        }
        Boolean bl = (Boolean)conditionalExpression.getConditionExpression().acceptVisitor(this);
        if (bl.booleanValue()) {
            return conditionalExpression.getIfTrueExpression().acceptVisitor(this);
        }
        return conditionalExpression.getIfFalseExpression().acceptVisitor(this);
    }

    public Object visit(PostIncrement postIncrement) {
        Expression expression = postIncrement.getExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        leftHandSideModifier.modify(this.context, InterpreterUtilities.add(NodeProperties.getType(postIncrement), object, InterpreterUtilities.ONE));
        return object;
    }

    public Object visit(PreIncrement preIncrement) {
        Expression expression = preIncrement.getExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        object = InterpreterUtilities.add(NodeProperties.getType(preIncrement), object, InterpreterUtilities.ONE);
        leftHandSideModifier.modify(this.context, object);
        return object;
    }

    public Object visit(PostDecrement postDecrement) {
        Expression expression = postDecrement.getExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        leftHandSideModifier.modify(this.context, InterpreterUtilities.subtract(NodeProperties.getType(postDecrement), object, InterpreterUtilities.ONE));
        return object;
    }

    public Object visit(PreDecrement preDecrement) {
        Expression expression = preDecrement.getExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        object = InterpreterUtilities.subtract(NodeProperties.getType(preDecrement), object, InterpreterUtilities.ONE);
        leftHandSideModifier.modify(this.context, object);
        return object;
    }

    public Object visit(CastExpression castExpression) {
        return EvaluationVisitor.performCast(NodeProperties.getType(castExpression), castExpression.getExpression().acceptVisitor(this));
    }

    public Object visit(BitAndExpression bitAndExpression) {
        if (bitAndExpression.hasProperty("value")) {
            return bitAndExpression.getProperty("value");
        }
        return InterpreterUtilities.bitAnd(NodeProperties.getType(bitAndExpression), bitAndExpression.getLeftExpression().acceptVisitor(this), bitAndExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(BitAndAssignExpression bitAndAssignExpression) {
        Expression expression = bitAndAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.bitAnd(NodeProperties.getType(bitAndAssignExpression), object, bitAndAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        NodeProperties.getModifier(expression).modify(this.context, object2);
        return object2;
    }

    public Object visit(ExclusiveOrExpression exclusiveOrExpression) {
        if (exclusiveOrExpression.hasProperty("value")) {
            return exclusiveOrExpression.getProperty("value");
        }
        return InterpreterUtilities.xOr(NodeProperties.getType(exclusiveOrExpression), exclusiveOrExpression.getLeftExpression().acceptVisitor(this), exclusiveOrExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ExclusiveOrAssignExpression exclusiveOrAssignExpression) {
        Expression expression = exclusiveOrAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.xOr(NodeProperties.getType(exclusiveOrAssignExpression), object, exclusiveOrAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(BitOrExpression bitOrExpression) {
        if (bitOrExpression.hasProperty("value")) {
            return bitOrExpression.getProperty("value");
        }
        return InterpreterUtilities.bitOr(NodeProperties.getType(bitOrExpression), bitOrExpression.getLeftExpression().acceptVisitor(this), bitOrExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(BitOrAssignExpression bitOrAssignExpression) {
        Expression expression = bitOrAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.bitOr(NodeProperties.getType(bitOrAssignExpression), object, bitOrAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(ShiftLeftExpression shiftLeftExpression) {
        if (shiftLeftExpression.hasProperty("value")) {
            return shiftLeftExpression.getProperty("value");
        }
        return InterpreterUtilities.shiftLeft(NodeProperties.getType(shiftLeftExpression), shiftLeftExpression.getLeftExpression().acceptVisitor(this), shiftLeftExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ShiftLeftAssignExpression shiftLeftAssignExpression) {
        Expression expression = shiftLeftAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.shiftLeft(NodeProperties.getType(shiftLeftAssignExpression), object, shiftLeftAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(ShiftRightExpression shiftRightExpression) {
        if (shiftRightExpression.hasProperty("value")) {
            return shiftRightExpression.getProperty("value");
        }
        return InterpreterUtilities.shiftRight(NodeProperties.getType(shiftRightExpression), shiftRightExpression.getLeftExpression().acceptVisitor(this), shiftRightExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(ShiftRightAssignExpression shiftRightAssignExpression) {
        Expression expression = shiftRightAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.shiftRight(NodeProperties.getType(shiftRightAssignExpression), object, shiftRightAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(UnsignedShiftRightExpression unsignedShiftRightExpression) {
        if (unsignedShiftRightExpression.hasProperty("value")) {
            return unsignedShiftRightExpression.getProperty("value");
        }
        return InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(unsignedShiftRightExpression), unsignedShiftRightExpression.getLeftExpression().acceptVisitor(this), unsignedShiftRightExpression.getRightExpression().acceptVisitor(this));
    }

    public Object visit(UnsignedShiftRightAssignExpression unsignedShiftRightAssignExpression) {
        Expression expression = unsignedShiftRightAssignExpression.getLeftExpression();
        LeftHandSideModifier leftHandSideModifier = NodeProperties.getModifier(expression);
        Object object = leftHandSideModifier.prepare(this, this.context);
        Object object2 = InterpreterUtilities.unsignedShiftRight(NodeProperties.getType(unsignedShiftRightAssignExpression), object, unsignedShiftRightAssignExpression.getRightExpression().acceptVisitor(this));
        object2 = EvaluationVisitor.performCast(NodeProperties.getType(expression), object2);
        leftHandSideModifier.modify(this.context, object2);
        return object2;
    }

    public Object visit(AndExpression andExpression) {
        Expression expression = andExpression.getLeftExpression();
        boolean bl = (Boolean)expression.acceptVisitor(this);
        if (bl) {
            expression = andExpression.getRightExpression();
            bl = (Boolean)expression.acceptVisitor(this);
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(OrExpression orExpression) {
        Expression expression = orExpression.getLeftExpression();
        boolean bl = (Boolean)expression.acceptVisitor(this);
        if (!bl) {
            expression = orExpression.getRightExpression();
            bl = (Boolean)expression.acceptVisitor(this);
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(FunctionCall functionCall) {
        Object object;
        Object object2;
        Object object3;
        MethodDeclaration methodDeclaration = (MethodDeclaration)functionCall.getProperty("function");
        GlobalContext globalContext = new GlobalContext(this.context.getInterpreter());
        if (functionCall.getArguments() != null) {
            object3 = methodDeclaration.getParameters().iterator();
            object2 = functionCall.getArguments().iterator();
            while (object3.hasNext()) {
                object = (FormalParameter)object3.next();
                if (((FormalParameter)object).isFinal()) {
                    globalContext.setConstant(((FormalParameter)object).getName(), ((Node)object2.next()).acceptVisitor(this));
                    continue;
                }
                globalContext.setVariable(((FormalParameter)object).getName(), ((Node)object2.next()).acceptVisitor(this));
            }
        }
        if (!((Node)(object3 = methodDeclaration.getBody())).hasProperty("visited")) {
            ((Node)object3).setProperty("visited", null);
            object2 = (ImportationManager)methodDeclaration.getProperty("importationManager");
            object = new GlobalContext(this.context.getInterpreter());
            object.setImportationManager((ImportationManager)object2);
            VisitorObject visitorObject = new NameVisitor((Context)object);
            Iterator iterator = methodDeclaration.getParameters().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(visitorObject);
            }
            ((Node)object3).acceptVisitor(visitorObject);
            object = new GlobalContext(this.context.getInterpreter());
            object.setImportationManager((ImportationManager)object2);
            object.setFunctions((List)methodDeclaration.getProperty("functions"));
            visitorObject = new TypeChecker((Context)object);
            iterator = methodDeclaration.getParameters().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(visitorObject);
            }
            ((Node)object3).acceptVisitor(visitorObject);
        }
        try {
            ((Node)object3).acceptVisitor(new EvaluationVisitor(globalContext));
        }
        catch (ReturnException returnException) {
            return returnException.getValue();
        }
        return null;
    }

    private static Object performCast(Class clazz, Object object) {
        Class<?> clazz2;
        Class<?> clazz3 = clazz2 = object != null ? object.getClass() : null;
        if (clazz != clazz2 && clazz.isPrimitive() && clazz2 != null) {
            if (clazz != Character.TYPE && clazz2 == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = EvaluationVisitor.class$("java.lang.Character")))) {
                object = new Integer(((Character)object).charValue());
            } else if (clazz == Byte.TYPE) {
                object = new Byte(((Number)object).byteValue());
            } else if (clazz == Short.TYPE) {
                object = new Short(((Number)object).shortValue());
            } else if (clazz == Integer.TYPE) {
                object = new Integer(((Number)object).intValue());
            } else if (clazz == Long.TYPE) {
                object = new Long(((Number)object).longValue());
            } else if (clazz == Float.TYPE) {
                object = new Float(((Number)object).floatValue());
            } else if (clazz == Double.TYPE) {
                object = new Double(((Number)object).doubleValue());
            } else if (clazz == Character.TYPE && clazz2 != (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = EvaluationVisitor.class$("java.lang.Character")))) {
                object = new Character((char)((Number)object).shortValue());
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EvaluationVisitor(Context context) {
        this.context = context;
    }
}

