/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.interpreter.ClassInfoCompiler;
import koala.dynamicjava.interpreter.ClassPool;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.TreeClassFinder;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;

public class TreeCompiler {
    protected Interpreter interpreter;
    protected TreeClassLoader classLoader;
    protected ClassInfoLoader classInfoLoader;
    protected ClassPool classPool = new ClassPool();

    public Class compile(String string) throws ClassNotFoundException {
        this.loadClass(string);
        return this.compileClasses(string);
    }

    public Class compileClasses(String string) throws ClassNotFoundException {
        Class clazz = null;
        if (this.classPool.contains(string)) {
            ClassInfo classInfo;
            while ((classInfo = this.classPool.getFirstCompilable()) != null) {
                if (!this.classExists(classInfo.getName())) {
                    Class clazz2 = this.compileClass(classInfo, string);
                    if (clazz2 == null) continue;
                    clazz = clazz2;
                    continue;
                }
                classInfo.setCompilable(false);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public Class compileTree(Context context, TypeDeclaration typeDeclaration) {
        TreeClassFinder treeClassFinder = new TreeClassFinder(context, this.interpreter, this.classPool);
        TreeClassInfo treeClassInfo = new TreeClassInfo(typeDeclaration, treeClassFinder);
        this.classPool.add(treeClassInfo.getName(), treeClassInfo);
        try {
            return this.compileClasses(treeClassInfo.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            typeDeclaration.setProperty("errorStrings", new String[]{typeDeclaration.getName()});
            throw new ExecutionError("undefined.or.defined.class", typeDeclaration);
        }
    }

    protected Class compileClass(ClassInfo classInfo, String string) {
        Object object;
        Object object2 = null;
        ClassInfo classInfo2 = classInfo.getSuperclass();
        if (classInfo2.isCompilable() && !this.classExists(classInfo2.getName()) && (object = this.compileClass(classInfo2, string)) != null) {
            object2 = object;
        }
        object = classInfo.getInterfaces();
        int n = 0;
        while (n < ((ClassInfo[])object).length) {
            Class clazz;
            classInfo2 = object[n];
            if (classInfo2.isCompilable() && !this.classExists(classInfo2.getName()) && (clazz = this.compileClass(classInfo2, string)) != null) {
                object2 = clazz;
            }
            ++n;
        }
        Class clazz = new ClassInfoCompiler(classInfo).compile();
        classInfo.setCompilable(false);
        if (string.equals(clazz.getName())) {
            object2 = clazz;
        }
        return object2;
    }

    protected boolean classExists(String string) {
        return this.classLoader.hasDefined(string);
    }

    protected void loadClass(String string) throws ClassNotFoundException {
        Object object;
        if (this.classPool.contains(string)) {
            return;
        }
        TypeDeclaration typeDeclaration = this.classLoader.getTree(string);
        if (typeDeclaration != null) {
            ImportationManager importationManager = (ImportationManager)typeDeclaration.getProperty("importationManager");
            GlobalContext globalContext = new GlobalContext(this.interpreter, this.classInfoLoader);
            importationManager.setClassLoader(this.classInfoLoader);
            globalContext.setImportationManager(importationManager);
            TreeClassFinder treeClassFinder = new TreeClassFinder(globalContext, this.interpreter, this.classPool);
            this.classPool.add(string, new TreeClassInfo(typeDeclaration, treeClassFinder));
            return;
        }
        LibraryFinder libraryFinder = this.interpreter.getLibraryFinder();
        try {
            object = libraryFinder.findCompilationUnitName(string);
            typeDeclaration = this.classLoader.getTree((String)object);
            if (typeDeclaration != null) {
                ImportationManager importationManager = (ImportationManager)typeDeclaration.getProperty("importationManager");
                GlobalContext globalContext = new GlobalContext(this.interpreter, this.classInfoLoader);
                importationManager.setClassLoader(this.classInfoLoader);
                globalContext.setImportationManager(importationManager);
                TreeClassFinder treeClassFinder = new TreeClassFinder(globalContext, this.interpreter, this.classPool);
                this.classPool.add((String)object, new TreeClassInfo(typeDeclaration, treeClassFinder));
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            object = libraryFinder.findCompilationUnit(string);
            FileInputStream fileInputStream = new FileInputStream((File)object);
            ParserFactory parserFactory = this.interpreter.getParserFactory();
            SourceCodeParser sourceCodeParser = parserFactory.createParser(fileInputStream, ((File)object).getCanonicalPath());
            List list = sourceCodeParser.parseCompilationUnit();
            Iterator iterator = list.iterator();
            TreeCompiler treeCompiler = this;
            if (treeCompiler == null) {
                throw null;
            }
            CompilationUnitVisitor compilationUnitVisitor = treeCompiler.new CompilationUnitVisitor();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(compilationUnitVisitor);
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }

    public TreeCompiler(Interpreter interpreter) {
        this.interpreter = interpreter;
        this.classLoader = (TreeClassLoader)this.interpreter.getClassLoader();
        TreeCompiler treeCompiler = this;
        if (treeCompiler == null) {
            throw null;
        }
        this.classInfoLoader = treeCompiler.new ClassInfoLoader();
    }

    protected class CompilationUnitVisitor
    extends VisitorObject {
        protected Context context;
        protected ClassFinder classFinder;

        public Object visit(PackageDeclaration packageDeclaration) {
            this.context.setCurrentPackage(packageDeclaration.getName());
            return null;
        }

        public Object visit(ImportDeclaration importDeclaration) {
            if (importDeclaration.isPackage()) {
                this.context.declarePackageImport(importDeclaration.getName());
            } else {
                try {
                    this.context.declareClassImport(importDeclaration.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CatchedExceptionError(classNotFoundException, (Node)importDeclaration);
                }
                catch (PseudoError pseudoError) {
                    // empty catch block
                }
            }
            return null;
        }

        public Object visit(ClassDeclaration classDeclaration) {
            return this.visitType(classDeclaration);
        }

        public Object visit(InterfaceDeclaration interfaceDeclaration) {
            return this.visitType(interfaceDeclaration);
        }

        protected Object visitType(TypeDeclaration typeDeclaration) {
            String string = this.classFinder.getCurrentPackage();
            string = (string.equals("") ? "" : string + ".") + typeDeclaration.getName();
            TreeCompiler.this.classPool.add(string, new TreeClassInfo(typeDeclaration, this.classFinder));
            return null;
        }

        CompilationUnitVisitor() {
            this.context = new GlobalContext(TreeCompiler.this.interpreter, TreeCompiler.this.classInfoLoader);
            this.classFinder = new TreeClassFinder(this.context, TreeCompiler.this.interpreter, TreeCompiler.this.classPool);
        }
    }

    protected class ClassInfoLoader
    extends ClassLoader {
        protected Class findClass(String string) throws ClassNotFoundException {
            TreeCompiler.this.loadClass(string);
            if (TreeCompiler.this.classPool.contains(string)) {
                TreeCompiler treeCompiler = TreeCompiler.this;
                if (treeCompiler == null) {
                    throw null;
                }
                throw treeCompiler.new PseudoError(TreeCompiler.this.classPool.get(string));
            }
            throw new ClassNotFoundException(string);
        }

        ClassInfoLoader() {
        }
    }

    public class PseudoError
    extends Error {
        protected ClassInfo classInfo;

        public ClassInfo getClassInfo() {
            return this.classInfo;
        }

        PseudoError(ClassInfo classInfo) {
            this.classInfo = classInfo;
        }
    }
}

