/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UpdateTracking {
    private static final String ELEMENT_MODULES = "installed_modules";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "installer";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String TRACKING_FILE_NAME = "update_tracking.xml";
    private List modules = new ArrayList();
    private boolean pError = false;
    private static UpdateTracking trackingHome;
    private static UpdateTracking trackingUser;
    private boolean fromUser = false;
    private File trackingFile = null;
    private String origin = "nbm";

    static UpdateTracking getTracking(boolean bl) {
        if (bl) {
            if (trackingUser == null) {
                UpdateTracking.readTracking(bl);
            }
            return trackingUser;
        }
        if (trackingHome == null) {
            UpdateTracking.readTracking(bl);
        }
        return trackingHome;
    }

    public UpdateTracking() {
    }

    public UpdateTracking(String string) {
        this.trackingFile = new File(string + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.origin = INST_ORIGIN;
    }

    static void readTracking(boolean bl) {
        if (bl) {
            trackingUser = new UpdateTracking();
            UpdateTracking.trackingUser.fromUser = true;
            trackingUser.read();
        } else {
            trackingHome = new UpdateTracking();
            UpdateTracking.trackingHome.fromUser = false;
            trackingHome.read();
        }
    }

    private File getTrackingFile(boolean bl) {
        if (this.trackingFile == null) {
            String string = bl && UpdateTracking.isMultiuser() ? System.getProperty("netbeans.user") : System.getProperty("netbeans.home");
            this.trackingFile = new File(string + FILE_SEPARATOR + TRACKING_FILE_NAME);
        }
        return this.trackingFile;
    }

    private static boolean isMultiuser() {
        return System.getProperty("netbeans.user") != null && !System.getProperty("netbeans.home").equals(System.getProperty("netbeans.user"));
    }

    private void read() {
        Document document;
        Object object;
        try {
            File file = this.getTrackingFile(this.fromUser);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)object, false, false, new ErrorCatcher(), null);
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("Bad update_tracking");
                sAXException.printStackTrace();
            }
            return;
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.out.println("Missing update_tracking");
                iOException.printStackTrace();
            }
            return;
        }
        object = document.getDocumentElement();
        if (object != null && object.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules((Element)object);
        }
    }

    void scanElement_installed_modules(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_MODULE)) {
                this.scanElement_module(element2);
            }
            ++n;
        }
    }

    void scanElement_module(Element element) {
        Object object;
        Module module = new Module();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n);
            if (object.getName().startsWith(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(object.getValue());
            }
            ++n;
        }
        object = element.getChildNodes();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Element element2;
            Node node = object.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_VERSION)) {
                this.scanElement_module_version(element2, module);
            }
            ++n2;
        }
        this.modules.add(module);
    }

    void scanElement_module_version(Element element, Module module) {
        Object object;
        Version version = new Version();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n);
            if (object.getName().equals(ATTR_VERSION)) {
                version.setVersion(object.getValue());
            }
            if (object.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(object.getValue());
            }
            if (object.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(object.getValue()));
            }
            if (object.getName().equals(ATTR_INSTALL)) {
                long l = 0L;
                try {
                    l = Long.parseLong(object.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                version.setInstall_time(l);
            }
            ++n;
        }
        object = element.getChildNodes();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Element element2;
            Node node = object.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_FILE)) {
                this.scanElement_file(element2, version);
            }
            ++n2;
        }
        module.addVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile moduleFile = new ModuleFile();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                moduleFile.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                moduleFile.setCrc(attr.getValue());
            }
            ++n;
        }
        version.addFile(moduleFile);
    }

    public Version addNewModuleVersion(String string, String string2) {
        Module module = this.getModule(string);
        if (module == null) {
            module = new Module();
            module.setCodenamebase(string);
            this.modules.add(module);
        } else {
            module.updateOldVersion();
        }
        Version version = new Version();
        version.setVersion(string2);
        version.setOrigin(this.origin);
        version.setLast(true);
        version.setInstall_time(System.currentTimeMillis());
        module.addVersion(version);
        return version;
    }

    private Module getModule(String string) {
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (!module.getCodenamebase().equals(string)) continue;
            return module;
        }
        return null;
    }

    void write() {
        Object object;
        Document document = XMLUtil.createDocument(ELEMENT_MODULES);
        Element element = document.getDocumentElement();
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            object = (Module)iterator.next();
            element2 = document.createElement(ELEMENT_MODULE);
            element2.setAttribute(ATTR_CODENAMEBASE, ((Module)object).getCodenamebase());
            element.appendChild(element2);
            Iterator iterator2 = ((Module)object).getVersions().iterator();
            while (iterator2.hasNext()) {
                Version version = (Version)iterator2.next();
                element3 = document.createElement(ELEMENT_VERSION);
                element3.setAttribute(ATTR_VERSION, version.getVersion());
                element3.setAttribute(ATTR_ORIGIN, version.getOrigin());
                element3.setAttribute(ATTR_LAST, new Boolean(version.isLast()).toString());
                element3.setAttribute(ATTR_INSTALL, Long.toString(version.getInstall_time()));
                element2.appendChild(element3);
                Iterator iterator3 = version.getFiles().iterator();
                while (iterator3.hasNext()) {
                    ModuleFile moduleFile = (ModuleFile)iterator3.next();
                    element4 = document.createElement(ELEMENT_FILE);
                    element4.setAttribute(ATTR_FILE_NAME, moduleFile.getName());
                    element4.setAttribute(ATTR_CRC, moduleFile.getCrc());
                    element3.appendChild(element4);
                }
            }
        }
        document.getDocumentElement().normalize();
        try {
            object = new FileOutputStream(this.getTrackingFile(this.fromUser));
            XMLUtil.write(document, (OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String string) {
            this.crc = string;
        }
    }

    public class Version {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String string) {
            this.version = string;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String string) {
            this.origin = string;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean bl) {
            this.last = bl;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long l) {
            this.install_time = l;
        }

        List getFiles() {
            return this.files;
        }

        void setFiles(List list) {
            this.files = list;
        }

        void addFile(ModuleFile moduleFile) {
            this.files.add(moduleFile);
        }

        public void addFileWithCrc(String string, String string2) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            this.files.add(moduleFile);
        }
    }

    class Module {
        private String codenamebase;
        private List versions = new ArrayList();

        Module() {
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String string) {
            this.codenamebase = string;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List list) {
            this.versions = list;
        }

        void addVersion(Version version) {
            this.versions.add(version);
        }

        void updateOldVersion() {
            Iterator iterator = this.versions.iterator();
            while (iterator.hasNext()) {
                Version version = (Version)iterator.next();
                if (!version.isLast()) continue;
                version.setLast(false);
            }
        }
    }
}

