/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;

public class DataObjectEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String PROPERTY_CURRENT_FOLDER = "currentFolder";
    private static final String PROPERTY_ROOT_FOLDER = "rootFolder";
    private static final String PROPERTY_ROOT_NODE = "rootNode";
    private static final String PROPERTY_COOKIES = "cookies";
    private static final String PROPERTY_DATA_FILTER = "dataFilter";
    private static final String PROPERTY_FOLDER_FILTER = "folderFilter";
    private static final String PROPERTY_NODE_ACCEPTOR = "nodeAcceptor";
    private static final String PROPERTY_LABEL = "label";
    private static final String PROPERTY_TITLE = "title";
    private static final String PROPERTY_INSET = "inset";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_HELPID = "helpID";
    private DataObjectPanel customEditor;
    private DataFolder rootFolder;
    private Node rootNode;
    private DataFolder currentFolder;
    private Class[] cookies;
    private DataFilter dataFilter;
    private DataFilter folderFilter;
    private NodeAcceptor nodeAcceptor;
    private String label;
    private String title;
    private Integer insets;
    private String description;
    private String helpID;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private PropertyEnv env;

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        Object object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_CURRENT_FOLDER);
        if (object instanceof DataFolder) {
            this.currentFolder = (DataFolder)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_ROOT_FOLDER)) instanceof DataFolder) {
            this.rootFolder = (DataFolder)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_ROOT_NODE)) instanceof Node) {
            this.rootNode = (Node)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_COOKIES)) instanceof Class[]) {
            this.cookies = (Class[])object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_DATA_FILTER)) instanceof DataFilter) {
            this.dataFilter = (DataFilter)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FOLDER_FILTER)) instanceof DataFilter) {
            this.folderFilter = (DataFilter)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_NODE_ACCEPTOR)) instanceof NodeAcceptor) {
            this.nodeAcceptor = (NodeAcceptor)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_LABEL)) instanceof String) {
            this.label = (String)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_TITLE)) instanceof String) {
            this.title = (String)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_INSET)) instanceof Integer) {
            this.insets = (Integer)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_DESCRIPTION)) instanceof String) {
            this.description = (String)object;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_HELPID)) instanceof String) {
            this.helpID = (String)object;
        }
    }

    public Component getCustomEditor() {
        return this.getDataObjectPanel();
    }

    void setOkButtonEnabled(boolean bl) {
        if (this.env != null) {
            this.env.setState(bl ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
    }

    private DataObjectPanel getDataObjectPanel() {
        if (this.customEditor == null) {
            this.customEditor = new DataObjectPanel(this);
        }
        if (this.cookies != null) {
            this.customEditor.setDataFilter(new CookieFilter(this.cookies, this.dataFilter));
        } else {
            this.customEditor.setDataFilter(this.dataFilter);
        }
        if (this.currentFolder != null) {
            this.customEditor.setDataObject((DataObject)this.currentFolder);
        }
        if (this.label != null) {
            this.customEditor.setText(this.label);
        }
        if (this.title != null) {
            this.customEditor.putClientProperty(PROPERTY_TITLE, this.title);
        }
        if (this.nodeAcceptor != null) {
            this.customEditor.setNodeFilter(this.nodeAcceptor);
        }
        if (this.folderFilter != null) {
            this.customEditor.setFolderFilter(this.folderFilter);
        }
        if (this.rootFolder != null) {
            this.customEditor.setRootObject((DataObject)this.rootFolder);
        }
        if (this.rootNode != null) {
            this.customEditor.setRootNode(this.rootNode);
        }
        if (this.insets != null) {
            this.customEditor.setInsetValue(this.insets);
        }
        if (this.description != null) {
            this.customEditor.setDescription(this.description);
        }
        if (this.helpID != null) {
            HelpCtx.setHelpIDString((JComponent)this.customEditor, (String)this.helpID);
        }
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof DataObject) {
            return ((DataObject)object).getName();
        }
        return "";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            this.setValue(null);
        }
    }

    private static class CookieFilter
    implements DataFilter {
        private Class[] cookieArray;
        private DataFilter originalFilter;

        public CookieFilter(Class[] classArray, DataFilter dataFilter) {
            this.cookieArray = classArray;
            this.originalFilter = dataFilter;
        }

        public boolean acceptDataObject(DataObject dataObject) {
            if (this.cookieArray == null) {
                if (this.originalFilter != null) {
                    return this.originalFilter.acceptDataObject(dataObject);
                }
                return true;
            }
            int n = 0;
            while (n < this.cookieArray.length) {
                if (dataObject.getCookie(this.cookieArray[n]) == null) {
                    return false;
                }
                ++n;
            }
            if (this.originalFilter != null) {
                return this.originalFilter.acceptDataObject(dataObject);
            }
            return true;
        }
    }
}

