/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.projects.SystemFileSystem;
import org.netbeans.core.projects.XMLSettingsHandler;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

public class AutomountSupport
extends FolderInstance
implements TaskListener,
RepositoryListener,
Runnable {
    private static RequestProcessor RP = new RequestProcessor("Automount");
    private static ThreadLocal VAR = new ThreadLocal();
    private static DblTask defaultTask;
    private static final int DELAY = 1000;
    private static Set createdByMe;
    private static Set sticky;
    private static Set shineAway;
    private static Set errCookies;
    private static ErrorManager err;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;
    static /* synthetic */ Class array$Lorg$openide$filesystems$FileSystem;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private AutomountSupport(DataObject.Container container) {
        super(container);
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < instanceCookieArray.length) {
            block8: {
                Object object;
                try {
                    object = instanceCookieArray[n].instanceCreate();
                }
                catch (IOException iOException) {
                    if (errCookies.add(instanceCookieArray[n])) {
                        TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                    }
                    break block8;
                }
                errCookies.remove(instanceCookieArray[n]);
                if (object instanceof FileSystem) {
                    arrayList.add(object);
                } else if (object instanceof FileSystem[]) {
                    arrayList.addAll(Arrays.asList((FileSystem[])object));
                }
            }
            ++n;
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        return arrayList.toArray(new FileSystem[0]);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new AutomountSupport(container);
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        if (instanceCookie instanceof InstanceCookie.Of) {
            InstanceCookie.Of of = (InstanceCookie.Of)instanceCookie;
            if (of.instanceOf(class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem) || of.instanceOf(array$Lorg$openide$filesystems$FileSystem == null ? (array$Lorg$openide$filesystems$FileSystem = AutomountSupport.class$("[Lorg.openide.filesystems.FileSystem;")) : array$Lorg$openide$filesystems$FileSystem)) {
                return instanceCookie;
            }
            return null;
        }
        Class<?> clazz = instanceCookie.instanceClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if ((class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).isAssignableFrom(clazz)) {
            return instanceCookie;
        }
        return null;
    }

    protected Task postCreationTask(Runnable runnable) {
        return RP.post(runnable);
    }

    public void taskFinished(Task task) {
        AutomountSupport.updateFileSystems(this.getList());
    }

    private List getList() {
        Object object = null;
        try {
            object = this.instanceCreate();
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)classNotFoundException);
        }
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof FileSystem) {
            return Collections.nCopies(1, object);
        }
        return Arrays.asList((FileSystem[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Task initialize() {
        if (defaultTask != null) {
            return defaultTask;
        }
        DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
        AutomountSupport automountSupport = new AutomountSupport((DataObject.Container)dataFolder);
        automountSupport.addTaskListener(automountSupport);
        automountSupport.recreate();
        RequestProcessor.Task task = RP.create((Runnable)automountSupport);
        task.setPriority(1);
        Repository repository = Repository.getDefault();
        repository.addRepositoryListener((RepositoryListener)automountSupport);
        defaultTask = new DblTask((Task)automountSupport, task);
        AutomountSupport automountSupport2 = automountSupport;
        synchronized (automountSupport2) {
            sticky.addAll(Arrays.asList(repository.toArray()));
            defaultTask.store();
        }
        return defaultTask;
    }

    public void run() {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    AutomountSupport.checkSaved(AutomountSupport.this.getList(), dataFolder, dataObjectArray);
                }
            });
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public void fileSystemAdded(final RepositoryEvent repositoryEvent) {
        final boolean bl = VAR.get() == null;
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Repository repository;
                Repository repository2 = repository = Repository.getDefault();
                synchronized (repository2) {
                    FileSystem fileSystem = repositoryEvent.getFileSystem();
                    boolean bl2 = AutomountSupport.containsFS(fileSystem);
                    AutomountSupport.log("fsAdded: " + fileSystem + " VAR: " + !bl + " contains: " + bl2);
                    if (bl && bl2) {
                        sticky.add(fileSystem);
                        shineAway.remove(fileSystem);
                        defaultTask.store();
                    }
                }
            }
        });
    }

    public void fileSystemRemoved(final RepositoryEvent repositoryEvent) {
        final boolean bl = VAR.get() == null;
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Repository repository;
                Repository repository2 = repository = Repository.getDefault();
                synchronized (repository2) {
                    FileSystem fileSystem = repositoryEvent.getFileSystem();
                    boolean bl2 = AutomountSupport.containsFS(fileSystem);
                    AutomountSupport.log("fsRemoved: " + fileSystem + " VAR: " + !bl + " contains: " + bl2);
                    if (bl && !bl2) {
                        sticky.remove(fileSystem);
                        shineAway.add(fileSystem);
                        defaultTask.store();
                    }
                }
            }
        });
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    private static boolean containsFS(FileSystem fileSystem) {
        FileSystem[] fileSystemArray = Repository.getDefault().toArray();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] == fileSystem) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSaved(List list, DataFolder dataFolder, DataObject[] dataObjectArray) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            Object object;
            Object object2;
            List<FileSystem> list2 = Arrays.asList(repository.toArray());
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(list2);
            arrayList.removeAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size() * 2);
            arrayList2.addAll(Arrays.asList(dataObjectArray));
            sticky.removeAll(list);
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list2);
            hashSet.retainAll(createdByMe);
            boolean bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FileSystem fileSystem = (FileSystem)iterator.next();
                if (fileSystem.isDefault()) continue;
                try {
                    Object object3 = object2 = XMLSettingsHandler.isProjectObject(fileSystem) ? null : "session";
                    if (object2 != null) {
                        SystemFileSystem.setLayerForNew(dataFolder.getPrimaryFile().toString(), (String)object2);
                    }
                    try {
                        object = InstanceDataObject.create((DataFolder)dataFolder, null, (Object)fileSystem, null);
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        continue;
                    }
                    if (object2 != null) {
                        SystemFileSystem.setLayerForNew(dataFolder.getPrimaryFile().toString(), null);
                    }
                    if (object.instanceCreate() != fileSystem) {
                        StringBuffer stringBuffer = new StringBuffer(255);
                        stringBuffer.append("This bug is caused by wrong implementation of InstanceDataObject, see ");
                        stringBuffer.append("http://www.netbeans.org/issues/show_bug.cgi?id=14557");
                        stringBuffer.append("\nSTORING: ");
                        stringBuffer.append(fileSystem);
                        stringBuffer.append("\nINSTNCE: ");
                        stringBuffer.append(object.instanceCreate());
                        throw new IllegalStateException(stringBuffer.toString());
                    }
                    hashSet.add(fileSystem);
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log(" written to disk: " + fileSystem + " into: " + object);
                    }
                    arrayList2.add(object);
                    sticky.remove(fileSystem);
                    bl = true;
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)classNotFoundException);
                }
            }
            int n = 0;
            while (n < dataObjectArray.length) {
                object2 = (InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (object2 != null) {
                    try {
                        object = object2.instanceCreate();
                        if (object instanceof FileSystem && !hashSet.contains(object)) {
                            dataObjectArray[n].delete();
                            if (AutomountSupport.isLog()) {
                                AutomountSupport.log("  deleted from disk: " + object + " from: " + dataObjectArray[n]);
                            }
                            arrayList2.remove(dataObjectArray[n]);
                            bl = true;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        TopManager.getDefault().getErrorManager().notify((Throwable)classNotFoundException);
                    }
                    catch (IOException iOException) {
                        TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                    }
                }
                ++n;
            }
            if (bl) {
                try {
                    dataFolder.setOrder(arrayList2.toArray(new DataObject[0]));
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("Changed order on the disk");
                        object2 = arrayList2.iterator();
                        int n2 = 0;
                        while (object2.hasNext()) {
                            DataObject dataObject = (DataObject)object2.next();
                            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (instanceCookie == null) continue;
                            AutomountSupport.log("  " + n2++ + " is: " + instanceCookie.instanceCreate());
                        }
                    }
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)classNotFoundException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFileSystems(List linkedList) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            int n;
            Object object;
            Object object2;
            Object object3;
            List<FileSystem> list = Arrays.asList(repository.toArray());
            LinkedList<FileSystem> linkedList2 = new LinkedList<FileSystem>(list);
            linkedList2.removeAll(linkedList);
            linkedList2.removeAll(sticky);
            AutomountSupport.log("sticky: " + sticky);
            linkedList2.retainAll(createdByMe);
            if (AutomountSupport.isLog()) {
                object3 = linkedList2.iterator();
                while (object3.hasNext()) {
                    object2 = (FileSystem)object3.next();
                    AutomountSupport.log("  r: " + object2 + " contains: " + sticky.contains(object2));
                }
            }
            object3 = new LinkedList(linkedList);
            object3.removeAll(list);
            object3.removeAll(shineAway);
            if (AutomountSupport.isLog()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FileSystem)object2.next();
                    AutomountSupport.log("  a: " + object + " contains: " + sticky.contains(object));
                }
            }
            VAR.set(VAR);
            AutomountSupport.cycleFileSystems(linkedList2, false);
            AutomountSupport.cycleFileSystems((Collection)object3, true);
            VAR.set(null);
            createdByMe.addAll(linkedList);
            createdByMe.retainAll(Arrays.asList(repository.toArray()));
            object2 = repository.toArray();
            linkedList = new LinkedList(linkedList);
            linkedList.retainAll(Arrays.asList(object2));
            object = new int[((Object)object2).length];
            int n2 = linkedList.size() + 1;
            boolean bl = false;
            int n3 = 0;
            while (n3 < ((Object)object2).length) {
                if (object2[n3].isDefault()) {
                    object[n3] = (FileSystem)false;
                } else {
                    n = linkedList.indexOf(object2[n3]);
                    n = n == -1 ? n2++ : ++n;
                    object[n] = (FileSystem)n3;
                    bl |= n != n3;
                }
                ++n3;
            }
            if (bl) {
                if (AutomountSupport.isLog()) {
                    AutomountSupport.log("Doing reorder");
                    n = 0;
                    while (n < ((Object)object2).length) {
                        AutomountSupport.log("  " + (int)object[n] + " <- " + n + " now: " + object2[n]);
                        ++n;
                    }
                    AutomountSupport.log("On disk");
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        AutomountSupport.log("  " + iterator.next());
                    }
                    AutomountSupport.log("------");
                }
                repository.reorder((int[])object);
            } else {
                AutomountSupport.log("No reoder");
            }
        }
    }

    private static void cycleFileSystems(Collection collection, boolean bl) {
        Repository repository = Repository.getDefault();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (bl) {
                FileSystem fileSystem2 = repository.findFileSystem(fileSystem.getSystemName());
                if (fileSystem2 != null && fileSystem2 != fileSystem && sticky.remove(fileSystem2)) {
                    repository.removeFileSystem(fileSystem2);
                }
                repository.addFileSystem(fileSystem);
                continue;
            }
            repository.removeFileSystem(fileSystem);
        }
    }

    private static boolean isLog() {
        if (err == null) {
            err = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.core.AutomountSupport");
        }
        return err.isLoggable(1);
    }

    private static void log(String string) {
        if (AutomountSupport.isLog()) {
            err.log(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        createdByMe = new WeakSet();
        sticky = new WeakSet();
        shineAway = new WeakSet();
        errCookies = new WeakSet();
    }

    private static final class DblTask
    extends Task
    implements TaskListener {
        private Task defaultInstance;
        private RequestProcessor.Task storeTask;

        public DblTask(Task task, RequestProcessor.Task task2) {
            this.defaultInstance = task;
            this.storeTask = task2;
            task.addTaskListener((TaskListener)this);
            task2.addTaskListener((TaskListener)this);
        }

        public void store() {
            this.storeTask.schedule(1000);
            this.notifyRunning();
        }

        private boolean areBothFinished() {
            return this.storeTask.isFinished() && this.defaultInstance.isFinished();
        }

        public void waitFinished() {
            do {
                this.defaultInstance.waitFinished();
                this.storeTask.waitFinished();
            } while (!this.areBothFinished());
        }

        public void taskFinished(Task task) {
            if (this.areBothFinished()) {
                this.notifyFinished();
            }
        }
    }
}

