/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import org.netbeans.core.NbTopManager;
import org.openide.TopManager;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.WeakListener;

class ClassLoaderSupport
extends NbClassLoader
implements FileChangeListener,
RepositoryListener,
PropertyChangeListener {
    private FileChangeListener listener;
    private PropertyChangeListener propListener;
    private static final Repository POOL = TopManager.getDefault().getRepository();
    private static ClassLoaderSupport current;
    private static PermissionCollection allPermission;
    private static boolean firstTime;

    static synchronized ClassLoader currentClassLoader() {
        if (current == null) {
            current = new ClassLoaderSupport();
            if (firstTime) {
                firstTime = false;
                NbTopManager.get().fireCurrentClassLoaderChange();
                NbTopManager.get().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("systemClassLoader".equals(propertyChangeEvent.getPropertyName()) && current != null) {
                            current.reset();
                        }
                    }
                });
            }
        }
        return current;
    }

    public ClassLoaderSupport() {
        POOL.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)POOL));
        this.listener = WeakListener.fileChange((FileChangeListener)this, null);
        Enumeration enumeration = POOL.fileSystems();
        this.propListener = WeakListener.propertyChange((PropertyChangeListener)this, null);
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.addPropertyChangeListener(this.propListener);
        }
        this.setDefaultPermissions(ClassLoaderSupport.getAllPermissions());
    }

    protected void finalize() {
        TopManager.getDefault().getErrorManager().getInstance("org.netbeans.core").log("Collected currentClassLoader");
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        int n;
        FileObject fileObject;
        Class clazz = super.findClass(string);
        if (clazz != null && (fileObject = (n = string.lastIndexOf(46)) == -1 ? POOL.find("", string, "class") : POOL.find(string.substring(0, n), string.substring(n + 1), "class")) != null) {
            fileObject.addFileChangeListener(this.listener);
        }
        return clazz;
    }

    private void test(FileObject fileObject) {
        if (current == this) {
            this.reset();
        }
        fileObject.removeFileChangeListener(this.listener);
    }

    private synchronized void reset() {
        if (current == this) {
            current = null;
        }
        NbTopManager.get().fireCurrentClassLoaderChange();
    }

    private void testRemove(FileObject fileObject) {
        if (current != this) {
            fileObject.removeFileChangeListener(this.listener);
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        fileSystem.addPropertyChangeListener(this.propListener);
        this.reset();
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        fileSystem.removePropertyChangeListener(this.propListener);
        this.reset();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        this.reset();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.testRemove(fileEvent.getFile());
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.testRemove(fileEvent.getFile());
    }

    public void fileChanged(FileEvent fileEvent) {
        this.test(fileEvent.getFile());
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.test(fileEvent.getFile());
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.test(fileRenameEvent.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.testRemove(fileAttributeEvent.getFile());
    }

    static synchronized PermissionCollection getAllPermissions() {
        if (allPermission == null) {
            allPermission = new Permissions();
            allPermission.add(new AllPermission());
        }
        return allPermission;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("root")) {
            this.reset();
        }
    }

    static {
        firstTime = true;
    }
}

