/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Timer;
import org.openide.TopManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public class CoronaClipboard
extends ExClipboard {
    private static final int TIME = 3000;
    private static final DataFlavor[] NONE = new DataFlavor[0];
    private ConvertorsCache convertors;
    private Clipboard nextClipboard;
    private DataFlavor[] flavors = NONE;
    private Transferable orignalTransferable;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard$Convertor;

    public CoronaClipboard(String string) {
        this(string, Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    public CoronaClipboard(String string, Clipboard clipboard) {
        super(string);
        this.nextClipboard = clipboard;
        if (Utilities.isUnix()) {
            return;
        }
        Timer timer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoronaClipboard.this.refreshClipboard();
            }
        });
        timer.setRepeats(true);
        timer.start();
        this.refreshClipboard();
    }

    final synchronized void changeTransferable(Transferable transferable) {
        if (this.orignalTransferable != null) {
            ExClipboard.transferableOwnershipLost((Transferable)this.orignalTransferable);
        }
        this.orignalTransferable = transferable;
    }

    synchronized boolean refreshClipboard() {
        if (Utilities.isUnix()) {
            return false;
        }
        Transferable transferable = null;
        try {
            transferable = this.nextClipboard.getContents((Object)this);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            TopManager.getDefault().getErrorManager().notify(1, throwable);
            return false;
        }
        try {
            Object[] objectArray = transferable.getTransferDataFlavors();
            if (objectArray == null) {
                objectArray = NONE;
            }
            if (!Arrays.equals(objectArray, this.flavors)) {
                this.flavors = objectArray;
                this.changeTransferable(null);
                this.fireClipboardChange();
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        this.changeTransferable(transferable);
        this.flavors = transferable.getTransferDataFlavors();
        this.nextClipboard.setContents(this.convert(transferable), clipboardOwner);
        if (!this.refreshClipboard()) {
            this.fireClipboardChange();
        }
    }

    public synchronized Transferable getContents(Object object) {
        try {
            Transferable transferable = this.nextClipboard.getContents(object);
            transferable = this.convert(transferable);
            return transferable;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            TopManager.getDefault().getErrorManager().notify(1, throwable);
            return null;
        }
    }

    protected ExClipboard.Convertor[] getConvertors() {
        return this.computeConvertors();
    }

    private synchronized ExClipboard.Convertor[] computeConvertors() {
        if (this.convertors == null) {
            this.convertors = new ConvertorsCache();
        }
        return this.convertors.getConvertors();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConvertorsCache
    implements LookupListener {
        private ExClipboard.Convertor[] convs;
        private Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$util$datatransfer$ExClipboard$Convertor == null ? (class$org$openide$util$datatransfer$ExClipboard$Convertor = CoronaClipboard.class$("org.openide.util.datatransfer.ExClipboard$Convertor")) : class$org$openide$util$datatransfer$ExClipboard$Convertor));

        public ConvertorsCache() {
            this.result.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Collection collection = this.result.allInstances();
            ExClipboard.Convertor[] convertorArray = new ExClipboard.Convertor[collection.size()];
            this.convs = collection.toArray(convertorArray);
        }

        public ExClipboard.Convertor[] getConvertors() {
            return this.convs;
        }
    }
}

